"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const sqs = require("@aws-cdk/aws-sqs");
const sns = require("@aws-cdk/aws-sns");
const kms = require("@aws-cdk/aws-kms");
const core_2 = require("@aws-solutions-constructs/core");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-sns-sqs Standard Queue';
// Definitions
const snsManagedKey = kms.Alias.fromAliasName(stack, 'sns-managed-key', 'alias/aws/sns');
const topic = new sns.Topic(stack, 'TestTopic', {
    displayName: 'Customer subscription topic',
    fifo: false,
    topicName: 'testTopic',
    masterKey: snsManagedKey
});
const encryptionKeyProps = {
    enableKeyRotation: true
};
const key = new kms.Key(stack, 'ImportedEncryptionKey', encryptionKeyProps);
const deadLetterQueueKey = new kms.Key(stack, 'ImportedDLQEncryptionKey', encryptionKeyProps);
const props = {
    enableEncryptionWithCustomerManagedKey: true,
    existingTopicObj: topic,
    queueProps: {
        fifo: false,
    },
    deadLetterQueueProps: {
        encryption: sqs.QueueEncryption.KMS,
        fifo: false,
        encryptionMasterKey: deadLetterQueueKey
    },
    encryptionKey: key
};
new lib_1.SnsToSqs(stack, 'test-sns-sqs', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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