/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.deployment;

import io.ray.serve.config.AutoscalingConfig;
import io.ray.serve.config.DeploymentConfig;
import io.ray.serve.deployment.Deployment;
import io.ray.serve.generated.DeploymentLanguage;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.util.Map;

public class DeploymentCreator {
    private String deploymentDef;
    private String name;
    private String version;
    private String prevVersion;
    private Integer numReplicas;
    private Object[] initArgs;
    private String routePrefix;
    private Map<String, Object> rayActorOptions;
    private Object userConfig;
    private Integer maxConcurrentQueries;
    private AutoscalingConfig autoscalingConfig;
    private Double gracefulShutdownWaitLoopS;
    private Double gracefulShutdownTimeoutS;
    private Double healthCheckPeriodS;
    private Double healthCheckTimeoutS;
    private boolean routed;
    private DeploymentLanguage language;

    public Deployment create() {
        Preconditions.checkArgument(this.numReplicas == null || this.numReplicas == 0 || this.autoscalingConfig == null, "Manually setting num_replicas is not allowed when autoscalingConfig is provided.");
        DeploymentConfig config = new DeploymentConfig().setNumReplicas(this.numReplicas).setMaxConcurrentQueries(this.maxConcurrentQueries).setUserConfig(this.userConfig).setAutoscalingConfig(this.autoscalingConfig).setGracefulShutdownWaitLoopS(this.gracefulShutdownWaitLoopS).setGracefulShutdownTimeoutS(this.gracefulShutdownTimeoutS).setHealthCheckPeriodS(this.healthCheckPeriodS).setHealthCheckTimeoutS(this.healthCheckTimeoutS).setDeploymentLanguage(this.language);
        return new Deployment(this.deploymentDef, this.name, config, this.version, this.prevVersion, this.initArgs, this.routed ? this.routePrefix : "/" + this.name, this.rayActorOptions);
    }

    public String getDeploymentDef() {
        return this.deploymentDef;
    }

    public DeploymentCreator setDeploymentDef(String deploymentDef) {
        this.deploymentDef = deploymentDef;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DeploymentCreator setName(String name) {
        this.name = name;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public DeploymentCreator setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getPrevVersion() {
        return this.prevVersion;
    }

    public DeploymentCreator setPrevVersion(String prevVersion) {
        this.prevVersion = prevVersion;
        return this;
    }

    public Integer getNumReplicas() {
        return this.numReplicas;
    }

    public DeploymentCreator setNumReplicas(Integer numReplicas) {
        this.numReplicas = numReplicas;
        return this;
    }

    public Object[] getInitArgs() {
        return this.initArgs;
    }

    public DeploymentCreator setInitArgs(Object[] initArgs) {
        this.initArgs = initArgs;
        return this;
    }

    public String getRoutePrefix() {
        return this.routePrefix;
    }

    public DeploymentCreator setRoutePrefix(String routePrefix) {
        this.routePrefix = routePrefix;
        this.routed = true;
        return this;
    }

    public Map<String, Object> getRayActorOptions() {
        return this.rayActorOptions;
    }

    public DeploymentCreator setRayActorOptions(Map<String, Object> rayActorOptions) {
        this.rayActorOptions = rayActorOptions;
        return this;
    }

    public Object getUserConfig() {
        return this.userConfig;
    }

    public DeploymentCreator setUserConfig(Object userConfig) {
        this.userConfig = userConfig;
        return this;
    }

    public Integer getMaxConcurrentQueries() {
        return this.maxConcurrentQueries;
    }

    public DeploymentCreator setMaxConcurrentQueries(Integer maxConcurrentQueries) {
        this.maxConcurrentQueries = maxConcurrentQueries;
        return this;
    }

    public AutoscalingConfig getAutoscalingConfig() {
        return this.autoscalingConfig;
    }

    public DeploymentCreator setAutoscalingConfig(AutoscalingConfig autoscalingConfig) {
        this.autoscalingConfig = autoscalingConfig;
        return this;
    }

    public Double getGracefulShutdownWaitLoopS() {
        return this.gracefulShutdownWaitLoopS;
    }

    public DeploymentCreator setGracefulShutdownWaitLoopS(Double gracefulShutdownWaitLoopS) {
        this.gracefulShutdownWaitLoopS = gracefulShutdownWaitLoopS;
        return this;
    }

    public Double getGracefulShutdownTimeoutS() {
        return this.gracefulShutdownTimeoutS;
    }

    public DeploymentCreator setGracefulShutdownTimeoutS(Double gracefulShutdownTimeoutS) {
        this.gracefulShutdownTimeoutS = gracefulShutdownTimeoutS;
        return this;
    }

    public Double getHealthCheckPeriodS() {
        return this.healthCheckPeriodS;
    }

    public DeploymentCreator setHealthCheckPeriodS(Double healthCheckPeriodS) {
        this.healthCheckPeriodS = healthCheckPeriodS;
        return this;
    }

    public Double getHealthCheckTimeoutS() {
        return this.healthCheckTimeoutS;
    }

    public DeploymentCreator setHealthCheckTimeoutS(Double healthCheckTimeoutS) {
        this.healthCheckTimeoutS = healthCheckTimeoutS;
        return this;
    }

    public DeploymentLanguage getLanguage() {
        return this.language;
    }

    public DeploymentCreator setLanguage(DeploymentLanguage language) {
        this.language = language;
        return this;
    }
}

