# -*- coding: utf-8 -*-

"""
    apimatic.controllers.validator_controller

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from .base_controller import BaseController
from ..api_helper import APIHelper
from ..configuration import Configuration
from ..http.auth.custom_header_auth import CustomHeaderAuth
from ..models.validation_summary import ValidationSummary

class ValidatorController(BaseController):

    """A Controller to access Endpoints in the apimatic API."""


    def validate_from_file(self,
                           file):
        """Does a POST request to /validate.

        Validate an API description using a file.

        Args:
            file (string): TODO: type description here. Example: 

        Returns:
            ValidationSummary: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/validate'
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare files
        _files = {
            'file': file
        }

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, files=_files)
        CustomHeaderAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, ValidationSummary.from_dictionary)

    def validate_from_url(self,
                          description_url):
        """Does a GET request to /validate.

        Validate an API description using a URL.

        Args:
            description_url (string): TODO: type description here. Example: 

        Returns:
            ValidationSummary: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/validate'
        _query_parameters = {
            'descriptionUrl': description_url
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        CustomHeaderAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, ValidationSummary.from_dictionary)

    def validate_from_key(self,
                          apikey):
        """Does a GET request to /validate.

        Validate an API description using an API key.

        Args:
            apikey (string): TODO: type description here. Example: 

        Returns:
            ValidationSummary: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/validate'
        _query_parameters = {
            'apikey': apikey
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, ValidationSummary.from_dictionary)
