"""
Exports EMOJI_ZWJ_SEQUENCES sequences keyed by supporting emoji version.

This code generated by wcwidth/bin/update-tables.py on 2023-10-18 00:04:10 UTC.

This module is used only for testing purposes, it is not imported or used by the
public API.
"""
EMOJI_ZWJ_SEQUENCES = {
    '2.0': {
        # Source: ./data/emoji-zwj-sequences-2.0.txt
        # Date: 2015-11-11
        #
        # sequences of length 3,
            (0x1f441, 0x0200d, 0x1f5e8), 
        # sequences of length 5,
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466), 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467), 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466), 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467), 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466), 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467), 
            (0x1f468, 0x0200d, 0x02764, 0x0200d, 0x1f468), 
            (0x1f469, 0x0200d, 0x02764, 0x0200d, 0x1f468), 
            (0x1f469, 0x0200d, 0x02764, 0x0200d, 0x1f469), 
        # sequences of length 6,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469), 
        # sequences of length 7,
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), 
            (0x1f468, 0x0200d, 0x02764, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), 
            (0x1f469, 0x0200d, 0x02764, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), 
            (0x1f469, 0x0200d, 0x02764, 0x0200d, 0x1f48b, 0x0200d, 0x1f469), 
        # sequences of length 8,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469), 
    },
    '4.0': {
        # Source: ./data/emoji-zwj-sequences-4.0.txt
        # Date: 2016-11-16, 18:29:53 GMT
        #
        # sequences of length 3,
            (0x1f468, 0x0200d, 0x1f466), # family: man, boy 
            (0x1f468, 0x0200d, 0x1f467), # family: man, girl 
            (0x1f469, 0x0200d, 0x1f466), # family: woman, boy 
            (0x1f469, 0x0200d, 0x1f467), # family: woman, girl 
            (0x1f468, 0x0200d, 0x1f33e), # man farmer 
            (0x1f468, 0x0200d, 0x1f373), # man cook 
            (0x1f468, 0x0200d, 0x1f393), # man student 
            (0x1f468, 0x0200d, 0x1f3a4), # man singer 
            (0x1f468, 0x0200d, 0x1f3a8), # man artist 
            (0x1f468, 0x0200d, 0x1f3eb), # man teacher 
            (0x1f468, 0x0200d, 0x1f3ed), # man factory worker 
            (0x1f468, 0x0200d, 0x1f4bb), # man technologist 
            (0x1f468, 0x0200d, 0x1f4bc), # man office worker 
            (0x1f468, 0x0200d, 0x1f527), # man mechanic 
            (0x1f468, 0x0200d, 0x1f52c), # man scientist 
            (0x1f468, 0x0200d, 0x1f680), # man astronaut 
            (0x1f468, 0x0200d, 0x1f692), # man firefighter 
            (0x1f469, 0x0200d, 0x1f33e), # woman farmer 
            (0x1f469, 0x0200d, 0x1f373), # woman cook 
            (0x1f469, 0x0200d, 0x1f393), # woman student 
            (0x1f469, 0x0200d, 0x1f3a4), # woman singer 
            (0x1f469, 0x0200d, 0x1f3a8), # woman artist 
            (0x1f469, 0x0200d, 0x1f3eb), # woman teacher 
            (0x1f469, 0x0200d, 0x1f3ed), # woman factory worker 
            (0x1f469, 0x0200d, 0x1f4bb), # woman technologist 
            (0x1f469, 0x0200d, 0x1f4bc), # woman office worker 
            (0x1f469, 0x0200d, 0x1f527), # woman mechanic 
            (0x1f469, 0x0200d, 0x1f52c), # woman scientist 
            (0x1f469, 0x0200d, 0x1f680), # woman astronaut 
            (0x1f469, 0x0200d, 0x1f692), # woman firefighter 
        # sequences of length 4,
            (0x1f468, 0x0200d, 0x02695, 0x0fe0f), # man health worker 
            (0x1f468, 0x0200d, 0x02696, 0x0fe0f), # man judge 
            (0x1f468, 0x0200d, 0x02708, 0x0fe0f), # man pilot 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f33e), # man farmer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f373), # man cook: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f393), # man student: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a4), # man singer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a8), # man artist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3eb), # man teacher: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3ed), # man factory worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bb), # man technologist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bc), # man office worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f527), # man mechanic: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f52c), # man scientist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f680), # man astronaut: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f692), # man firefighter: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f33e), # man farmer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f373), # man cook: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f393), # man student: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a4), # man singer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a8), # man artist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3eb), # man teacher: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3ed), # man factory worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bb), # man technologist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bc), # man office worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f527), # man mechanic: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f52c), # man scientist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f680), # man astronaut: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f692), # man firefighter: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f33e), # man farmer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f373), # man cook: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f393), # man student: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a4), # man singer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a8), # man artist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3eb), # man teacher: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3ed), # man factory worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bb), # man technologist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bc), # man office worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f527), # man mechanic: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f52c), # man scientist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f680), # man astronaut: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f692), # man firefighter: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f33e), # man farmer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f373), # man cook: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f393), # man student: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a4), # man singer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a8), # man artist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3eb), # man teacher: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3ed), # man factory worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bb), # man technologist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bc), # man office worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f527), # man mechanic: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f52c), # man scientist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f680), # man astronaut: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f692), # man firefighter: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f33e), # man farmer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f373), # man cook: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f393), # man student: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a4), # man singer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a8), # man artist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3eb), # man teacher: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3ed), # man factory worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bb), # man technologist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bc), # man office worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f527), # man mechanic: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f52c), # man scientist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f680), # man astronaut: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f692), # man firefighter: dark skin tone 
            (0x1f469, 0x0200d, 0x02695, 0x0fe0f), # woman health worker 
            (0x1f469, 0x0200d, 0x02696, 0x0fe0f), # woman judge 
            (0x1f469, 0x0200d, 0x02708, 0x0fe0f), # woman pilot 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f33e), # woman farmer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f373), # woman cook: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f393), # woman student: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a4), # woman singer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a8), # woman artist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3eb), # woman teacher: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3ed), # woman factory worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bb), # woman technologist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bc), # woman office worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f527), # woman mechanic: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f52c), # woman scientist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f680), # woman astronaut: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f692), # woman firefighter: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f33e), # woman farmer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f373), # woman cook: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f393), # woman student: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a4), # woman singer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a8), # woman artist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3eb), # woman teacher: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3ed), # woman factory worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bb), # woman technologist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bc), # woman office worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f527), # woman mechanic: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f52c), # woman scientist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f680), # woman astronaut: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f692), # woman firefighter: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f33e), # woman farmer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f373), # woman cook: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f393), # woman student: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a4), # woman singer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a8), # woman artist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3eb), # woman teacher: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3ed), # woman factory worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bb), # woman technologist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bc), # woman office worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f527), # woman mechanic: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f52c), # woman scientist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f680), # woman astronaut: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f692), # woman firefighter: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f33e), # woman farmer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f373), # woman cook: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f393), # woman student: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a4), # woman singer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a8), # woman artist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3eb), # woman teacher: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3ed), # woman factory worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bb), # woman technologist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bc), # woman office worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f527), # woman mechanic: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f52c), # woman scientist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f680), # woman astronaut: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f692), # woman firefighter: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f33e), # woman farmer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f373), # woman cook: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f393), # woman student: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a4), # woman singer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a8), # woman artist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3eb), # woman teacher: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3ed), # woman factory worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bb), # woman technologist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bc), # woman office worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f527), # woman mechanic: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f52c), # woman scientist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f680), # woman astronaut: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f692), # woman firefighter: dark skin tone 
            (0x1f46e, 0x0200d, 0x02640, 0x0fe0f), # woman police officer 
            (0x1f46e, 0x0200d, 0x02642, 0x0fe0f), # man police officer 
            (0x1f471, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman 
            (0x1f471, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man 
            (0x1f473, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban 
            (0x1f473, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban 
            (0x1f477, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker 
            (0x1f477, 0x0200d, 0x02642, 0x0fe0f), # man construction worker 
            (0x1f482, 0x0200d, 0x02640, 0x0fe0f), # woman guard 
            (0x1f482, 0x0200d, 0x02642, 0x0fe0f), # man guard 
            (0x1f3c3, 0x0200d, 0x02640, 0x0fe0f), # woman running 
            (0x1f3c3, 0x0200d, 0x02642, 0x0fe0f), # man running 
            (0x1f3c4, 0x0200d, 0x02640, 0x0fe0f), # woman surfing 
            (0x1f3c4, 0x0200d, 0x02642, 0x0fe0f), # man surfing 
            (0x1f3ca, 0x0200d, 0x02640, 0x0fe0f), # woman swimming 
            (0x1f3ca, 0x0200d, 0x02642, 0x0fe0f), # man swimming 
            (0x1f46f, 0x0200d, 0x02640, 0x0fe0f), # women with bunny ears partying 
            (0x1f46f, 0x0200d, 0x02642, 0x0fe0f), # men with bunny ears partying 
            (0x1f486, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage 
            (0x1f486, 0x0200d, 0x02642, 0x0fe0f), # man getting massage 
            (0x1f487, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut 
            (0x1f487, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut 
            (0x1f6a3, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat 
            (0x1f6a3, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat 
            (0x1f6b4, 0x0200d, 0x02640, 0x0fe0f), # woman biking 
            (0x1f6b4, 0x0200d, 0x02642, 0x0fe0f), # man biking 
            (0x1f6b5, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking 
            (0x1f6b5, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking 
            (0x1f6b6, 0x0200d, 0x02640, 0x0fe0f), # woman walking 
            (0x1f6b6, 0x0200d, 0x02642, 0x0fe0f), # man walking 
            (0x1f938, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling 
            (0x1f938, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling 
            (0x1f939, 0x0200d, 0x02640, 0x0fe0f), # woman juggling 
            (0x1f939, 0x0200d, 0x02642, 0x0fe0f), # man juggling 
            (0x1f93c, 0x0200d, 0x02640, 0x0fe0f), # women wrestling 
            (0x1f93c, 0x0200d, 0x02642, 0x0fe0f), # men wrestling 
            (0x1f93d, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo 
            (0x1f93d, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo 
            (0x1f93e, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball 
            (0x1f93e, 0x0200d, 0x02642, 0x0fe0f), # man playing handball 
            (0x1f481, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand 
            (0x1f481, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand 
            (0x1f645, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO 
            (0x1f645, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO 
            (0x1f646, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK 
            (0x1f646, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK 
            (0x1f647, 0x0200d, 0x02640, 0x0fe0f), # woman bowing 
            (0x1f647, 0x0200d, 0x02642, 0x0fe0f), # man bowing 
            (0x1f64b, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand 
            (0x1f64b, 0x0200d, 0x02642, 0x0fe0f), # man raising hand 
            (0x1f64d, 0x0200d, 0x02640, 0x0fe0f), # woman frowning 
            (0x1f64d, 0x0200d, 0x02642, 0x0fe0f), # man frowning 
            (0x1f64e, 0x0200d, 0x02640, 0x0fe0f), # woman pouting 
            (0x1f64e, 0x0200d, 0x02642, 0x0fe0f), # man pouting 
            (0x1f926, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming 
            (0x1f926, 0x0200d, 0x02642, 0x0fe0f), # man facepalming 
            (0x1f937, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging 
            (0x1f937, 0x0200d, 0x02642, 0x0fe0f), # man shrugging 
            (0x1f3f3, 0x0fe0f, 0x0200d, 0x1f308), # rainbow flag 
        # sequences of length 5,
            (0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, boy, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, girl, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, girl, girl 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466), # family: man, man, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467), # family: man, man, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: man, woman, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: man, woman, girl 
            (0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, girl, girl 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: woman, woman, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: woman, woman, girl 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # man health worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # man judge: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # man pilot: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # man health worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # man judge: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # man pilot: dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # woman judge: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # woman judge: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: dark skin tone 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: light skin tone 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man police officer: light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man police officer: dark skin tone 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman: light skin tone 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man: light skin tone 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman: medium-light skin tone 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man: medium-light skin tone 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman: medium skin tone 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man: medium skin tone 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman: medium-dark skin tone 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man: medium-dark skin tone 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman: dark skin tone 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man: dark skin tone 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: light skin tone 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: dark skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: light skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: dark skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman guard: light skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man guard: light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-light skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-dark skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman guard: dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man guard: dark skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman detective: light skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man detective: light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-light skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-dark skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman detective: dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man detective: dark skin tone 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman detective 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man detective 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: light skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: dark skin tone 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman running: light skin tone 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man running: light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-light skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man running: medium skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-dark skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman running: dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man running: dark skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: light skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man surfing: light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man surfing: dark skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: light skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man swimming: light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man swimming: dark skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: dark skin tone 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: light skin tone 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man golfing: light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man golfing: dark skin tone 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman golfing 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man golfing 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: light skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: dark skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: light skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: dark skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: dark skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman biking: light skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man biking: light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman biking: dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man biking: dark skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: dark skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman walking: light skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man walking: light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman walking: dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man walking: dark skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: light skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: dark skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: light skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man juggling: light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-light skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-dark skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man juggling: dark skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: light skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: dark skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: light skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: dark skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: light skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: dark skin tone 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: light skin tone 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: dark skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: light skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: dark skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: light skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bowing: light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-light skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-dark skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bowing: dark skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: light skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: dark skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: light skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man frowning: light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man frowning: dark skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: light skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man pouting: light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man pouting: dark skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: light skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: dark skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: light skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: dark skin tone 
            (0x1f441, 0x0fe0f, 0x0200d, 0x1f5e8, 0x0fe0f), # eye in speech bubble 
        # sequences of length 6,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: man, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469), # couple with heart: woman, woman 
        # sequences of length 7,
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, man, boy, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, man, girl, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, man, girl, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, woman, boy, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, woman, girl, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, woman, girl, girl 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, woman, girl, girl 
        # sequences of length 8,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: man, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469), # kiss: woman, woman 
    },
    '5.0': {
        # Source: ./data/emoji-zwj-sequences-5.0.txt
        # Date: 2017-06-19, 11:13:24 GMT
        #
        # sequences of length 3,
            (0x1f468, 0x0200d, 0x1f466), # family: man, boy 
            (0x1f468, 0x0200d, 0x1f467), # family: man, girl 
            (0x1f469, 0x0200d, 0x1f466), # family: woman, boy 
            (0x1f469, 0x0200d, 0x1f467), # family: woman, girl 
            (0x1f468, 0x0200d, 0x1f33e), # man farmer 
            (0x1f468, 0x0200d, 0x1f373), # man cook 
            (0x1f468, 0x0200d, 0x1f393), # man student 
            (0x1f468, 0x0200d, 0x1f3a4), # man singer 
            (0x1f468, 0x0200d, 0x1f3a8), # man artist 
            (0x1f468, 0x0200d, 0x1f3eb), # man teacher 
            (0x1f468, 0x0200d, 0x1f3ed), # man factory worker 
            (0x1f468, 0x0200d, 0x1f4bb), # man technologist 
            (0x1f468, 0x0200d, 0x1f4bc), # man office worker 
            (0x1f468, 0x0200d, 0x1f527), # man mechanic 
            (0x1f468, 0x0200d, 0x1f52c), # man scientist 
            (0x1f468, 0x0200d, 0x1f680), # man astronaut 
            (0x1f468, 0x0200d, 0x1f692), # man firefighter 
            (0x1f469, 0x0200d, 0x1f33e), # woman farmer 
            (0x1f469, 0x0200d, 0x1f373), # woman cook 
            (0x1f469, 0x0200d, 0x1f393), # woman student 
            (0x1f469, 0x0200d, 0x1f3a4), # woman singer 
            (0x1f469, 0x0200d, 0x1f3a8), # woman artist 
            (0x1f469, 0x0200d, 0x1f3eb), # woman teacher 
            (0x1f469, 0x0200d, 0x1f3ed), # woman factory worker 
            (0x1f469, 0x0200d, 0x1f4bb), # woman technologist 
            (0x1f469, 0x0200d, 0x1f4bc), # woman office worker 
            (0x1f469, 0x0200d, 0x1f527), # woman mechanic 
            (0x1f469, 0x0200d, 0x1f52c), # woman scientist 
            (0x1f469, 0x0200d, 0x1f680), # woman astronaut 
            (0x1f469, 0x0200d, 0x1f692), # woman firefighter 
        # sequences of length 4,
            (0x1f468, 0x0200d, 0x02695, 0x0fe0f), # man health worker 
            (0x1f468, 0x0200d, 0x02696, 0x0fe0f), # man judge 
            (0x1f468, 0x0200d, 0x02708, 0x0fe0f), # man pilot 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f33e), # man farmer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f373), # man cook: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f393), # man student: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a4), # man singer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a8), # man artist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3eb), # man teacher: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3ed), # man factory worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bb), # man technologist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bc), # man office worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f527), # man mechanic: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f52c), # man scientist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f680), # man astronaut: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f692), # man firefighter: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f33e), # man farmer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f373), # man cook: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f393), # man student: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a4), # man singer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a8), # man artist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3eb), # man teacher: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3ed), # man factory worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bb), # man technologist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bc), # man office worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f527), # man mechanic: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f52c), # man scientist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f680), # man astronaut: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f692), # man firefighter: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f33e), # man farmer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f373), # man cook: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f393), # man student: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a4), # man singer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a8), # man artist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3eb), # man teacher: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3ed), # man factory worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bb), # man technologist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bc), # man office worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f527), # man mechanic: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f52c), # man scientist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f680), # man astronaut: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f692), # man firefighter: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f33e), # man farmer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f373), # man cook: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f393), # man student: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a4), # man singer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a8), # man artist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3eb), # man teacher: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3ed), # man factory worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bb), # man technologist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bc), # man office worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f527), # man mechanic: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f52c), # man scientist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f680), # man astronaut: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f692), # man firefighter: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f33e), # man farmer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f373), # man cook: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f393), # man student: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a4), # man singer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a8), # man artist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3eb), # man teacher: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3ed), # man factory worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bb), # man technologist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bc), # man office worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f527), # man mechanic: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f52c), # man scientist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f680), # man astronaut: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f692), # man firefighter: dark skin tone 
            (0x1f469, 0x0200d, 0x02695, 0x0fe0f), # woman health worker 
            (0x1f469, 0x0200d, 0x02696, 0x0fe0f), # woman judge 
            (0x1f469, 0x0200d, 0x02708, 0x0fe0f), # woman pilot 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f33e), # woman farmer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f373), # woman cook: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f393), # woman student: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a4), # woman singer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a8), # woman artist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3eb), # woman teacher: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3ed), # woman factory worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bb), # woman technologist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bc), # woman office worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f527), # woman mechanic: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f52c), # woman scientist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f680), # woman astronaut: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f692), # woman firefighter: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f33e), # woman farmer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f373), # woman cook: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f393), # woman student: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a4), # woman singer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a8), # woman artist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3eb), # woman teacher: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3ed), # woman factory worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bb), # woman technologist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bc), # woman office worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f527), # woman mechanic: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f52c), # woman scientist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f680), # woman astronaut: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f692), # woman firefighter: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f33e), # woman farmer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f373), # woman cook: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f393), # woman student: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a4), # woman singer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a8), # woman artist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3eb), # woman teacher: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3ed), # woman factory worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bb), # woman technologist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bc), # woman office worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f527), # woman mechanic: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f52c), # woman scientist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f680), # woman astronaut: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f692), # woman firefighter: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f33e), # woman farmer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f373), # woman cook: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f393), # woman student: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a4), # woman singer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a8), # woman artist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3eb), # woman teacher: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3ed), # woman factory worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bb), # woman technologist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bc), # woman office worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f527), # woman mechanic: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f52c), # woman scientist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f680), # woman astronaut: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f692), # woman firefighter: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f33e), # woman farmer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f373), # woman cook: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f393), # woman student: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a4), # woman singer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a8), # woman artist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3eb), # woman teacher: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3ed), # woman factory worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bb), # woman technologist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bc), # woman office worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f527), # woman mechanic: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f52c), # woman scientist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f680), # woman astronaut: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f692), # woman firefighter: dark skin tone 
            (0x1f46e, 0x0200d, 0x02640, 0x0fe0f), # woman police officer 
            (0x1f46e, 0x0200d, 0x02642, 0x0fe0f), # man police officer 
            (0x1f471, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman 
            (0x1f471, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man 
            (0x1f473, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban 
            (0x1f473, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban 
            (0x1f477, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker 
            (0x1f477, 0x0200d, 0x02642, 0x0fe0f), # man construction worker 
            (0x1f482, 0x0200d, 0x02640, 0x0fe0f), # woman guard 
            (0x1f482, 0x0200d, 0x02642, 0x0fe0f), # man guard 
            (0x1f9d9, 0x0200d, 0x02640, 0x0fe0f), # woman mage 
            (0x1f9d9, 0x0200d, 0x02642, 0x0fe0f), # man mage 
            (0x1f9da, 0x0200d, 0x02640, 0x0fe0f), # woman fairy 
            (0x1f9da, 0x0200d, 0x02642, 0x0fe0f), # man fairy 
            (0x1f9db, 0x0200d, 0x02640, 0x0fe0f), # woman vampire 
            (0x1f9db, 0x0200d, 0x02642, 0x0fe0f), # man vampire 
            (0x1f9dc, 0x0200d, 0x02640, 0x0fe0f), # mermaid 
            (0x1f9dc, 0x0200d, 0x02642, 0x0fe0f), # merman 
            (0x1f9dd, 0x0200d, 0x02640, 0x0fe0f), # woman elf 
            (0x1f9dd, 0x0200d, 0x02642, 0x0fe0f), # man elf 
            (0x1f9de, 0x0200d, 0x02640, 0x0fe0f), # woman genie 
            (0x1f9de, 0x0200d, 0x02642, 0x0fe0f), # man genie 
            (0x1f9df, 0x0200d, 0x02640, 0x0fe0f), # woman zombie 
            (0x1f9df, 0x0200d, 0x02642, 0x0fe0f), # man zombie 
            (0x1f3c3, 0x0200d, 0x02640, 0x0fe0f), # woman running 
            (0x1f3c3, 0x0200d, 0x02642, 0x0fe0f), # man running 
            (0x1f3c4, 0x0200d, 0x02640, 0x0fe0f), # woman surfing 
            (0x1f3c4, 0x0200d, 0x02642, 0x0fe0f), # man surfing 
            (0x1f3ca, 0x0200d, 0x02640, 0x0fe0f), # woman swimming 
            (0x1f3ca, 0x0200d, 0x02642, 0x0fe0f), # man swimming 
            (0x1f46f, 0x0200d, 0x02640, 0x0fe0f), # women with bunny ears 
            (0x1f46f, 0x0200d, 0x02642, 0x0fe0f), # men with bunny ears 
            (0x1f486, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage 
            (0x1f486, 0x0200d, 0x02642, 0x0fe0f), # man getting massage 
            (0x1f487, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut 
            (0x1f487, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut 
            (0x1f6a3, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat 
            (0x1f6a3, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat 
            (0x1f6b4, 0x0200d, 0x02640, 0x0fe0f), # woman biking 
            (0x1f6b4, 0x0200d, 0x02642, 0x0fe0f), # man biking 
            (0x1f6b5, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking 
            (0x1f6b5, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking 
            (0x1f6b6, 0x0200d, 0x02640, 0x0fe0f), # woman walking 
            (0x1f6b6, 0x0200d, 0x02642, 0x0fe0f), # man walking 
            (0x1f938, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling 
            (0x1f938, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling 
            (0x1f939, 0x0200d, 0x02640, 0x0fe0f), # woman juggling 
            (0x1f939, 0x0200d, 0x02642, 0x0fe0f), # man juggling 
            (0x1f93c, 0x0200d, 0x02640, 0x0fe0f), # women wrestling 
            (0x1f93c, 0x0200d, 0x02642, 0x0fe0f), # men wrestling 
            (0x1f93d, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo 
            (0x1f93d, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo 
            (0x1f93e, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball 
            (0x1f93e, 0x0200d, 0x02642, 0x0fe0f), # man playing handball 
            (0x1f9d6, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room 
            (0x1f9d6, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room 
            (0x1f9d7, 0x0200d, 0x02640, 0x0fe0f), # woman climbing 
            (0x1f9d7, 0x0200d, 0x02642, 0x0fe0f), # man climbing 
            (0x1f9d8, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position 
            (0x1f9d8, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position 
            (0x1f481, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand 
            (0x1f481, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand 
            (0x1f645, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO 
            (0x1f645, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO 
            (0x1f646, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK 
            (0x1f646, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK 
            (0x1f647, 0x0200d, 0x02640, 0x0fe0f), # woman bowing 
            (0x1f647, 0x0200d, 0x02642, 0x0fe0f), # man bowing 
            (0x1f64b, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand 
            (0x1f64b, 0x0200d, 0x02642, 0x0fe0f), # man raising hand 
            (0x1f64d, 0x0200d, 0x02640, 0x0fe0f), # woman frowning 
            (0x1f64d, 0x0200d, 0x02642, 0x0fe0f), # man frowning 
            (0x1f64e, 0x0200d, 0x02640, 0x0fe0f), # woman pouting 
            (0x1f64e, 0x0200d, 0x02642, 0x0fe0f), # man pouting 
            (0x1f926, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming 
            (0x1f926, 0x0200d, 0x02642, 0x0fe0f), # man facepalming 
            (0x1f937, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging 
            (0x1f937, 0x0200d, 0x02642, 0x0fe0f), # man shrugging 
            (0x1f3f3, 0x0fe0f, 0x0200d, 0x1f308), # rainbow flag 
        # sequences of length 5,
            (0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, boy, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, girl, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, girl, girl 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466), # family: man, man, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467), # family: man, man, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: man, woman, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: man, woman, girl 
            (0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, girl, girl 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: woman, woman, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: woman, woman, girl 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # man health worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # man judge: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # man pilot: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # man health worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # man judge: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # man pilot: dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # woman judge: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # woman judge: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: dark skin tone 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: light skin tone 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man police officer: light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man police officer: dark skin tone 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman: light skin tone 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man: light skin tone 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman: medium-light skin tone 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man: medium-light skin tone 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman: medium skin tone 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man: medium skin tone 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman: medium-dark skin tone 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man: medium-dark skin tone 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman: dark skin tone 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man: dark skin tone 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: light skin tone 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: dark skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: light skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: dark skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman guard: light skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man guard: light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-light skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-dark skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman guard: dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man guard: dark skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman detective: light skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man detective: light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-light skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-dark skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman detective: dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man detective: dark skin tone 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman detective 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man detective 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mage: light skin tone 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mage: light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mage: dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mage: dark skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: light skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man fairy: light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man fairy: dark skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: light skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man vampire: light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man vampire: dark skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # mermaid: light skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # merman: light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-light skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # merman: medium skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-dark skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # mermaid: dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # merman: dark skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman elf: light skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man elf: light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman elf: dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man elf: dark skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: light skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: dark skin tone 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman running: light skin tone 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man running: light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-light skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man running: medium skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-dark skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman running: dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man running: dark skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: light skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man surfing: light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man surfing: dark skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: light skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man swimming: light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man swimming: dark skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: dark skin tone 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: light skin tone 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man golfing: light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man golfing: dark skin tone 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman golfing 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man golfing 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: light skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: dark skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: light skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: dark skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: dark skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman biking: light skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man biking: light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman biking: dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man biking: dark skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: dark skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman walking: light skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man walking: light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman walking: dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man walking: dark skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: light skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: dark skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: light skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man juggling: light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-light skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-dark skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man juggling: dark skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: light skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: dark skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: light skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: dark skin tone 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: dark skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: light skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man climbing: light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man climbing: dark skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: dark skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: light skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: dark skin tone 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: light skin tone 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: dark skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: light skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: dark skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: light skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bowing: light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-light skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-dark skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bowing: dark skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: light skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: dark skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: light skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man frowning: light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man frowning: dark skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: light skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man pouting: light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man pouting: dark skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: light skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: dark skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: light skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: dark skin tone 
            (0x1f441, 0x0fe0f, 0x0200d, 0x1f5e8, 0x0fe0f), # eye in speech bubble 
        # sequences of length 6,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: man, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469), # couple with heart: woman, woman 
        # sequences of length 7,
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, man, boy, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, man, girl, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, man, girl, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, woman, boy, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, woman, girl, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, woman, girl, girl 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, woman, girl, girl 
        # sequences of length 8,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: man, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469), # kiss: woman, woman 
    },
    '11.0': {
        # Source: ./data/emoji-zwj-sequences-11.0.txt
        # Date: 2018-02-07, 08:40:26 GMT
        #
        # sequences of length 3,
            (0x1f468, 0x0200d, 0x1f466), # family: man, boy 
            (0x1f468, 0x0200d, 0x1f467), # family: man, girl 
            (0x1f469, 0x0200d, 0x1f466), # family: woman, boy 
            (0x1f469, 0x0200d, 0x1f467), # family: woman, girl 
            (0x1f468, 0x0200d, 0x1f33e), # man farmer 
            (0x1f468, 0x0200d, 0x1f373), # man cook 
            (0x1f468, 0x0200d, 0x1f393), # man student 
            (0x1f468, 0x0200d, 0x1f3a4), # man singer 
            (0x1f468, 0x0200d, 0x1f3a8), # man artist 
            (0x1f468, 0x0200d, 0x1f3eb), # man teacher 
            (0x1f468, 0x0200d, 0x1f3ed), # man factory worker 
            (0x1f468, 0x0200d, 0x1f4bb), # man technologist 
            (0x1f468, 0x0200d, 0x1f4bc), # man office worker 
            (0x1f468, 0x0200d, 0x1f527), # man mechanic 
            (0x1f468, 0x0200d, 0x1f52c), # man scientist 
            (0x1f468, 0x0200d, 0x1f680), # man astronaut 
            (0x1f468, 0x0200d, 0x1f692), # man firefighter 
            (0x1f468, 0x0200d, 0x1f9b0), # man, red haired 
            (0x1f468, 0x0200d, 0x1f9b1), # man, curly haired 
            (0x1f468, 0x0200d, 0x1f9b2), # man, bald 
            (0x1f468, 0x0200d, 0x1f9b3), # man, white haired 
            (0x1f469, 0x0200d, 0x1f33e), # woman farmer 
            (0x1f469, 0x0200d, 0x1f373), # woman cook 
            (0x1f469, 0x0200d, 0x1f393), # woman student 
            (0x1f469, 0x0200d, 0x1f3a4), # woman singer 
            (0x1f469, 0x0200d, 0x1f3a8), # woman artist 
            (0x1f469, 0x0200d, 0x1f3eb), # woman teacher 
            (0x1f469, 0x0200d, 0x1f3ed), # woman factory worker 
            (0x1f469, 0x0200d, 0x1f4bb), # woman technologist 
            (0x1f469, 0x0200d, 0x1f4bc), # woman office worker 
            (0x1f469, 0x0200d, 0x1f527), # woman mechanic 
            (0x1f469, 0x0200d, 0x1f52c), # woman scientist 
            (0x1f469, 0x0200d, 0x1f680), # woman astronaut 
            (0x1f469, 0x0200d, 0x1f692), # woman firefighter 
            (0x1f469, 0x0200d, 0x1f9b0), # woman, red haired 
            (0x1f469, 0x0200d, 0x1f9b1), # woman, curly haired 
            (0x1f469, 0x0200d, 0x1f9b2), # woman, bald 
            (0x1f469, 0x0200d, 0x1f9b3), # woman, white haired 
        # sequences of length 4,
            (0x1f468, 0x0200d, 0x02695, 0x0fe0f), # man health worker 
            (0x1f468, 0x0200d, 0x02696, 0x0fe0f), # man judge 
            (0x1f468, 0x0200d, 0x02708, 0x0fe0f), # man pilot 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f33e), # man farmer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f373), # man cook: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f393), # man student: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a4), # man singer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a8), # man artist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3eb), # man teacher: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3ed), # man factory worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bb), # man technologist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bc), # man office worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f527), # man mechanic: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f52c), # man scientist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f680), # man astronaut: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f692), # man firefighter: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b0), # man, red haired: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b1), # man, curly haired: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b2), # man, bald: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b3), # man, white haired: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f33e), # man farmer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f373), # man cook: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f393), # man student: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a4), # man singer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a8), # man artist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3eb), # man teacher: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3ed), # man factory worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bb), # man technologist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bc), # man office worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f527), # man mechanic: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f52c), # man scientist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f680), # man astronaut: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f692), # man firefighter: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b0), # man, red haired: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b1), # man, curly haired: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b2), # man, bald: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b3), # man, white haired: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f33e), # man farmer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f373), # man cook: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f393), # man student: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a4), # man singer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a8), # man artist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3eb), # man teacher: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3ed), # man factory worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bb), # man technologist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bc), # man office worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f527), # man mechanic: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f52c), # man scientist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f680), # man astronaut: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f692), # man firefighter: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b0), # man, red haired: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b1), # man, curly haired: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b2), # man, bald: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b3), # man, white haired: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f33e), # man farmer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f373), # man cook: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f393), # man student: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a4), # man singer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a8), # man artist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3eb), # man teacher: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3ed), # man factory worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bb), # man technologist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bc), # man office worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f527), # man mechanic: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f52c), # man scientist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f680), # man astronaut: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f692), # man firefighter: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b0), # man, red haired: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b1), # man, curly haired: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b2), # man, bald: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b3), # man, white haired: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f33e), # man farmer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f373), # man cook: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f393), # man student: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a4), # man singer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a8), # man artist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3eb), # man teacher: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3ed), # man factory worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bb), # man technologist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bc), # man office worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f527), # man mechanic: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f52c), # man scientist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f680), # man astronaut: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f692), # man firefighter: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b0), # man, red haired: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b1), # man, curly haired: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b2), # man, bald: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b3), # man, white haired: dark skin tone 
            (0x1f469, 0x0200d, 0x02695, 0x0fe0f), # woman health worker 
            (0x1f469, 0x0200d, 0x02696, 0x0fe0f), # woman judge 
            (0x1f469, 0x0200d, 0x02708, 0x0fe0f), # woman pilot 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f33e), # woman farmer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f373), # woman cook: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f393), # woman student: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a4), # woman singer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a8), # woman artist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3eb), # woman teacher: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3ed), # woman factory worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bb), # woman technologist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bc), # woman office worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f527), # woman mechanic: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f52c), # woman scientist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f680), # woman astronaut: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f692), # woman firefighter: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b0), # woman, red haired: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b1), # woman, curly haired: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b2), # woman, bald: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b3), # woman, white haired: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f33e), # woman farmer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f373), # woman cook: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f393), # woman student: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a4), # woman singer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a8), # woman artist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3eb), # woman teacher: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3ed), # woman factory worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bb), # woman technologist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bc), # woman office worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f527), # woman mechanic: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f52c), # woman scientist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f680), # woman astronaut: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f692), # woman firefighter: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b0), # woman, red haired: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b1), # woman, curly haired: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b2), # woman, bald: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b3), # woman, white haired: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f33e), # woman farmer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f373), # woman cook: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f393), # woman student: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a4), # woman singer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a8), # woman artist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3eb), # woman teacher: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3ed), # woman factory worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bb), # woman technologist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bc), # woman office worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f527), # woman mechanic: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f52c), # woman scientist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f680), # woman astronaut: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f692), # woman firefighter: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b0), # woman, red haired: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b1), # woman, curly haired: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b2), # woman, bald: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b3), # woman, white haired: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f33e), # woman farmer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f373), # woman cook: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f393), # woman student: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a4), # woman singer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a8), # woman artist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3eb), # woman teacher: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3ed), # woman factory worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bb), # woman technologist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bc), # woman office worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f527), # woman mechanic: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f52c), # woman scientist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f680), # woman astronaut: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f692), # woman firefighter: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b0), # woman, red haired: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b1), # woman, curly haired: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b2), # woman, bald: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b3), # woman, white haired: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f33e), # woman farmer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f373), # woman cook: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f393), # woman student: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a4), # woman singer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a8), # woman artist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3eb), # woman teacher: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3ed), # woman factory worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bb), # woman technologist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bc), # woman office worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f527), # woman mechanic: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f52c), # woman scientist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f680), # woman astronaut: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f692), # woman firefighter: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b0), # woman, red haired: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b1), # woman, curly haired: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b2), # woman, bald: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b3), # woman, white haired: dark skin tone 
            (0x1f46e, 0x0200d, 0x02640, 0x0fe0f), # woman police officer 
            (0x1f46e, 0x0200d, 0x02642, 0x0fe0f), # man police officer 
            (0x1f471, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman 
            (0x1f471, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man 
            (0x1f473, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban 
            (0x1f473, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban 
            (0x1f477, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker 
            (0x1f477, 0x0200d, 0x02642, 0x0fe0f), # man construction worker 
            (0x1f482, 0x0200d, 0x02640, 0x0fe0f), # woman guard 
            (0x1f482, 0x0200d, 0x02642, 0x0fe0f), # man guard 
            (0x1f9d9, 0x0200d, 0x02640, 0x0fe0f), # woman mage 
            (0x1f9d9, 0x0200d, 0x02642, 0x0fe0f), # man mage 
            (0x1f9da, 0x0200d, 0x02640, 0x0fe0f), # woman fairy 
            (0x1f9da, 0x0200d, 0x02642, 0x0fe0f), # man fairy 
            (0x1f9db, 0x0200d, 0x02640, 0x0fe0f), # woman vampire 
            (0x1f9db, 0x0200d, 0x02642, 0x0fe0f), # man vampire 
            (0x1f9dc, 0x0200d, 0x02640, 0x0fe0f), # mermaid 
            (0x1f9dc, 0x0200d, 0x02642, 0x0fe0f), # merman 
            (0x1f9dd, 0x0200d, 0x02640, 0x0fe0f), # woman elf 
            (0x1f9dd, 0x0200d, 0x02642, 0x0fe0f), # man elf 
            (0x1f9de, 0x0200d, 0x02640, 0x0fe0f), # woman genie 
            (0x1f9de, 0x0200d, 0x02642, 0x0fe0f), # man genie 
            (0x1f9df, 0x0200d, 0x02640, 0x0fe0f), # woman zombie 
            (0x1f9df, 0x0200d, 0x02642, 0x0fe0f), # man zombie 
            (0x1f3c3, 0x0200d, 0x02640, 0x0fe0f), # woman running 
            (0x1f3c3, 0x0200d, 0x02642, 0x0fe0f), # man running 
            (0x1f3c4, 0x0200d, 0x02640, 0x0fe0f), # woman surfing 
            (0x1f3c4, 0x0200d, 0x02642, 0x0fe0f), # man surfing 
            (0x1f3ca, 0x0200d, 0x02640, 0x0fe0f), # woman swimming 
            (0x1f3ca, 0x0200d, 0x02642, 0x0fe0f), # man swimming 
            (0x1f46f, 0x0200d, 0x02640, 0x0fe0f), # women with bunny ears 
            (0x1f46f, 0x0200d, 0x02642, 0x0fe0f), # men with bunny ears 
            (0x1f486, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage 
            (0x1f486, 0x0200d, 0x02642, 0x0fe0f), # man getting massage 
            (0x1f487, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut 
            (0x1f487, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut 
            (0x1f6a3, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat 
            (0x1f6a3, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat 
            (0x1f6b4, 0x0200d, 0x02640, 0x0fe0f), # woman biking 
            (0x1f6b4, 0x0200d, 0x02642, 0x0fe0f), # man biking 
            (0x1f6b5, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking 
            (0x1f6b5, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking 
            (0x1f6b6, 0x0200d, 0x02640, 0x0fe0f), # woman walking 
            (0x1f6b6, 0x0200d, 0x02642, 0x0fe0f), # man walking 
            (0x1f938, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling 
            (0x1f938, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling 
            (0x1f939, 0x0200d, 0x02640, 0x0fe0f), # woman juggling 
            (0x1f939, 0x0200d, 0x02642, 0x0fe0f), # man juggling 
            (0x1f93c, 0x0200d, 0x02640, 0x0fe0f), # women wrestling 
            (0x1f93c, 0x0200d, 0x02642, 0x0fe0f), # men wrestling 
            (0x1f93d, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo 
            (0x1f93d, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo 
            (0x1f93e, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball 
            (0x1f93e, 0x0200d, 0x02642, 0x0fe0f), # man playing handball 
            (0x1f9d6, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room 
            (0x1f9d6, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room 
            (0x1f9d7, 0x0200d, 0x02640, 0x0fe0f), # woman climbing 
            (0x1f9d7, 0x0200d, 0x02642, 0x0fe0f), # man climbing 
            (0x1f9d8, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position 
            (0x1f9d8, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position 
            (0x1f481, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand 
            (0x1f481, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand 
            (0x1f645, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO 
            (0x1f645, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO 
            (0x1f646, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK 
            (0x1f646, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK 
            (0x1f647, 0x0200d, 0x02640, 0x0fe0f), # woman bowing 
            (0x1f647, 0x0200d, 0x02642, 0x0fe0f), # man bowing 
            (0x1f64b, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand 
            (0x1f64b, 0x0200d, 0x02642, 0x0fe0f), # man raising hand 
            (0x1f64d, 0x0200d, 0x02640, 0x0fe0f), # woman frowning 
            (0x1f64d, 0x0200d, 0x02642, 0x0fe0f), # man frowning 
            (0x1f64e, 0x0200d, 0x02640, 0x0fe0f), # woman pouting 
            (0x1f64e, 0x0200d, 0x02642, 0x0fe0f), # man pouting 
            (0x1f926, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming 
            (0x1f926, 0x0200d, 0x02642, 0x0fe0f), # man facepalming 
            (0x1f937, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging 
            (0x1f937, 0x0200d, 0x02642, 0x0fe0f), # man shrugging 
            (0x1f9b8, 0x0200d, 0x02640, 0x0fe0f), # woman superhero 
            (0x1f9b8, 0x0200d, 0x02642, 0x0fe0f), # man superhero 
            (0x1f9b9, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain 
            (0x1f9b9, 0x0200d, 0x02642, 0x0fe0f), # man supervillain 
            (0x1f3f3, 0x0fe0f, 0x0200d, 0x1f308), # rainbow flag 
            (0x1f3f4, 0x0200d, 0x02620, 0x0fe0f), # pirate flag 
        # sequences of length 5,
            (0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, boy, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, girl, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, girl, girl 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466), # family: man, man, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467), # family: man, man, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: man, woman, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: man, woman, girl 
            (0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, girl, girl 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: woman, woman, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: woman, woman, girl 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # man health worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # man judge: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # man pilot: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # man health worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # man judge: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # man pilot: dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # woman judge: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # woman judge: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: dark skin tone 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: light skin tone 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man police officer: light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man police officer: dark skin tone 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman: light skin tone 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man: light skin tone 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman: medium-light skin tone 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man: medium-light skin tone 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman: medium skin tone 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man: medium skin tone 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman: medium-dark skin tone 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man: medium-dark skin tone 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # blond-haired woman: dark skin tone 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # blond-haired man: dark skin tone 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: light skin tone 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: dark skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: light skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: dark skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman guard: light skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man guard: light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-light skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-dark skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman guard: dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man guard: dark skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman detective: light skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man detective: light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-light skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-dark skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman detective: dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man detective: dark skin tone 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman detective 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man detective 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mage: light skin tone 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mage: light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mage: dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mage: dark skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: light skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man fairy: light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man fairy: dark skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: light skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man vampire: light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man vampire: dark skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # mermaid: light skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # merman: light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-light skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # merman: medium skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-dark skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # mermaid: dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # merman: dark skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman elf: light skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man elf: light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman elf: dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man elf: dark skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: light skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: dark skin tone 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman running: light skin tone 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man running: light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-light skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man running: medium skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-dark skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman running: dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man running: dark skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: light skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man surfing: light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man surfing: dark skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: light skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man swimming: light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man swimming: dark skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: dark skin tone 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: light skin tone 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man golfing: light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man golfing: dark skin tone 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman golfing 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man golfing 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: light skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: dark skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: light skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: dark skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: dark skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman biking: light skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man biking: light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman biking: dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man biking: dark skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: dark skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman walking: light skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man walking: light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman walking: dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man walking: dark skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: light skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: dark skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: light skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man juggling: light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-light skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-dark skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man juggling: dark skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: light skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: dark skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: light skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: dark skin tone 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: dark skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: light skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man climbing: light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man climbing: dark skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: dark skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: light skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: dark skin tone 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: light skin tone 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: dark skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: light skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: dark skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: light skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bowing: light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-light skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-dark skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bowing: dark skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: light skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: dark skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: light skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man frowning: light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man frowning: dark skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: light skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man pouting: light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man pouting: dark skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: light skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: dark skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: light skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: dark skin tone 
            (0x1f9b8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: light skin tone 
            (0x1f9b8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man superhero: light skin tone 
            (0x1f9b8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium-light skin tone 
            (0x1f9b8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium-light skin tone 
            (0x1f9b8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium skin tone 
            (0x1f9b8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium skin tone 
            (0x1f9b8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium-dark skin tone 
            (0x1f9b8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium-dark skin tone 
            (0x1f9b8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: dark skin tone 
            (0x1f9b8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man superhero: dark skin tone 
            (0x1f9b9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: light skin tone 
            (0x1f9b9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: light skin tone 
            (0x1f9b9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium-light skin tone 
            (0x1f9b9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium-light skin tone 
            (0x1f9b9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium skin tone 
            (0x1f9b9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium skin tone 
            (0x1f9b9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium-dark skin tone 
            (0x1f9b9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium-dark skin tone 
            (0x1f9b9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: dark skin tone 
            (0x1f9b9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: dark skin tone 
            (0x1f441, 0x0fe0f, 0x0200d, 0x1f5e8, 0x0fe0f), # eye in speech bubble 
        # sequences of length 6,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: man, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469), # couple with heart: woman, woman 
        # sequences of length 7,
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, man, boy, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, man, girl, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, man, girl, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, woman, boy, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, woman, girl, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, woman, girl, girl 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, woman, girl, girl 
        # sequences of length 8,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: man, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469), # kiss: woman, woman 
    },
    '12.0': {
        # Source: ./data/emoji-zwj-sequences-12.0.txt
        # Date: 2019-01-15, 19:25:59 GMT
        #
        # sequences of length 3,
            (0x1f468, 0x0200d, 0x1f466), # family: man, boy 
            (0x1f468, 0x0200d, 0x1f467), # family: man, girl 
            (0x1f469, 0x0200d, 0x1f466), # family: woman, boy 
            (0x1f469, 0x0200d, 0x1f467), # family: woman, girl 
            (0x1f468, 0x0200d, 0x1f33e), # man farmer 
            (0x1f468, 0x0200d, 0x1f373), # man cook 
            (0x1f468, 0x0200d, 0x1f393), # man student 
            (0x1f468, 0x0200d, 0x1f3a4), # man singer 
            (0x1f468, 0x0200d, 0x1f3a8), # man artist 
            (0x1f468, 0x0200d, 0x1f3eb), # man teacher 
            (0x1f468, 0x0200d, 0x1f3ed), # man factory worker 
            (0x1f468, 0x0200d, 0x1f4bb), # man technologist 
            (0x1f468, 0x0200d, 0x1f4bc), # man office worker 
            (0x1f468, 0x0200d, 0x1f527), # man mechanic 
            (0x1f468, 0x0200d, 0x1f52c), # man scientist 
            (0x1f468, 0x0200d, 0x1f680), # man astronaut 
            (0x1f468, 0x0200d, 0x1f692), # man firefighter 
            (0x1f468, 0x0200d, 0x1f9af), # man with probing cane 
            (0x1f468, 0x0200d, 0x1f9bc), # man in motorized wheelchair 
            (0x1f468, 0x0200d, 0x1f9bd), # man in manual wheelchair 
            (0x1f469, 0x0200d, 0x1f33e), # woman farmer 
            (0x1f469, 0x0200d, 0x1f373), # woman cook 
            (0x1f469, 0x0200d, 0x1f393), # woman student 
            (0x1f469, 0x0200d, 0x1f3a4), # woman singer 
            (0x1f469, 0x0200d, 0x1f3a8), # woman artist 
            (0x1f469, 0x0200d, 0x1f3eb), # woman teacher 
            (0x1f469, 0x0200d, 0x1f3ed), # woman factory worker 
            (0x1f469, 0x0200d, 0x1f4bb), # woman technologist 
            (0x1f469, 0x0200d, 0x1f4bc), # woman office worker 
            (0x1f469, 0x0200d, 0x1f527), # woman mechanic 
            (0x1f469, 0x0200d, 0x1f52c), # woman scientist 
            (0x1f469, 0x0200d, 0x1f680), # woman astronaut 
            (0x1f469, 0x0200d, 0x1f692), # woman firefighter 
            (0x1f469, 0x0200d, 0x1f9af), # woman with probing cane 
            (0x1f469, 0x0200d, 0x1f9bc), # woman in motorized wheelchair 
            (0x1f469, 0x0200d, 0x1f9bd), # woman in manual wheelchair 
            (0x1f468, 0x0200d, 0x1f9b0), # man: red hair 
            (0x1f468, 0x0200d, 0x1f9b1), # man: curly hair 
            (0x1f468, 0x0200d, 0x1f9b2), # man: bald 
            (0x1f468, 0x0200d, 0x1f9b3), # man: white hair 
            (0x1f469, 0x0200d, 0x1f9b0), # woman: red hair 
            (0x1f469, 0x0200d, 0x1f9b1), # woman: curly hair 
            (0x1f469, 0x0200d, 0x1f9b2), # woman: bald 
            (0x1f469, 0x0200d, 0x1f9b3), # woman: white hair 
            (0x1f415, 0x0200d, 0x1f9ba), # service dog 
        # sequences of length 4,
            (0x1f468, 0x0200d, 0x02695, 0x0fe0f), # man health worker 
            (0x1f468, 0x0200d, 0x02696, 0x0fe0f), # man judge 
            (0x1f468, 0x0200d, 0x02708, 0x0fe0f), # man pilot 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f33e), # man farmer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f373), # man cook: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f393), # man student: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a4), # man singer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a8), # man artist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3eb), # man teacher: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3ed), # man factory worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bb), # man technologist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bc), # man office worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f527), # man mechanic: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f52c), # man scientist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f680), # man astronaut: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f692), # man firefighter: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9af), # man with probing cane: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9bc), # man in motorized wheelchair: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9bd), # man in manual wheelchair: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f33e), # man farmer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f373), # man cook: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f393), # man student: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a4), # man singer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a8), # man artist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3eb), # man teacher: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3ed), # man factory worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bb), # man technologist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bc), # man office worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f527), # man mechanic: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f52c), # man scientist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f680), # man astronaut: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f692), # man firefighter: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9af), # man with probing cane: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f33e), # man farmer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f373), # man cook: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f393), # man student: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a4), # man singer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a8), # man artist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3eb), # man teacher: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3ed), # man factory worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bb), # man technologist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bc), # man office worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f527), # man mechanic: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f52c), # man scientist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f680), # man astronaut: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f692), # man firefighter: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9af), # man with probing cane: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f33e), # man farmer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f373), # man cook: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f393), # man student: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a4), # man singer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a8), # man artist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3eb), # man teacher: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3ed), # man factory worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bb), # man technologist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bc), # man office worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f527), # man mechanic: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f52c), # man scientist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f680), # man astronaut: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f692), # man firefighter: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9af), # man with probing cane: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f33e), # man farmer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f373), # man cook: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f393), # man student: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a4), # man singer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a8), # man artist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3eb), # man teacher: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3ed), # man factory worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bb), # man technologist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bc), # man office worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f527), # man mechanic: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f52c), # man scientist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f680), # man astronaut: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f692), # man firefighter: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9af), # man with probing cane: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9bc), # man in motorized wheelchair: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9bd), # man in manual wheelchair: dark skin tone 
            (0x1f469, 0x0200d, 0x02695, 0x0fe0f), # woman health worker 
            (0x1f469, 0x0200d, 0x02696, 0x0fe0f), # woman judge 
            (0x1f469, 0x0200d, 0x02708, 0x0fe0f), # woman pilot 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f33e), # woman farmer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f373), # woman cook: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f393), # woman student: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a4), # woman singer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a8), # woman artist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3eb), # woman teacher: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3ed), # woman factory worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bb), # woman technologist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bc), # woman office worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f527), # woman mechanic: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f52c), # woman scientist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f680), # woman astronaut: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f692), # woman firefighter: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9af), # woman with probing cane: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9bd), # woman in manual wheelchair: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f33e), # woman farmer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f373), # woman cook: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f393), # woman student: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a4), # woman singer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a8), # woman artist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3eb), # woman teacher: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3ed), # woman factory worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bb), # woman technologist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bc), # woman office worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f527), # woman mechanic: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f52c), # woman scientist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f680), # woman astronaut: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f692), # woman firefighter: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9af), # woman with probing cane: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f33e), # woman farmer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f373), # woman cook: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f393), # woman student: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a4), # woman singer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a8), # woman artist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3eb), # woman teacher: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3ed), # woman factory worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bb), # woman technologist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bc), # woman office worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f527), # woman mechanic: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f52c), # woman scientist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f680), # woman astronaut: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f692), # woman firefighter: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9af), # woman with probing cane: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f33e), # woman farmer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f373), # woman cook: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f393), # woman student: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a4), # woman singer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a8), # woman artist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3eb), # woman teacher: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3ed), # woman factory worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bb), # woman technologist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bc), # woman office worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f527), # woman mechanic: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f52c), # woman scientist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f680), # woman astronaut: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f692), # woman firefighter: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9af), # woman with probing cane: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f33e), # woman farmer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f373), # woman cook: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f393), # woman student: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a4), # woman singer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a8), # woman artist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3eb), # woman teacher: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3ed), # woman factory worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bb), # woman technologist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bc), # woman office worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f527), # woman mechanic: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f52c), # woman scientist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f680), # woman astronaut: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f692), # woman firefighter: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9af), # woman with probing cane: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9bd), # woman in manual wheelchair: dark skin tone 
            (0x1f3c3, 0x0200d, 0x02640, 0x0fe0f), # woman running 
            (0x1f3c3, 0x0200d, 0x02642, 0x0fe0f), # man running 
            (0x1f3c4, 0x0200d, 0x02640, 0x0fe0f), # woman surfing 
            (0x1f3c4, 0x0200d, 0x02642, 0x0fe0f), # man surfing 
            (0x1f3ca, 0x0200d, 0x02640, 0x0fe0f), # woman swimming 
            (0x1f3ca, 0x0200d, 0x02642, 0x0fe0f), # man swimming 
            (0x1f46e, 0x0200d, 0x02640, 0x0fe0f), # woman police officer 
            (0x1f46e, 0x0200d, 0x02642, 0x0fe0f), # man police officer 
            (0x1f46f, 0x0200d, 0x02640, 0x0fe0f), # women with bunny ears 
            (0x1f46f, 0x0200d, 0x02642, 0x0fe0f), # men with bunny ears 
            (0x1f471, 0x0200d, 0x02640, 0x0fe0f), # woman: blond hair 
            (0x1f471, 0x0200d, 0x02642, 0x0fe0f), # man: blond hair 
            (0x1f473, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban 
            (0x1f473, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban 
            (0x1f477, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker 
            (0x1f477, 0x0200d, 0x02642, 0x0fe0f), # man construction worker 
            (0x1f481, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand 
            (0x1f481, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand 
            (0x1f482, 0x0200d, 0x02640, 0x0fe0f), # woman guard 
            (0x1f482, 0x0200d, 0x02642, 0x0fe0f), # man guard 
            (0x1f486, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage 
            (0x1f486, 0x0200d, 0x02642, 0x0fe0f), # man getting massage 
            (0x1f487, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut 
            (0x1f487, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut 
            (0x1f645, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO 
            (0x1f645, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO 
            (0x1f646, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK 
            (0x1f646, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK 
            (0x1f647, 0x0200d, 0x02640, 0x0fe0f), # woman bowing 
            (0x1f647, 0x0200d, 0x02642, 0x0fe0f), # man bowing 
            (0x1f64b, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand 
            (0x1f64b, 0x0200d, 0x02642, 0x0fe0f), # man raising hand 
            (0x1f64d, 0x0200d, 0x02640, 0x0fe0f), # woman frowning 
            (0x1f64d, 0x0200d, 0x02642, 0x0fe0f), # man frowning 
            (0x1f64e, 0x0200d, 0x02640, 0x0fe0f), # woman pouting 
            (0x1f64e, 0x0200d, 0x02642, 0x0fe0f), # man pouting 
            (0x1f6a3, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat 
            (0x1f6a3, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat 
            (0x1f6b4, 0x0200d, 0x02640, 0x0fe0f), # woman biking 
            (0x1f6b4, 0x0200d, 0x02642, 0x0fe0f), # man biking 
            (0x1f6b5, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking 
            (0x1f6b5, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking 
            (0x1f6b6, 0x0200d, 0x02640, 0x0fe0f), # woman walking 
            (0x1f6b6, 0x0200d, 0x02642, 0x0fe0f), # man walking 
            (0x1f926, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming 
            (0x1f926, 0x0200d, 0x02642, 0x0fe0f), # man facepalming 
            (0x1f937, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging 
            (0x1f937, 0x0200d, 0x02642, 0x0fe0f), # man shrugging 
            (0x1f938, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling 
            (0x1f938, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling 
            (0x1f939, 0x0200d, 0x02640, 0x0fe0f), # woman juggling 
            (0x1f939, 0x0200d, 0x02642, 0x0fe0f), # man juggling 
            (0x1f93c, 0x0200d, 0x02640, 0x0fe0f), # women wrestling 
            (0x1f93c, 0x0200d, 0x02642, 0x0fe0f), # men wrestling 
            (0x1f93d, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo 
            (0x1f93d, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo 
            (0x1f93e, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball 
            (0x1f93e, 0x0200d, 0x02642, 0x0fe0f), # man playing handball 
            (0x1f9b8, 0x0200d, 0x02640, 0x0fe0f), # woman superhero 
            (0x1f9b8, 0x0200d, 0x02642, 0x0fe0f), # man superhero 
            (0x1f9b9, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain 
            (0x1f9b9, 0x0200d, 0x02642, 0x0fe0f), # man supervillain 
            (0x1f9cd, 0x0200d, 0x02640, 0x0fe0f), # woman standing 
            (0x1f9cd, 0x0200d, 0x02642, 0x0fe0f), # man standing 
            (0x1f9ce, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling 
            (0x1f9ce, 0x0200d, 0x02642, 0x0fe0f), # man kneeling 
            (0x1f9cf, 0x0200d, 0x02640, 0x0fe0f), # deaf woman 
            (0x1f9cf, 0x0200d, 0x02642, 0x0fe0f), # deaf man 
            (0x1f9d6, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room 
            (0x1f9d6, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room 
            (0x1f9d7, 0x0200d, 0x02640, 0x0fe0f), # woman climbing 
            (0x1f9d7, 0x0200d, 0x02642, 0x0fe0f), # man climbing 
            (0x1f9d8, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position 
            (0x1f9d8, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position 
            (0x1f9d9, 0x0200d, 0x02640, 0x0fe0f), # woman mage 
            (0x1f9d9, 0x0200d, 0x02642, 0x0fe0f), # man mage 
            (0x1f9da, 0x0200d, 0x02640, 0x0fe0f), # woman fairy 
            (0x1f9da, 0x0200d, 0x02642, 0x0fe0f), # man fairy 
            (0x1f9db, 0x0200d, 0x02640, 0x0fe0f), # woman vampire 
            (0x1f9db, 0x0200d, 0x02642, 0x0fe0f), # man vampire 
            (0x1f9dc, 0x0200d, 0x02640, 0x0fe0f), # mermaid 
            (0x1f9dc, 0x0200d, 0x02642, 0x0fe0f), # merman 
            (0x1f9dd, 0x0200d, 0x02640, 0x0fe0f), # woman elf 
            (0x1f9dd, 0x0200d, 0x02642, 0x0fe0f), # man elf 
            (0x1f9de, 0x0200d, 0x02640, 0x0fe0f), # woman genie 
            (0x1f9de, 0x0200d, 0x02642, 0x0fe0f), # man genie 
            (0x1f9df, 0x0200d, 0x02640, 0x0fe0f), # woman zombie 
            (0x1f9df, 0x0200d, 0x02642, 0x0fe0f), # man zombie 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b0), # man: light skin tone, red hair 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b1), # man: light skin tone, curly hair 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b2), # man: light skin tone, bald 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b3), # man: light skin tone, white hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b0), # man: medium-light skin tone, red hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b1), # man: medium-light skin tone, curly hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b2), # man: medium-light skin tone, bald 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b3), # man: medium-light skin tone, white hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b0), # man: medium skin tone, red hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b1), # man: medium skin tone, curly hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b2), # man: medium skin tone, bald 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b3), # man: medium skin tone, white hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b0), # man: medium-dark skin tone, red hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b1), # man: medium-dark skin tone, curly hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b2), # man: medium-dark skin tone, bald 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b3), # man: medium-dark skin tone, white hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b0), # man: dark skin tone, red hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b1), # man: dark skin tone, curly hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b2), # man: dark skin tone, bald 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b3), # man: dark skin tone, white hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b0), # woman: light skin tone, red hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b1), # woman: light skin tone, curly hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b2), # woman: light skin tone, bald 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b3), # woman: light skin tone, white hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b0), # woman: medium-light skin tone, red hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b1), # woman: medium-light skin tone, curly hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b2), # woman: medium-light skin tone, bald 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b3), # woman: medium-light skin tone, white hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b0), # woman: medium skin tone, red hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b1), # woman: medium skin tone, curly hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b2), # woman: medium skin tone, bald 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b3), # woman: medium skin tone, white hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b0), # woman: medium-dark skin tone, red hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b1), # woman: medium-dark skin tone, curly hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b2), # woman: medium-dark skin tone, bald 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b3), # woman: medium-dark skin tone, white hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b0), # woman: dark skin tone, red hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b1), # woman: dark skin tone, curly hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b2), # woman: dark skin tone, bald 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b3), # woman: dark skin tone, white hair 
            (0x1f3f3, 0x0fe0f, 0x0200d, 0x1f308), # rainbow flag 
            (0x1f3f4, 0x0200d, 0x02620, 0x0fe0f), # pirate flag 
        # sequences of length 5,
            (0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, boy, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, girl, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, girl, girl 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466), # family: man, man, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467), # family: man, man, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: man, woman, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: man, woman, girl 
            (0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, girl, girl 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: woman, woman, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: woman, woman, girl 
            (0x1f9d1, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1), # people holding hands 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # man health worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # man judge: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # man pilot: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # man health worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # man judge: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # man pilot: dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # woman judge: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # woman judge: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: dark skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: light skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: dark skin tone 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman running: light skin tone 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man running: light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-light skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man running: medium skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-dark skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman running: dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man running: dark skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: light skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man surfing: light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man surfing: dark skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: light skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man swimming: light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man swimming: dark skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: dark skin tone 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: light skin tone 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man golfing: light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man golfing: dark skin tone 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman golfing 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man golfing 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: light skin tone 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man police officer: light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man police officer: dark skin tone 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman: light skin tone, blond hair 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man: light skin tone, blond hair 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-light skin tone, blond hair 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man: medium-light skin tone, blond hair 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman: medium skin tone, blond hair 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man: medium skin tone, blond hair 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-dark skin tone, blond hair 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man: medium-dark skin tone, blond hair 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman: dark skin tone, blond hair 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man: dark skin tone, blond hair 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: light skin tone 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: dark skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: light skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: dark skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: light skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: dark skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman guard: light skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man guard: light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-light skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-dark skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman guard: dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man guard: dark skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: light skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: dark skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: light skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: dark skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman detective: light skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man detective: light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-light skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-dark skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman detective: dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man detective: dark skin tone 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman detective 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man detective 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: light skin tone 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: dark skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: light skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: dark skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: light skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bowing: light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-light skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-dark skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bowing: dark skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: light skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: dark skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: light skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man frowning: light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man frowning: dark skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: light skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man pouting: light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man pouting: dark skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: dark skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman biking: light skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man biking: light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman biking: dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man biking: dark skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: dark skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman walking: light skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man walking: light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman walking: dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man walking: dark skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: light skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: dark skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: light skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: dark skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: light skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: dark skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: light skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man juggling: light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-light skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-dark skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man juggling: dark skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: light skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: dark skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: light skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: dark skin tone 
            (0x1f9b8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: light skin tone 
            (0x1f9b8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man superhero: light skin tone 
            (0x1f9b8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium-light skin tone 
            (0x1f9b8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium-light skin tone 
            (0x1f9b8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium skin tone 
            (0x1f9b8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium skin tone 
            (0x1f9b8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium-dark skin tone 
            (0x1f9b8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium-dark skin tone 
            (0x1f9b8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: dark skin tone 
            (0x1f9b8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man superhero: dark skin tone 
            (0x1f9b9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: light skin tone 
            (0x1f9b9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: light skin tone 
            (0x1f9b9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium-light skin tone 
            (0x1f9b9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium-light skin tone 
            (0x1f9b9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium skin tone 
            (0x1f9b9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium skin tone 
            (0x1f9b9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium-dark skin tone 
            (0x1f9b9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium-dark skin tone 
            (0x1f9b9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: dark skin tone 
            (0x1f9b9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: dark skin tone 
            (0x1f9cd, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman standing: light skin tone 
            (0x1f9cd, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man standing: light skin tone 
            (0x1f9cd, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium-light skin tone 
            (0x1f9cd, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium-light skin tone 
            (0x1f9cd, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium skin tone 
            (0x1f9cd, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium skin tone 
            (0x1f9cd, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium-dark skin tone 
            (0x1f9cd, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium-dark skin tone 
            (0x1f9cd, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman standing: dark skin tone 
            (0x1f9cd, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man standing: dark skin tone 
            (0x1f9ce, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: light skin tone 
            (0x1f9ce, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: light skin tone 
            (0x1f9ce, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium-light skin tone 
            (0x1f9ce, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium-light skin tone 
            (0x1f9ce, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium skin tone 
            (0x1f9ce, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium skin tone 
            (0x1f9ce, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium-dark skin tone 
            (0x1f9ce, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium-dark skin tone 
            (0x1f9ce, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: dark skin tone 
            (0x1f9ce, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: dark skin tone 
            (0x1f9cf, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: light skin tone 
            (0x1f9cf, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # deaf man: light skin tone 
            (0x1f9cf, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium-light skin tone 
            (0x1f9cf, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium-light skin tone 
            (0x1f9cf, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium skin tone 
            (0x1f9cf, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium skin tone 
            (0x1f9cf, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium-dark skin tone 
            (0x1f9cf, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium-dark skin tone 
            (0x1f9cf, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: dark skin tone 
            (0x1f9cf, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # deaf man: dark skin tone 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: dark skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: light skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man climbing: light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man climbing: dark skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: dark skin tone 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mage: light skin tone 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mage: light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mage: dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mage: dark skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: light skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man fairy: light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man fairy: dark skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: light skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man vampire: light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man vampire: dark skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # mermaid: light skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # merman: light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-light skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # merman: medium skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-dark skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # mermaid: dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # merman: dark skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman elf: light skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man elf: light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman elf: dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man elf: dark skin tone 
            (0x1f441, 0x0fe0f, 0x0200d, 0x1f5e8, 0x0fe0f), # eye in speech bubble 
        # sequences of length 6,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: man, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469), # couple with heart: woman, woman 
        # sequences of length 7,
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, man, boy, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, man, girl, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, man, girl, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, woman, boy, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, woman, girl, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, woman, girl, girl 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium-light skin tone, light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium skin tone, light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: medium skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium-dark skin tone, light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: medium-dark skin tone, medium skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: dark skin tone, light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: dark skin tone, medium skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: dark skin tone, medium-dark skin tone 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, woman, girl, girl 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: dark skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium-light skin tone, light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium skin tone, light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium-dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium-dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: dark skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: dark skin tone 
        # sequences of length 8,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: man, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469), # kiss: woman, woman 
    },
    '12.1': {
        # Source: ./data/emoji-zwj-sequences-12.1.txt
        # Date: 2019-10-12, 21:18:36 GMT
        #
        # sequences of length 3,
            (0x1f468, 0x0200d, 0x1f466), # family: man, boy 
            (0x1f468, 0x0200d, 0x1f467), # family: man, girl 
            (0x1f469, 0x0200d, 0x1f466), # family: woman, boy 
            (0x1f469, 0x0200d, 0x1f467), # family: woman, girl 
            (0x1f468, 0x0200d, 0x1f33e), # man farmer 
            (0x1f468, 0x0200d, 0x1f373), # man cook 
            (0x1f468, 0x0200d, 0x1f393), # man student 
            (0x1f468, 0x0200d, 0x1f3a4), # man singer 
            (0x1f468, 0x0200d, 0x1f3a8), # man artist 
            (0x1f468, 0x0200d, 0x1f3eb), # man teacher 
            (0x1f468, 0x0200d, 0x1f3ed), # man factory worker 
            (0x1f468, 0x0200d, 0x1f4bb), # man technologist 
            (0x1f468, 0x0200d, 0x1f4bc), # man office worker 
            (0x1f468, 0x0200d, 0x1f527), # man mechanic 
            (0x1f468, 0x0200d, 0x1f52c), # man scientist 
            (0x1f468, 0x0200d, 0x1f680), # man astronaut 
            (0x1f468, 0x0200d, 0x1f692), # man firefighter 
            (0x1f468, 0x0200d, 0x1f9af), # man with probing cane 
            (0x1f468, 0x0200d, 0x1f9bc), # man in motorized wheelchair 
            (0x1f468, 0x0200d, 0x1f9bd), # man in manual wheelchair 
            (0x1f469, 0x0200d, 0x1f33e), # woman farmer 
            (0x1f469, 0x0200d, 0x1f373), # woman cook 
            (0x1f469, 0x0200d, 0x1f393), # woman student 
            (0x1f469, 0x0200d, 0x1f3a4), # woman singer 
            (0x1f469, 0x0200d, 0x1f3a8), # woman artist 
            (0x1f469, 0x0200d, 0x1f3eb), # woman teacher 
            (0x1f469, 0x0200d, 0x1f3ed), # woman factory worker 
            (0x1f469, 0x0200d, 0x1f4bb), # woman technologist 
            (0x1f469, 0x0200d, 0x1f4bc), # woman office worker 
            (0x1f469, 0x0200d, 0x1f527), # woman mechanic 
            (0x1f469, 0x0200d, 0x1f52c), # woman scientist 
            (0x1f469, 0x0200d, 0x1f680), # woman astronaut 
            (0x1f469, 0x0200d, 0x1f692), # woman firefighter 
            (0x1f469, 0x0200d, 0x1f9af), # woman with probing cane 
            (0x1f469, 0x0200d, 0x1f9bc), # woman in motorized wheelchair 
            (0x1f469, 0x0200d, 0x1f9bd), # woman in manual wheelchair 
            (0x1f9d1, 0x0200d, 0x1f33e), # farmer 
            (0x1f9d1, 0x0200d, 0x1f373), # cook 
            (0x1f9d1, 0x0200d, 0x1f393), # student 
            (0x1f9d1, 0x0200d, 0x1f3a4), # singer 
            (0x1f9d1, 0x0200d, 0x1f3a8), # artist 
            (0x1f9d1, 0x0200d, 0x1f3eb), # teacher 
            (0x1f9d1, 0x0200d, 0x1f3ed), # factory worker 
            (0x1f9d1, 0x0200d, 0x1f4bb), # technologist 
            (0x1f9d1, 0x0200d, 0x1f4bc), # office worker 
            (0x1f9d1, 0x0200d, 0x1f527), # mechanic 
            (0x1f9d1, 0x0200d, 0x1f52c), # scientist 
            (0x1f9d1, 0x0200d, 0x1f680), # astronaut 
            (0x1f9d1, 0x0200d, 0x1f692), # firefighter 
            (0x1f9d1, 0x0200d, 0x1f9af), # person with probing cane 
            (0x1f9d1, 0x0200d, 0x1f9bc), # person in motorized wheelchair 
            (0x1f9d1, 0x0200d, 0x1f9bd), # person in manual wheelchair 
            (0x1f468, 0x0200d, 0x1f9b0), # man: red hair 
            (0x1f468, 0x0200d, 0x1f9b1), # man: curly hair 
            (0x1f468, 0x0200d, 0x1f9b2), # man: bald 
            (0x1f468, 0x0200d, 0x1f9b3), # man: white hair 
            (0x1f469, 0x0200d, 0x1f9b0), # woman: red hair 
            (0x1f469, 0x0200d, 0x1f9b1), # woman: curly hair 
            (0x1f469, 0x0200d, 0x1f9b2), # woman: bald 
            (0x1f469, 0x0200d, 0x1f9b3), # woman: white hair 
            (0x1f9d1, 0x0200d, 0x1f9b0), # person: red hair 
            (0x1f9d1, 0x0200d, 0x1f9b1), # person: curly hair 
            (0x1f9d1, 0x0200d, 0x1f9b2), # person: bald 
            (0x1f9d1, 0x0200d, 0x1f9b3), # person: white hair 
            (0x1f415, 0x0200d, 0x1f9ba), # service dog 
        # sequences of length 4,
            (0x1f468, 0x0200d, 0x02695, 0x0fe0f), # man health worker 
            (0x1f468, 0x0200d, 0x02696, 0x0fe0f), # man judge 
            (0x1f468, 0x0200d, 0x02708, 0x0fe0f), # man pilot 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f33e), # man farmer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f373), # man cook: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f393), # man student: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a4), # man singer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a8), # man artist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3eb), # man teacher: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3ed), # man factory worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bb), # man technologist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bc), # man office worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f527), # man mechanic: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f52c), # man scientist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f680), # man astronaut: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f692), # man firefighter: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9af), # man with probing cane: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9bc), # man in motorized wheelchair: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9bd), # man in manual wheelchair: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f33e), # man farmer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f373), # man cook: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f393), # man student: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a4), # man singer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a8), # man artist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3eb), # man teacher: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3ed), # man factory worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bb), # man technologist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bc), # man office worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f527), # man mechanic: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f52c), # man scientist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f680), # man astronaut: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f692), # man firefighter: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9af), # man with probing cane: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f33e), # man farmer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f373), # man cook: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f393), # man student: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a4), # man singer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a8), # man artist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3eb), # man teacher: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3ed), # man factory worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bb), # man technologist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bc), # man office worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f527), # man mechanic: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f52c), # man scientist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f680), # man astronaut: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f692), # man firefighter: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9af), # man with probing cane: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f33e), # man farmer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f373), # man cook: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f393), # man student: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a4), # man singer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a8), # man artist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3eb), # man teacher: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3ed), # man factory worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bb), # man technologist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bc), # man office worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f527), # man mechanic: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f52c), # man scientist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f680), # man astronaut: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f692), # man firefighter: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9af), # man with probing cane: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f33e), # man farmer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f373), # man cook: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f393), # man student: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a4), # man singer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a8), # man artist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3eb), # man teacher: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3ed), # man factory worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bb), # man technologist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bc), # man office worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f527), # man mechanic: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f52c), # man scientist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f680), # man astronaut: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f692), # man firefighter: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9af), # man with probing cane: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9bc), # man in motorized wheelchair: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9bd), # man in manual wheelchair: dark skin tone 
            (0x1f469, 0x0200d, 0x02695, 0x0fe0f), # woman health worker 
            (0x1f469, 0x0200d, 0x02696, 0x0fe0f), # woman judge 
            (0x1f469, 0x0200d, 0x02708, 0x0fe0f), # woman pilot 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f33e), # woman farmer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f373), # woman cook: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f393), # woman student: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a4), # woman singer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a8), # woman artist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3eb), # woman teacher: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3ed), # woman factory worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bb), # woman technologist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bc), # woman office worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f527), # woman mechanic: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f52c), # woman scientist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f680), # woman astronaut: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f692), # woman firefighter: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9af), # woman with probing cane: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9bd), # woman in manual wheelchair: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f33e), # woman farmer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f373), # woman cook: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f393), # woman student: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a4), # woman singer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a8), # woman artist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3eb), # woman teacher: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3ed), # woman factory worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bb), # woman technologist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bc), # woman office worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f527), # woman mechanic: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f52c), # woman scientist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f680), # woman astronaut: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f692), # woman firefighter: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9af), # woman with probing cane: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f33e), # woman farmer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f373), # woman cook: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f393), # woman student: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a4), # woman singer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a8), # woman artist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3eb), # woman teacher: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3ed), # woman factory worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bb), # woman technologist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bc), # woman office worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f527), # woman mechanic: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f52c), # woman scientist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f680), # woman astronaut: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f692), # woman firefighter: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9af), # woman with probing cane: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f33e), # woman farmer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f373), # woman cook: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f393), # woman student: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a4), # woman singer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a8), # woman artist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3eb), # woman teacher: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3ed), # woman factory worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bb), # woman technologist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bc), # woman office worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f527), # woman mechanic: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f52c), # woman scientist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f680), # woman astronaut: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f692), # woman firefighter: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9af), # woman with probing cane: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f33e), # woman farmer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f373), # woman cook: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f393), # woman student: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a4), # woman singer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a8), # woman artist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3eb), # woman teacher: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3ed), # woman factory worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bb), # woman technologist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bc), # woman office worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f527), # woman mechanic: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f52c), # woman scientist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f680), # woman astronaut: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f692), # woman firefighter: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9af), # woman with probing cane: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9bd), # woman in manual wheelchair: dark skin tone 
            (0x1f9d1, 0x0200d, 0x02695, 0x0fe0f), # health worker 
            (0x1f9d1, 0x0200d, 0x02696, 0x0fe0f), # judge 
            (0x1f9d1, 0x0200d, 0x02708, 0x0fe0f), # pilot 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f33e), # farmer: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f373), # cook: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f393), # student: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3a4), # singer: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3a8), # artist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3eb), # teacher: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3ed), # factory worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f4bb), # technologist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f4bc), # office worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f527), # mechanic: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f52c), # scientist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f680), # astronaut: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f692), # firefighter: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9af), # person with probing cane: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9bc), # person in motorized wheelchair: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9bd), # person in manual wheelchair: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f33e), # farmer: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f373), # cook: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f393), # student: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3a4), # singer: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3a8), # artist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3eb), # teacher: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3ed), # factory worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f4bb), # technologist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f4bc), # office worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f527), # mechanic: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f52c), # scientist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f680), # astronaut: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f692), # firefighter: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9af), # person with probing cane: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f33e), # farmer: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f373), # cook: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f393), # student: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3a4), # singer: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3a8), # artist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3eb), # teacher: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3ed), # factory worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f4bb), # technologist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f4bc), # office worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f527), # mechanic: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f52c), # scientist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f680), # astronaut: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f692), # firefighter: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9af), # person with probing cane: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f33e), # farmer: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f373), # cook: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f393), # student: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3a4), # singer: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3a8), # artist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3eb), # teacher: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3ed), # factory worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f4bb), # technologist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f4bc), # office worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f527), # mechanic: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f52c), # scientist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f680), # astronaut: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f692), # firefighter: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9af), # person with probing cane: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f33e), # farmer: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f373), # cook: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f393), # student: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3a4), # singer: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3a8), # artist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3eb), # teacher: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3ed), # factory worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f4bb), # technologist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f4bc), # office worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f527), # mechanic: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f52c), # scientist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f680), # astronaut: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f692), # firefighter: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9af), # person with probing cane: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9bc), # person in motorized wheelchair: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9bd), # person in manual wheelchair: dark skin tone 
            (0x1f3c3, 0x0200d, 0x02640, 0x0fe0f), # woman running 
            (0x1f3c3, 0x0200d, 0x02642, 0x0fe0f), # man running 
            (0x1f3c4, 0x0200d, 0x02640, 0x0fe0f), # woman surfing 
            (0x1f3c4, 0x0200d, 0x02642, 0x0fe0f), # man surfing 
            (0x1f3ca, 0x0200d, 0x02640, 0x0fe0f), # woman swimming 
            (0x1f3ca, 0x0200d, 0x02642, 0x0fe0f), # man swimming 
            (0x1f46e, 0x0200d, 0x02640, 0x0fe0f), # woman police officer 
            (0x1f46e, 0x0200d, 0x02642, 0x0fe0f), # man police officer 
            (0x1f46f, 0x0200d, 0x02640, 0x0fe0f), # women with bunny ears 
            (0x1f46f, 0x0200d, 0x02642, 0x0fe0f), # men with bunny ears 
            (0x1f471, 0x0200d, 0x02640, 0x0fe0f), # woman: blond hair 
            (0x1f471, 0x0200d, 0x02642, 0x0fe0f), # man: blond hair 
            (0x1f473, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban 
            (0x1f473, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban 
            (0x1f477, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker 
            (0x1f477, 0x0200d, 0x02642, 0x0fe0f), # man construction worker 
            (0x1f481, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand 
            (0x1f481, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand 
            (0x1f482, 0x0200d, 0x02640, 0x0fe0f), # woman guard 
            (0x1f482, 0x0200d, 0x02642, 0x0fe0f), # man guard 
            (0x1f486, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage 
            (0x1f486, 0x0200d, 0x02642, 0x0fe0f), # man getting massage 
            (0x1f487, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut 
            (0x1f487, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut 
            (0x1f645, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO 
            (0x1f645, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO 
            (0x1f646, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK 
            (0x1f646, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK 
            (0x1f647, 0x0200d, 0x02640, 0x0fe0f), # woman bowing 
            (0x1f647, 0x0200d, 0x02642, 0x0fe0f), # man bowing 
            (0x1f64b, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand 
            (0x1f64b, 0x0200d, 0x02642, 0x0fe0f), # man raising hand 
            (0x1f64d, 0x0200d, 0x02640, 0x0fe0f), # woman frowning 
            (0x1f64d, 0x0200d, 0x02642, 0x0fe0f), # man frowning 
            (0x1f64e, 0x0200d, 0x02640, 0x0fe0f), # woman pouting 
            (0x1f64e, 0x0200d, 0x02642, 0x0fe0f), # man pouting 
            (0x1f6a3, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat 
            (0x1f6a3, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat 
            (0x1f6b4, 0x0200d, 0x02640, 0x0fe0f), # woman biking 
            (0x1f6b4, 0x0200d, 0x02642, 0x0fe0f), # man biking 
            (0x1f6b5, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking 
            (0x1f6b5, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking 
            (0x1f6b6, 0x0200d, 0x02640, 0x0fe0f), # woman walking 
            (0x1f6b6, 0x0200d, 0x02642, 0x0fe0f), # man walking 
            (0x1f926, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming 
            (0x1f926, 0x0200d, 0x02642, 0x0fe0f), # man facepalming 
            (0x1f937, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging 
            (0x1f937, 0x0200d, 0x02642, 0x0fe0f), # man shrugging 
            (0x1f938, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling 
            (0x1f938, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling 
            (0x1f939, 0x0200d, 0x02640, 0x0fe0f), # woman juggling 
            (0x1f939, 0x0200d, 0x02642, 0x0fe0f), # man juggling 
            (0x1f93c, 0x0200d, 0x02640, 0x0fe0f), # women wrestling 
            (0x1f93c, 0x0200d, 0x02642, 0x0fe0f), # men wrestling 
            (0x1f93d, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo 
            (0x1f93d, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo 
            (0x1f93e, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball 
            (0x1f93e, 0x0200d, 0x02642, 0x0fe0f), # man playing handball 
            (0x1f9b8, 0x0200d, 0x02640, 0x0fe0f), # woman superhero 
            (0x1f9b8, 0x0200d, 0x02642, 0x0fe0f), # man superhero 
            (0x1f9b9, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain 
            (0x1f9b9, 0x0200d, 0x02642, 0x0fe0f), # man supervillain 
            (0x1f9cd, 0x0200d, 0x02640, 0x0fe0f), # woman standing 
            (0x1f9cd, 0x0200d, 0x02642, 0x0fe0f), # man standing 
            (0x1f9ce, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling 
            (0x1f9ce, 0x0200d, 0x02642, 0x0fe0f), # man kneeling 
            (0x1f9cf, 0x0200d, 0x02640, 0x0fe0f), # deaf woman 
            (0x1f9cf, 0x0200d, 0x02642, 0x0fe0f), # deaf man 
            (0x1f9d6, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room 
            (0x1f9d6, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room 
            (0x1f9d7, 0x0200d, 0x02640, 0x0fe0f), # woman climbing 
            (0x1f9d7, 0x0200d, 0x02642, 0x0fe0f), # man climbing 
            (0x1f9d8, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position 
            (0x1f9d8, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position 
            (0x1f9d9, 0x0200d, 0x02640, 0x0fe0f), # woman mage 
            (0x1f9d9, 0x0200d, 0x02642, 0x0fe0f), # man mage 
            (0x1f9da, 0x0200d, 0x02640, 0x0fe0f), # woman fairy 
            (0x1f9da, 0x0200d, 0x02642, 0x0fe0f), # man fairy 
            (0x1f9db, 0x0200d, 0x02640, 0x0fe0f), # woman vampire 
            (0x1f9db, 0x0200d, 0x02642, 0x0fe0f), # man vampire 
            (0x1f9dc, 0x0200d, 0x02640, 0x0fe0f), # mermaid 
            (0x1f9dc, 0x0200d, 0x02642, 0x0fe0f), # merman 
            (0x1f9dd, 0x0200d, 0x02640, 0x0fe0f), # woman elf 
            (0x1f9dd, 0x0200d, 0x02642, 0x0fe0f), # man elf 
            (0x1f9de, 0x0200d, 0x02640, 0x0fe0f), # woman genie 
            (0x1f9de, 0x0200d, 0x02642, 0x0fe0f), # man genie 
            (0x1f9df, 0x0200d, 0x02640, 0x0fe0f), # woman zombie 
            (0x1f9df, 0x0200d, 0x02642, 0x0fe0f), # man zombie 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b0), # man: light skin tone, red hair 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b1), # man: light skin tone, curly hair 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b2), # man: light skin tone, bald 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b3), # man: light skin tone, white hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b0), # man: medium-light skin tone, red hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b1), # man: medium-light skin tone, curly hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b2), # man: medium-light skin tone, bald 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b3), # man: medium-light skin tone, white hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b0), # man: medium skin tone, red hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b1), # man: medium skin tone, curly hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b2), # man: medium skin tone, bald 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b3), # man: medium skin tone, white hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b0), # man: medium-dark skin tone, red hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b1), # man: medium-dark skin tone, curly hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b2), # man: medium-dark skin tone, bald 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b3), # man: medium-dark skin tone, white hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b0), # man: dark skin tone, red hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b1), # man: dark skin tone, curly hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b2), # man: dark skin tone, bald 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b3), # man: dark skin tone, white hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b0), # woman: light skin tone, red hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b1), # woman: light skin tone, curly hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b2), # woman: light skin tone, bald 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b3), # woman: light skin tone, white hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b0), # woman: medium-light skin tone, red hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b1), # woman: medium-light skin tone, curly hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b2), # woman: medium-light skin tone, bald 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b3), # woman: medium-light skin tone, white hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b0), # woman: medium skin tone, red hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b1), # woman: medium skin tone, curly hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b2), # woman: medium skin tone, bald 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b3), # woman: medium skin tone, white hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b0), # woman: medium-dark skin tone, red hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b1), # woman: medium-dark skin tone, curly hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b2), # woman: medium-dark skin tone, bald 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b3), # woman: medium-dark skin tone, white hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b0), # woman: dark skin tone, red hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b1), # woman: dark skin tone, curly hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b2), # woman: dark skin tone, bald 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b3), # woman: dark skin tone, white hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b0), # person: light skin tone, red hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b1), # person: light skin tone, curly hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b2), # person: light skin tone, bald 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b3), # person: light skin tone, white hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b0), # person: medium-light skin tone, red hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b1), # person: medium-light skin tone, curly hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b2), # person: medium-light skin tone, bald 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b3), # person: medium-light skin tone, white hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b0), # person: medium skin tone, red hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b1), # person: medium skin tone, curly hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b2), # person: medium skin tone, bald 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b3), # person: medium skin tone, white hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b0), # person: medium-dark skin tone, red hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b1), # person: medium-dark skin tone, curly hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b2), # person: medium-dark skin tone, bald 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b3), # person: medium-dark skin tone, white hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b0), # person: dark skin tone, red hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b1), # person: dark skin tone, curly hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b2), # person: dark skin tone, bald 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b3), # person: dark skin tone, white hair 
            (0x1f3f3, 0x0fe0f, 0x0200d, 0x1f308), # rainbow flag 
            (0x1f3f4, 0x0200d, 0x02620, 0x0fe0f), # pirate flag 
        # sequences of length 5,
            (0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, boy, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, girl, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, girl, girl 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466), # family: man, man, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467), # family: man, man, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: man, woman, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: man, woman, girl 
            (0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, girl, girl 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: woman, woman, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: woman, woman, girl 
            (0x1f9d1, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1), # people holding hands 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # man health worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # man judge: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # man pilot: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # man health worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # man judge: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # man pilot: dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # woman judge: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # woman judge: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # health worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # judge: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # pilot: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # judge: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # judge: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # judge: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # health worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # judge: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # pilot: dark skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: light skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: dark skin tone 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman running: light skin tone 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man running: light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-light skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man running: medium skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-dark skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman running: dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man running: dark skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: light skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man surfing: light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man surfing: dark skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: light skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man swimming: light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man swimming: dark skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: dark skin tone 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: light skin tone 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man golfing: light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man golfing: dark skin tone 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman golfing 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man golfing 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: light skin tone 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man police officer: light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man police officer: dark skin tone 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman: light skin tone, blond hair 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man: light skin tone, blond hair 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-light skin tone, blond hair 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man: medium-light skin tone, blond hair 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman: medium skin tone, blond hair 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man: medium skin tone, blond hair 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-dark skin tone, blond hair 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man: medium-dark skin tone, blond hair 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman: dark skin tone, blond hair 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man: dark skin tone, blond hair 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: light skin tone 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: dark skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: light skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: dark skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: light skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: dark skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman guard: light skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man guard: light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-light skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-dark skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman guard: dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man guard: dark skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: light skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: dark skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: light skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: dark skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman detective: light skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man detective: light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-light skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-dark skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman detective: dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man detective: dark skin tone 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman detective 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man detective 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: light skin tone 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: dark skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: light skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: dark skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: light skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bowing: light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-light skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-dark skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bowing: dark skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: light skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: dark skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: light skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man frowning: light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man frowning: dark skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: light skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man pouting: light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man pouting: dark skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: dark skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman biking: light skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man biking: light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman biking: dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man biking: dark skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: dark skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman walking: light skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man walking: light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman walking: dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man walking: dark skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: light skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: dark skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: light skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: dark skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: light skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: dark skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: light skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man juggling: light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-light skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-dark skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man juggling: dark skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: light skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: dark skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: light skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: dark skin tone 
            (0x1f9b8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: light skin tone 
            (0x1f9b8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man superhero: light skin tone 
            (0x1f9b8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium-light skin tone 
            (0x1f9b8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium-light skin tone 
            (0x1f9b8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium skin tone 
            (0x1f9b8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium skin tone 
            (0x1f9b8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium-dark skin tone 
            (0x1f9b8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium-dark skin tone 
            (0x1f9b8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: dark skin tone 
            (0x1f9b8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man superhero: dark skin tone 
            (0x1f9b9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: light skin tone 
            (0x1f9b9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: light skin tone 
            (0x1f9b9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium-light skin tone 
            (0x1f9b9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium-light skin tone 
            (0x1f9b9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium skin tone 
            (0x1f9b9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium skin tone 
            (0x1f9b9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium-dark skin tone 
            (0x1f9b9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium-dark skin tone 
            (0x1f9b9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: dark skin tone 
            (0x1f9b9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: dark skin tone 
            (0x1f9cd, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman standing: light skin tone 
            (0x1f9cd, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man standing: light skin tone 
            (0x1f9cd, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium-light skin tone 
            (0x1f9cd, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium-light skin tone 
            (0x1f9cd, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium skin tone 
            (0x1f9cd, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium skin tone 
            (0x1f9cd, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium-dark skin tone 
            (0x1f9cd, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium-dark skin tone 
            (0x1f9cd, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman standing: dark skin tone 
            (0x1f9cd, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man standing: dark skin tone 
            (0x1f9ce, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: light skin tone 
            (0x1f9ce, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: light skin tone 
            (0x1f9ce, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium-light skin tone 
            (0x1f9ce, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium-light skin tone 
            (0x1f9ce, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium skin tone 
            (0x1f9ce, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium skin tone 
            (0x1f9ce, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium-dark skin tone 
            (0x1f9ce, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium-dark skin tone 
            (0x1f9ce, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: dark skin tone 
            (0x1f9ce, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: dark skin tone 
            (0x1f9cf, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: light skin tone 
            (0x1f9cf, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # deaf man: light skin tone 
            (0x1f9cf, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium-light skin tone 
            (0x1f9cf, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium-light skin tone 
            (0x1f9cf, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium skin tone 
            (0x1f9cf, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium skin tone 
            (0x1f9cf, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium-dark skin tone 
            (0x1f9cf, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium-dark skin tone 
            (0x1f9cf, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: dark skin tone 
            (0x1f9cf, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # deaf man: dark skin tone 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: dark skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: light skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man climbing: light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man climbing: dark skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: dark skin tone 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mage: light skin tone 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mage: light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mage: dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mage: dark skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: light skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man fairy: light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man fairy: dark skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: light skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man vampire: light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man vampire: dark skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # mermaid: light skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # merman: light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-light skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # merman: medium skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-dark skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # mermaid: dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # merman: dark skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman elf: light skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man elf: light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman elf: dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man elf: dark skin tone 
            (0x1f441, 0x0fe0f, 0x0200d, 0x1f5e8, 0x0fe0f), # eye in speech bubble 
        # sequences of length 6,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: man, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469), # couple with heart: woman, woman 
        # sequences of length 7,
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, man, boy, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, man, girl, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, man, girl, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, woman, boy, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, woman, girl, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, woman, girl, girl 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: light skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: light skin tone, medium skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: light skin tone, dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium-light skin tone, light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: medium-light skin tone, medium skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium-light skin tone, dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium skin tone, light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: medium skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: medium skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium skin tone, dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium-dark skin tone, light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: medium-dark skin tone, medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium-dark skin tone, dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: dark skin tone, light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: dark skin tone, medium skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: dark skin tone, medium-dark skin tone 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, woman, girl, girl 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: light skin tone, dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: dark skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: light skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium-light skin tone, light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium-light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: medium-light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium skin tone, light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: medium skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: medium skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium-dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium-dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: medium-dark skin tone, dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: dark skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: dark skin tone 
        # sequences of length 8,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: man, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469), # kiss: woman, woman 
    },
    '13.0': {
        # Source: ./data/emoji-zwj-sequences-13.0.txt
        # Date: 2020-01-28, 20:48:43 GMT
        #
        # sequences of length 3,
            (0x1f468, 0x0200d, 0x1f466), # family: man, boy 
            (0x1f468, 0x0200d, 0x1f467), # family: man, girl 
            (0x1f469, 0x0200d, 0x1f466), # family: woman, boy 
            (0x1f469, 0x0200d, 0x1f467), # family: woman, girl 
            (0x1f468, 0x0200d, 0x1f33e), # man farmer 
            (0x1f468, 0x0200d, 0x1f373), # man cook 
            (0x1f468, 0x0200d, 0x1f37c), # man feeding baby 
            (0x1f468, 0x0200d, 0x1f393), # man student 
            (0x1f468, 0x0200d, 0x1f3a4), # man singer 
            (0x1f468, 0x0200d, 0x1f3a8), # man artist 
            (0x1f468, 0x0200d, 0x1f3eb), # man teacher 
            (0x1f468, 0x0200d, 0x1f3ed), # man factory worker 
            (0x1f468, 0x0200d, 0x1f4bb), # man technologist 
            (0x1f468, 0x0200d, 0x1f4bc), # man office worker 
            (0x1f468, 0x0200d, 0x1f527), # man mechanic 
            (0x1f468, 0x0200d, 0x1f52c), # man scientist 
            (0x1f468, 0x0200d, 0x1f680), # man astronaut 
            (0x1f468, 0x0200d, 0x1f692), # man firefighter 
            (0x1f468, 0x0200d, 0x1f9af), # man with white cane 
            (0x1f468, 0x0200d, 0x1f9bc), # man in motorized wheelchair 
            (0x1f468, 0x0200d, 0x1f9bd), # man in manual wheelchair 
            (0x1f469, 0x0200d, 0x1f33e), # woman farmer 
            (0x1f469, 0x0200d, 0x1f373), # woman cook 
            (0x1f469, 0x0200d, 0x1f37c), # woman feeding baby 
            (0x1f469, 0x0200d, 0x1f393), # woman student 
            (0x1f469, 0x0200d, 0x1f3a4), # woman singer 
            (0x1f469, 0x0200d, 0x1f3a8), # woman artist 
            (0x1f469, 0x0200d, 0x1f3eb), # woman teacher 
            (0x1f469, 0x0200d, 0x1f3ed), # woman factory worker 
            (0x1f469, 0x0200d, 0x1f4bb), # woman technologist 
            (0x1f469, 0x0200d, 0x1f4bc), # woman office worker 
            (0x1f469, 0x0200d, 0x1f527), # woman mechanic 
            (0x1f469, 0x0200d, 0x1f52c), # woman scientist 
            (0x1f469, 0x0200d, 0x1f680), # woman astronaut 
            (0x1f469, 0x0200d, 0x1f692), # woman firefighter 
            (0x1f469, 0x0200d, 0x1f9af), # woman with white cane 
            (0x1f469, 0x0200d, 0x1f9bc), # woman in motorized wheelchair 
            (0x1f469, 0x0200d, 0x1f9bd), # woman in manual wheelchair 
            (0x1f9d1, 0x0200d, 0x1f33e), # farmer 
            (0x1f9d1, 0x0200d, 0x1f373), # cook 
            (0x1f9d1, 0x0200d, 0x1f37c), # person feeding baby 
            (0x1f9d1, 0x0200d, 0x1f393), # student 
            (0x1f9d1, 0x0200d, 0x1f3a4), # singer 
            (0x1f9d1, 0x0200d, 0x1f3a8), # artist 
            (0x1f9d1, 0x0200d, 0x1f3eb), # teacher 
            (0x1f9d1, 0x0200d, 0x1f3ed), # factory worker 
            (0x1f9d1, 0x0200d, 0x1f4bb), # technologist 
            (0x1f9d1, 0x0200d, 0x1f4bc), # office worker 
            (0x1f9d1, 0x0200d, 0x1f527), # mechanic 
            (0x1f9d1, 0x0200d, 0x1f52c), # scientist 
            (0x1f9d1, 0x0200d, 0x1f680), # astronaut 
            (0x1f9d1, 0x0200d, 0x1f692), # firefighter 
            (0x1f9d1, 0x0200d, 0x1f9af), # person with white cane 
            (0x1f9d1, 0x0200d, 0x1f9bc), # person in motorized wheelchair 
            (0x1f9d1, 0x0200d, 0x1f9bd), # person in manual wheelchair 
            (0x1f468, 0x0200d, 0x1f9b0), # man: red hair 
            (0x1f468, 0x0200d, 0x1f9b1), # man: curly hair 
            (0x1f468, 0x0200d, 0x1f9b2), # man: bald 
            (0x1f468, 0x0200d, 0x1f9b3), # man: white hair 
            (0x1f469, 0x0200d, 0x1f9b0), # woman: red hair 
            (0x1f469, 0x0200d, 0x1f9b1), # woman: curly hair 
            (0x1f469, 0x0200d, 0x1f9b2), # woman: bald 
            (0x1f469, 0x0200d, 0x1f9b3), # woman: white hair 
            (0x1f9d1, 0x0200d, 0x1f9b0), # person: red hair 
            (0x1f9d1, 0x0200d, 0x1f9b1), # person: curly hair 
            (0x1f9d1, 0x0200d, 0x1f9b2), # person: bald 
            (0x1f9d1, 0x0200d, 0x1f9b3), # person: white hair 
            (0x1f408, 0x0200d, 0x02b1b), # black cat 
            (0x1f415, 0x0200d, 0x1f9ba), # service dog 
            (0x1f9d1, 0x0200d, 0x1f384), # mx claus 
        # sequences of length 4,
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f384), # mx claus: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f384), # mx claus: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f384), # mx claus: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f384), # mx claus: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f384), # mx claus: dark skin tone 
            (0x1f468, 0x0200d, 0x02695, 0x0fe0f), # man health worker 
            (0x1f468, 0x0200d, 0x02696, 0x0fe0f), # man judge 
            (0x1f468, 0x0200d, 0x02708, 0x0fe0f), # man pilot 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f33e), # man farmer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f373), # man cook: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f37c), # man feeding baby: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f393), # man student: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a4), # man singer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a8), # man artist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3eb), # man teacher: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3ed), # man factory worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bb), # man technologist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bc), # man office worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f527), # man mechanic: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f52c), # man scientist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f680), # man astronaut: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f692), # man firefighter: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9af), # man with white cane: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9bc), # man in motorized wheelchair: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9bd), # man in manual wheelchair: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f33e), # man farmer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f373), # man cook: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f37c), # man feeding baby: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f393), # man student: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a4), # man singer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a8), # man artist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3eb), # man teacher: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3ed), # man factory worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bb), # man technologist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bc), # man office worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f527), # man mechanic: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f52c), # man scientist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f680), # man astronaut: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f692), # man firefighter: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9af), # man with white cane: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f33e), # man farmer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f373), # man cook: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f37c), # man feeding baby: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f393), # man student: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a4), # man singer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a8), # man artist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3eb), # man teacher: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3ed), # man factory worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bb), # man technologist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bc), # man office worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f527), # man mechanic: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f52c), # man scientist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f680), # man astronaut: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f692), # man firefighter: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9af), # man with white cane: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f33e), # man farmer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f373), # man cook: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f37c), # man feeding baby: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f393), # man student: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a4), # man singer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a8), # man artist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3eb), # man teacher: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3ed), # man factory worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bb), # man technologist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bc), # man office worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f527), # man mechanic: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f52c), # man scientist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f680), # man astronaut: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f692), # man firefighter: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9af), # man with white cane: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f33e), # man farmer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f373), # man cook: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f37c), # man feeding baby: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f393), # man student: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a4), # man singer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a8), # man artist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3eb), # man teacher: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3ed), # man factory worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bb), # man technologist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bc), # man office worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f527), # man mechanic: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f52c), # man scientist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f680), # man astronaut: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f692), # man firefighter: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9af), # man with white cane: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9bc), # man in motorized wheelchair: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9bd), # man in manual wheelchair: dark skin tone 
            (0x1f469, 0x0200d, 0x02695, 0x0fe0f), # woman health worker 
            (0x1f469, 0x0200d, 0x02696, 0x0fe0f), # woman judge 
            (0x1f469, 0x0200d, 0x02708, 0x0fe0f), # woman pilot 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f33e), # woman farmer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f373), # woman cook: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f37c), # woman feeding baby: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f393), # woman student: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a4), # woman singer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a8), # woman artist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3eb), # woman teacher: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3ed), # woman factory worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bb), # woman technologist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bc), # woman office worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f527), # woman mechanic: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f52c), # woman scientist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f680), # woman astronaut: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f692), # woman firefighter: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9af), # woman with white cane: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9bd), # woman in manual wheelchair: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f33e), # woman farmer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f373), # woman cook: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f37c), # woman feeding baby: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f393), # woman student: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a4), # woman singer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a8), # woman artist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3eb), # woman teacher: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3ed), # woman factory worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bb), # woman technologist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bc), # woman office worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f527), # woman mechanic: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f52c), # woman scientist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f680), # woman astronaut: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f692), # woman firefighter: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9af), # woman with white cane: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f33e), # woman farmer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f373), # woman cook: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f37c), # woman feeding baby: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f393), # woman student: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a4), # woman singer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a8), # woman artist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3eb), # woman teacher: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3ed), # woman factory worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bb), # woman technologist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bc), # woman office worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f527), # woman mechanic: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f52c), # woman scientist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f680), # woman astronaut: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f692), # woman firefighter: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9af), # woman with white cane: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f33e), # woman farmer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f373), # woman cook: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f37c), # woman feeding baby: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f393), # woman student: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a4), # woman singer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a8), # woman artist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3eb), # woman teacher: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3ed), # woman factory worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bb), # woman technologist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bc), # woman office worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f527), # woman mechanic: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f52c), # woman scientist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f680), # woman astronaut: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f692), # woman firefighter: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9af), # woman with white cane: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f33e), # woman farmer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f373), # woman cook: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f37c), # woman feeding baby: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f393), # woman student: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a4), # woman singer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a8), # woman artist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3eb), # woman teacher: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3ed), # woman factory worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bb), # woman technologist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bc), # woman office worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f527), # woman mechanic: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f52c), # woman scientist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f680), # woman astronaut: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f692), # woman firefighter: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9af), # woman with white cane: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9bd), # woman in manual wheelchair: dark skin tone 
            (0x1f9d1, 0x0200d, 0x02695, 0x0fe0f), # health worker 
            (0x1f9d1, 0x0200d, 0x02696, 0x0fe0f), # judge 
            (0x1f9d1, 0x0200d, 0x02708, 0x0fe0f), # pilot 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f33e), # farmer: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f373), # cook: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f37c), # person feeding baby: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f393), # student: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3a4), # singer: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3a8), # artist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3eb), # teacher: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3ed), # factory worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f4bb), # technologist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f4bc), # office worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f527), # mechanic: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f52c), # scientist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f680), # astronaut: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f692), # firefighter: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9af), # person with white cane: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9bc), # person in motorized wheelchair: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9bd), # person in manual wheelchair: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f33e), # farmer: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f373), # cook: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f37c), # person feeding baby: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f393), # student: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3a4), # singer: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3a8), # artist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3eb), # teacher: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3ed), # factory worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f4bb), # technologist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f4bc), # office worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f527), # mechanic: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f52c), # scientist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f680), # astronaut: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f692), # firefighter: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9af), # person with white cane: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f33e), # farmer: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f373), # cook: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f37c), # person feeding baby: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f393), # student: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3a4), # singer: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3a8), # artist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3eb), # teacher: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3ed), # factory worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f4bb), # technologist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f4bc), # office worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f527), # mechanic: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f52c), # scientist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f680), # astronaut: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f692), # firefighter: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9af), # person with white cane: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f33e), # farmer: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f373), # cook: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f37c), # person feeding baby: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f393), # student: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3a4), # singer: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3a8), # artist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3eb), # teacher: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3ed), # factory worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f4bb), # technologist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f4bc), # office worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f527), # mechanic: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f52c), # scientist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f680), # astronaut: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f692), # firefighter: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9af), # person with white cane: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f33e), # farmer: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f373), # cook: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f37c), # person feeding baby: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f393), # student: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3a4), # singer: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3a8), # artist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3eb), # teacher: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3ed), # factory worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f4bb), # technologist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f4bc), # office worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f527), # mechanic: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f52c), # scientist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f680), # astronaut: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f692), # firefighter: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9af), # person with white cane: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9bc), # person in motorized wheelchair: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9bd), # person in manual wheelchair: dark skin tone 
            (0x1f3c3, 0x0200d, 0x02640, 0x0fe0f), # woman running 
            (0x1f3c3, 0x0200d, 0x02642, 0x0fe0f), # man running 
            (0x1f3c4, 0x0200d, 0x02640, 0x0fe0f), # woman surfing 
            (0x1f3c4, 0x0200d, 0x02642, 0x0fe0f), # man surfing 
            (0x1f3ca, 0x0200d, 0x02640, 0x0fe0f), # woman swimming 
            (0x1f3ca, 0x0200d, 0x02642, 0x0fe0f), # man swimming 
            (0x1f46e, 0x0200d, 0x02640, 0x0fe0f), # woman police officer 
            (0x1f46e, 0x0200d, 0x02642, 0x0fe0f), # man police officer 
            (0x1f46f, 0x0200d, 0x02640, 0x0fe0f), # women with bunny ears 
            (0x1f46f, 0x0200d, 0x02642, 0x0fe0f), # men with bunny ears 
            (0x1f470, 0x0200d, 0x02640, 0x0fe0f), # woman with veil 
            (0x1f470, 0x0200d, 0x02642, 0x0fe0f), # man with veil 
            (0x1f471, 0x0200d, 0x02640, 0x0fe0f), # woman: blond hair 
            (0x1f471, 0x0200d, 0x02642, 0x0fe0f), # man: blond hair 
            (0x1f473, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban 
            (0x1f473, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban 
            (0x1f477, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker 
            (0x1f477, 0x0200d, 0x02642, 0x0fe0f), # man construction worker 
            (0x1f481, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand 
            (0x1f481, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand 
            (0x1f482, 0x0200d, 0x02640, 0x0fe0f), # woman guard 
            (0x1f482, 0x0200d, 0x02642, 0x0fe0f), # man guard 
            (0x1f486, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage 
            (0x1f486, 0x0200d, 0x02642, 0x0fe0f), # man getting massage 
            (0x1f487, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut 
            (0x1f487, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut 
            (0x1f645, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO 
            (0x1f645, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO 
            (0x1f646, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK 
            (0x1f646, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK 
            (0x1f647, 0x0200d, 0x02640, 0x0fe0f), # woman bowing 
            (0x1f647, 0x0200d, 0x02642, 0x0fe0f), # man bowing 
            (0x1f64b, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand 
            (0x1f64b, 0x0200d, 0x02642, 0x0fe0f), # man raising hand 
            (0x1f64d, 0x0200d, 0x02640, 0x0fe0f), # woman frowning 
            (0x1f64d, 0x0200d, 0x02642, 0x0fe0f), # man frowning 
            (0x1f64e, 0x0200d, 0x02640, 0x0fe0f), # woman pouting 
            (0x1f64e, 0x0200d, 0x02642, 0x0fe0f), # man pouting 
            (0x1f6a3, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat 
            (0x1f6a3, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat 
            (0x1f6b4, 0x0200d, 0x02640, 0x0fe0f), # woman biking 
            (0x1f6b4, 0x0200d, 0x02642, 0x0fe0f), # man biking 
            (0x1f6b5, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking 
            (0x1f6b5, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking 
            (0x1f6b6, 0x0200d, 0x02640, 0x0fe0f), # woman walking 
            (0x1f6b6, 0x0200d, 0x02642, 0x0fe0f), # man walking 
            (0x1f926, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming 
            (0x1f926, 0x0200d, 0x02642, 0x0fe0f), # man facepalming 
            (0x1f935, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo 
            (0x1f935, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo 
            (0x1f937, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging 
            (0x1f937, 0x0200d, 0x02642, 0x0fe0f), # man shrugging 
            (0x1f938, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling 
            (0x1f938, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling 
            (0x1f939, 0x0200d, 0x02640, 0x0fe0f), # woman juggling 
            (0x1f939, 0x0200d, 0x02642, 0x0fe0f), # man juggling 
            (0x1f93c, 0x0200d, 0x02640, 0x0fe0f), # women wrestling 
            (0x1f93c, 0x0200d, 0x02642, 0x0fe0f), # men wrestling 
            (0x1f93d, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo 
            (0x1f93d, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo 
            (0x1f93e, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball 
            (0x1f93e, 0x0200d, 0x02642, 0x0fe0f), # man playing handball 
            (0x1f9b8, 0x0200d, 0x02640, 0x0fe0f), # woman superhero 
            (0x1f9b8, 0x0200d, 0x02642, 0x0fe0f), # man superhero 
            (0x1f9b9, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain 
            (0x1f9b9, 0x0200d, 0x02642, 0x0fe0f), # man supervillain 
            (0x1f9cd, 0x0200d, 0x02640, 0x0fe0f), # woman standing 
            (0x1f9cd, 0x0200d, 0x02642, 0x0fe0f), # man standing 
            (0x1f9ce, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling 
            (0x1f9ce, 0x0200d, 0x02642, 0x0fe0f), # man kneeling 
            (0x1f9cf, 0x0200d, 0x02640, 0x0fe0f), # deaf woman 
            (0x1f9cf, 0x0200d, 0x02642, 0x0fe0f), # deaf man 
            (0x1f9d6, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room 
            (0x1f9d6, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room 
            (0x1f9d7, 0x0200d, 0x02640, 0x0fe0f), # woman climbing 
            (0x1f9d7, 0x0200d, 0x02642, 0x0fe0f), # man climbing 
            (0x1f9d8, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position 
            (0x1f9d8, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position 
            (0x1f9d9, 0x0200d, 0x02640, 0x0fe0f), # woman mage 
            (0x1f9d9, 0x0200d, 0x02642, 0x0fe0f), # man mage 
            (0x1f9da, 0x0200d, 0x02640, 0x0fe0f), # woman fairy 
            (0x1f9da, 0x0200d, 0x02642, 0x0fe0f), # man fairy 
            (0x1f9db, 0x0200d, 0x02640, 0x0fe0f), # woman vampire 
            (0x1f9db, 0x0200d, 0x02642, 0x0fe0f), # man vampire 
            (0x1f9dc, 0x0200d, 0x02640, 0x0fe0f), # mermaid 
            (0x1f9dc, 0x0200d, 0x02642, 0x0fe0f), # merman 
            (0x1f9dd, 0x0200d, 0x02640, 0x0fe0f), # woman elf 
            (0x1f9dd, 0x0200d, 0x02642, 0x0fe0f), # man elf 
            (0x1f9de, 0x0200d, 0x02640, 0x0fe0f), # woman genie 
            (0x1f9de, 0x0200d, 0x02642, 0x0fe0f), # man genie 
            (0x1f9df, 0x0200d, 0x02640, 0x0fe0f), # woman zombie 
            (0x1f9df, 0x0200d, 0x02642, 0x0fe0f), # man zombie 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b0), # man: light skin tone, red hair 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b1), # man: light skin tone, curly hair 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b2), # man: light skin tone, bald 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b3), # man: light skin tone, white hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b0), # man: medium-light skin tone, red hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b1), # man: medium-light skin tone, curly hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b2), # man: medium-light skin tone, bald 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b3), # man: medium-light skin tone, white hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b0), # man: medium skin tone, red hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b1), # man: medium skin tone, curly hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b2), # man: medium skin tone, bald 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b3), # man: medium skin tone, white hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b0), # man: medium-dark skin tone, red hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b1), # man: medium-dark skin tone, curly hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b2), # man: medium-dark skin tone, bald 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b3), # man: medium-dark skin tone, white hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b0), # man: dark skin tone, red hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b1), # man: dark skin tone, curly hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b2), # man: dark skin tone, bald 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b3), # man: dark skin tone, white hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b0), # woman: light skin tone, red hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b1), # woman: light skin tone, curly hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b2), # woman: light skin tone, bald 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b3), # woman: light skin tone, white hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b0), # woman: medium-light skin tone, red hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b1), # woman: medium-light skin tone, curly hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b2), # woman: medium-light skin tone, bald 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b3), # woman: medium-light skin tone, white hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b0), # woman: medium skin tone, red hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b1), # woman: medium skin tone, curly hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b2), # woman: medium skin tone, bald 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b3), # woman: medium skin tone, white hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b0), # woman: medium-dark skin tone, red hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b1), # woman: medium-dark skin tone, curly hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b2), # woman: medium-dark skin tone, bald 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b3), # woman: medium-dark skin tone, white hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b0), # woman: dark skin tone, red hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b1), # woman: dark skin tone, curly hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b2), # woman: dark skin tone, bald 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b3), # woman: dark skin tone, white hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b0), # person: light skin tone, red hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b1), # person: light skin tone, curly hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b2), # person: light skin tone, bald 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b3), # person: light skin tone, white hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b0), # person: medium-light skin tone, red hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b1), # person: medium-light skin tone, curly hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b2), # person: medium-light skin tone, bald 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b3), # person: medium-light skin tone, white hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b0), # person: medium skin tone, red hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b1), # person: medium skin tone, curly hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b2), # person: medium skin tone, bald 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b3), # person: medium skin tone, white hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b0), # person: medium-dark skin tone, red hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b1), # person: medium-dark skin tone, curly hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b2), # person: medium-dark skin tone, bald 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b3), # person: medium-dark skin tone, white hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b0), # person: dark skin tone, red hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b1), # person: dark skin tone, curly hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b2), # person: dark skin tone, bald 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b3), # person: dark skin tone, white hair 
            (0x1f3f3, 0x0fe0f, 0x0200d, 0x1f308), # rainbow flag 
            (0x1f3f4, 0x0200d, 0x02620, 0x0fe0f), # pirate flag 
            (0x1f43b, 0x0200d, 0x02744, 0x0fe0f), # polar bear 
        # sequences of length 5,
            (0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, boy, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, girl, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, girl, girl 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466), # family: man, man, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467), # family: man, man, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: man, woman, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: man, woman, girl 
            (0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, girl, girl 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: woman, woman, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: woman, woman, girl 
            (0x1f9d1, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1), # people holding hands 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # man health worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # man judge: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # man pilot: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # man health worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # man judge: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # man pilot: dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # woman judge: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # woman judge: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # health worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # judge: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # pilot: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # judge: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # judge: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # judge: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # health worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # judge: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # pilot: dark skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: light skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: dark skin tone 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman running: light skin tone 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man running: light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-light skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man running: medium skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-dark skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman running: dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man running: dark skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: light skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man surfing: light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man surfing: dark skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: light skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man swimming: light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man swimming: dark skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: dark skin tone 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: light skin tone 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man golfing: light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man golfing: dark skin tone 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman golfing 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man golfing 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: light skin tone 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man police officer: light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man police officer: dark skin tone 
            (0x1f470, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: light skin tone 
            (0x1f470, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man with veil: light skin tone 
            (0x1f470, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: medium-light skin tone 
            (0x1f470, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man with veil: medium-light skin tone 
            (0x1f470, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: medium skin tone 
            (0x1f470, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man with veil: medium skin tone 
            (0x1f470, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: medium-dark skin tone 
            (0x1f470, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man with veil: medium-dark skin tone 
            (0x1f470, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: dark skin tone 
            (0x1f470, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man with veil: dark skin tone 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman: light skin tone, blond hair 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man: light skin tone, blond hair 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-light skin tone, blond hair 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man: medium-light skin tone, blond hair 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman: medium skin tone, blond hair 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man: medium skin tone, blond hair 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-dark skin tone, blond hair 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man: medium-dark skin tone, blond hair 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman: dark skin tone, blond hair 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man: dark skin tone, blond hair 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: light skin tone 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: dark skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: light skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: dark skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: light skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: dark skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman guard: light skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man guard: light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-light skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-dark skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman guard: dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man guard: dark skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: light skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: dark skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: light skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: dark skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman detective: light skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man detective: light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-light skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-dark skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman detective: dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man detective: dark skin tone 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman detective 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man detective 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: light skin tone 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: dark skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: light skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: dark skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: light skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bowing: light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-light skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-dark skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bowing: dark skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: light skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: dark skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: light skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man frowning: light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man frowning: dark skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: light skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man pouting: light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man pouting: dark skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: dark skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman biking: light skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man biking: light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman biking: dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man biking: dark skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: dark skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman walking: light skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man walking: light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman walking: dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man walking: dark skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: light skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: dark skin tone 
            (0x1f935, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: light skin tone 
            (0x1f935, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: light skin tone 
            (0x1f935, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: medium-light skin tone 
            (0x1f935, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: medium-light skin tone 
            (0x1f935, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: medium skin tone 
            (0x1f935, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: medium skin tone 
            (0x1f935, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: medium-dark skin tone 
            (0x1f935, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: medium-dark skin tone 
            (0x1f935, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: dark skin tone 
            (0x1f935, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: dark skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: light skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: dark skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: light skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: dark skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: light skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man juggling: light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-light skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-dark skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man juggling: dark skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: light skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: dark skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: light skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: dark skin tone 
            (0x1f9b8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: light skin tone 
            (0x1f9b8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man superhero: light skin tone 
            (0x1f9b8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium-light skin tone 
            (0x1f9b8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium-light skin tone 
            (0x1f9b8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium skin tone 
            (0x1f9b8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium skin tone 
            (0x1f9b8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium-dark skin tone 
            (0x1f9b8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium-dark skin tone 
            (0x1f9b8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: dark skin tone 
            (0x1f9b8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man superhero: dark skin tone 
            (0x1f9b9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: light skin tone 
            (0x1f9b9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: light skin tone 
            (0x1f9b9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium-light skin tone 
            (0x1f9b9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium-light skin tone 
            (0x1f9b9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium skin tone 
            (0x1f9b9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium skin tone 
            (0x1f9b9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium-dark skin tone 
            (0x1f9b9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium-dark skin tone 
            (0x1f9b9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: dark skin tone 
            (0x1f9b9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: dark skin tone 
            (0x1f9cd, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman standing: light skin tone 
            (0x1f9cd, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man standing: light skin tone 
            (0x1f9cd, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium-light skin tone 
            (0x1f9cd, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium-light skin tone 
            (0x1f9cd, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium skin tone 
            (0x1f9cd, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium skin tone 
            (0x1f9cd, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium-dark skin tone 
            (0x1f9cd, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium-dark skin tone 
            (0x1f9cd, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman standing: dark skin tone 
            (0x1f9cd, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man standing: dark skin tone 
            (0x1f9ce, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: light skin tone 
            (0x1f9ce, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: light skin tone 
            (0x1f9ce, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium-light skin tone 
            (0x1f9ce, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium-light skin tone 
            (0x1f9ce, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium skin tone 
            (0x1f9ce, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium skin tone 
            (0x1f9ce, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium-dark skin tone 
            (0x1f9ce, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium-dark skin tone 
            (0x1f9ce, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: dark skin tone 
            (0x1f9ce, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: dark skin tone 
            (0x1f9cf, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: light skin tone 
            (0x1f9cf, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # deaf man: light skin tone 
            (0x1f9cf, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium-light skin tone 
            (0x1f9cf, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium-light skin tone 
            (0x1f9cf, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium skin tone 
            (0x1f9cf, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium skin tone 
            (0x1f9cf, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium-dark skin tone 
            (0x1f9cf, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium-dark skin tone 
            (0x1f9cf, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: dark skin tone 
            (0x1f9cf, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # deaf man: dark skin tone 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: dark skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: light skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man climbing: light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man climbing: dark skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: dark skin tone 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mage: light skin tone 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mage: light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mage: dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mage: dark skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: light skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man fairy: light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man fairy: dark skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: light skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man vampire: light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man vampire: dark skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # mermaid: light skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # merman: light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-light skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # merman: medium skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-dark skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # mermaid: dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # merman: dark skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman elf: light skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man elf: light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman elf: dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man elf: dark skin tone 
            (0x1f3f3, 0x0fe0f, 0x0200d, 0x026a7, 0x0fe0f), # transgender flag 
            (0x1f441, 0x0fe0f, 0x0200d, 0x1f5e8, 0x0fe0f), # eye in speech bubble 
        # sequences of length 6,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: man, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469), # couple with heart: woman, woman 
        # sequences of length 7,
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, man, boy, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, man, girl, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, man, girl, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, woman, boy, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, woman, girl, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, woman, girl, girl 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: light skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: light skin tone, medium skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: light skin tone, dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium-light skin tone, light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: medium-light skin tone, medium skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium-light skin tone, dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium skin tone, light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: medium skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: medium skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium skin tone, dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium-dark skin tone, light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: medium-dark skin tone, medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium-dark skin tone, dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: dark skin tone, light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: dark skin tone, medium skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: dark skin tone, medium-dark skin tone 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, woman, girl, girl 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: light skin tone, dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: dark skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: light skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium-light skin tone, light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium-light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: medium-light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium skin tone, light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: medium skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: medium skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium-dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium-dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: medium-dark skin tone, dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: dark skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: dark skin tone 
        # sequences of length 8,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: man, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469), # kiss: woman, woman 
    },
    '13.1': {
        # Source: ./data/emoji-zwj-sequences-13.1.txt
        # Date: 2020-08-30, 17:14:54 GMT
        #
        # sequences of length 3,
            (0x1f468, 0x0200d, 0x1f466), # family: man, boy 
            (0x1f468, 0x0200d, 0x1f467), # family: man, girl 
            (0x1f469, 0x0200d, 0x1f466), # family: woman, boy 
            (0x1f469, 0x0200d, 0x1f467), # family: woman, girl 
            (0x1f468, 0x0200d, 0x1f33e), # man farmer 
            (0x1f468, 0x0200d, 0x1f373), # man cook 
            (0x1f468, 0x0200d, 0x1f37c), # man feeding baby 
            (0x1f468, 0x0200d, 0x1f393), # man student 
            (0x1f468, 0x0200d, 0x1f3a4), # man singer 
            (0x1f468, 0x0200d, 0x1f3a8), # man artist 
            (0x1f468, 0x0200d, 0x1f3eb), # man teacher 
            (0x1f468, 0x0200d, 0x1f3ed), # man factory worker 
            (0x1f468, 0x0200d, 0x1f4bb), # man technologist 
            (0x1f468, 0x0200d, 0x1f4bc), # man office worker 
            (0x1f468, 0x0200d, 0x1f527), # man mechanic 
            (0x1f468, 0x0200d, 0x1f52c), # man scientist 
            (0x1f468, 0x0200d, 0x1f680), # man astronaut 
            (0x1f468, 0x0200d, 0x1f692), # man firefighter 
            (0x1f468, 0x0200d, 0x1f9af), # man with white cane 
            (0x1f468, 0x0200d, 0x1f9bc), # man in motorized wheelchair 
            (0x1f468, 0x0200d, 0x1f9bd), # man in manual wheelchair 
            (0x1f469, 0x0200d, 0x1f33e), # woman farmer 
            (0x1f469, 0x0200d, 0x1f373), # woman cook 
            (0x1f469, 0x0200d, 0x1f37c), # woman feeding baby 
            (0x1f469, 0x0200d, 0x1f393), # woman student 
            (0x1f469, 0x0200d, 0x1f3a4), # woman singer 
            (0x1f469, 0x0200d, 0x1f3a8), # woman artist 
            (0x1f469, 0x0200d, 0x1f3eb), # woman teacher 
            (0x1f469, 0x0200d, 0x1f3ed), # woman factory worker 
            (0x1f469, 0x0200d, 0x1f4bb), # woman technologist 
            (0x1f469, 0x0200d, 0x1f4bc), # woman office worker 
            (0x1f469, 0x0200d, 0x1f527), # woman mechanic 
            (0x1f469, 0x0200d, 0x1f52c), # woman scientist 
            (0x1f469, 0x0200d, 0x1f680), # woman astronaut 
            (0x1f469, 0x0200d, 0x1f692), # woman firefighter 
            (0x1f469, 0x0200d, 0x1f9af), # woman with white cane 
            (0x1f469, 0x0200d, 0x1f9bc), # woman in motorized wheelchair 
            (0x1f469, 0x0200d, 0x1f9bd), # woman in manual wheelchair 
            (0x1f9d1, 0x0200d, 0x1f33e), # farmer 
            (0x1f9d1, 0x0200d, 0x1f373), # cook 
            (0x1f9d1, 0x0200d, 0x1f37c), # person feeding baby 
            (0x1f9d1, 0x0200d, 0x1f393), # student 
            (0x1f9d1, 0x0200d, 0x1f3a4), # singer 
            (0x1f9d1, 0x0200d, 0x1f3a8), # artist 
            (0x1f9d1, 0x0200d, 0x1f3eb), # teacher 
            (0x1f9d1, 0x0200d, 0x1f3ed), # factory worker 
            (0x1f9d1, 0x0200d, 0x1f4bb), # technologist 
            (0x1f9d1, 0x0200d, 0x1f4bc), # office worker 
            (0x1f9d1, 0x0200d, 0x1f527), # mechanic 
            (0x1f9d1, 0x0200d, 0x1f52c), # scientist 
            (0x1f9d1, 0x0200d, 0x1f680), # astronaut 
            (0x1f9d1, 0x0200d, 0x1f692), # firefighter 
            (0x1f9d1, 0x0200d, 0x1f9af), # person with white cane 
            (0x1f9d1, 0x0200d, 0x1f9bc), # person in motorized wheelchair 
            (0x1f9d1, 0x0200d, 0x1f9bd), # person in manual wheelchair 
            (0x1f468, 0x0200d, 0x1f9b0), # man: red hair 
            (0x1f468, 0x0200d, 0x1f9b1), # man: curly hair 
            (0x1f468, 0x0200d, 0x1f9b2), # man: bald 
            (0x1f468, 0x0200d, 0x1f9b3), # man: white hair 
            (0x1f469, 0x0200d, 0x1f9b0), # woman: red hair 
            (0x1f469, 0x0200d, 0x1f9b1), # woman: curly hair 
            (0x1f469, 0x0200d, 0x1f9b2), # woman: bald 
            (0x1f469, 0x0200d, 0x1f9b3), # woman: white hair 
            (0x1f9d1, 0x0200d, 0x1f9b0), # person: red hair 
            (0x1f9d1, 0x0200d, 0x1f9b1), # person: curly hair 
            (0x1f9d1, 0x0200d, 0x1f9b2), # person: bald 
            (0x1f9d1, 0x0200d, 0x1f9b3), # person: white hair 
            (0x1f408, 0x0200d, 0x02b1b), # black cat 
            (0x1f415, 0x0200d, 0x1f9ba), # service dog 
            (0x1f62e, 0x0200d, 0x1f4a8), # face exhaling 
            (0x1f635, 0x0200d, 0x1f4ab), # face with spiral eyes 
            (0x1f9d1, 0x0200d, 0x1f384), # mx claus 
        # sequences of length 4,
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f384), # mx claus: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f384), # mx claus: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f384), # mx claus: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f384), # mx claus: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f384), # mx claus: dark skin tone 
            (0x1f468, 0x0200d, 0x02695, 0x0fe0f), # man health worker 
            (0x1f468, 0x0200d, 0x02696, 0x0fe0f), # man judge 
            (0x1f468, 0x0200d, 0x02708, 0x0fe0f), # man pilot 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f33e), # man farmer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f373), # man cook: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f37c), # man feeding baby: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f393), # man student: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a4), # man singer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a8), # man artist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3eb), # man teacher: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3ed), # man factory worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bb), # man technologist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bc), # man office worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f527), # man mechanic: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f52c), # man scientist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f680), # man astronaut: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f692), # man firefighter: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9af), # man with white cane: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9bc), # man in motorized wheelchair: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9bd), # man in manual wheelchair: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f33e), # man farmer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f373), # man cook: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f37c), # man feeding baby: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f393), # man student: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a4), # man singer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a8), # man artist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3eb), # man teacher: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3ed), # man factory worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bb), # man technologist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bc), # man office worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f527), # man mechanic: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f52c), # man scientist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f680), # man astronaut: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f692), # man firefighter: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9af), # man with white cane: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f33e), # man farmer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f373), # man cook: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f37c), # man feeding baby: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f393), # man student: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a4), # man singer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a8), # man artist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3eb), # man teacher: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3ed), # man factory worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bb), # man technologist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bc), # man office worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f527), # man mechanic: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f52c), # man scientist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f680), # man astronaut: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f692), # man firefighter: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9af), # man with white cane: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f33e), # man farmer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f373), # man cook: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f37c), # man feeding baby: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f393), # man student: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a4), # man singer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a8), # man artist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3eb), # man teacher: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3ed), # man factory worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bb), # man technologist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bc), # man office worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f527), # man mechanic: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f52c), # man scientist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f680), # man astronaut: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f692), # man firefighter: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9af), # man with white cane: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f33e), # man farmer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f373), # man cook: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f37c), # man feeding baby: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f393), # man student: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a4), # man singer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a8), # man artist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3eb), # man teacher: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3ed), # man factory worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bb), # man technologist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bc), # man office worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f527), # man mechanic: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f52c), # man scientist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f680), # man astronaut: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f692), # man firefighter: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9af), # man with white cane: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9bc), # man in motorized wheelchair: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9bd), # man in manual wheelchair: dark skin tone 
            (0x1f469, 0x0200d, 0x02695, 0x0fe0f), # woman health worker 
            (0x1f469, 0x0200d, 0x02696, 0x0fe0f), # woman judge 
            (0x1f469, 0x0200d, 0x02708, 0x0fe0f), # woman pilot 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f33e), # woman farmer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f373), # woman cook: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f37c), # woman feeding baby: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f393), # woman student: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a4), # woman singer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a8), # woman artist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3eb), # woman teacher: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3ed), # woman factory worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bb), # woman technologist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bc), # woman office worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f527), # woman mechanic: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f52c), # woman scientist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f680), # woman astronaut: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f692), # woman firefighter: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9af), # woman with white cane: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9bd), # woman in manual wheelchair: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f33e), # woman farmer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f373), # woman cook: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f37c), # woman feeding baby: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f393), # woman student: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a4), # woman singer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a8), # woman artist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3eb), # woman teacher: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3ed), # woman factory worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bb), # woman technologist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bc), # woman office worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f527), # woman mechanic: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f52c), # woman scientist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f680), # woman astronaut: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f692), # woman firefighter: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9af), # woman with white cane: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f33e), # woman farmer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f373), # woman cook: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f37c), # woman feeding baby: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f393), # woman student: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a4), # woman singer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a8), # woman artist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3eb), # woman teacher: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3ed), # woman factory worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bb), # woman technologist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bc), # woman office worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f527), # woman mechanic: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f52c), # woman scientist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f680), # woman astronaut: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f692), # woman firefighter: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9af), # woman with white cane: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f33e), # woman farmer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f373), # woman cook: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f37c), # woman feeding baby: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f393), # woman student: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a4), # woman singer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a8), # woman artist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3eb), # woman teacher: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3ed), # woman factory worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bb), # woman technologist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bc), # woman office worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f527), # woman mechanic: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f52c), # woman scientist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f680), # woman astronaut: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f692), # woman firefighter: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9af), # woman with white cane: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f33e), # woman farmer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f373), # woman cook: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f37c), # woman feeding baby: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f393), # woman student: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a4), # woman singer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a8), # woman artist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3eb), # woman teacher: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3ed), # woman factory worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bb), # woman technologist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bc), # woman office worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f527), # woman mechanic: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f52c), # woman scientist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f680), # woman astronaut: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f692), # woman firefighter: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9af), # woman with white cane: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9bd), # woman in manual wheelchair: dark skin tone 
            (0x1f9d1, 0x0200d, 0x02695, 0x0fe0f), # health worker 
            (0x1f9d1, 0x0200d, 0x02696, 0x0fe0f), # judge 
            (0x1f9d1, 0x0200d, 0x02708, 0x0fe0f), # pilot 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f33e), # farmer: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f373), # cook: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f37c), # person feeding baby: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f393), # student: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3a4), # singer: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3a8), # artist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3eb), # teacher: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3ed), # factory worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f4bb), # technologist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f4bc), # office worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f527), # mechanic: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f52c), # scientist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f680), # astronaut: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f692), # firefighter: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9af), # person with white cane: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9bc), # person in motorized wheelchair: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9bd), # person in manual wheelchair: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f33e), # farmer: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f373), # cook: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f37c), # person feeding baby: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f393), # student: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3a4), # singer: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3a8), # artist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3eb), # teacher: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3ed), # factory worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f4bb), # technologist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f4bc), # office worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f527), # mechanic: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f52c), # scientist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f680), # astronaut: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f692), # firefighter: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9af), # person with white cane: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f33e), # farmer: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f373), # cook: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f37c), # person feeding baby: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f393), # student: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3a4), # singer: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3a8), # artist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3eb), # teacher: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3ed), # factory worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f4bb), # technologist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f4bc), # office worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f527), # mechanic: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f52c), # scientist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f680), # astronaut: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f692), # firefighter: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9af), # person with white cane: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f33e), # farmer: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f373), # cook: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f37c), # person feeding baby: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f393), # student: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3a4), # singer: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3a8), # artist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3eb), # teacher: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3ed), # factory worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f4bb), # technologist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f4bc), # office worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f527), # mechanic: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f52c), # scientist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f680), # astronaut: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f692), # firefighter: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9af), # person with white cane: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f33e), # farmer: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f373), # cook: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f37c), # person feeding baby: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f393), # student: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3a4), # singer: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3a8), # artist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3eb), # teacher: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3ed), # factory worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f4bb), # technologist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f4bc), # office worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f527), # mechanic: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f52c), # scientist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f680), # astronaut: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f692), # firefighter: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9af), # person with white cane: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9bc), # person in motorized wheelchair: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9bd), # person in manual wheelchair: dark skin tone 
            (0x1f3c3, 0x0200d, 0x02640, 0x0fe0f), # woman running 
            (0x1f3c3, 0x0200d, 0x02642, 0x0fe0f), # man running 
            (0x1f3c4, 0x0200d, 0x02640, 0x0fe0f), # woman surfing 
            (0x1f3c4, 0x0200d, 0x02642, 0x0fe0f), # man surfing 
            (0x1f3ca, 0x0200d, 0x02640, 0x0fe0f), # woman swimming 
            (0x1f3ca, 0x0200d, 0x02642, 0x0fe0f), # man swimming 
            (0x1f46e, 0x0200d, 0x02640, 0x0fe0f), # woman police officer 
            (0x1f46e, 0x0200d, 0x02642, 0x0fe0f), # man police officer 
            (0x1f46f, 0x0200d, 0x02640, 0x0fe0f), # women with bunny ears 
            (0x1f46f, 0x0200d, 0x02642, 0x0fe0f), # men with bunny ears 
            (0x1f470, 0x0200d, 0x02640, 0x0fe0f), # woman with veil 
            (0x1f470, 0x0200d, 0x02642, 0x0fe0f), # man with veil 
            (0x1f471, 0x0200d, 0x02640, 0x0fe0f), # woman: blond hair 
            (0x1f471, 0x0200d, 0x02642, 0x0fe0f), # man: blond hair 
            (0x1f473, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban 
            (0x1f473, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban 
            (0x1f477, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker 
            (0x1f477, 0x0200d, 0x02642, 0x0fe0f), # man construction worker 
            (0x1f481, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand 
            (0x1f481, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand 
            (0x1f482, 0x0200d, 0x02640, 0x0fe0f), # woman guard 
            (0x1f482, 0x0200d, 0x02642, 0x0fe0f), # man guard 
            (0x1f486, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage 
            (0x1f486, 0x0200d, 0x02642, 0x0fe0f), # man getting massage 
            (0x1f487, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut 
            (0x1f487, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut 
            (0x1f645, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO 
            (0x1f645, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO 
            (0x1f646, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK 
            (0x1f646, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK 
            (0x1f647, 0x0200d, 0x02640, 0x0fe0f), # woman bowing 
            (0x1f647, 0x0200d, 0x02642, 0x0fe0f), # man bowing 
            (0x1f64b, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand 
            (0x1f64b, 0x0200d, 0x02642, 0x0fe0f), # man raising hand 
            (0x1f64d, 0x0200d, 0x02640, 0x0fe0f), # woman frowning 
            (0x1f64d, 0x0200d, 0x02642, 0x0fe0f), # man frowning 
            (0x1f64e, 0x0200d, 0x02640, 0x0fe0f), # woman pouting 
            (0x1f64e, 0x0200d, 0x02642, 0x0fe0f), # man pouting 
            (0x1f6a3, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat 
            (0x1f6a3, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat 
            (0x1f6b4, 0x0200d, 0x02640, 0x0fe0f), # woman biking 
            (0x1f6b4, 0x0200d, 0x02642, 0x0fe0f), # man biking 
            (0x1f6b5, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking 
            (0x1f6b5, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking 
            (0x1f6b6, 0x0200d, 0x02640, 0x0fe0f), # woman walking 
            (0x1f6b6, 0x0200d, 0x02642, 0x0fe0f), # man walking 
            (0x1f926, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming 
            (0x1f926, 0x0200d, 0x02642, 0x0fe0f), # man facepalming 
            (0x1f935, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo 
            (0x1f935, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo 
            (0x1f937, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging 
            (0x1f937, 0x0200d, 0x02642, 0x0fe0f), # man shrugging 
            (0x1f938, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling 
            (0x1f938, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling 
            (0x1f939, 0x0200d, 0x02640, 0x0fe0f), # woman juggling 
            (0x1f939, 0x0200d, 0x02642, 0x0fe0f), # man juggling 
            (0x1f93c, 0x0200d, 0x02640, 0x0fe0f), # women wrestling 
            (0x1f93c, 0x0200d, 0x02642, 0x0fe0f), # men wrestling 
            (0x1f93d, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo 
            (0x1f93d, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo 
            (0x1f93e, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball 
            (0x1f93e, 0x0200d, 0x02642, 0x0fe0f), # man playing handball 
            (0x1f9b8, 0x0200d, 0x02640, 0x0fe0f), # woman superhero 
            (0x1f9b8, 0x0200d, 0x02642, 0x0fe0f), # man superhero 
            (0x1f9b9, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain 
            (0x1f9b9, 0x0200d, 0x02642, 0x0fe0f), # man supervillain 
            (0x1f9cd, 0x0200d, 0x02640, 0x0fe0f), # woman standing 
            (0x1f9cd, 0x0200d, 0x02642, 0x0fe0f), # man standing 
            (0x1f9ce, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling 
            (0x1f9ce, 0x0200d, 0x02642, 0x0fe0f), # man kneeling 
            (0x1f9cf, 0x0200d, 0x02640, 0x0fe0f), # deaf woman 
            (0x1f9cf, 0x0200d, 0x02642, 0x0fe0f), # deaf man 
            (0x1f9d4, 0x0200d, 0x02640, 0x0fe0f), # woman: beard 
            (0x1f9d4, 0x0200d, 0x02642, 0x0fe0f), # man: beard 
            (0x1f9d6, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room 
            (0x1f9d6, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room 
            (0x1f9d7, 0x0200d, 0x02640, 0x0fe0f), # woman climbing 
            (0x1f9d7, 0x0200d, 0x02642, 0x0fe0f), # man climbing 
            (0x1f9d8, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position 
            (0x1f9d8, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position 
            (0x1f9d9, 0x0200d, 0x02640, 0x0fe0f), # woman mage 
            (0x1f9d9, 0x0200d, 0x02642, 0x0fe0f), # man mage 
            (0x1f9da, 0x0200d, 0x02640, 0x0fe0f), # woman fairy 
            (0x1f9da, 0x0200d, 0x02642, 0x0fe0f), # man fairy 
            (0x1f9db, 0x0200d, 0x02640, 0x0fe0f), # woman vampire 
            (0x1f9db, 0x0200d, 0x02642, 0x0fe0f), # man vampire 
            (0x1f9dc, 0x0200d, 0x02640, 0x0fe0f), # mermaid 
            (0x1f9dc, 0x0200d, 0x02642, 0x0fe0f), # merman 
            (0x1f9dd, 0x0200d, 0x02640, 0x0fe0f), # woman elf 
            (0x1f9dd, 0x0200d, 0x02642, 0x0fe0f), # man elf 
            (0x1f9de, 0x0200d, 0x02640, 0x0fe0f), # woman genie 
            (0x1f9de, 0x0200d, 0x02642, 0x0fe0f), # man genie 
            (0x1f9df, 0x0200d, 0x02640, 0x0fe0f), # woman zombie 
            (0x1f9df, 0x0200d, 0x02642, 0x0fe0f), # man zombie 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b0), # man: light skin tone, red hair 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b1), # man: light skin tone, curly hair 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b2), # man: light skin tone, bald 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b3), # man: light skin tone, white hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b0), # man: medium-light skin tone, red hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b1), # man: medium-light skin tone, curly hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b2), # man: medium-light skin tone, bald 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b3), # man: medium-light skin tone, white hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b0), # man: medium skin tone, red hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b1), # man: medium skin tone, curly hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b2), # man: medium skin tone, bald 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b3), # man: medium skin tone, white hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b0), # man: medium-dark skin tone, red hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b1), # man: medium-dark skin tone, curly hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b2), # man: medium-dark skin tone, bald 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b3), # man: medium-dark skin tone, white hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b0), # man: dark skin tone, red hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b1), # man: dark skin tone, curly hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b2), # man: dark skin tone, bald 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b3), # man: dark skin tone, white hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b0), # woman: light skin tone, red hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b1), # woman: light skin tone, curly hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b2), # woman: light skin tone, bald 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b3), # woman: light skin tone, white hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b0), # woman: medium-light skin tone, red hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b1), # woman: medium-light skin tone, curly hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b2), # woman: medium-light skin tone, bald 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b3), # woman: medium-light skin tone, white hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b0), # woman: medium skin tone, red hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b1), # woman: medium skin tone, curly hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b2), # woman: medium skin tone, bald 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b3), # woman: medium skin tone, white hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b0), # woman: medium-dark skin tone, red hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b1), # woman: medium-dark skin tone, curly hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b2), # woman: medium-dark skin tone, bald 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b3), # woman: medium-dark skin tone, white hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b0), # woman: dark skin tone, red hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b1), # woman: dark skin tone, curly hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b2), # woman: dark skin tone, bald 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b3), # woman: dark skin tone, white hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b0), # person: light skin tone, red hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b1), # person: light skin tone, curly hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b2), # person: light skin tone, bald 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b3), # person: light skin tone, white hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b0), # person: medium-light skin tone, red hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b1), # person: medium-light skin tone, curly hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b2), # person: medium-light skin tone, bald 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b3), # person: medium-light skin tone, white hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b0), # person: medium skin tone, red hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b1), # person: medium skin tone, curly hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b2), # person: medium skin tone, bald 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b3), # person: medium skin tone, white hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b0), # person: medium-dark skin tone, red hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b1), # person: medium-dark skin tone, curly hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b2), # person: medium-dark skin tone, bald 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b3), # person: medium-dark skin tone, white hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b0), # person: dark skin tone, red hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b1), # person: dark skin tone, curly hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b2), # person: dark skin tone, bald 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b3), # person: dark skin tone, white hair 
            (0x02764, 0x0fe0f, 0x0200d, 0x1f525), # heart on fire 
            (0x02764, 0x0fe0f, 0x0200d, 0x1fa79), # mending heart 
            (0x1f3f3, 0x0fe0f, 0x0200d, 0x1f308), # rainbow flag 
            (0x1f3f4, 0x0200d, 0x02620, 0x0fe0f), # pirate flag 
            (0x1f43b, 0x0200d, 0x02744, 0x0fe0f), # polar bear 
            (0x1f636, 0x0200d, 0x1f32b, 0x0fe0f), # face in clouds 
        # sequences of length 5,
            (0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, boy, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, girl, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, girl, girl 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466), # family: man, man, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467), # family: man, man, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: man, woman, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: man, woman, girl 
            (0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, girl, girl 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: woman, woman, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: woman, woman, girl 
            (0x1f9d1, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1), # people holding hands 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # man health worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # man judge: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # man pilot: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # man health worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # man judge: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # man pilot: dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # woman judge: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # woman judge: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # health worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # judge: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # pilot: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # judge: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # judge: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # judge: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # health worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # judge: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # pilot: dark skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: light skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: dark skin tone 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman running: light skin tone 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man running: light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-light skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man running: medium skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-dark skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman running: dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man running: dark skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: light skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man surfing: light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man surfing: dark skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: light skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man swimming: light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man swimming: dark skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: dark skin tone 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: light skin tone 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man golfing: light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man golfing: dark skin tone 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman golfing 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man golfing 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: light skin tone 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man police officer: light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man police officer: dark skin tone 
            (0x1f470, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: light skin tone 
            (0x1f470, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man with veil: light skin tone 
            (0x1f470, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: medium-light skin tone 
            (0x1f470, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man with veil: medium-light skin tone 
            (0x1f470, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: medium skin tone 
            (0x1f470, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man with veil: medium skin tone 
            (0x1f470, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: medium-dark skin tone 
            (0x1f470, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man with veil: medium-dark skin tone 
            (0x1f470, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: dark skin tone 
            (0x1f470, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man with veil: dark skin tone 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman: light skin tone, blond hair 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man: light skin tone, blond hair 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-light skin tone, blond hair 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man: medium-light skin tone, blond hair 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman: medium skin tone, blond hair 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man: medium skin tone, blond hair 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-dark skin tone, blond hair 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man: medium-dark skin tone, blond hair 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman: dark skin tone, blond hair 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man: dark skin tone, blond hair 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: light skin tone 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: dark skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: light skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: dark skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: light skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: dark skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman guard: light skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man guard: light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-light skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-dark skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman guard: dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man guard: dark skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: light skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: dark skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: light skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: dark skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman detective: light skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man detective: light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-light skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-dark skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman detective: dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man detective: dark skin tone 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman detective 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man detective 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: light skin tone 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: dark skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: light skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: dark skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: light skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bowing: light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-light skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-dark skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bowing: dark skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: light skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: dark skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: light skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man frowning: light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man frowning: dark skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: light skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man pouting: light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man pouting: dark skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: dark skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman biking: light skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man biking: light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman biking: dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man biking: dark skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: dark skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman walking: light skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man walking: light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman walking: dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man walking: dark skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: light skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: dark skin tone 
            (0x1f935, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: light skin tone 
            (0x1f935, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: light skin tone 
            (0x1f935, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: medium-light skin tone 
            (0x1f935, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: medium-light skin tone 
            (0x1f935, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: medium skin tone 
            (0x1f935, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: medium skin tone 
            (0x1f935, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: medium-dark skin tone 
            (0x1f935, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: medium-dark skin tone 
            (0x1f935, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: dark skin tone 
            (0x1f935, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: dark skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: light skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: dark skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: light skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: dark skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: light skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man juggling: light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-light skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-dark skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man juggling: dark skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: light skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: dark skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: light skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: dark skin tone 
            (0x1f9b8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: light skin tone 
            (0x1f9b8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man superhero: light skin tone 
            (0x1f9b8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium-light skin tone 
            (0x1f9b8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium-light skin tone 
            (0x1f9b8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium skin tone 
            (0x1f9b8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium skin tone 
            (0x1f9b8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium-dark skin tone 
            (0x1f9b8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium-dark skin tone 
            (0x1f9b8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: dark skin tone 
            (0x1f9b8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man superhero: dark skin tone 
            (0x1f9b9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: light skin tone 
            (0x1f9b9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: light skin tone 
            (0x1f9b9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium-light skin tone 
            (0x1f9b9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium-light skin tone 
            (0x1f9b9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium skin tone 
            (0x1f9b9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium skin tone 
            (0x1f9b9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium-dark skin tone 
            (0x1f9b9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium-dark skin tone 
            (0x1f9b9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: dark skin tone 
            (0x1f9b9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: dark skin tone 
            (0x1f9cd, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman standing: light skin tone 
            (0x1f9cd, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man standing: light skin tone 
            (0x1f9cd, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium-light skin tone 
            (0x1f9cd, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium-light skin tone 
            (0x1f9cd, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium skin tone 
            (0x1f9cd, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium skin tone 
            (0x1f9cd, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium-dark skin tone 
            (0x1f9cd, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium-dark skin tone 
            (0x1f9cd, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman standing: dark skin tone 
            (0x1f9cd, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man standing: dark skin tone 
            (0x1f9ce, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: light skin tone 
            (0x1f9ce, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: light skin tone 
            (0x1f9ce, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium-light skin tone 
            (0x1f9ce, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium-light skin tone 
            (0x1f9ce, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium skin tone 
            (0x1f9ce, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium skin tone 
            (0x1f9ce, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium-dark skin tone 
            (0x1f9ce, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium-dark skin tone 
            (0x1f9ce, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: dark skin tone 
            (0x1f9ce, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: dark skin tone 
            (0x1f9cf, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: light skin tone 
            (0x1f9cf, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # deaf man: light skin tone 
            (0x1f9cf, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium-light skin tone 
            (0x1f9cf, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium-light skin tone 
            (0x1f9cf, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium skin tone 
            (0x1f9cf, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium skin tone 
            (0x1f9cf, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium-dark skin tone 
            (0x1f9cf, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium-dark skin tone 
            (0x1f9cf, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: dark skin tone 
            (0x1f9cf, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # deaf man: dark skin tone 
            (0x1f9d4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman: light skin tone, beard 
            (0x1f9d4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man: light skin tone, beard 
            (0x1f9d4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-light skin tone, beard 
            (0x1f9d4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man: medium-light skin tone, beard 
            (0x1f9d4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman: medium skin tone, beard 
            (0x1f9d4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man: medium skin tone, beard 
            (0x1f9d4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-dark skin tone, beard 
            (0x1f9d4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man: medium-dark skin tone, beard 
            (0x1f9d4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman: dark skin tone, beard 
            (0x1f9d4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man: dark skin tone, beard 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: dark skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: light skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man climbing: light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man climbing: dark skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: dark skin tone 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mage: light skin tone 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mage: light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mage: dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mage: dark skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: light skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man fairy: light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man fairy: dark skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: light skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man vampire: light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man vampire: dark skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # mermaid: light skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # merman: light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-light skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # merman: medium skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-dark skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # mermaid: dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # merman: dark skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman elf: light skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man elf: light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman elf: dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man elf: dark skin tone 
            (0x1f3f3, 0x0fe0f, 0x0200d, 0x026a7, 0x0fe0f), # transgender flag 
            (0x1f441, 0x0fe0f, 0x0200d, 0x1f5e8, 0x0fe0f), # eye in speech bubble 
        # sequences of length 6,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: man, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469), # couple with heart: woman, woman 
        # sequences of length 7,
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, man, boy, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, man, girl, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, man, girl, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, woman, boy, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, woman, girl, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, woman, girl, girl 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: light skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: light skin tone, medium skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: light skin tone, dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium-light skin tone, light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: medium-light skin tone, medium skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium-light skin tone, dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium skin tone, light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: medium skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: medium skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium skin tone, dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium-dark skin tone, light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: medium-dark skin tone, medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium-dark skin tone, dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: dark skin tone, light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: dark skin tone, medium skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: dark skin tone, medium-dark skin tone 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, woman, girl, girl 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: light skin tone, dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: dark skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: light skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium-light skin tone, light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium-light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: medium-light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium skin tone, light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: medium skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: medium skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium-dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium-dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: medium-dark skin tone, dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: dark skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: dark skin tone 
        # sequences of length 8,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: man, man 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: man, man, light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: man, man, light skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: man, man, light skin tone, medium skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: man, man, light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: man, man, light skin tone, dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: man, man, medium-light skin tone, light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: man, man, medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: man, man, medium-light skin tone, medium skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: man, man, medium-light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: man, man, medium-light skin tone, dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: man, man, medium skin tone, light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: man, man, medium skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: man, man, medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: man, man, medium skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: man, man, medium skin tone, dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: man, man, medium-dark skin tone, light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: man, man, medium-dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: man, man, medium-dark skin tone, medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: man, man, medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: man, man, medium-dark skin tone, dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: man, man, dark skin tone, light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: man, man, dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: man, man, dark skin tone, medium skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: man, man, dark skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: man, man, dark skin tone 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469), # kiss: woman, woman 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: woman, man, light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: woman, man, light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: woman, man, light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: woman, man, light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: woman, man, light skin tone, dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fb), # couple with heart: woman, woman, light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fc), # couple with heart: woman, woman, light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fd), # couple with heart: woman, woman, light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fe), # couple with heart: woman, woman, light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3ff), # couple with heart: woman, woman, light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: woman, man, medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: woman, man, medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: woman, man, medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: woman, man, medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: woman, man, medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fb), # couple with heart: woman, woman, medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fc), # couple with heart: woman, woman, medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fd), # couple with heart: woman, woman, medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fe), # couple with heart: woman, woman, medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3ff), # couple with heart: woman, woman, medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: woman, man, medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: woman, man, medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: woman, man, medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: woman, man, medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: woman, man, medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fb), # couple with heart: woman, woman, medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fc), # couple with heart: woman, woman, medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fd), # couple with heart: woman, woman, medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fe), # couple with heart: woman, woman, medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3ff), # couple with heart: woman, woman, medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: woman, man, medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: woman, man, medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: woman, man, medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: woman, man, medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: woman, man, medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fb), # couple with heart: woman, woman, medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fc), # couple with heart: woman, woman, medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fd), # couple with heart: woman, woman, medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fe), # couple with heart: woman, woman, medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3ff), # couple with heart: woman, woman, medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: woman, man, dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: woman, man, dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: woman, man, dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: woman, man, dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: woman, man, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fb), # couple with heart: woman, woman, dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fc), # couple with heart: woman, woman, dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fd), # couple with heart: woman, woman, dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fe), # couple with heart: woman, woman, dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3ff), # couple with heart: woman, woman, dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fc), # couple with heart: person, person, light skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fd), # couple with heart: person, person, light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fe), # couple with heart: person, person, light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3ff), # couple with heart: person, person, light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fb), # couple with heart: person, person, medium-light skin tone, light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fd), # couple with heart: person, person, medium-light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fe), # couple with heart: person, person, medium-light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3ff), # couple with heart: person, person, medium-light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fb), # couple with heart: person, person, medium skin tone, light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fc), # couple with heart: person, person, medium skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fe), # couple with heart: person, person, medium skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3ff), # couple with heart: person, person, medium skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fb), # couple with heart: person, person, medium-dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fc), # couple with heart: person, person, medium-dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fd), # couple with heart: person, person, medium-dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3ff), # couple with heart: person, person, medium-dark skin tone, dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fb), # couple with heart: person, person, dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fc), # couple with heart: person, person, dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fd), # couple with heart: person, person, dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fe), # couple with heart: person, person, dark skin tone, medium-dark skin tone 
        # sequences of length 10,
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: man, man, light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: man, man, light skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: man, man, light skin tone, medium skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: man, man, light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: man, man, light skin tone, dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: man, man, medium-light skin tone, light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: man, man, medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: man, man, medium-light skin tone, medium skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: man, man, medium-light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: man, man, medium-light skin tone, dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: man, man, medium skin tone, light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: man, man, medium skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: man, man, medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: man, man, medium skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: man, man, medium skin tone, dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: man, man, medium-dark skin tone, light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: man, man, medium-dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: man, man, medium-dark skin tone, medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: man, man, medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: man, man, medium-dark skin tone, dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: man, man, dark skin tone, light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: man, man, dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: man, man, dark skin tone, medium skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: man, man, dark skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: man, man, dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: woman, man, light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: woman, man, light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: woman, man, light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: woman, man, light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: woman, man, light skin tone, dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fb), # kiss: woman, woman, light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fc), # kiss: woman, woman, light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fd), # kiss: woman, woman, light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fe), # kiss: woman, woman, light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3ff), # kiss: woman, woman, light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: woman, man, medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: woman, man, medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: woman, man, medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: woman, man, medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: woman, man, medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fb), # kiss: woman, woman, medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fc), # kiss: woman, woman, medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fd), # kiss: woman, woman, medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fe), # kiss: woman, woman, medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3ff), # kiss: woman, woman, medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: woman, man, medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: woman, man, medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: woman, man, medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: woman, man, medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: woman, man, medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fb), # kiss: woman, woman, medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fc), # kiss: woman, woman, medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fd), # kiss: woman, woman, medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fe), # kiss: woman, woman, medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3ff), # kiss: woman, woman, medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: woman, man, medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: woman, man, medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: woman, man, medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: woman, man, medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: woman, man, medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fb), # kiss: woman, woman, medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fc), # kiss: woman, woman, medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fd), # kiss: woman, woman, medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fe), # kiss: woman, woman, medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3ff), # kiss: woman, woman, medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: woman, man, dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: woman, man, dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: woman, man, dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: woman, man, dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: woman, man, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fb), # kiss: woman, woman, dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fc), # kiss: woman, woman, dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fd), # kiss: woman, woman, dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fe), # kiss: woman, woman, dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3ff), # kiss: woman, woman, dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fc), # kiss: person, person, light skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fd), # kiss: person, person, light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fe), # kiss: person, person, light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3ff), # kiss: person, person, light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fb), # kiss: person, person, medium-light skin tone, light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fd), # kiss: person, person, medium-light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fe), # kiss: person, person, medium-light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3ff), # kiss: person, person, medium-light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fb), # kiss: person, person, medium skin tone, light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fc), # kiss: person, person, medium skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fe), # kiss: person, person, medium skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3ff), # kiss: person, person, medium skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fb), # kiss: person, person, medium-dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fc), # kiss: person, person, medium-dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fd), # kiss: person, person, medium-dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3ff), # kiss: person, person, medium-dark skin tone, dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fb), # kiss: person, person, dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fc), # kiss: person, person, dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fd), # kiss: person, person, dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fe), # kiss: person, person, dark skin tone, medium-dark skin tone 
    },
    '14.0': {
        # Source: ./data/emoji-zwj-sequences-14.0.txt
        # Date: 2021-06-08, 05:19:16 GMT
        #
        # sequences of length 3,
            (0x1f468, 0x0200d, 0x1f466), # family: man, boy 
            (0x1f468, 0x0200d, 0x1f467), # family: man, girl 
            (0x1f469, 0x0200d, 0x1f466), # family: woman, boy 
            (0x1f469, 0x0200d, 0x1f467), # family: woman, girl 
            (0x1f468, 0x0200d, 0x1f33e), # man farmer 
            (0x1f468, 0x0200d, 0x1f373), # man cook 
            (0x1f468, 0x0200d, 0x1f37c), # man feeding baby 
            (0x1f468, 0x0200d, 0x1f393), # man student 
            (0x1f468, 0x0200d, 0x1f3a4), # man singer 
            (0x1f468, 0x0200d, 0x1f3a8), # man artist 
            (0x1f468, 0x0200d, 0x1f3eb), # man teacher 
            (0x1f468, 0x0200d, 0x1f3ed), # man factory worker 
            (0x1f468, 0x0200d, 0x1f4bb), # man technologist 
            (0x1f468, 0x0200d, 0x1f4bc), # man office worker 
            (0x1f468, 0x0200d, 0x1f527), # man mechanic 
            (0x1f468, 0x0200d, 0x1f52c), # man scientist 
            (0x1f468, 0x0200d, 0x1f680), # man astronaut 
            (0x1f468, 0x0200d, 0x1f692), # man firefighter 
            (0x1f468, 0x0200d, 0x1f9af), # man with white cane 
            (0x1f468, 0x0200d, 0x1f9bc), # man in motorized wheelchair 
            (0x1f468, 0x0200d, 0x1f9bd), # man in manual wheelchair 
            (0x1f469, 0x0200d, 0x1f33e), # woman farmer 
            (0x1f469, 0x0200d, 0x1f373), # woman cook 
            (0x1f469, 0x0200d, 0x1f37c), # woman feeding baby 
            (0x1f469, 0x0200d, 0x1f393), # woman student 
            (0x1f469, 0x0200d, 0x1f3a4), # woman singer 
            (0x1f469, 0x0200d, 0x1f3a8), # woman artist 
            (0x1f469, 0x0200d, 0x1f3eb), # woman teacher 
            (0x1f469, 0x0200d, 0x1f3ed), # woman factory worker 
            (0x1f469, 0x0200d, 0x1f4bb), # woman technologist 
            (0x1f469, 0x0200d, 0x1f4bc), # woman office worker 
            (0x1f469, 0x0200d, 0x1f527), # woman mechanic 
            (0x1f469, 0x0200d, 0x1f52c), # woman scientist 
            (0x1f469, 0x0200d, 0x1f680), # woman astronaut 
            (0x1f469, 0x0200d, 0x1f692), # woman firefighter 
            (0x1f469, 0x0200d, 0x1f9af), # woman with white cane 
            (0x1f469, 0x0200d, 0x1f9bc), # woman in motorized wheelchair 
            (0x1f469, 0x0200d, 0x1f9bd), # woman in manual wheelchair 
            (0x1f9d1, 0x0200d, 0x1f33e), # farmer 
            (0x1f9d1, 0x0200d, 0x1f373), # cook 
            (0x1f9d1, 0x0200d, 0x1f37c), # person feeding baby 
            (0x1f9d1, 0x0200d, 0x1f393), # student 
            (0x1f9d1, 0x0200d, 0x1f3a4), # singer 
            (0x1f9d1, 0x0200d, 0x1f3a8), # artist 
            (0x1f9d1, 0x0200d, 0x1f3eb), # teacher 
            (0x1f9d1, 0x0200d, 0x1f3ed), # factory worker 
            (0x1f9d1, 0x0200d, 0x1f4bb), # technologist 
            (0x1f9d1, 0x0200d, 0x1f4bc), # office worker 
            (0x1f9d1, 0x0200d, 0x1f527), # mechanic 
            (0x1f9d1, 0x0200d, 0x1f52c), # scientist 
            (0x1f9d1, 0x0200d, 0x1f680), # astronaut 
            (0x1f9d1, 0x0200d, 0x1f692), # firefighter 
            (0x1f9d1, 0x0200d, 0x1f9af), # person with white cane 
            (0x1f9d1, 0x0200d, 0x1f9bc), # person in motorized wheelchair 
            (0x1f9d1, 0x0200d, 0x1f9bd), # person in manual wheelchair 
            (0x1f468, 0x0200d, 0x1f9b0), # man: red hair 
            (0x1f468, 0x0200d, 0x1f9b1), # man: curly hair 
            (0x1f468, 0x0200d, 0x1f9b2), # man: bald 
            (0x1f468, 0x0200d, 0x1f9b3), # man: white hair 
            (0x1f469, 0x0200d, 0x1f9b0), # woman: red hair 
            (0x1f469, 0x0200d, 0x1f9b1), # woman: curly hair 
            (0x1f469, 0x0200d, 0x1f9b2), # woman: bald 
            (0x1f469, 0x0200d, 0x1f9b3), # woman: white hair 
            (0x1f9d1, 0x0200d, 0x1f9b0), # person: red hair 
            (0x1f9d1, 0x0200d, 0x1f9b1), # person: curly hair 
            (0x1f9d1, 0x0200d, 0x1f9b2), # person: bald 
            (0x1f9d1, 0x0200d, 0x1f9b3), # person: white hair 
            (0x1f408, 0x0200d, 0x02b1b), # black cat 
            (0x1f415, 0x0200d, 0x1f9ba), # service dog 
            (0x1f62e, 0x0200d, 0x1f4a8), # face exhaling 
            (0x1f635, 0x0200d, 0x1f4ab), # face with spiral eyes 
            (0x1f9d1, 0x0200d, 0x1f384), # mx claus 
        # sequences of length 4,
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f384), # mx claus: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f384), # mx claus: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f384), # mx claus: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f384), # mx claus: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f384), # mx claus: dark skin tone 
            (0x1f468, 0x0200d, 0x02695, 0x0fe0f), # man health worker 
            (0x1f468, 0x0200d, 0x02696, 0x0fe0f), # man judge 
            (0x1f468, 0x0200d, 0x02708, 0x0fe0f), # man pilot 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f33e), # man farmer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f373), # man cook: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f37c), # man feeding baby: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f393), # man student: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a4), # man singer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a8), # man artist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3eb), # man teacher: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3ed), # man factory worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bb), # man technologist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bc), # man office worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f527), # man mechanic: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f52c), # man scientist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f680), # man astronaut: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f692), # man firefighter: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9af), # man with white cane: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9bc), # man in motorized wheelchair: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9bd), # man in manual wheelchair: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f33e), # man farmer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f373), # man cook: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f37c), # man feeding baby: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f393), # man student: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a4), # man singer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a8), # man artist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3eb), # man teacher: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3ed), # man factory worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bb), # man technologist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bc), # man office worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f527), # man mechanic: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f52c), # man scientist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f680), # man astronaut: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f692), # man firefighter: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9af), # man with white cane: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f33e), # man farmer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f373), # man cook: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f37c), # man feeding baby: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f393), # man student: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a4), # man singer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a8), # man artist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3eb), # man teacher: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3ed), # man factory worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bb), # man technologist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bc), # man office worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f527), # man mechanic: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f52c), # man scientist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f680), # man astronaut: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f692), # man firefighter: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9af), # man with white cane: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f33e), # man farmer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f373), # man cook: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f37c), # man feeding baby: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f393), # man student: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a4), # man singer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a8), # man artist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3eb), # man teacher: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3ed), # man factory worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bb), # man technologist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bc), # man office worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f527), # man mechanic: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f52c), # man scientist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f680), # man astronaut: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f692), # man firefighter: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9af), # man with white cane: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f33e), # man farmer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f373), # man cook: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f37c), # man feeding baby: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f393), # man student: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a4), # man singer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a8), # man artist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3eb), # man teacher: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3ed), # man factory worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bb), # man technologist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bc), # man office worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f527), # man mechanic: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f52c), # man scientist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f680), # man astronaut: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f692), # man firefighter: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9af), # man with white cane: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9bc), # man in motorized wheelchair: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9bd), # man in manual wheelchair: dark skin tone 
            (0x1f469, 0x0200d, 0x02695, 0x0fe0f), # woman health worker 
            (0x1f469, 0x0200d, 0x02696, 0x0fe0f), # woman judge 
            (0x1f469, 0x0200d, 0x02708, 0x0fe0f), # woman pilot 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f33e), # woman farmer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f373), # woman cook: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f37c), # woman feeding baby: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f393), # woman student: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a4), # woman singer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a8), # woman artist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3eb), # woman teacher: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3ed), # woman factory worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bb), # woman technologist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bc), # woman office worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f527), # woman mechanic: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f52c), # woman scientist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f680), # woman astronaut: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f692), # woman firefighter: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9af), # woman with white cane: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9bd), # woman in manual wheelchair: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f33e), # woman farmer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f373), # woman cook: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f37c), # woman feeding baby: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f393), # woman student: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a4), # woman singer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a8), # woman artist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3eb), # woman teacher: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3ed), # woman factory worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bb), # woman technologist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bc), # woman office worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f527), # woman mechanic: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f52c), # woman scientist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f680), # woman astronaut: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f692), # woman firefighter: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9af), # woman with white cane: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f33e), # woman farmer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f373), # woman cook: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f37c), # woman feeding baby: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f393), # woman student: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a4), # woman singer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a8), # woman artist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3eb), # woman teacher: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3ed), # woman factory worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bb), # woman technologist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bc), # woman office worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f527), # woman mechanic: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f52c), # woman scientist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f680), # woman astronaut: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f692), # woman firefighter: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9af), # woman with white cane: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f33e), # woman farmer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f373), # woman cook: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f37c), # woman feeding baby: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f393), # woman student: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a4), # woman singer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a8), # woman artist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3eb), # woman teacher: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3ed), # woman factory worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bb), # woman technologist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bc), # woman office worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f527), # woman mechanic: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f52c), # woman scientist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f680), # woman astronaut: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f692), # woman firefighter: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9af), # woman with white cane: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f33e), # woman farmer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f373), # woman cook: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f37c), # woman feeding baby: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f393), # woman student: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a4), # woman singer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a8), # woman artist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3eb), # woman teacher: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3ed), # woman factory worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bb), # woman technologist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bc), # woman office worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f527), # woman mechanic: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f52c), # woman scientist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f680), # woman astronaut: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f692), # woman firefighter: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9af), # woman with white cane: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9bd), # woman in manual wheelchair: dark skin tone 
            (0x1f9d1, 0x0200d, 0x02695, 0x0fe0f), # health worker 
            (0x1f9d1, 0x0200d, 0x02696, 0x0fe0f), # judge 
            (0x1f9d1, 0x0200d, 0x02708, 0x0fe0f), # pilot 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f33e), # farmer: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f373), # cook: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f37c), # person feeding baby: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f393), # student: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3a4), # singer: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3a8), # artist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3eb), # teacher: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3ed), # factory worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f4bb), # technologist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f4bc), # office worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f527), # mechanic: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f52c), # scientist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f680), # astronaut: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f692), # firefighter: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9af), # person with white cane: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9bc), # person in motorized wheelchair: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9bd), # person in manual wheelchair: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f33e), # farmer: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f373), # cook: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f37c), # person feeding baby: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f393), # student: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3a4), # singer: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3a8), # artist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3eb), # teacher: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3ed), # factory worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f4bb), # technologist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f4bc), # office worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f527), # mechanic: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f52c), # scientist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f680), # astronaut: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f692), # firefighter: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9af), # person with white cane: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f33e), # farmer: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f373), # cook: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f37c), # person feeding baby: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f393), # student: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3a4), # singer: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3a8), # artist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3eb), # teacher: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3ed), # factory worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f4bb), # technologist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f4bc), # office worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f527), # mechanic: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f52c), # scientist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f680), # astronaut: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f692), # firefighter: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9af), # person with white cane: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f33e), # farmer: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f373), # cook: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f37c), # person feeding baby: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f393), # student: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3a4), # singer: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3a8), # artist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3eb), # teacher: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3ed), # factory worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f4bb), # technologist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f4bc), # office worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f527), # mechanic: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f52c), # scientist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f680), # astronaut: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f692), # firefighter: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9af), # person with white cane: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f33e), # farmer: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f373), # cook: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f37c), # person feeding baby: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f393), # student: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3a4), # singer: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3a8), # artist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3eb), # teacher: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3ed), # factory worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f4bb), # technologist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f4bc), # office worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f527), # mechanic: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f52c), # scientist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f680), # astronaut: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f692), # firefighter: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9af), # person with white cane: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9bc), # person in motorized wheelchair: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9bd), # person in manual wheelchair: dark skin tone 
            (0x1f3c3, 0x0200d, 0x02640, 0x0fe0f), # woman running 
            (0x1f3c3, 0x0200d, 0x02642, 0x0fe0f), # man running 
            (0x1f3c4, 0x0200d, 0x02640, 0x0fe0f), # woman surfing 
            (0x1f3c4, 0x0200d, 0x02642, 0x0fe0f), # man surfing 
            (0x1f3ca, 0x0200d, 0x02640, 0x0fe0f), # woman swimming 
            (0x1f3ca, 0x0200d, 0x02642, 0x0fe0f), # man swimming 
            (0x1f46e, 0x0200d, 0x02640, 0x0fe0f), # woman police officer 
            (0x1f46e, 0x0200d, 0x02642, 0x0fe0f), # man police officer 
            (0x1f46f, 0x0200d, 0x02640, 0x0fe0f), # women with bunny ears 
            (0x1f46f, 0x0200d, 0x02642, 0x0fe0f), # men with bunny ears 
            (0x1f470, 0x0200d, 0x02640, 0x0fe0f), # woman with veil 
            (0x1f470, 0x0200d, 0x02642, 0x0fe0f), # man with veil 
            (0x1f471, 0x0200d, 0x02640, 0x0fe0f), # woman: blond hair 
            (0x1f471, 0x0200d, 0x02642, 0x0fe0f), # man: blond hair 
            (0x1f473, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban 
            (0x1f473, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban 
            (0x1f477, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker 
            (0x1f477, 0x0200d, 0x02642, 0x0fe0f), # man construction worker 
            (0x1f481, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand 
            (0x1f481, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand 
            (0x1f482, 0x0200d, 0x02640, 0x0fe0f), # woman guard 
            (0x1f482, 0x0200d, 0x02642, 0x0fe0f), # man guard 
            (0x1f486, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage 
            (0x1f486, 0x0200d, 0x02642, 0x0fe0f), # man getting massage 
            (0x1f487, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut 
            (0x1f487, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut 
            (0x1f645, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO 
            (0x1f645, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO 
            (0x1f646, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK 
            (0x1f646, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK 
            (0x1f647, 0x0200d, 0x02640, 0x0fe0f), # woman bowing 
            (0x1f647, 0x0200d, 0x02642, 0x0fe0f), # man bowing 
            (0x1f64b, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand 
            (0x1f64b, 0x0200d, 0x02642, 0x0fe0f), # man raising hand 
            (0x1f64d, 0x0200d, 0x02640, 0x0fe0f), # woman frowning 
            (0x1f64d, 0x0200d, 0x02642, 0x0fe0f), # man frowning 
            (0x1f64e, 0x0200d, 0x02640, 0x0fe0f), # woman pouting 
            (0x1f64e, 0x0200d, 0x02642, 0x0fe0f), # man pouting 
            (0x1f6a3, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat 
            (0x1f6a3, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat 
            (0x1f6b4, 0x0200d, 0x02640, 0x0fe0f), # woman biking 
            (0x1f6b4, 0x0200d, 0x02642, 0x0fe0f), # man biking 
            (0x1f6b5, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking 
            (0x1f6b5, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking 
            (0x1f6b6, 0x0200d, 0x02640, 0x0fe0f), # woman walking 
            (0x1f6b6, 0x0200d, 0x02642, 0x0fe0f), # man walking 
            (0x1f926, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming 
            (0x1f926, 0x0200d, 0x02642, 0x0fe0f), # man facepalming 
            (0x1f935, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo 
            (0x1f935, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo 
            (0x1f937, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging 
            (0x1f937, 0x0200d, 0x02642, 0x0fe0f), # man shrugging 
            (0x1f938, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling 
            (0x1f938, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling 
            (0x1f939, 0x0200d, 0x02640, 0x0fe0f), # woman juggling 
            (0x1f939, 0x0200d, 0x02642, 0x0fe0f), # man juggling 
            (0x1f93c, 0x0200d, 0x02640, 0x0fe0f), # women wrestling 
            (0x1f93c, 0x0200d, 0x02642, 0x0fe0f), # men wrestling 
            (0x1f93d, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo 
            (0x1f93d, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo 
            (0x1f93e, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball 
            (0x1f93e, 0x0200d, 0x02642, 0x0fe0f), # man playing handball 
            (0x1f9b8, 0x0200d, 0x02640, 0x0fe0f), # woman superhero 
            (0x1f9b8, 0x0200d, 0x02642, 0x0fe0f), # man superhero 
            (0x1f9b9, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain 
            (0x1f9b9, 0x0200d, 0x02642, 0x0fe0f), # man supervillain 
            (0x1f9cd, 0x0200d, 0x02640, 0x0fe0f), # woman standing 
            (0x1f9cd, 0x0200d, 0x02642, 0x0fe0f), # man standing 
            (0x1f9ce, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling 
            (0x1f9ce, 0x0200d, 0x02642, 0x0fe0f), # man kneeling 
            (0x1f9cf, 0x0200d, 0x02640, 0x0fe0f), # deaf woman 
            (0x1f9cf, 0x0200d, 0x02642, 0x0fe0f), # deaf man 
            (0x1f9d4, 0x0200d, 0x02640, 0x0fe0f), # woman: beard 
            (0x1f9d4, 0x0200d, 0x02642, 0x0fe0f), # man: beard 
            (0x1f9d6, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room 
            (0x1f9d6, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room 
            (0x1f9d7, 0x0200d, 0x02640, 0x0fe0f), # woman climbing 
            (0x1f9d7, 0x0200d, 0x02642, 0x0fe0f), # man climbing 
            (0x1f9d8, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position 
            (0x1f9d8, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position 
            (0x1f9d9, 0x0200d, 0x02640, 0x0fe0f), # woman mage 
            (0x1f9d9, 0x0200d, 0x02642, 0x0fe0f), # man mage 
            (0x1f9da, 0x0200d, 0x02640, 0x0fe0f), # woman fairy 
            (0x1f9da, 0x0200d, 0x02642, 0x0fe0f), # man fairy 
            (0x1f9db, 0x0200d, 0x02640, 0x0fe0f), # woman vampire 
            (0x1f9db, 0x0200d, 0x02642, 0x0fe0f), # man vampire 
            (0x1f9dc, 0x0200d, 0x02640, 0x0fe0f), # mermaid 
            (0x1f9dc, 0x0200d, 0x02642, 0x0fe0f), # merman 
            (0x1f9dd, 0x0200d, 0x02640, 0x0fe0f), # woman elf 
            (0x1f9dd, 0x0200d, 0x02642, 0x0fe0f), # man elf 
            (0x1f9de, 0x0200d, 0x02640, 0x0fe0f), # woman genie 
            (0x1f9de, 0x0200d, 0x02642, 0x0fe0f), # man genie 
            (0x1f9df, 0x0200d, 0x02640, 0x0fe0f), # woman zombie 
            (0x1f9df, 0x0200d, 0x02642, 0x0fe0f), # man zombie 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b0), # man: light skin tone, red hair 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b1), # man: light skin tone, curly hair 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b2), # man: light skin tone, bald 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b3), # man: light skin tone, white hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b0), # man: medium-light skin tone, red hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b1), # man: medium-light skin tone, curly hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b2), # man: medium-light skin tone, bald 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b3), # man: medium-light skin tone, white hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b0), # man: medium skin tone, red hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b1), # man: medium skin tone, curly hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b2), # man: medium skin tone, bald 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b3), # man: medium skin tone, white hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b0), # man: medium-dark skin tone, red hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b1), # man: medium-dark skin tone, curly hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b2), # man: medium-dark skin tone, bald 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b3), # man: medium-dark skin tone, white hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b0), # man: dark skin tone, red hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b1), # man: dark skin tone, curly hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b2), # man: dark skin tone, bald 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b3), # man: dark skin tone, white hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b0), # woman: light skin tone, red hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b1), # woman: light skin tone, curly hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b2), # woman: light skin tone, bald 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b3), # woman: light skin tone, white hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b0), # woman: medium-light skin tone, red hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b1), # woman: medium-light skin tone, curly hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b2), # woman: medium-light skin tone, bald 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b3), # woman: medium-light skin tone, white hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b0), # woman: medium skin tone, red hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b1), # woman: medium skin tone, curly hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b2), # woman: medium skin tone, bald 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b3), # woman: medium skin tone, white hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b0), # woman: medium-dark skin tone, red hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b1), # woman: medium-dark skin tone, curly hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b2), # woman: medium-dark skin tone, bald 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b3), # woman: medium-dark skin tone, white hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b0), # woman: dark skin tone, red hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b1), # woman: dark skin tone, curly hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b2), # woman: dark skin tone, bald 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b3), # woman: dark skin tone, white hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b0), # person: light skin tone, red hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b1), # person: light skin tone, curly hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b2), # person: light skin tone, bald 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b3), # person: light skin tone, white hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b0), # person: medium-light skin tone, red hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b1), # person: medium-light skin tone, curly hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b2), # person: medium-light skin tone, bald 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b3), # person: medium-light skin tone, white hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b0), # person: medium skin tone, red hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b1), # person: medium skin tone, curly hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b2), # person: medium skin tone, bald 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b3), # person: medium skin tone, white hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b0), # person: medium-dark skin tone, red hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b1), # person: medium-dark skin tone, curly hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b2), # person: medium-dark skin tone, bald 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b3), # person: medium-dark skin tone, white hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b0), # person: dark skin tone, red hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b1), # person: dark skin tone, curly hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b2), # person: dark skin tone, bald 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b3), # person: dark skin tone, white hair 
            (0x02764, 0x0fe0f, 0x0200d, 0x1f525), # heart on fire 
            (0x02764, 0x0fe0f, 0x0200d, 0x1fa79), # mending heart 
            (0x1f3f3, 0x0fe0f, 0x0200d, 0x1f308), # rainbow flag 
            (0x1f3f4, 0x0200d, 0x02620, 0x0fe0f), # pirate flag 
            (0x1f43b, 0x0200d, 0x02744, 0x0fe0f), # polar bear 
            (0x1f636, 0x0200d, 0x1f32b, 0x0fe0f), # face in clouds 
        # sequences of length 5,
            (0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, boy, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, girl, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, girl, girl 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466), # family: man, man, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467), # family: man, man, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: man, woman, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: man, woman, girl 
            (0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, girl, girl 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: woman, woman, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: woman, woman, girl 
            (0x1f9d1, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1), # people holding hands 
            (0x1faf1, 0x1f3fb, 0x0200d, 0x1faf2, 0x1f3fc), # handshake: light skin tone, medium-light skin tone 
            (0x1faf1, 0x1f3fb, 0x0200d, 0x1faf2, 0x1f3fd), # handshake: light skin tone, medium skin tone 
            (0x1faf1, 0x1f3fb, 0x0200d, 0x1faf2, 0x1f3fe), # handshake: light skin tone, medium-dark skin tone 
            (0x1faf1, 0x1f3fb, 0x0200d, 0x1faf2, 0x1f3ff), # handshake: light skin tone, dark skin tone 
            (0x1faf1, 0x1f3fc, 0x0200d, 0x1faf2, 0x1f3fb), # handshake: medium-light skin tone, light skin tone 
            (0x1faf1, 0x1f3fc, 0x0200d, 0x1faf2, 0x1f3fd), # handshake: medium-light skin tone, medium skin tone 
            (0x1faf1, 0x1f3fc, 0x0200d, 0x1faf2, 0x1f3fe), # handshake: medium-light skin tone, medium-dark skin tone 
            (0x1faf1, 0x1f3fc, 0x0200d, 0x1faf2, 0x1f3ff), # handshake: medium-light skin tone, dark skin tone 
            (0x1faf1, 0x1f3fd, 0x0200d, 0x1faf2, 0x1f3fb), # handshake: medium skin tone, light skin tone 
            (0x1faf1, 0x1f3fd, 0x0200d, 0x1faf2, 0x1f3fc), # handshake: medium skin tone, medium-light skin tone 
            (0x1faf1, 0x1f3fd, 0x0200d, 0x1faf2, 0x1f3fe), # handshake: medium skin tone, medium-dark skin tone 
            (0x1faf1, 0x1f3fd, 0x0200d, 0x1faf2, 0x1f3ff), # handshake: medium skin tone, dark skin tone 
            (0x1faf1, 0x1f3fe, 0x0200d, 0x1faf2, 0x1f3fb), # handshake: medium-dark skin tone, light skin tone 
            (0x1faf1, 0x1f3fe, 0x0200d, 0x1faf2, 0x1f3fc), # handshake: medium-dark skin tone, medium-light skin tone 
            (0x1faf1, 0x1f3fe, 0x0200d, 0x1faf2, 0x1f3fd), # handshake: medium-dark skin tone, medium skin tone 
            (0x1faf1, 0x1f3fe, 0x0200d, 0x1faf2, 0x1f3ff), # handshake: medium-dark skin tone, dark skin tone 
            (0x1faf1, 0x1f3ff, 0x0200d, 0x1faf2, 0x1f3fb), # handshake: dark skin tone, light skin tone 
            (0x1faf1, 0x1f3ff, 0x0200d, 0x1faf2, 0x1f3fc), # handshake: dark skin tone, medium-light skin tone 
            (0x1faf1, 0x1f3ff, 0x0200d, 0x1faf2, 0x1f3fd), # handshake: dark skin tone, medium skin tone 
            (0x1faf1, 0x1f3ff, 0x0200d, 0x1faf2, 0x1f3fe), # handshake: dark skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # man health worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # man judge: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # man pilot: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # man health worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # man judge: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # man pilot: dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # woman judge: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # woman judge: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # health worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # judge: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # pilot: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # judge: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # judge: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # judge: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # health worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # judge: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # pilot: dark skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: light skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: dark skin tone 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman running: light skin tone 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man running: light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-light skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man running: medium skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-dark skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman running: dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man running: dark skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: light skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man surfing: light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man surfing: dark skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: light skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man swimming: light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man swimming: dark skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: dark skin tone 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: light skin tone 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man golfing: light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man golfing: dark skin tone 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman golfing 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man golfing 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: light skin tone 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man police officer: light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man police officer: dark skin tone 
            (0x1f470, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: light skin tone 
            (0x1f470, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man with veil: light skin tone 
            (0x1f470, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: medium-light skin tone 
            (0x1f470, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man with veil: medium-light skin tone 
            (0x1f470, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: medium skin tone 
            (0x1f470, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man with veil: medium skin tone 
            (0x1f470, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: medium-dark skin tone 
            (0x1f470, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man with veil: medium-dark skin tone 
            (0x1f470, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: dark skin tone 
            (0x1f470, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man with veil: dark skin tone 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman: light skin tone, blond hair 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man: light skin tone, blond hair 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-light skin tone, blond hair 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man: medium-light skin tone, blond hair 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman: medium skin tone, blond hair 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man: medium skin tone, blond hair 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-dark skin tone, blond hair 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man: medium-dark skin tone, blond hair 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman: dark skin tone, blond hair 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man: dark skin tone, blond hair 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: light skin tone 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: dark skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: light skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: dark skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: light skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: dark skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman guard: light skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man guard: light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-light skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-dark skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman guard: dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man guard: dark skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: light skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: dark skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: light skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: dark skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman detective: light skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man detective: light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-light skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-dark skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman detective: dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man detective: dark skin tone 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman detective 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man detective 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: light skin tone 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: dark skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: light skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: dark skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: light skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bowing: light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-light skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-dark skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bowing: dark skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: light skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: dark skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: light skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man frowning: light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man frowning: dark skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: light skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man pouting: light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man pouting: dark skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: dark skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman biking: light skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man biking: light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman biking: dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man biking: dark skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: dark skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman walking: light skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man walking: light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman walking: dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man walking: dark skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: light skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: dark skin tone 
            (0x1f935, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: light skin tone 
            (0x1f935, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: light skin tone 
            (0x1f935, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: medium-light skin tone 
            (0x1f935, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: medium-light skin tone 
            (0x1f935, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: medium skin tone 
            (0x1f935, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: medium skin tone 
            (0x1f935, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: medium-dark skin tone 
            (0x1f935, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: medium-dark skin tone 
            (0x1f935, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: dark skin tone 
            (0x1f935, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: dark skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: light skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: dark skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: light skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: dark skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: light skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man juggling: light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-light skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-dark skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man juggling: dark skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: light skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: dark skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: light skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: dark skin tone 
            (0x1f9b8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: light skin tone 
            (0x1f9b8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man superhero: light skin tone 
            (0x1f9b8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium-light skin tone 
            (0x1f9b8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium-light skin tone 
            (0x1f9b8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium skin tone 
            (0x1f9b8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium skin tone 
            (0x1f9b8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium-dark skin tone 
            (0x1f9b8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium-dark skin tone 
            (0x1f9b8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: dark skin tone 
            (0x1f9b8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man superhero: dark skin tone 
            (0x1f9b9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: light skin tone 
            (0x1f9b9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: light skin tone 
            (0x1f9b9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium-light skin tone 
            (0x1f9b9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium-light skin tone 
            (0x1f9b9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium skin tone 
            (0x1f9b9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium skin tone 
            (0x1f9b9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium-dark skin tone 
            (0x1f9b9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium-dark skin tone 
            (0x1f9b9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: dark skin tone 
            (0x1f9b9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: dark skin tone 
            (0x1f9cd, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman standing: light skin tone 
            (0x1f9cd, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man standing: light skin tone 
            (0x1f9cd, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium-light skin tone 
            (0x1f9cd, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium-light skin tone 
            (0x1f9cd, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium skin tone 
            (0x1f9cd, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium skin tone 
            (0x1f9cd, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium-dark skin tone 
            (0x1f9cd, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium-dark skin tone 
            (0x1f9cd, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman standing: dark skin tone 
            (0x1f9cd, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man standing: dark skin tone 
            (0x1f9ce, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: light skin tone 
            (0x1f9ce, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: light skin tone 
            (0x1f9ce, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium-light skin tone 
            (0x1f9ce, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium-light skin tone 
            (0x1f9ce, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium skin tone 
            (0x1f9ce, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium skin tone 
            (0x1f9ce, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium-dark skin tone 
            (0x1f9ce, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium-dark skin tone 
            (0x1f9ce, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: dark skin tone 
            (0x1f9ce, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: dark skin tone 
            (0x1f9cf, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: light skin tone 
            (0x1f9cf, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # deaf man: light skin tone 
            (0x1f9cf, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium-light skin tone 
            (0x1f9cf, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium-light skin tone 
            (0x1f9cf, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium skin tone 
            (0x1f9cf, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium skin tone 
            (0x1f9cf, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium-dark skin tone 
            (0x1f9cf, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium-dark skin tone 
            (0x1f9cf, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: dark skin tone 
            (0x1f9cf, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # deaf man: dark skin tone 
            (0x1f9d4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman: light skin tone, beard 
            (0x1f9d4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man: light skin tone, beard 
            (0x1f9d4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-light skin tone, beard 
            (0x1f9d4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man: medium-light skin tone, beard 
            (0x1f9d4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman: medium skin tone, beard 
            (0x1f9d4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man: medium skin tone, beard 
            (0x1f9d4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-dark skin tone, beard 
            (0x1f9d4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man: medium-dark skin tone, beard 
            (0x1f9d4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman: dark skin tone, beard 
            (0x1f9d4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man: dark skin tone, beard 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: dark skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: light skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man climbing: light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man climbing: dark skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: dark skin tone 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mage: light skin tone 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mage: light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mage: dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mage: dark skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: light skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man fairy: light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man fairy: dark skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: light skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man vampire: light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man vampire: dark skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # mermaid: light skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # merman: light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-light skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # merman: medium skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-dark skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # mermaid: dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # merman: dark skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman elf: light skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man elf: light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman elf: dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man elf: dark skin tone 
            (0x1f3f3, 0x0fe0f, 0x0200d, 0x026a7, 0x0fe0f), # transgender flag 
            (0x1f441, 0x0fe0f, 0x0200d, 0x1f5e8, 0x0fe0f), # eye in speech bubble 
        # sequences of length 6,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: man, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469), # couple with heart: woman, woman 
        # sequences of length 7,
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, man, boy, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, man, girl, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, man, girl, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, woman, boy, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, woman, girl, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, woman, girl, girl 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: light skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: light skin tone, medium skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: light skin tone, dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium-light skin tone, light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: medium-light skin tone, medium skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium-light skin tone, dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium skin tone, light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: medium skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: medium skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium skin tone, dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium-dark skin tone, light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: medium-dark skin tone, medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium-dark skin tone, dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: dark skin tone, light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: dark skin tone, medium skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: dark skin tone, medium-dark skin tone 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, woman, girl, girl 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: light skin tone, dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: dark skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: light skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium-light skin tone, light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium-light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: medium-light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium skin tone, light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: medium skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: medium skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium-dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium-dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: medium-dark skin tone, dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: dark skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: dark skin tone 
        # sequences of length 8,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: man, man 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: man, man, light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: man, man, light skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: man, man, light skin tone, medium skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: man, man, light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: man, man, light skin tone, dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: man, man, medium-light skin tone, light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: man, man, medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: man, man, medium-light skin tone, medium skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: man, man, medium-light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: man, man, medium-light skin tone, dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: man, man, medium skin tone, light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: man, man, medium skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: man, man, medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: man, man, medium skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: man, man, medium skin tone, dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: man, man, medium-dark skin tone, light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: man, man, medium-dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: man, man, medium-dark skin tone, medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: man, man, medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: man, man, medium-dark skin tone, dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: man, man, dark skin tone, light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: man, man, dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: man, man, dark skin tone, medium skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: man, man, dark skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: man, man, dark skin tone 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469), # kiss: woman, woman 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: woman, man, light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: woman, man, light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: woman, man, light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: woman, man, light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: woman, man, light skin tone, dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fb), # couple with heart: woman, woman, light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fc), # couple with heart: woman, woman, light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fd), # couple with heart: woman, woman, light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fe), # couple with heart: woman, woman, light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3ff), # couple with heart: woman, woman, light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: woman, man, medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: woman, man, medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: woman, man, medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: woman, man, medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: woman, man, medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fb), # couple with heart: woman, woman, medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fc), # couple with heart: woman, woman, medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fd), # couple with heart: woman, woman, medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fe), # couple with heart: woman, woman, medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3ff), # couple with heart: woman, woman, medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: woman, man, medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: woman, man, medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: woman, man, medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: woman, man, medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: woman, man, medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fb), # couple with heart: woman, woman, medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fc), # couple with heart: woman, woman, medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fd), # couple with heart: woman, woman, medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fe), # couple with heart: woman, woman, medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3ff), # couple with heart: woman, woman, medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: woman, man, medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: woman, man, medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: woman, man, medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: woman, man, medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: woman, man, medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fb), # couple with heart: woman, woman, medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fc), # couple with heart: woman, woman, medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fd), # couple with heart: woman, woman, medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fe), # couple with heart: woman, woman, medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3ff), # couple with heart: woman, woman, medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: woman, man, dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: woman, man, dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: woman, man, dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: woman, man, dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: woman, man, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fb), # couple with heart: woman, woman, dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fc), # couple with heart: woman, woman, dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fd), # couple with heart: woman, woman, dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fe), # couple with heart: woman, woman, dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3ff), # couple with heart: woman, woman, dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fc), # couple with heart: person, person, light skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fd), # couple with heart: person, person, light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fe), # couple with heart: person, person, light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3ff), # couple with heart: person, person, light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fb), # couple with heart: person, person, medium-light skin tone, light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fd), # couple with heart: person, person, medium-light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fe), # couple with heart: person, person, medium-light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3ff), # couple with heart: person, person, medium-light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fb), # couple with heart: person, person, medium skin tone, light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fc), # couple with heart: person, person, medium skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fe), # couple with heart: person, person, medium skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3ff), # couple with heart: person, person, medium skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fb), # couple with heart: person, person, medium-dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fc), # couple with heart: person, person, medium-dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fd), # couple with heart: person, person, medium-dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3ff), # couple with heart: person, person, medium-dark skin tone, dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fb), # couple with heart: person, person, dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fc), # couple with heart: person, person, dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fd), # couple with heart: person, person, dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fe), # couple with heart: person, person, dark skin tone, medium-dark skin tone 
        # sequences of length 10,
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: man, man, light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: man, man, light skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: man, man, light skin tone, medium skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: man, man, light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: man, man, light skin tone, dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: man, man, medium-light skin tone, light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: man, man, medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: man, man, medium-light skin tone, medium skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: man, man, medium-light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: man, man, medium-light skin tone, dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: man, man, medium skin tone, light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: man, man, medium skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: man, man, medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: man, man, medium skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: man, man, medium skin tone, dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: man, man, medium-dark skin tone, light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: man, man, medium-dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: man, man, medium-dark skin tone, medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: man, man, medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: man, man, medium-dark skin tone, dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: man, man, dark skin tone, light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: man, man, dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: man, man, dark skin tone, medium skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: man, man, dark skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: man, man, dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: woman, man, light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: woman, man, light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: woman, man, light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: woman, man, light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: woman, man, light skin tone, dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fb), # kiss: woman, woman, light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fc), # kiss: woman, woman, light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fd), # kiss: woman, woman, light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fe), # kiss: woman, woman, light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3ff), # kiss: woman, woman, light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: woman, man, medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: woman, man, medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: woman, man, medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: woman, man, medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: woman, man, medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fb), # kiss: woman, woman, medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fc), # kiss: woman, woman, medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fd), # kiss: woman, woman, medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fe), # kiss: woman, woman, medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3ff), # kiss: woman, woman, medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: woman, man, medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: woman, man, medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: woman, man, medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: woman, man, medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: woman, man, medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fb), # kiss: woman, woman, medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fc), # kiss: woman, woman, medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fd), # kiss: woman, woman, medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fe), # kiss: woman, woman, medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3ff), # kiss: woman, woman, medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: woman, man, medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: woman, man, medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: woman, man, medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: woman, man, medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: woman, man, medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fb), # kiss: woman, woman, medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fc), # kiss: woman, woman, medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fd), # kiss: woman, woman, medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fe), # kiss: woman, woman, medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3ff), # kiss: woman, woman, medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: woman, man, dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: woman, man, dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: woman, man, dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: woman, man, dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: woman, man, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fb), # kiss: woman, woman, dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fc), # kiss: woman, woman, dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fd), # kiss: woman, woman, dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fe), # kiss: woman, woman, dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3ff), # kiss: woman, woman, dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fc), # kiss: person, person, light skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fd), # kiss: person, person, light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fe), # kiss: person, person, light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3ff), # kiss: person, person, light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fb), # kiss: person, person, medium-light skin tone, light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fd), # kiss: person, person, medium-light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fe), # kiss: person, person, medium-light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3ff), # kiss: person, person, medium-light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fb), # kiss: person, person, medium skin tone, light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fc), # kiss: person, person, medium skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fe), # kiss: person, person, medium skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3ff), # kiss: person, person, medium skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fb), # kiss: person, person, medium-dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fc), # kiss: person, person, medium-dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fd), # kiss: person, person, medium-dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3ff), # kiss: person, person, medium-dark skin tone, dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fb), # kiss: person, person, dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fc), # kiss: person, person, dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fd), # kiss: person, person, dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fe), # kiss: person, person, dark skin tone, medium-dark skin tone 
    },
    '15.0': {
        # Source: ./data/emoji-zwj-sequences-15.0.txt
        # Date: 2022-05-06, 16:14:52 GMT
        #
        # sequences of length 3,
            (0x1f468, 0x0200d, 0x1f466), # family: man, boy 
            (0x1f468, 0x0200d, 0x1f467), # family: man, girl 
            (0x1f469, 0x0200d, 0x1f466), # family: woman, boy 
            (0x1f469, 0x0200d, 0x1f467), # family: woman, girl 
            (0x1f468, 0x0200d, 0x1f33e), # man farmer 
            (0x1f468, 0x0200d, 0x1f373), # man cook 
            (0x1f468, 0x0200d, 0x1f37c), # man feeding baby 
            (0x1f468, 0x0200d, 0x1f393), # man student 
            (0x1f468, 0x0200d, 0x1f3a4), # man singer 
            (0x1f468, 0x0200d, 0x1f3a8), # man artist 
            (0x1f468, 0x0200d, 0x1f3eb), # man teacher 
            (0x1f468, 0x0200d, 0x1f3ed), # man factory worker 
            (0x1f468, 0x0200d, 0x1f4bb), # man technologist 
            (0x1f468, 0x0200d, 0x1f4bc), # man office worker 
            (0x1f468, 0x0200d, 0x1f527), # man mechanic 
            (0x1f468, 0x0200d, 0x1f52c), # man scientist 
            (0x1f468, 0x0200d, 0x1f680), # man astronaut 
            (0x1f468, 0x0200d, 0x1f692), # man firefighter 
            (0x1f468, 0x0200d, 0x1f9af), # man with white cane 
            (0x1f468, 0x0200d, 0x1f9bc), # man in motorized wheelchair 
            (0x1f468, 0x0200d, 0x1f9bd), # man in manual wheelchair 
            (0x1f469, 0x0200d, 0x1f33e), # woman farmer 
            (0x1f469, 0x0200d, 0x1f373), # woman cook 
            (0x1f469, 0x0200d, 0x1f37c), # woman feeding baby 
            (0x1f469, 0x0200d, 0x1f393), # woman student 
            (0x1f469, 0x0200d, 0x1f3a4), # woman singer 
            (0x1f469, 0x0200d, 0x1f3a8), # woman artist 
            (0x1f469, 0x0200d, 0x1f3eb), # woman teacher 
            (0x1f469, 0x0200d, 0x1f3ed), # woman factory worker 
            (0x1f469, 0x0200d, 0x1f4bb), # woman technologist 
            (0x1f469, 0x0200d, 0x1f4bc), # woman office worker 
            (0x1f469, 0x0200d, 0x1f527), # woman mechanic 
            (0x1f469, 0x0200d, 0x1f52c), # woman scientist 
            (0x1f469, 0x0200d, 0x1f680), # woman astronaut 
            (0x1f469, 0x0200d, 0x1f692), # woman firefighter 
            (0x1f469, 0x0200d, 0x1f9af), # woman with white cane 
            (0x1f469, 0x0200d, 0x1f9bc), # woman in motorized wheelchair 
            (0x1f469, 0x0200d, 0x1f9bd), # woman in manual wheelchair 
            (0x1f9d1, 0x0200d, 0x1f33e), # farmer 
            (0x1f9d1, 0x0200d, 0x1f373), # cook 
            (0x1f9d1, 0x0200d, 0x1f37c), # person feeding baby 
            (0x1f9d1, 0x0200d, 0x1f393), # student 
            (0x1f9d1, 0x0200d, 0x1f3a4), # singer 
            (0x1f9d1, 0x0200d, 0x1f3a8), # artist 
            (0x1f9d1, 0x0200d, 0x1f3eb), # teacher 
            (0x1f9d1, 0x0200d, 0x1f3ed), # factory worker 
            (0x1f9d1, 0x0200d, 0x1f4bb), # technologist 
            (0x1f9d1, 0x0200d, 0x1f4bc), # office worker 
            (0x1f9d1, 0x0200d, 0x1f527), # mechanic 
            (0x1f9d1, 0x0200d, 0x1f52c), # scientist 
            (0x1f9d1, 0x0200d, 0x1f680), # astronaut 
            (0x1f9d1, 0x0200d, 0x1f692), # firefighter 
            (0x1f9d1, 0x0200d, 0x1f9af), # person with white cane 
            (0x1f9d1, 0x0200d, 0x1f9bc), # person in motorized wheelchair 
            (0x1f9d1, 0x0200d, 0x1f9bd), # person in manual wheelchair 
            (0x1f468, 0x0200d, 0x1f9b0), # man: red hair 
            (0x1f468, 0x0200d, 0x1f9b1), # man: curly hair 
            (0x1f468, 0x0200d, 0x1f9b2), # man: bald 
            (0x1f468, 0x0200d, 0x1f9b3), # man: white hair 
            (0x1f469, 0x0200d, 0x1f9b0), # woman: red hair 
            (0x1f469, 0x0200d, 0x1f9b1), # woman: curly hair 
            (0x1f469, 0x0200d, 0x1f9b2), # woman: bald 
            (0x1f469, 0x0200d, 0x1f9b3), # woman: white hair 
            (0x1f9d1, 0x0200d, 0x1f9b0), # person: red hair 
            (0x1f9d1, 0x0200d, 0x1f9b1), # person: curly hair 
            (0x1f9d1, 0x0200d, 0x1f9b2), # person: bald 
            (0x1f9d1, 0x0200d, 0x1f9b3), # person: white hair 
            (0x1f408, 0x0200d, 0x02b1b), # black cat 
            (0x1f415, 0x0200d, 0x1f9ba), # service dog 
            (0x1f426, 0x0200d, 0x02b1b), # black bird 
            (0x1f62e, 0x0200d, 0x1f4a8), # face exhaling 
            (0x1f635, 0x0200d, 0x1f4ab), # face with spiral eyes 
            (0x1f9d1, 0x0200d, 0x1f384), # mx claus 
        # sequences of length 4,
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f384), # mx claus: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f384), # mx claus: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f384), # mx claus: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f384), # mx claus: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f384), # mx claus: dark skin tone 
            (0x1f468, 0x0200d, 0x02695, 0x0fe0f), # man health worker 
            (0x1f468, 0x0200d, 0x02696, 0x0fe0f), # man judge 
            (0x1f468, 0x0200d, 0x02708, 0x0fe0f), # man pilot 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f33e), # man farmer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f373), # man cook: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f37c), # man feeding baby: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f393), # man student: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a4), # man singer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a8), # man artist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3eb), # man teacher: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3ed), # man factory worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bb), # man technologist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bc), # man office worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f527), # man mechanic: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f52c), # man scientist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f680), # man astronaut: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f692), # man firefighter: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9af), # man with white cane: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9bc), # man in motorized wheelchair: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9bd), # man in manual wheelchair: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f33e), # man farmer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f373), # man cook: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f37c), # man feeding baby: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f393), # man student: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a4), # man singer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a8), # man artist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3eb), # man teacher: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3ed), # man factory worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bb), # man technologist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bc), # man office worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f527), # man mechanic: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f52c), # man scientist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f680), # man astronaut: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f692), # man firefighter: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9af), # man with white cane: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f33e), # man farmer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f373), # man cook: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f37c), # man feeding baby: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f393), # man student: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a4), # man singer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a8), # man artist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3eb), # man teacher: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3ed), # man factory worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bb), # man technologist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bc), # man office worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f527), # man mechanic: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f52c), # man scientist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f680), # man astronaut: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f692), # man firefighter: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9af), # man with white cane: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f33e), # man farmer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f373), # man cook: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f37c), # man feeding baby: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f393), # man student: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a4), # man singer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a8), # man artist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3eb), # man teacher: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3ed), # man factory worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bb), # man technologist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bc), # man office worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f527), # man mechanic: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f52c), # man scientist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f680), # man astronaut: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f692), # man firefighter: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9af), # man with white cane: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f33e), # man farmer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f373), # man cook: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f37c), # man feeding baby: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f393), # man student: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a4), # man singer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a8), # man artist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3eb), # man teacher: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3ed), # man factory worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bb), # man technologist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bc), # man office worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f527), # man mechanic: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f52c), # man scientist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f680), # man astronaut: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f692), # man firefighter: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9af), # man with white cane: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9bc), # man in motorized wheelchair: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9bd), # man in manual wheelchair: dark skin tone 
            (0x1f469, 0x0200d, 0x02695, 0x0fe0f), # woman health worker 
            (0x1f469, 0x0200d, 0x02696, 0x0fe0f), # woman judge 
            (0x1f469, 0x0200d, 0x02708, 0x0fe0f), # woman pilot 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f33e), # woman farmer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f373), # woman cook: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f37c), # woman feeding baby: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f393), # woman student: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a4), # woman singer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a8), # woman artist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3eb), # woman teacher: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3ed), # woman factory worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bb), # woman technologist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bc), # woman office worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f527), # woman mechanic: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f52c), # woman scientist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f680), # woman astronaut: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f692), # woman firefighter: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9af), # woman with white cane: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9bd), # woman in manual wheelchair: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f33e), # woman farmer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f373), # woman cook: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f37c), # woman feeding baby: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f393), # woman student: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a4), # woman singer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a8), # woman artist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3eb), # woman teacher: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3ed), # woman factory worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bb), # woman technologist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bc), # woman office worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f527), # woman mechanic: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f52c), # woman scientist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f680), # woman astronaut: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f692), # woman firefighter: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9af), # woman with white cane: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f33e), # woman farmer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f373), # woman cook: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f37c), # woman feeding baby: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f393), # woman student: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a4), # woman singer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a8), # woman artist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3eb), # woman teacher: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3ed), # woman factory worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bb), # woman technologist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bc), # woman office worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f527), # woman mechanic: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f52c), # woman scientist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f680), # woman astronaut: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f692), # woman firefighter: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9af), # woman with white cane: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f33e), # woman farmer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f373), # woman cook: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f37c), # woman feeding baby: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f393), # woman student: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a4), # woman singer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a8), # woman artist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3eb), # woman teacher: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3ed), # woman factory worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bb), # woman technologist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bc), # woman office worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f527), # woman mechanic: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f52c), # woman scientist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f680), # woman astronaut: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f692), # woman firefighter: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9af), # woman with white cane: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f33e), # woman farmer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f373), # woman cook: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f37c), # woman feeding baby: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f393), # woman student: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a4), # woman singer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a8), # woman artist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3eb), # woman teacher: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3ed), # woman factory worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bb), # woman technologist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bc), # woman office worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f527), # woman mechanic: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f52c), # woman scientist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f680), # woman astronaut: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f692), # woman firefighter: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9af), # woman with white cane: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9bd), # woman in manual wheelchair: dark skin tone 
            (0x1f9d1, 0x0200d, 0x02695, 0x0fe0f), # health worker 
            (0x1f9d1, 0x0200d, 0x02696, 0x0fe0f), # judge 
            (0x1f9d1, 0x0200d, 0x02708, 0x0fe0f), # pilot 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f33e), # farmer: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f373), # cook: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f37c), # person feeding baby: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f393), # student: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3a4), # singer: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3a8), # artist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3eb), # teacher: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3ed), # factory worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f4bb), # technologist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f4bc), # office worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f527), # mechanic: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f52c), # scientist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f680), # astronaut: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f692), # firefighter: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9af), # person with white cane: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9bc), # person in motorized wheelchair: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9bd), # person in manual wheelchair: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f33e), # farmer: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f373), # cook: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f37c), # person feeding baby: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f393), # student: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3a4), # singer: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3a8), # artist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3eb), # teacher: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3ed), # factory worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f4bb), # technologist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f4bc), # office worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f527), # mechanic: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f52c), # scientist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f680), # astronaut: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f692), # firefighter: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9af), # person with white cane: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f33e), # farmer: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f373), # cook: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f37c), # person feeding baby: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f393), # student: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3a4), # singer: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3a8), # artist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3eb), # teacher: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3ed), # factory worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f4bb), # technologist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f4bc), # office worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f527), # mechanic: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f52c), # scientist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f680), # astronaut: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f692), # firefighter: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9af), # person with white cane: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f33e), # farmer: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f373), # cook: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f37c), # person feeding baby: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f393), # student: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3a4), # singer: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3a8), # artist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3eb), # teacher: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3ed), # factory worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f4bb), # technologist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f4bc), # office worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f527), # mechanic: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f52c), # scientist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f680), # astronaut: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f692), # firefighter: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9af), # person with white cane: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f33e), # farmer: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f373), # cook: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f37c), # person feeding baby: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f393), # student: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3a4), # singer: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3a8), # artist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3eb), # teacher: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3ed), # factory worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f4bb), # technologist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f4bc), # office worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f527), # mechanic: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f52c), # scientist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f680), # astronaut: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f692), # firefighter: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9af), # person with white cane: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9bc), # person in motorized wheelchair: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9bd), # person in manual wheelchair: dark skin tone 
            (0x1f3c3, 0x0200d, 0x02640, 0x0fe0f), # woman running 
            (0x1f3c3, 0x0200d, 0x02642, 0x0fe0f), # man running 
            (0x1f3c4, 0x0200d, 0x02640, 0x0fe0f), # woman surfing 
            (0x1f3c4, 0x0200d, 0x02642, 0x0fe0f), # man surfing 
            (0x1f3ca, 0x0200d, 0x02640, 0x0fe0f), # woman swimming 
            (0x1f3ca, 0x0200d, 0x02642, 0x0fe0f), # man swimming 
            (0x1f46e, 0x0200d, 0x02640, 0x0fe0f), # woman police officer 
            (0x1f46e, 0x0200d, 0x02642, 0x0fe0f), # man police officer 
            (0x1f46f, 0x0200d, 0x02640, 0x0fe0f), # women with bunny ears 
            (0x1f46f, 0x0200d, 0x02642, 0x0fe0f), # men with bunny ears 
            (0x1f470, 0x0200d, 0x02640, 0x0fe0f), # woman with veil 
            (0x1f470, 0x0200d, 0x02642, 0x0fe0f), # man with veil 
            (0x1f471, 0x0200d, 0x02640, 0x0fe0f), # woman: blond hair 
            (0x1f471, 0x0200d, 0x02642, 0x0fe0f), # man: blond hair 
            (0x1f473, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban 
            (0x1f473, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban 
            (0x1f477, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker 
            (0x1f477, 0x0200d, 0x02642, 0x0fe0f), # man construction worker 
            (0x1f481, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand 
            (0x1f481, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand 
            (0x1f482, 0x0200d, 0x02640, 0x0fe0f), # woman guard 
            (0x1f482, 0x0200d, 0x02642, 0x0fe0f), # man guard 
            (0x1f486, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage 
            (0x1f486, 0x0200d, 0x02642, 0x0fe0f), # man getting massage 
            (0x1f487, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut 
            (0x1f487, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut 
            (0x1f645, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO 
            (0x1f645, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO 
            (0x1f646, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK 
            (0x1f646, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK 
            (0x1f647, 0x0200d, 0x02640, 0x0fe0f), # woman bowing 
            (0x1f647, 0x0200d, 0x02642, 0x0fe0f), # man bowing 
            (0x1f64b, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand 
            (0x1f64b, 0x0200d, 0x02642, 0x0fe0f), # man raising hand 
            (0x1f64d, 0x0200d, 0x02640, 0x0fe0f), # woman frowning 
            (0x1f64d, 0x0200d, 0x02642, 0x0fe0f), # man frowning 
            (0x1f64e, 0x0200d, 0x02640, 0x0fe0f), # woman pouting 
            (0x1f64e, 0x0200d, 0x02642, 0x0fe0f), # man pouting 
            (0x1f6a3, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat 
            (0x1f6a3, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat 
            (0x1f6b4, 0x0200d, 0x02640, 0x0fe0f), # woman biking 
            (0x1f6b4, 0x0200d, 0x02642, 0x0fe0f), # man biking 
            (0x1f6b5, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking 
            (0x1f6b5, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking 
            (0x1f6b6, 0x0200d, 0x02640, 0x0fe0f), # woman walking 
            (0x1f6b6, 0x0200d, 0x02642, 0x0fe0f), # man walking 
            (0x1f926, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming 
            (0x1f926, 0x0200d, 0x02642, 0x0fe0f), # man facepalming 
            (0x1f935, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo 
            (0x1f935, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo 
            (0x1f937, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging 
            (0x1f937, 0x0200d, 0x02642, 0x0fe0f), # man shrugging 
            (0x1f938, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling 
            (0x1f938, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling 
            (0x1f939, 0x0200d, 0x02640, 0x0fe0f), # woman juggling 
            (0x1f939, 0x0200d, 0x02642, 0x0fe0f), # man juggling 
            (0x1f93c, 0x0200d, 0x02640, 0x0fe0f), # women wrestling 
            (0x1f93c, 0x0200d, 0x02642, 0x0fe0f), # men wrestling 
            (0x1f93d, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo 
            (0x1f93d, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo 
            (0x1f93e, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball 
            (0x1f93e, 0x0200d, 0x02642, 0x0fe0f), # man playing handball 
            (0x1f9b8, 0x0200d, 0x02640, 0x0fe0f), # woman superhero 
            (0x1f9b8, 0x0200d, 0x02642, 0x0fe0f), # man superhero 
            (0x1f9b9, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain 
            (0x1f9b9, 0x0200d, 0x02642, 0x0fe0f), # man supervillain 
            (0x1f9cd, 0x0200d, 0x02640, 0x0fe0f), # woman standing 
            (0x1f9cd, 0x0200d, 0x02642, 0x0fe0f), # man standing 
            (0x1f9ce, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling 
            (0x1f9ce, 0x0200d, 0x02642, 0x0fe0f), # man kneeling 
            (0x1f9cf, 0x0200d, 0x02640, 0x0fe0f), # deaf woman 
            (0x1f9cf, 0x0200d, 0x02642, 0x0fe0f), # deaf man 
            (0x1f9d4, 0x0200d, 0x02640, 0x0fe0f), # woman: beard 
            (0x1f9d4, 0x0200d, 0x02642, 0x0fe0f), # man: beard 
            (0x1f9d6, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room 
            (0x1f9d6, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room 
            (0x1f9d7, 0x0200d, 0x02640, 0x0fe0f), # woman climbing 
            (0x1f9d7, 0x0200d, 0x02642, 0x0fe0f), # man climbing 
            (0x1f9d8, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position 
            (0x1f9d8, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position 
            (0x1f9d9, 0x0200d, 0x02640, 0x0fe0f), # woman mage 
            (0x1f9d9, 0x0200d, 0x02642, 0x0fe0f), # man mage 
            (0x1f9da, 0x0200d, 0x02640, 0x0fe0f), # woman fairy 
            (0x1f9da, 0x0200d, 0x02642, 0x0fe0f), # man fairy 
            (0x1f9db, 0x0200d, 0x02640, 0x0fe0f), # woman vampire 
            (0x1f9db, 0x0200d, 0x02642, 0x0fe0f), # man vampire 
            (0x1f9dc, 0x0200d, 0x02640, 0x0fe0f), # mermaid 
            (0x1f9dc, 0x0200d, 0x02642, 0x0fe0f), # merman 
            (0x1f9dd, 0x0200d, 0x02640, 0x0fe0f), # woman elf 
            (0x1f9dd, 0x0200d, 0x02642, 0x0fe0f), # man elf 
            (0x1f9de, 0x0200d, 0x02640, 0x0fe0f), # woman genie 
            (0x1f9de, 0x0200d, 0x02642, 0x0fe0f), # man genie 
            (0x1f9df, 0x0200d, 0x02640, 0x0fe0f), # woman zombie 
            (0x1f9df, 0x0200d, 0x02642, 0x0fe0f), # man zombie 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b0), # man: light skin tone, red hair 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b1), # man: light skin tone, curly hair 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b2), # man: light skin tone, bald 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b3), # man: light skin tone, white hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b0), # man: medium-light skin tone, red hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b1), # man: medium-light skin tone, curly hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b2), # man: medium-light skin tone, bald 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b3), # man: medium-light skin tone, white hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b0), # man: medium skin tone, red hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b1), # man: medium skin tone, curly hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b2), # man: medium skin tone, bald 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b3), # man: medium skin tone, white hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b0), # man: medium-dark skin tone, red hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b1), # man: medium-dark skin tone, curly hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b2), # man: medium-dark skin tone, bald 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b3), # man: medium-dark skin tone, white hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b0), # man: dark skin tone, red hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b1), # man: dark skin tone, curly hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b2), # man: dark skin tone, bald 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b3), # man: dark skin tone, white hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b0), # woman: light skin tone, red hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b1), # woman: light skin tone, curly hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b2), # woman: light skin tone, bald 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b3), # woman: light skin tone, white hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b0), # woman: medium-light skin tone, red hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b1), # woman: medium-light skin tone, curly hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b2), # woman: medium-light skin tone, bald 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b3), # woman: medium-light skin tone, white hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b0), # woman: medium skin tone, red hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b1), # woman: medium skin tone, curly hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b2), # woman: medium skin tone, bald 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b3), # woman: medium skin tone, white hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b0), # woman: medium-dark skin tone, red hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b1), # woman: medium-dark skin tone, curly hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b2), # woman: medium-dark skin tone, bald 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b3), # woman: medium-dark skin tone, white hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b0), # woman: dark skin tone, red hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b1), # woman: dark skin tone, curly hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b2), # woman: dark skin tone, bald 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b3), # woman: dark skin tone, white hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b0), # person: light skin tone, red hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b1), # person: light skin tone, curly hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b2), # person: light skin tone, bald 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b3), # person: light skin tone, white hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b0), # person: medium-light skin tone, red hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b1), # person: medium-light skin tone, curly hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b2), # person: medium-light skin tone, bald 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b3), # person: medium-light skin tone, white hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b0), # person: medium skin tone, red hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b1), # person: medium skin tone, curly hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b2), # person: medium skin tone, bald 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b3), # person: medium skin tone, white hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b0), # person: medium-dark skin tone, red hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b1), # person: medium-dark skin tone, curly hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b2), # person: medium-dark skin tone, bald 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b3), # person: medium-dark skin tone, white hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b0), # person: dark skin tone, red hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b1), # person: dark skin tone, curly hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b2), # person: dark skin tone, bald 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b3), # person: dark skin tone, white hair 
            (0x02764, 0x0fe0f, 0x0200d, 0x1f525), # heart on fire 
            (0x02764, 0x0fe0f, 0x0200d, 0x1fa79), # mending heart 
            (0x1f3f3, 0x0fe0f, 0x0200d, 0x1f308), # rainbow flag 
            (0x1f3f4, 0x0200d, 0x02620, 0x0fe0f), # pirate flag 
            (0x1f43b, 0x0200d, 0x02744, 0x0fe0f), # polar bear 
            (0x1f636, 0x0200d, 0x1f32b, 0x0fe0f), # face in clouds 
        # sequences of length 5,
            (0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, boy, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, girl, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, girl, girl 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466), # family: man, man, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467), # family: man, man, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: man, woman, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: man, woman, girl 
            (0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, girl, girl 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: woman, woman, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: woman, woman, girl 
            (0x1f9d1, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1), # people holding hands 
            (0x1faf1, 0x1f3fb, 0x0200d, 0x1faf2, 0x1f3fc), # handshake: light skin tone, medium-light skin tone 
            (0x1faf1, 0x1f3fb, 0x0200d, 0x1faf2, 0x1f3fd), # handshake: light skin tone, medium skin tone 
            (0x1faf1, 0x1f3fb, 0x0200d, 0x1faf2, 0x1f3fe), # handshake: light skin tone, medium-dark skin tone 
            (0x1faf1, 0x1f3fb, 0x0200d, 0x1faf2, 0x1f3ff), # handshake: light skin tone, dark skin tone 
            (0x1faf1, 0x1f3fc, 0x0200d, 0x1faf2, 0x1f3fb), # handshake: medium-light skin tone, light skin tone 
            (0x1faf1, 0x1f3fc, 0x0200d, 0x1faf2, 0x1f3fd), # handshake: medium-light skin tone, medium skin tone 
            (0x1faf1, 0x1f3fc, 0x0200d, 0x1faf2, 0x1f3fe), # handshake: medium-light skin tone, medium-dark skin tone 
            (0x1faf1, 0x1f3fc, 0x0200d, 0x1faf2, 0x1f3ff), # handshake: medium-light skin tone, dark skin tone 
            (0x1faf1, 0x1f3fd, 0x0200d, 0x1faf2, 0x1f3fb), # handshake: medium skin tone, light skin tone 
            (0x1faf1, 0x1f3fd, 0x0200d, 0x1faf2, 0x1f3fc), # handshake: medium skin tone, medium-light skin tone 
            (0x1faf1, 0x1f3fd, 0x0200d, 0x1faf2, 0x1f3fe), # handshake: medium skin tone, medium-dark skin tone 
            (0x1faf1, 0x1f3fd, 0x0200d, 0x1faf2, 0x1f3ff), # handshake: medium skin tone, dark skin tone 
            (0x1faf1, 0x1f3fe, 0x0200d, 0x1faf2, 0x1f3fb), # handshake: medium-dark skin tone, light skin tone 
            (0x1faf1, 0x1f3fe, 0x0200d, 0x1faf2, 0x1f3fc), # handshake: medium-dark skin tone, medium-light skin tone 
            (0x1faf1, 0x1f3fe, 0x0200d, 0x1faf2, 0x1f3fd), # handshake: medium-dark skin tone, medium skin tone 
            (0x1faf1, 0x1f3fe, 0x0200d, 0x1faf2, 0x1f3ff), # handshake: medium-dark skin tone, dark skin tone 
            (0x1faf1, 0x1f3ff, 0x0200d, 0x1faf2, 0x1f3fb), # handshake: dark skin tone, light skin tone 
            (0x1faf1, 0x1f3ff, 0x0200d, 0x1faf2, 0x1f3fc), # handshake: dark skin tone, medium-light skin tone 
            (0x1faf1, 0x1f3ff, 0x0200d, 0x1faf2, 0x1f3fd), # handshake: dark skin tone, medium skin tone 
            (0x1faf1, 0x1f3ff, 0x0200d, 0x1faf2, 0x1f3fe), # handshake: dark skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # man health worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # man judge: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # man pilot: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # man health worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # man judge: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # man pilot: dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # woman judge: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # woman judge: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # health worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # judge: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # pilot: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # judge: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # judge: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # judge: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # health worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # judge: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # pilot: dark skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: light skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: dark skin tone 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman running: light skin tone 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man running: light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-light skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man running: medium skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-dark skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman running: dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man running: dark skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: light skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man surfing: light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man surfing: dark skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: light skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man swimming: light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man swimming: dark skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: dark skin tone 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: light skin tone 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man golfing: light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man golfing: dark skin tone 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman golfing 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man golfing 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: light skin tone 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man police officer: light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man police officer: dark skin tone 
            (0x1f470, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: light skin tone 
            (0x1f470, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man with veil: light skin tone 
            (0x1f470, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: medium-light skin tone 
            (0x1f470, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man with veil: medium-light skin tone 
            (0x1f470, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: medium skin tone 
            (0x1f470, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man with veil: medium skin tone 
            (0x1f470, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: medium-dark skin tone 
            (0x1f470, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man with veil: medium-dark skin tone 
            (0x1f470, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: dark skin tone 
            (0x1f470, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man with veil: dark skin tone 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman: light skin tone, blond hair 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man: light skin tone, blond hair 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-light skin tone, blond hair 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man: medium-light skin tone, blond hair 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman: medium skin tone, blond hair 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man: medium skin tone, blond hair 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-dark skin tone, blond hair 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man: medium-dark skin tone, blond hair 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman: dark skin tone, blond hair 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man: dark skin tone, blond hair 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: light skin tone 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: dark skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: light skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: dark skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: light skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: dark skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman guard: light skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man guard: light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-light skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-dark skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman guard: dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man guard: dark skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: light skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: dark skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: light skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: dark skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman detective: light skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man detective: light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-light skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-dark skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman detective: dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man detective: dark skin tone 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman detective 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man detective 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: light skin tone 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: dark skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: light skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: dark skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: light skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bowing: light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-light skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-dark skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bowing: dark skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: light skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: dark skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: light skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man frowning: light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man frowning: dark skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: light skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man pouting: light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man pouting: dark skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: dark skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman biking: light skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man biking: light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman biking: dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man biking: dark skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: dark skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman walking: light skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man walking: light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman walking: dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man walking: dark skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: light skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: dark skin tone 
            (0x1f935, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: light skin tone 
            (0x1f935, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: light skin tone 
            (0x1f935, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: medium-light skin tone 
            (0x1f935, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: medium-light skin tone 
            (0x1f935, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: medium skin tone 
            (0x1f935, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: medium skin tone 
            (0x1f935, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: medium-dark skin tone 
            (0x1f935, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: medium-dark skin tone 
            (0x1f935, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: dark skin tone 
            (0x1f935, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: dark skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: light skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: dark skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: light skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: dark skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: light skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man juggling: light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-light skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-dark skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man juggling: dark skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: light skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: dark skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: light skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: dark skin tone 
            (0x1f9b8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: light skin tone 
            (0x1f9b8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man superhero: light skin tone 
            (0x1f9b8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium-light skin tone 
            (0x1f9b8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium-light skin tone 
            (0x1f9b8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium skin tone 
            (0x1f9b8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium skin tone 
            (0x1f9b8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium-dark skin tone 
            (0x1f9b8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium-dark skin tone 
            (0x1f9b8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: dark skin tone 
            (0x1f9b8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man superhero: dark skin tone 
            (0x1f9b9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: light skin tone 
            (0x1f9b9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: light skin tone 
            (0x1f9b9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium-light skin tone 
            (0x1f9b9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium-light skin tone 
            (0x1f9b9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium skin tone 
            (0x1f9b9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium skin tone 
            (0x1f9b9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium-dark skin tone 
            (0x1f9b9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium-dark skin tone 
            (0x1f9b9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: dark skin tone 
            (0x1f9b9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: dark skin tone 
            (0x1f9cd, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman standing: light skin tone 
            (0x1f9cd, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man standing: light skin tone 
            (0x1f9cd, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium-light skin tone 
            (0x1f9cd, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium-light skin tone 
            (0x1f9cd, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium skin tone 
            (0x1f9cd, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium skin tone 
            (0x1f9cd, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium-dark skin tone 
            (0x1f9cd, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium-dark skin tone 
            (0x1f9cd, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman standing: dark skin tone 
            (0x1f9cd, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man standing: dark skin tone 
            (0x1f9ce, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: light skin tone 
            (0x1f9ce, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: light skin tone 
            (0x1f9ce, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium-light skin tone 
            (0x1f9ce, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium-light skin tone 
            (0x1f9ce, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium skin tone 
            (0x1f9ce, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium skin tone 
            (0x1f9ce, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium-dark skin tone 
            (0x1f9ce, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium-dark skin tone 
            (0x1f9ce, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: dark skin tone 
            (0x1f9ce, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: dark skin tone 
            (0x1f9cf, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: light skin tone 
            (0x1f9cf, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # deaf man: light skin tone 
            (0x1f9cf, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium-light skin tone 
            (0x1f9cf, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium-light skin tone 
            (0x1f9cf, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium skin tone 
            (0x1f9cf, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium skin tone 
            (0x1f9cf, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium-dark skin tone 
            (0x1f9cf, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium-dark skin tone 
            (0x1f9cf, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: dark skin tone 
            (0x1f9cf, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # deaf man: dark skin tone 
            (0x1f9d4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman: light skin tone, beard 
            (0x1f9d4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man: light skin tone, beard 
            (0x1f9d4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-light skin tone, beard 
            (0x1f9d4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man: medium-light skin tone, beard 
            (0x1f9d4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman: medium skin tone, beard 
            (0x1f9d4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man: medium skin tone, beard 
            (0x1f9d4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-dark skin tone, beard 
            (0x1f9d4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man: medium-dark skin tone, beard 
            (0x1f9d4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman: dark skin tone, beard 
            (0x1f9d4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man: dark skin tone, beard 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: dark skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: light skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man climbing: light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man climbing: dark skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: dark skin tone 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mage: light skin tone 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mage: light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mage: dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mage: dark skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: light skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man fairy: light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man fairy: dark skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: light skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man vampire: light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man vampire: dark skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # mermaid: light skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # merman: light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-light skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # merman: medium skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-dark skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # mermaid: dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # merman: dark skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman elf: light skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man elf: light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman elf: dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man elf: dark skin tone 
            (0x1f3f3, 0x0fe0f, 0x0200d, 0x026a7, 0x0fe0f), # transgender flag 
            (0x1f441, 0x0fe0f, 0x0200d, 0x1f5e8, 0x0fe0f), # eye in speech bubble 
        # sequences of length 6,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: man, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469), # couple with heart: woman, woman 
        # sequences of length 7,
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, man, boy, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, man, girl, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, man, girl, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, woman, boy, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, woman, girl, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, woman, girl, girl 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: light skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: light skin tone, medium skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: light skin tone, dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium-light skin tone, light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: medium-light skin tone, medium skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium-light skin tone, dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium skin tone, light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: medium skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: medium skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium skin tone, dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium-dark skin tone, light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: medium-dark skin tone, medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium-dark skin tone, dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: dark skin tone, light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: dark skin tone, medium skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: dark skin tone, medium-dark skin tone 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, woman, girl, girl 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: light skin tone, dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: dark skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: light skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium-light skin tone, light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium-light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: medium-light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium skin tone, light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: medium skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: medium skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: medium-dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: medium-dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: medium-dark skin tone, dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: dark skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3ff), # people holding hands: dark skin tone 
        # sequences of length 8,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: man, man 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: man, man, light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: man, man, light skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: man, man, light skin tone, medium skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: man, man, light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: man, man, light skin tone, dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: man, man, medium-light skin tone, light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: man, man, medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: man, man, medium-light skin tone, medium skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: man, man, medium-light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: man, man, medium-light skin tone, dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: man, man, medium skin tone, light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: man, man, medium skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: man, man, medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: man, man, medium skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: man, man, medium skin tone, dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: man, man, medium-dark skin tone, light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: man, man, medium-dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: man, man, medium-dark skin tone, medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: man, man, medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: man, man, medium-dark skin tone, dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: man, man, dark skin tone, light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: man, man, dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: man, man, dark skin tone, medium skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: man, man, dark skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: man, man, dark skin tone 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468), # kiss: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469), # kiss: woman, woman 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: woman, man, light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: woman, man, light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: woman, man, light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: woman, man, light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: woman, man, light skin tone, dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fb), # couple with heart: woman, woman, light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fc), # couple with heart: woman, woman, light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fd), # couple with heart: woman, woman, light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fe), # couple with heart: woman, woman, light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3ff), # couple with heart: woman, woman, light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: woman, man, medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: woman, man, medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: woman, man, medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: woman, man, medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: woman, man, medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fb), # couple with heart: woman, woman, medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fc), # couple with heart: woman, woman, medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fd), # couple with heart: woman, woman, medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fe), # couple with heart: woman, woman, medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3ff), # couple with heart: woman, woman, medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: woman, man, medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: woman, man, medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: woman, man, medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: woman, man, medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: woman, man, medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fb), # couple with heart: woman, woman, medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fc), # couple with heart: woman, woman, medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fd), # couple with heart: woman, woman, medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fe), # couple with heart: woman, woman, medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3ff), # couple with heart: woman, woman, medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: woman, man, medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: woman, man, medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: woman, man, medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: woman, man, medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: woman, man, medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fb), # couple with heart: woman, woman, medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fc), # couple with heart: woman, woman, medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fd), # couple with heart: woman, woman, medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fe), # couple with heart: woman, woman, medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3ff), # couple with heart: woman, woman, medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fb), # couple with heart: woman, man, dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fc), # couple with heart: woman, man, dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fd), # couple with heart: woman, man, dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3fe), # couple with heart: woman, man, dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468, 0x1f3ff), # couple with heart: woman, man, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fb), # couple with heart: woman, woman, dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fc), # couple with heart: woman, woman, dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fd), # couple with heart: woman, woman, dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3fe), # couple with heart: woman, woman, dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469, 0x1f3ff), # couple with heart: woman, woman, dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fc), # couple with heart: person, person, light skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fd), # couple with heart: person, person, light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fe), # couple with heart: person, person, light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3ff), # couple with heart: person, person, light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fb), # couple with heart: person, person, medium-light skin tone, light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fd), # couple with heart: person, person, medium-light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fe), # couple with heart: person, person, medium-light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3ff), # couple with heart: person, person, medium-light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fb), # couple with heart: person, person, medium skin tone, light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fc), # couple with heart: person, person, medium skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fe), # couple with heart: person, person, medium skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3ff), # couple with heart: person, person, medium skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fb), # couple with heart: person, person, medium-dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fc), # couple with heart: person, person, medium-dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fd), # couple with heart: person, person, medium-dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3ff), # couple with heart: person, person, medium-dark skin tone, dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fb), # couple with heart: person, person, dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fc), # couple with heart: person, person, dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fd), # couple with heart: person, person, dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f9d1, 0x1f3fe), # couple with heart: person, person, dark skin tone, medium-dark skin tone 
        # sequences of length 10,
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: man, man, light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: man, man, light skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: man, man, light skin tone, medium skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: man, man, light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: man, man, light skin tone, dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: man, man, medium-light skin tone, light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: man, man, medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: man, man, medium-light skin tone, medium skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: man, man, medium-light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: man, man, medium-light skin tone, dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: man, man, medium skin tone, light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: man, man, medium skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: man, man, medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: man, man, medium skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: man, man, medium skin tone, dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: man, man, medium-dark skin tone, light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: man, man, medium-dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: man, man, medium-dark skin tone, medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: man, man, medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: man, man, medium-dark skin tone, dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: man, man, dark skin tone, light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: man, man, dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: man, man, dark skin tone, medium skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: man, man, dark skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: man, man, dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: woman, man, light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: woman, man, light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: woman, man, light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: woman, man, light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: woman, man, light skin tone, dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fb), # kiss: woman, woman, light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fc), # kiss: woman, woman, light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fd), # kiss: woman, woman, light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fe), # kiss: woman, woman, light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3ff), # kiss: woman, woman, light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: woman, man, medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: woman, man, medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: woman, man, medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: woman, man, medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: woman, man, medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fb), # kiss: woman, woman, medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fc), # kiss: woman, woman, medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fd), # kiss: woman, woman, medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fe), # kiss: woman, woman, medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3ff), # kiss: woman, woman, medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: woman, man, medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: woman, man, medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: woman, man, medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: woman, man, medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: woman, man, medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fb), # kiss: woman, woman, medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fc), # kiss: woman, woman, medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fd), # kiss: woman, woman, medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fe), # kiss: woman, woman, medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3ff), # kiss: woman, woman, medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: woman, man, medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: woman, man, medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: woman, man, medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: woman, man, medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: woman, man, medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fb), # kiss: woman, woman, medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fc), # kiss: woman, woman, medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fd), # kiss: woman, woman, medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fe), # kiss: woman, woman, medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3ff), # kiss: woman, woman, medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fb), # kiss: woman, man, dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fc), # kiss: woman, man, dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fd), # kiss: woman, man, dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3fe), # kiss: woman, man, dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f468, 0x1f3ff), # kiss: woman, man, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fb), # kiss: woman, woman, dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fc), # kiss: woman, woman, dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fd), # kiss: woman, woman, dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3fe), # kiss: woman, woman, dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f469, 0x1f3ff), # kiss: woman, woman, dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fc), # kiss: person, person, light skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fd), # kiss: person, person, light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fe), # kiss: person, person, light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3ff), # kiss: person, person, light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fb), # kiss: person, person, medium-light skin tone, light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fd), # kiss: person, person, medium-light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fe), # kiss: person, person, medium-light skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3ff), # kiss: person, person, medium-light skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fb), # kiss: person, person, medium skin tone, light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fc), # kiss: person, person, medium skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fe), # kiss: person, person, medium skin tone, medium-dark skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3ff), # kiss: person, person, medium skin tone, dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fb), # kiss: person, person, medium-dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fc), # kiss: person, person, medium-dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fd), # kiss: person, person, medium-dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3ff), # kiss: person, person, medium-dark skin tone, dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fb), # kiss: person, person, dark skin tone, light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fc), # kiss: person, person, dark skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fd), # kiss: person, person, dark skin tone, medium skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f48b, 0x0200d, 0x1f9d1, 0x1f3fe), # kiss: person, person, dark skin tone, medium-dark skin tone 
    },
    '15.1': {
        # Source: ./data/emoji-zwj-sequences-15.1.txt
        # Date: 2023-06-05, 20:04:50 GMT
        #
        # sequences of length 3,
            (0x1f468, 0x0200d, 0x1f466), # family: man, boy 
            (0x1f468, 0x0200d, 0x1f467), # family: man, girl 
            (0x1f469, 0x0200d, 0x1f466), # family: woman, boy 
            (0x1f469, 0x0200d, 0x1f467), # family: woman, girl 
            (0x1f9d1, 0x0200d, 0x1f9d2), # family: adult, child 
            (0x1f468, 0x0200d, 0x1f33e), # man farmer 
            (0x1f468, 0x0200d, 0x1f373), # man cook 
            (0x1f468, 0x0200d, 0x1f37c), # man feeding baby 
            (0x1f468, 0x0200d, 0x1f393), # man student 
            (0x1f468, 0x0200d, 0x1f3a4), # man singer 
            (0x1f468, 0x0200d, 0x1f3a8), # man artist 
            (0x1f468, 0x0200d, 0x1f3eb), # man teacher 
            (0x1f468, 0x0200d, 0x1f3ed), # man factory worker 
            (0x1f468, 0x0200d, 0x1f4bb), # man technologist 
            (0x1f468, 0x0200d, 0x1f4bc), # man office worker 
            (0x1f468, 0x0200d, 0x1f527), # man mechanic 
            (0x1f468, 0x0200d, 0x1f52c), # man scientist 
            (0x1f468, 0x0200d, 0x1f680), # man astronaut 
            (0x1f468, 0x0200d, 0x1f692), # man firefighter 
            (0x1f468, 0x0200d, 0x1f9af), # man with white cane 
            (0x1f468, 0x0200d, 0x1f9bc), # man in motorized wheelchair 
            (0x1f468, 0x0200d, 0x1f9bd), # man in manual wheelchair 
            (0x1f469, 0x0200d, 0x1f33e), # woman farmer 
            (0x1f469, 0x0200d, 0x1f373), # woman cook 
            (0x1f469, 0x0200d, 0x1f37c), # woman feeding baby 
            (0x1f469, 0x0200d, 0x1f393), # woman student 
            (0x1f469, 0x0200d, 0x1f3a4), # woman singer 
            (0x1f469, 0x0200d, 0x1f3a8), # woman artist 
            (0x1f469, 0x0200d, 0x1f3eb), # woman teacher 
            (0x1f469, 0x0200d, 0x1f3ed), # woman factory worker 
            (0x1f469, 0x0200d, 0x1f4bb), # woman technologist 
            (0x1f469, 0x0200d, 0x1f4bc), # woman office worker 
            (0x1f469, 0x0200d, 0x1f527), # woman mechanic 
            (0x1f469, 0x0200d, 0x1f52c), # woman scientist 
            (0x1f469, 0x0200d, 0x1f680), # woman astronaut 
            (0x1f469, 0x0200d, 0x1f692), # woman firefighter 
            (0x1f469, 0x0200d, 0x1f9af), # woman with white cane 
            (0x1f469, 0x0200d, 0x1f9bc), # woman in motorized wheelchair 
            (0x1f469, 0x0200d, 0x1f9bd), # woman in manual wheelchair 
            (0x1f9d1, 0x0200d, 0x1f33e), # farmer 
            (0x1f9d1, 0x0200d, 0x1f373), # cook 
            (0x1f9d1, 0x0200d, 0x1f37c), # person feeding baby 
            (0x1f9d1, 0x0200d, 0x1f384), # mx claus 
            (0x1f9d1, 0x0200d, 0x1f393), # student 
            (0x1f9d1, 0x0200d, 0x1f3a4), # singer 
            (0x1f9d1, 0x0200d, 0x1f3a8), # artist 
            (0x1f9d1, 0x0200d, 0x1f3eb), # teacher 
            (0x1f9d1, 0x0200d, 0x1f3ed), # factory worker 
            (0x1f9d1, 0x0200d, 0x1f4bb), # technologist 
            (0x1f9d1, 0x0200d, 0x1f4bc), # office worker 
            (0x1f9d1, 0x0200d, 0x1f527), # mechanic 
            (0x1f9d1, 0x0200d, 0x1f52c), # scientist 
            (0x1f9d1, 0x0200d, 0x1f680), # astronaut 
            (0x1f9d1, 0x0200d, 0x1f692), # firefighter 
            (0x1f9d1, 0x0200d, 0x1f9af), # person with white cane 
            (0x1f9d1, 0x0200d, 0x1f9bc), # person in motorized wheelchair 
            (0x1f9d1, 0x0200d, 0x1f9bd), # person in manual wheelchair 
            (0x1f468, 0x0200d, 0x1f9b0), # man: red hair 
            (0x1f468, 0x0200d, 0x1f9b1), # man: curly hair 
            (0x1f468, 0x0200d, 0x1f9b2), # man: bald 
            (0x1f468, 0x0200d, 0x1f9b3), # man: white hair 
            (0x1f469, 0x0200d, 0x1f9b0), # woman: red hair 
            (0x1f469, 0x0200d, 0x1f9b1), # woman: curly hair 
            (0x1f469, 0x0200d, 0x1f9b2), # woman: bald 
            (0x1f469, 0x0200d, 0x1f9b3), # woman: white hair 
            (0x1f9d1, 0x0200d, 0x1f9b0), # person: red hair 
            (0x1f9d1, 0x0200d, 0x1f9b1), # person: curly hair 
            (0x1f9d1, 0x0200d, 0x1f9b2), # person: bald 
            (0x1f9d1, 0x0200d, 0x1f9b3), # person: white hair 
            (0x1f344, 0x0200d, 0x1f7eb), # brown mushroom 
            (0x1f34b, 0x0200d, 0x1f7e9), # lime 
            (0x1f408, 0x0200d, 0x02b1b), # black cat 
            (0x1f415, 0x0200d, 0x1f9ba), # service dog 
            (0x1f426, 0x0200d, 0x02b1b), # black bird 
            (0x1f426, 0x0200d, 0x1f525), # phoenix 
            (0x1f62e, 0x0200d, 0x1f4a8), # face exhaling 
            (0x1f635, 0x0200d, 0x1f4ab), # face with spiral eyes 
        # sequences of length 4,
            (0x1f3c3, 0x0200d, 0x027a1, 0x0fe0f), # person running facing right 
            (0x1f468, 0x0200d, 0x02695, 0x0fe0f), # man health worker 
            (0x1f468, 0x0200d, 0x02696, 0x0fe0f), # man judge 
            (0x1f468, 0x0200d, 0x02708, 0x0fe0f), # man pilot 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f33e), # man farmer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f373), # man cook: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f37c), # man feeding baby: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f393), # man student: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a4), # man singer: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3a8), # man artist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3eb), # man teacher: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f3ed), # man factory worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bb), # man technologist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f4bc), # man office worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f527), # man mechanic: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f52c), # man scientist: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f680), # man astronaut: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f692), # man firefighter: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9af), # man with white cane: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9bc), # man in motorized wheelchair: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9bd), # man in manual wheelchair: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f33e), # man farmer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f373), # man cook: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f37c), # man feeding baby: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f393), # man student: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a4), # man singer: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3a8), # man artist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3eb), # man teacher: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f3ed), # man factory worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bb), # man technologist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f4bc), # man office worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f527), # man mechanic: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f52c), # man scientist: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f680), # man astronaut: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f692), # man firefighter: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9af), # man with white cane: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f33e), # man farmer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f373), # man cook: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f37c), # man feeding baby: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f393), # man student: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a4), # man singer: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3a8), # man artist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3eb), # man teacher: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f3ed), # man factory worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bb), # man technologist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f4bc), # man office worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f527), # man mechanic: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f52c), # man scientist: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f680), # man astronaut: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f692), # man firefighter: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9af), # man with white cane: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f33e), # man farmer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f373), # man cook: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f37c), # man feeding baby: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f393), # man student: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a4), # man singer: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3a8), # man artist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3eb), # man teacher: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f3ed), # man factory worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bb), # man technologist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f4bc), # man office worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f527), # man mechanic: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f52c), # man scientist: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f680), # man astronaut: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f692), # man firefighter: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9af), # man with white cane: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9bc), # man in motorized wheelchair: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9bd), # man in manual wheelchair: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f33e), # man farmer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f373), # man cook: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f37c), # man feeding baby: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f393), # man student: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a4), # man singer: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3a8), # man artist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3eb), # man teacher: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f3ed), # man factory worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bb), # man technologist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f4bc), # man office worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f527), # man mechanic: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f52c), # man scientist: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f680), # man astronaut: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f692), # man firefighter: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9af), # man with white cane: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9bc), # man in motorized wheelchair: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9bd), # man in manual wheelchair: dark skin tone 
            (0x1f469, 0x0200d, 0x02695, 0x0fe0f), # woman health worker 
            (0x1f469, 0x0200d, 0x02696, 0x0fe0f), # woman judge 
            (0x1f469, 0x0200d, 0x02708, 0x0fe0f), # woman pilot 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f33e), # woman farmer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f373), # woman cook: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f37c), # woman feeding baby: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f393), # woman student: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a4), # woman singer: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3a8), # woman artist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3eb), # woman teacher: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f3ed), # woman factory worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bb), # woman technologist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f4bc), # woman office worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f527), # woman mechanic: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f52c), # woman scientist: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f680), # woman astronaut: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f692), # woman firefighter: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9af), # woman with white cane: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9bd), # woman in manual wheelchair: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f33e), # woman farmer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f373), # woman cook: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f37c), # woman feeding baby: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f393), # woman student: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a4), # woman singer: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3a8), # woman artist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3eb), # woman teacher: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f3ed), # woman factory worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bb), # woman technologist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f4bc), # woman office worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f527), # woman mechanic: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f52c), # woman scientist: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f680), # woman astronaut: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f692), # woman firefighter: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9af), # woman with white cane: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f33e), # woman farmer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f373), # woman cook: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f37c), # woman feeding baby: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f393), # woman student: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a4), # woman singer: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3a8), # woman artist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3eb), # woman teacher: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f3ed), # woman factory worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bb), # woman technologist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f4bc), # woman office worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f527), # woman mechanic: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f52c), # woman scientist: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f680), # woman astronaut: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f692), # woman firefighter: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9af), # woman with white cane: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f33e), # woman farmer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f373), # woman cook: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f37c), # woman feeding baby: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f393), # woman student: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a4), # woman singer: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3a8), # woman artist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3eb), # woman teacher: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f3ed), # woman factory worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bb), # woman technologist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f4bc), # woman office worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f527), # woman mechanic: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f52c), # woman scientist: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f680), # woman astronaut: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f692), # woman firefighter: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9af), # woman with white cane: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9bd), # woman in manual wheelchair: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f33e), # woman farmer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f373), # woman cook: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f37c), # woman feeding baby: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f393), # woman student: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a4), # woman singer: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3a8), # woman artist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3eb), # woman teacher: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f3ed), # woman factory worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bb), # woman technologist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f4bc), # woman office worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f527), # woman mechanic: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f52c), # woman scientist: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f680), # woman astronaut: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f692), # woman firefighter: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9af), # woman with white cane: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9bc), # woman in motorized wheelchair: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9bd), # woman in manual wheelchair: dark skin tone 
            (0x1f6b6, 0x0200d, 0x027a1, 0x0fe0f), # person walking facing right 
            (0x1f9ce, 0x0200d, 0x027a1, 0x0fe0f), # person kneeling facing right 
            (0x1f9d1, 0x0200d, 0x02695, 0x0fe0f), # health worker 
            (0x1f9d1, 0x0200d, 0x02696, 0x0fe0f), # judge 
            (0x1f9d1, 0x0200d, 0x02708, 0x0fe0f), # pilot 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f33e), # farmer: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f373), # cook: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f37c), # person feeding baby: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f384), # mx claus: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f393), # student: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3a4), # singer: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3a8), # artist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3eb), # teacher: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f3ed), # factory worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f4bb), # technologist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f4bc), # office worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f527), # mechanic: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f52c), # scientist: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f680), # astronaut: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f692), # firefighter: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9af), # person with white cane: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9bc), # person in motorized wheelchair: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9bd), # person in manual wheelchair: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f33e), # farmer: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f373), # cook: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f37c), # person feeding baby: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f384), # mx claus: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f393), # student: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3a4), # singer: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3a8), # artist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3eb), # teacher: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f3ed), # factory worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f4bb), # technologist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f4bc), # office worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f527), # mechanic: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f52c), # scientist: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f680), # astronaut: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f692), # firefighter: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9af), # person with white cane: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f33e), # farmer: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f373), # cook: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f37c), # person feeding baby: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f384), # mx claus: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f393), # student: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3a4), # singer: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3a8), # artist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3eb), # teacher: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f3ed), # factory worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f4bb), # technologist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f4bc), # office worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f527), # mechanic: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f52c), # scientist: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f680), # astronaut: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f692), # firefighter: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9af), # person with white cane: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f33e), # farmer: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f373), # cook: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f37c), # person feeding baby: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f384), # mx claus: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f393), # student: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3a4), # singer: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3a8), # artist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3eb), # teacher: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f3ed), # factory worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f4bb), # technologist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f4bc), # office worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f527), # mechanic: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f52c), # scientist: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f680), # astronaut: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f692), # firefighter: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9af), # person with white cane: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9bc), # person in motorized wheelchair: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9bd), # person in manual wheelchair: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f33e), # farmer: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f373), # cook: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f37c), # person feeding baby: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f384), # mx claus: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f393), # student: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3a4), # singer: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3a8), # artist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3eb), # teacher: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f3ed), # factory worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f4bb), # technologist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f4bc), # office worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f527), # mechanic: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f52c), # scientist: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f680), # astronaut: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f692), # firefighter: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9af), # person with white cane: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9bc), # person in motorized wheelchair: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9bd), # person in manual wheelchair: dark skin tone 
            (0x1f3c3, 0x0200d, 0x02640, 0x0fe0f), # woman running 
            (0x1f3c3, 0x0200d, 0x02642, 0x0fe0f), # man running 
            (0x1f3c4, 0x0200d, 0x02640, 0x0fe0f), # woman surfing 
            (0x1f3c4, 0x0200d, 0x02642, 0x0fe0f), # man surfing 
            (0x1f3ca, 0x0200d, 0x02640, 0x0fe0f), # woman swimming 
            (0x1f3ca, 0x0200d, 0x02642, 0x0fe0f), # man swimming 
            (0x1f46e, 0x0200d, 0x02640, 0x0fe0f), # woman police officer 
            (0x1f46e, 0x0200d, 0x02642, 0x0fe0f), # man police officer 
            (0x1f46f, 0x0200d, 0x02640, 0x0fe0f), # women with bunny ears 
            (0x1f46f, 0x0200d, 0x02642, 0x0fe0f), # men with bunny ears 
            (0x1f470, 0x0200d, 0x02640, 0x0fe0f), # woman with veil 
            (0x1f470, 0x0200d, 0x02642, 0x0fe0f), # man with veil 
            (0x1f471, 0x0200d, 0x02640, 0x0fe0f), # woman: blond hair 
            (0x1f471, 0x0200d, 0x02642, 0x0fe0f), # man: blond hair 
            (0x1f473, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban 
            (0x1f473, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban 
            (0x1f477, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker 
            (0x1f477, 0x0200d, 0x02642, 0x0fe0f), # man construction worker 
            (0x1f481, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand 
            (0x1f481, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand 
            (0x1f482, 0x0200d, 0x02640, 0x0fe0f), # woman guard 
            (0x1f482, 0x0200d, 0x02642, 0x0fe0f), # man guard 
            (0x1f486, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage 
            (0x1f486, 0x0200d, 0x02642, 0x0fe0f), # man getting massage 
            (0x1f487, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut 
            (0x1f487, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut 
            (0x1f645, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO 
            (0x1f645, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO 
            (0x1f646, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK 
            (0x1f646, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK 
            (0x1f647, 0x0200d, 0x02640, 0x0fe0f), # woman bowing 
            (0x1f647, 0x0200d, 0x02642, 0x0fe0f), # man bowing 
            (0x1f64b, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand 
            (0x1f64b, 0x0200d, 0x02642, 0x0fe0f), # man raising hand 
            (0x1f64d, 0x0200d, 0x02640, 0x0fe0f), # woman frowning 
            (0x1f64d, 0x0200d, 0x02642, 0x0fe0f), # man frowning 
            (0x1f64e, 0x0200d, 0x02640, 0x0fe0f), # woman pouting 
            (0x1f64e, 0x0200d, 0x02642, 0x0fe0f), # man pouting 
            (0x1f6a3, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat 
            (0x1f6a3, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat 
            (0x1f6b4, 0x0200d, 0x02640, 0x0fe0f), # woman biking 
            (0x1f6b4, 0x0200d, 0x02642, 0x0fe0f), # man biking 
            (0x1f6b5, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking 
            (0x1f6b5, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking 
            (0x1f6b6, 0x0200d, 0x02640, 0x0fe0f), # woman walking 
            (0x1f6b6, 0x0200d, 0x02642, 0x0fe0f), # man walking 
            (0x1f926, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming 
            (0x1f926, 0x0200d, 0x02642, 0x0fe0f), # man facepalming 
            (0x1f935, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo 
            (0x1f935, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo 
            (0x1f937, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging 
            (0x1f937, 0x0200d, 0x02642, 0x0fe0f), # man shrugging 
            (0x1f938, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling 
            (0x1f938, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling 
            (0x1f939, 0x0200d, 0x02640, 0x0fe0f), # woman juggling 
            (0x1f939, 0x0200d, 0x02642, 0x0fe0f), # man juggling 
            (0x1f93c, 0x0200d, 0x02640, 0x0fe0f), # women wrestling 
            (0x1f93c, 0x0200d, 0x02642, 0x0fe0f), # men wrestling 
            (0x1f93d, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo 
            (0x1f93d, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo 
            (0x1f93e, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball 
            (0x1f93e, 0x0200d, 0x02642, 0x0fe0f), # man playing handball 
            (0x1f9b8, 0x0200d, 0x02640, 0x0fe0f), # woman superhero 
            (0x1f9b8, 0x0200d, 0x02642, 0x0fe0f), # man superhero 
            (0x1f9b9, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain 
            (0x1f9b9, 0x0200d, 0x02642, 0x0fe0f), # man supervillain 
            (0x1f9cd, 0x0200d, 0x02640, 0x0fe0f), # woman standing 
            (0x1f9cd, 0x0200d, 0x02642, 0x0fe0f), # man standing 
            (0x1f9ce, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling 
            (0x1f9ce, 0x0200d, 0x02642, 0x0fe0f), # man kneeling 
            (0x1f9cf, 0x0200d, 0x02640, 0x0fe0f), # deaf woman 
            (0x1f9cf, 0x0200d, 0x02642, 0x0fe0f), # deaf man 
            (0x1f9d4, 0x0200d, 0x02640, 0x0fe0f), # woman: beard 
            (0x1f9d4, 0x0200d, 0x02642, 0x0fe0f), # man: beard 
            (0x1f9d6, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room 
            (0x1f9d6, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room 
            (0x1f9d7, 0x0200d, 0x02640, 0x0fe0f), # woman climbing 
            (0x1f9d7, 0x0200d, 0x02642, 0x0fe0f), # man climbing 
            (0x1f9d8, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position 
            (0x1f9d8, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position 
            (0x1f9d9, 0x0200d, 0x02640, 0x0fe0f), # woman mage 
            (0x1f9d9, 0x0200d, 0x02642, 0x0fe0f), # man mage 
            (0x1f9da, 0x0200d, 0x02640, 0x0fe0f), # woman fairy 
            (0x1f9da, 0x0200d, 0x02642, 0x0fe0f), # man fairy 
            (0x1f9db, 0x0200d, 0x02640, 0x0fe0f), # woman vampire 
            (0x1f9db, 0x0200d, 0x02642, 0x0fe0f), # man vampire 
            (0x1f9dc, 0x0200d, 0x02640, 0x0fe0f), # mermaid 
            (0x1f9dc, 0x0200d, 0x02642, 0x0fe0f), # merman 
            (0x1f9dd, 0x0200d, 0x02640, 0x0fe0f), # woman elf 
            (0x1f9dd, 0x0200d, 0x02642, 0x0fe0f), # man elf 
            (0x1f9de, 0x0200d, 0x02640, 0x0fe0f), # woman genie 
            (0x1f9de, 0x0200d, 0x02642, 0x0fe0f), # man genie 
            (0x1f9df, 0x0200d, 0x02640, 0x0fe0f), # woman zombie 
            (0x1f9df, 0x0200d, 0x02642, 0x0fe0f), # man zombie 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b0), # man: light skin tone, red hair 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b1), # man: light skin tone, curly hair 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b2), # man: light skin tone, bald 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f9b3), # man: light skin tone, white hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b0), # man: medium-light skin tone, red hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b1), # man: medium-light skin tone, curly hair 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b2), # man: medium-light skin tone, bald 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f9b3), # man: medium-light skin tone, white hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b0), # man: medium skin tone, red hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b1), # man: medium skin tone, curly hair 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b2), # man: medium skin tone, bald 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f9b3), # man: medium skin tone, white hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b0), # man: medium-dark skin tone, red hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b1), # man: medium-dark skin tone, curly hair 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b2), # man: medium-dark skin tone, bald 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f9b3), # man: medium-dark skin tone, white hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b0), # man: dark skin tone, red hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b1), # man: dark skin tone, curly hair 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b2), # man: dark skin tone, bald 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f9b3), # man: dark skin tone, white hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b0), # woman: light skin tone, red hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b1), # woman: light skin tone, curly hair 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b2), # woman: light skin tone, bald 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f9b3), # woman: light skin tone, white hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b0), # woman: medium-light skin tone, red hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b1), # woman: medium-light skin tone, curly hair 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b2), # woman: medium-light skin tone, bald 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f9b3), # woman: medium-light skin tone, white hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b0), # woman: medium skin tone, red hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b1), # woman: medium skin tone, curly hair 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b2), # woman: medium skin tone, bald 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f9b3), # woman: medium skin tone, white hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b0), # woman: medium-dark skin tone, red hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b1), # woman: medium-dark skin tone, curly hair 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b2), # woman: medium-dark skin tone, bald 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f9b3), # woman: medium-dark skin tone, white hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b0), # woman: dark skin tone, red hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b1), # woman: dark skin tone, curly hair 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b2), # woman: dark skin tone, bald 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f9b3), # woman: dark skin tone, white hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b0), # person: light skin tone, red hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b1), # person: light skin tone, curly hair 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b2), # person: light skin tone, bald 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f9b3), # person: light skin tone, white hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b0), # person: medium-light skin tone, red hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b1), # person: medium-light skin tone, curly hair 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b2), # person: medium-light skin tone, bald 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x1f9b3), # person: medium-light skin tone, white hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b0), # person: medium skin tone, red hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b1), # person: medium skin tone, curly hair 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b2), # person: medium skin tone, bald 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x1f9b3), # person: medium skin tone, white hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b0), # person: medium-dark skin tone, red hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b1), # person: medium-dark skin tone, curly hair 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b2), # person: medium-dark skin tone, bald 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x1f9b3), # person: medium-dark skin tone, white hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b0), # person: dark skin tone, red hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b1), # person: dark skin tone, curly hair 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b2), # person: dark skin tone, bald 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x1f9b3), # person: dark skin tone, white hair 
            (0x026d3, 0x0fe0f, 0x0200d, 0x1f4a5), # broken chain 
            (0x02764, 0x0fe0f, 0x0200d, 0x1f525), # heart on fire 
            (0x02764, 0x0fe0f, 0x0200d, 0x1fa79), # mending heart 
            (0x1f3f3, 0x0fe0f, 0x0200d, 0x1f308), # rainbow flag 
            (0x1f3f4, 0x0200d, 0x02620, 0x0fe0f), # pirate flag 
            (0x1f43b, 0x0200d, 0x02744, 0x0fe0f), # polar bear 
            (0x1f636, 0x0200d, 0x1f32b, 0x0fe0f), # face in clouds 
            (0x1f642, 0x0200d, 0x02194, 0x0fe0f), # head shaking horizontally 
            (0x1f642, 0x0200d, 0x02195, 0x0fe0f), # head shaking vertically 
        # sequences of length 5,
            (0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, boy, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, girl, boy 
            (0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, girl, girl 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466), # family: man, man, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467), # family: man, man, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: man, woman, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: man, woman, girl 
            (0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, girl, girl 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466), # family: woman, woman, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467), # family: woman, woman, girl 
            (0x1f9d1, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1), # people holding hands 
            (0x1f9d1, 0x0200d, 0x1f9d1, 0x0200d, 0x1f9d2), # family: adult, adult, child 
            (0x1f9d1, 0x0200d, 0x1f9d2, 0x0200d, 0x1f9d2), # family: adult, child, child 
            (0x1faf1, 0x1f3fb, 0x0200d, 0x1faf2, 0x1f3fc), # handshake: light skin tone, medium-light skin tone 
            (0x1faf1, 0x1f3fb, 0x0200d, 0x1faf2, 0x1f3fd), # handshake: light skin tone, medium skin tone 
            (0x1faf1, 0x1f3fb, 0x0200d, 0x1faf2, 0x1f3fe), # handshake: light skin tone, medium-dark skin tone 
            (0x1faf1, 0x1f3fb, 0x0200d, 0x1faf2, 0x1f3ff), # handshake: light skin tone, dark skin tone 
            (0x1faf1, 0x1f3fc, 0x0200d, 0x1faf2, 0x1f3fb), # handshake: medium-light skin tone, light skin tone 
            (0x1faf1, 0x1f3fc, 0x0200d, 0x1faf2, 0x1f3fd), # handshake: medium-light skin tone, medium skin tone 
            (0x1faf1, 0x1f3fc, 0x0200d, 0x1faf2, 0x1f3fe), # handshake: medium-light skin tone, medium-dark skin tone 
            (0x1faf1, 0x1f3fc, 0x0200d, 0x1faf2, 0x1f3ff), # handshake: medium-light skin tone, dark skin tone 
            (0x1faf1, 0x1f3fd, 0x0200d, 0x1faf2, 0x1f3fb), # handshake: medium skin tone, light skin tone 
            (0x1faf1, 0x1f3fd, 0x0200d, 0x1faf2, 0x1f3fc), # handshake: medium skin tone, medium-light skin tone 
            (0x1faf1, 0x1f3fd, 0x0200d, 0x1faf2, 0x1f3fe), # handshake: medium skin tone, medium-dark skin tone 
            (0x1faf1, 0x1f3fd, 0x0200d, 0x1faf2, 0x1f3ff), # handshake: medium skin tone, dark skin tone 
            (0x1faf1, 0x1f3fe, 0x0200d, 0x1faf2, 0x1f3fb), # handshake: medium-dark skin tone, light skin tone 
            (0x1faf1, 0x1f3fe, 0x0200d, 0x1faf2, 0x1f3fc), # handshake: medium-dark skin tone, medium-light skin tone 
            (0x1faf1, 0x1f3fe, 0x0200d, 0x1faf2, 0x1f3fd), # handshake: medium-dark skin tone, medium skin tone 
            (0x1faf1, 0x1f3fe, 0x0200d, 0x1faf2, 0x1f3ff), # handshake: medium-dark skin tone, dark skin tone 
            (0x1faf1, 0x1f3ff, 0x0200d, 0x1faf2, 0x1f3fb), # handshake: dark skin tone, light skin tone 
            (0x1faf1, 0x1f3ff, 0x0200d, 0x1faf2, 0x1f3fc), # handshake: dark skin tone, medium-light skin tone 
            (0x1faf1, 0x1f3ff, 0x0200d, 0x1faf2, 0x1f3fd), # handshake: dark skin tone, medium skin tone 
            (0x1faf1, 0x1f3ff, 0x0200d, 0x1faf2, 0x1f3fe), # handshake: dark skin tone, medium-dark skin tone 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x027a1, 0x0fe0f), # person running facing right: light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x027a1, 0x0fe0f), # person running facing right: medium-light skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x027a1, 0x0fe0f), # person running facing right: medium skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x027a1, 0x0fe0f), # person running facing right: medium-dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x027a1, 0x0fe0f), # person running facing right: dark skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # man health worker: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # man judge: light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # man pilot: light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # man health worker: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # man judge: medium-dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # man pilot: medium-dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # man health worker: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # man judge: dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # man pilot: dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # woman judge: light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # woman judge: medium-dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # woman health worker: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # woman judge: dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # woman pilot: dark skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x027a1, 0x0fe0f), # person walking facing right: light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x027a1, 0x0fe0f), # person walking facing right: medium-light skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x027a1, 0x0fe0f), # person walking facing right: medium skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x027a1, 0x0fe0f), # person walking facing right: medium-dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x027a1, 0x0fe0f), # person walking facing right: dark skin tone 
            (0x1f9ce, 0x1f3fb, 0x0200d, 0x027a1, 0x0fe0f), # person kneeling facing right: light skin tone 
            (0x1f9ce, 0x1f3fc, 0x0200d, 0x027a1, 0x0fe0f), # person kneeling facing right: medium-light skin tone 
            (0x1f9ce, 0x1f3fd, 0x0200d, 0x027a1, 0x0fe0f), # person kneeling facing right: medium skin tone 
            (0x1f9ce, 0x1f3fe, 0x0200d, 0x027a1, 0x0fe0f), # person kneeling facing right: medium-dark skin tone 
            (0x1f9ce, 0x1f3ff, 0x0200d, 0x027a1, 0x0fe0f), # person kneeling facing right: dark skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02695, 0x0fe0f), # health worker: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02696, 0x0fe0f), # judge: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x02708, 0x0fe0f), # pilot: light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02696, 0x0fe0f), # judge: medium-light skin tone 
            (0x1f9d1, 0x1f3fc, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium-light skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02696, 0x0fe0f), # judge: medium skin tone 
            (0x1f9d1, 0x1f3fd, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02695, 0x0fe0f), # health worker: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02696, 0x0fe0f), # judge: medium-dark skin tone 
            (0x1f9d1, 0x1f3fe, 0x0200d, 0x02708, 0x0fe0f), # pilot: medium-dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02695, 0x0fe0f), # health worker: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02696, 0x0fe0f), # judge: dark skin tone 
            (0x1f9d1, 0x1f3ff, 0x0200d, 0x02708, 0x0fe0f), # pilot: dark skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: light skin tone 
            (0x026f9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-light skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: medium-dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball: dark skin tone 
            (0x026f9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball: dark skin tone 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman bouncing ball 
            (0x026f9, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man bouncing ball 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman running: light skin tone 
            (0x1f3c3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man running: light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-light skin tone 
            (0x1f3c3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-light skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium skin tone 
            (0x1f3c3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man running: medium skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman running: medium-dark skin tone 
            (0x1f3c3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man running: medium-dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman running: dark skin tone 
            (0x1f3c3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man running: dark skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: light skin tone 
            (0x1f3c4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man surfing: light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-light skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium skin tone 
            (0x1f3c4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man surfing: medium-dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman surfing: dark skin tone 
            (0x1f3c4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man surfing: dark skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: light skin tone 
            (0x1f3ca, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man swimming: light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-light skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium skin tone 
            (0x1f3ca, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man swimming: medium-dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman swimming: dark skin tone 
            (0x1f3ca, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man swimming: dark skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-light skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: medium-dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights: dark skin tone 
            (0x1f3cb, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights: dark skin tone 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman lifting weights 
            (0x1f3cb, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man lifting weights 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: light skin tone 
            (0x1f3cc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man golfing: light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-light skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium skin tone 
            (0x1f3cc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man golfing: medium-dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman golfing: dark skin tone 
            (0x1f3cc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man golfing: dark skin tone 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman golfing 
            (0x1f3cc, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man golfing 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: light skin tone 
            (0x1f46e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man police officer: light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-light skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium skin tone 
            (0x1f46e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man police officer: medium-dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman police officer: dark skin tone 
            (0x1f46e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man police officer: dark skin tone 
            (0x1f470, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: light skin tone 
            (0x1f470, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man with veil: light skin tone 
            (0x1f470, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: medium-light skin tone 
            (0x1f470, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man with veil: medium-light skin tone 
            (0x1f470, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: medium skin tone 
            (0x1f470, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man with veil: medium skin tone 
            (0x1f470, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: medium-dark skin tone 
            (0x1f470, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man with veil: medium-dark skin tone 
            (0x1f470, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman with veil: dark skin tone 
            (0x1f470, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man with veil: dark skin tone 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman: light skin tone, blond hair 
            (0x1f471, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man: light skin tone, blond hair 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-light skin tone, blond hair 
            (0x1f471, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man: medium-light skin tone, blond hair 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman: medium skin tone, blond hair 
            (0x1f471, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man: medium skin tone, blond hair 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-dark skin tone, blond hair 
            (0x1f471, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man: medium-dark skin tone, blond hair 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman: dark skin tone, blond hair 
            (0x1f471, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man: dark skin tone, blond hair 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: light skin tone 
            (0x1f473, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-light skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium skin tone 
            (0x1f473, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: medium-dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman wearing turban: dark skin tone 
            (0x1f473, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man wearing turban: dark skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: light skin tone 
            (0x1f477, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-light skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium skin tone 
            (0x1f477, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: medium-dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman construction worker: dark skin tone 
            (0x1f477, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man construction worker: dark skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: light skin tone 
            (0x1f481, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-light skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium skin tone 
            (0x1f481, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: medium-dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman tipping hand: dark skin tone 
            (0x1f481, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man tipping hand: dark skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman guard: light skin tone 
            (0x1f482, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man guard: light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-light skin tone 
            (0x1f482, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-light skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium skin tone 
            (0x1f482, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman guard: medium-dark skin tone 
            (0x1f482, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man guard: medium-dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman guard: dark skin tone 
            (0x1f482, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man guard: dark skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: light skin tone 
            (0x1f486, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-light skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium skin tone 
            (0x1f486, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: medium-dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting massage: dark skin tone 
            (0x1f486, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting massage: dark skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: light skin tone 
            (0x1f487, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-light skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium skin tone 
            (0x1f487, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: medium-dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman getting haircut: dark skin tone 
            (0x1f487, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man getting haircut: dark skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman detective: light skin tone 
            (0x1f575, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man detective: light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-light skin tone 
            (0x1f575, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-light skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium skin tone 
            (0x1f575, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman detective: medium-dark skin tone 
            (0x1f575, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man detective: medium-dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman detective: dark skin tone 
            (0x1f575, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man detective: dark skin tone 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02640, 0x0fe0f), # woman detective 
            (0x1f575, 0x0fe0f, 0x0200d, 0x02642, 0x0fe0f), # man detective 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: light skin tone 
            (0x1f645, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-light skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: medium-dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing NO: dark skin tone 
            (0x1f645, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing NO: dark skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: light skin tone 
            (0x1f646, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-light skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: medium-dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman gesturing OK: dark skin tone 
            (0x1f646, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man gesturing OK: dark skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: light skin tone 
            (0x1f647, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man bowing: light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-light skin tone 
            (0x1f647, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-light skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium skin tone 
            (0x1f647, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: medium-dark skin tone 
            (0x1f647, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man bowing: medium-dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman bowing: dark skin tone 
            (0x1f647, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man bowing: dark skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: light skin tone 
            (0x1f64b, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-light skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium skin tone 
            (0x1f64b, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: medium-dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman raising hand: dark skin tone 
            (0x1f64b, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man raising hand: dark skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: light skin tone 
            (0x1f64d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man frowning: light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-light skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium skin tone 
            (0x1f64d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man frowning: medium-dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman frowning: dark skin tone 
            (0x1f64d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man frowning: dark skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: light skin tone 
            (0x1f64e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man pouting: light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-light skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium skin tone 
            (0x1f64e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man pouting: medium-dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman pouting: dark skin tone 
            (0x1f64e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man pouting: dark skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-light skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: medium-dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman rowing boat: dark skin tone 
            (0x1f6a3, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man rowing boat: dark skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman biking: light skin tone 
            (0x1f6b4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man biking: light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-light skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium skin tone 
            (0x1f6b4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man biking: medium-dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman biking: dark skin tone 
            (0x1f6b4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man biking: dark skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-light skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: medium-dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mountain biking: dark skin tone 
            (0x1f6b5, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mountain biking: dark skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman walking: light skin tone 
            (0x1f6b6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man walking: light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-light skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium skin tone 
            (0x1f6b6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man walking: medium-dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman walking: dark skin tone 
            (0x1f6b6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man walking: dark skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: light skin tone 
            (0x1f926, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-light skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium skin tone 
            (0x1f926, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: medium-dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman facepalming: dark skin tone 
            (0x1f926, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man facepalming: dark skin tone 
            (0x1f935, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: light skin tone 
            (0x1f935, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: light skin tone 
            (0x1f935, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: medium-light skin tone 
            (0x1f935, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: medium-light skin tone 
            (0x1f935, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: medium skin tone 
            (0x1f935, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: medium skin tone 
            (0x1f935, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: medium-dark skin tone 
            (0x1f935, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: medium-dark skin tone 
            (0x1f935, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in tuxedo: dark skin tone 
            (0x1f935, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in tuxedo: dark skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: light skin tone 
            (0x1f937, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-light skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium skin tone 
            (0x1f937, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: medium-dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman shrugging: dark skin tone 
            (0x1f937, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man shrugging: dark skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: light skin tone 
            (0x1f938, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-light skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: medium-dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman cartwheeling: dark skin tone 
            (0x1f938, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man cartwheeling: dark skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: light skin tone 
            (0x1f939, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man juggling: light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-light skin tone 
            (0x1f939, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-light skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium skin tone 
            (0x1f939, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: medium-dark skin tone 
            (0x1f939, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man juggling: medium-dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman juggling: dark skin tone 
            (0x1f939, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man juggling: dark skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: light skin tone 
            (0x1f93d, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-light skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: medium-dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing water polo: dark skin tone 
            (0x1f93d, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing water polo: dark skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: light skin tone 
            (0x1f93e, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-light skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium skin tone 
            (0x1f93e, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: medium-dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman playing handball: dark skin tone 
            (0x1f93e, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man playing handball: dark skin tone 
            (0x1f9b8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: light skin tone 
            (0x1f9b8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man superhero: light skin tone 
            (0x1f9b8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium-light skin tone 
            (0x1f9b8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium-light skin tone 
            (0x1f9b8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium skin tone 
            (0x1f9b8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium skin tone 
            (0x1f9b8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: medium-dark skin tone 
            (0x1f9b8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man superhero: medium-dark skin tone 
            (0x1f9b8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman superhero: dark skin tone 
            (0x1f9b8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man superhero: dark skin tone 
            (0x1f9b9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: light skin tone 
            (0x1f9b9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: light skin tone 
            (0x1f9b9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium-light skin tone 
            (0x1f9b9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium-light skin tone 
            (0x1f9b9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium skin tone 
            (0x1f9b9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium skin tone 
            (0x1f9b9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: medium-dark skin tone 
            (0x1f9b9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: medium-dark skin tone 
            (0x1f9b9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman supervillain: dark skin tone 
            (0x1f9b9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man supervillain: dark skin tone 
            (0x1f9cd, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman standing: light skin tone 
            (0x1f9cd, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man standing: light skin tone 
            (0x1f9cd, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium-light skin tone 
            (0x1f9cd, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium-light skin tone 
            (0x1f9cd, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium skin tone 
            (0x1f9cd, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium skin tone 
            (0x1f9cd, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman standing: medium-dark skin tone 
            (0x1f9cd, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man standing: medium-dark skin tone 
            (0x1f9cd, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman standing: dark skin tone 
            (0x1f9cd, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man standing: dark skin tone 
            (0x1f9ce, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: light skin tone 
            (0x1f9ce, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: light skin tone 
            (0x1f9ce, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium-light skin tone 
            (0x1f9ce, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium-light skin tone 
            (0x1f9ce, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium skin tone 
            (0x1f9ce, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium skin tone 
            (0x1f9ce, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: medium-dark skin tone 
            (0x1f9ce, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: medium-dark skin tone 
            (0x1f9ce, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman kneeling: dark skin tone 
            (0x1f9ce, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man kneeling: dark skin tone 
            (0x1f9cf, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: light skin tone 
            (0x1f9cf, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # deaf man: light skin tone 
            (0x1f9cf, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium-light skin tone 
            (0x1f9cf, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium-light skin tone 
            (0x1f9cf, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium skin tone 
            (0x1f9cf, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium skin tone 
            (0x1f9cf, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: medium-dark skin tone 
            (0x1f9cf, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # deaf man: medium-dark skin tone 
            (0x1f9cf, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # deaf woman: dark skin tone 
            (0x1f9cf, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # deaf man: dark skin tone 
            (0x1f9d4, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman: light skin tone, beard 
            (0x1f9d4, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man: light skin tone, beard 
            (0x1f9d4, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-light skin tone, beard 
            (0x1f9d4, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man: medium-light skin tone, beard 
            (0x1f9d4, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman: medium skin tone, beard 
            (0x1f9d4, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man: medium skin tone, beard 
            (0x1f9d4, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman: medium-dark skin tone, beard 
            (0x1f9d4, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man: medium-dark skin tone, beard 
            (0x1f9d4, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman: dark skin tone, beard 
            (0x1f9d4, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man: dark skin tone, beard 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-light skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: medium-dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in steamy room: dark skin tone 
            (0x1f9d6, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in steamy room: dark skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: light skin tone 
            (0x1f9d7, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man climbing: light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-light skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium skin tone 
            (0x1f9d7, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man climbing: medium-dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman climbing: dark skin tone 
            (0x1f9d7, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man climbing: dark skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-light skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: medium-dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman in lotus position: dark skin tone 
            (0x1f9d8, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man in lotus position: dark skin tone 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman mage: light skin tone 
            (0x1f9d9, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man mage: light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-light skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium skin tone 
            (0x1f9d9, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man mage: medium-dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman mage: dark skin tone 
            (0x1f9d9, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man mage: dark skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: light skin tone 
            (0x1f9da, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man fairy: light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-light skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium skin tone 
            (0x1f9da, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man fairy: medium-dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman fairy: dark skin tone 
            (0x1f9da, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man fairy: dark skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: light skin tone 
            (0x1f9db, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man vampire: light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-light skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium skin tone 
            (0x1f9db, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man vampire: medium-dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman vampire: dark skin tone 
            (0x1f9db, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man vampire: dark skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # mermaid: light skin tone 
            (0x1f9dc, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # merman: light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-light skin tone 
            (0x1f9dc, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-light skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium skin tone 
            (0x1f9dc, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # merman: medium skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # mermaid: medium-dark skin tone 
            (0x1f9dc, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # merman: medium-dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # mermaid: dark skin tone 
            (0x1f9dc, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # merman: dark skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02640, 0x0fe0f), # woman elf: light skin tone 
            (0x1f9dd, 0x1f3fb, 0x0200d, 0x02642, 0x0fe0f), # man elf: light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fc, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-light skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium skin tone 
            (0x1f9dd, 0x1f3fd, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02640, 0x0fe0f), # woman elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3fe, 0x0200d, 0x02642, 0x0fe0f), # man elf: medium-dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02640, 0x0fe0f), # woman elf: dark skin tone 
            (0x1f9dd, 0x1f3ff, 0x0200d, 0x02642, 0x0fe0f), # man elf: dark skin tone 
            (0x1f3f3, 0x0fe0f, 0x0200d, 0x026a7, 0x0fe0f), # transgender flag 
            (0x1f441, 0x0fe0f, 0x0200d, 0x1f5e8, 0x0fe0f), # eye in speech bubble 
        # sequences of length 6,
            (0x1f468, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: man, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f468), # couple with heart: woman, man 
            (0x1f469, 0x0200d, 0x02764, 0x0fe0f, 0x0200d, 0x1f469), # couple with heart: woman, woman 
            (0x1f468, 0x0200d, 0x1f9af, 0x0200d, 0x027a1, 0x0fe0f), # man with white cane facing right 
            (0x1f468, 0x0200d, 0x1f9bc, 0x0200d, 0x027a1, 0x0fe0f), # man in motorized wheelchair facing right 
            (0x1f468, 0x0200d, 0x1f9bd, 0x0200d, 0x027a1, 0x0fe0f), # man in manual wheelchair facing right 
            (0x1f469, 0x0200d, 0x1f9af, 0x0200d, 0x027a1, 0x0fe0f), # woman with white cane facing right 
            (0x1f469, 0x0200d, 0x1f9bc, 0x0200d, 0x027a1, 0x0fe0f), # woman in motorized wheelchair facing right 
            (0x1f469, 0x0200d, 0x1f9bd, 0x0200d, 0x027a1, 0x0fe0f), # woman in manual wheelchair facing right 
            (0x1f9d1, 0x0200d, 0x1f9af, 0x0200d, 0x027a1, 0x0fe0f), # person with white cane facing right 
            (0x1f9d1, 0x0200d, 0x1f9bc, 0x0200d, 0x027a1, 0x0fe0f), # person in motorized wheelchair facing right 
            (0x1f9d1, 0x0200d, 0x1f9bd, 0x0200d, 0x027a1, 0x0fe0f), # person in manual wheelchair facing right 
        # sequences of length 7,
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, man, boy, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, man, girl, boy 
            (0x1f468, 0x0200d, 0x1f468, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, man, girl, girl 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: man, woman, boy, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: man, woman, girl, boy 
            (0x1f468, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: man, woman, girl, girl 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: light skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: light skin tone, medium skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: light skin tone, dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium-light skin tone, light skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: medium-light skin tone, medium skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium-light skin tone, dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium skin tone, light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: medium skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: medium skin tone, medium-dark skin tone 
            (0x1f468, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium skin tone, dark skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: medium-dark skin tone, light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: medium-dark skin tone, medium skin tone 
            (0x1f468, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # men holding hands: medium-dark skin tone, dark skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # men holding hands: dark skin tone, light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # men holding hands: dark skin tone, medium-light skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # men holding hands: dark skin tone, medium skin tone 
            (0x1f468, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # men holding hands: dark skin tone, medium-dark skin tone 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f466, 0x0200d, 0x1f466), # family: woman, woman, boy, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f466), # family: woman, woman, girl, boy 
            (0x1f469, 0x0200d, 0x1f469, 0x0200d, 0x1f467, 0x0200d, 0x1f467), # family: woman, woman, girl, girl 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: light skin tone, dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: light skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: light skin tone, medium skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium-light skin tone, light skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: medium-light skin tone, medium skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: medium-light skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fc, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium-light skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium skin tone, light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: medium skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: medium skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3fd, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3ff), # woman and man holding hands: medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: medium-dark skin tone, light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: medium-dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: medium-dark skin tone, medium skin tone 
            (0x1f469, 0x1f3fe, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3ff), # women holding hands: medium-dark skin tone, dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fb), # woman and man holding hands: dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fc), # woman and man holding hands: dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fd), # woman and man holding hands: dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f468, 0x1f3fe), # woman and man holding hands: dark skin tone, medium-dark skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fb), # women holding hands: dark skin tone, light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fc), # women holding hands: dark skin tone, medium-light skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fd), # women holding hands: dark skin tone, medium skin tone 
            (0x1f469, 0x1f3ff, 0x0200d, 0x1f91d, 0x0200d, 0x1f469, 0x1f3fe), # women holding hands: dark skin tone, medium-dark skin tone 
            (0x1f9d1, 0x0200d, 0x1f9d1, 0x0200d, 0x1f9d2, 0x0200d, 0x1f9d2), # family: adult, adult, child, child 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fb), # people holding hands: light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fc), # people holding hands: light skin tone, medium-light skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fd), # people holding hands: light skin tone, medium skin tone 
            (0x1f9d1, 0x1f3fb, 0x0200d, 0x1f91d, 0x0200d, 0x1f9d1, 0x1f3fe), # people holding hands: light skin tone, m