# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetExternalExadataStorageServerResult',
    'AwaitableGetExternalExadataStorageServerResult',
    'get_external_exadata_storage_server',
    'get_external_exadata_storage_server_output',
]

@pulumi.output_type
class GetExternalExadataStorageServerResult:
    """
    A collection of values returned by getExternalExadataStorageServer.
    """
    def __init__(__self__, additional_details=None, connectors=None, cpu_count=None, defined_tags=None, display_name=None, exadata_infrastructure_id=None, external_exadata_storage_server_id=None, freeform_tags=None, id=None, internal_id=None, ip_address=None, lifecycle_details=None, make_model=None, max_flash_disk_iops=None, max_flash_disk_throughput=None, max_hard_disk_iops=None, max_hard_disk_throughput=None, memory_gb=None, resource_type=None, state=None, status=None, storage_grid_id=None, time_created=None, time_updated=None, version=None):
        if additional_details and not isinstance(additional_details, dict):
            raise TypeError("Expected argument 'additional_details' to be a dict")
        pulumi.set(__self__, "additional_details", additional_details)
        if connectors and not isinstance(connectors, list):
            raise TypeError("Expected argument 'connectors' to be a list")
        pulumi.set(__self__, "connectors", connectors)
        if cpu_count and not isinstance(cpu_count, float):
            raise TypeError("Expected argument 'cpu_count' to be a float")
        pulumi.set(__self__, "cpu_count", cpu_count)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if exadata_infrastructure_id and not isinstance(exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if external_exadata_storage_server_id and not isinstance(external_exadata_storage_server_id, str):
            raise TypeError("Expected argument 'external_exadata_storage_server_id' to be a str")
        pulumi.set(__self__, "external_exadata_storage_server_id", external_exadata_storage_server_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal_id and not isinstance(internal_id, str):
            raise TypeError("Expected argument 'internal_id' to be a str")
        pulumi.set(__self__, "internal_id", internal_id)
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if make_model and not isinstance(make_model, str):
            raise TypeError("Expected argument 'make_model' to be a str")
        pulumi.set(__self__, "make_model", make_model)
        if max_flash_disk_iops and not isinstance(max_flash_disk_iops, int):
            raise TypeError("Expected argument 'max_flash_disk_iops' to be a int")
        pulumi.set(__self__, "max_flash_disk_iops", max_flash_disk_iops)
        if max_flash_disk_throughput and not isinstance(max_flash_disk_throughput, int):
            raise TypeError("Expected argument 'max_flash_disk_throughput' to be a int")
        pulumi.set(__self__, "max_flash_disk_throughput", max_flash_disk_throughput)
        if max_hard_disk_iops and not isinstance(max_hard_disk_iops, int):
            raise TypeError("Expected argument 'max_hard_disk_iops' to be a int")
        pulumi.set(__self__, "max_hard_disk_iops", max_hard_disk_iops)
        if max_hard_disk_throughput and not isinstance(max_hard_disk_throughput, int):
            raise TypeError("Expected argument 'max_hard_disk_throughput' to be a int")
        pulumi.set(__self__, "max_hard_disk_throughput", max_hard_disk_throughput)
        if memory_gb and not isinstance(memory_gb, float):
            raise TypeError("Expected argument 'memory_gb' to be a float")
        pulumi.set(__self__, "memory_gb", memory_gb)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if storage_grid_id and not isinstance(storage_grid_id, str):
            raise TypeError("Expected argument 'storage_grid_id' to be a str")
        pulumi.set(__self__, "storage_grid_id", storage_grid_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Mapping[str, Any]:
        """
        The additional details of the resource defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter
    def connectors(self) -> Sequence['outputs.GetExternalExadataStorageServerConnectorResult']:
        """
        The connector of the Exadata storage server.
        """
        return pulumi.get(self, "connectors")

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> float:
        """
        The CPU count of the Exadata storage server.
        """
        return pulumi.get(self, "cpu_count")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The name of the Exadata resource. English letters, numbers, "-", "_" and "." only.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="externalExadataStorageServerId")
    def external_exadata_storage_server_id(self) -> str:
        return pulumi.get(self, "external_exadata_storage_server_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internalId")
    def internal_id(self) -> str:
        """
        The internal ID of the Exadata resource.
        """
        return pulumi.get(self, "internal_id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address of the Exadata storage server.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        The details of the lifecycle state of the Exadata resource.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="makeModel")
    def make_model(self) -> str:
        """
        The make model of the Exadata storage server.
        """
        return pulumi.get(self, "make_model")

    @property
    @pulumi.getter(name="maxFlashDiskIops")
    def max_flash_disk_iops(self) -> int:
        """
        The maximum flash disk IO operations per second of the Exadata storage server.
        """
        return pulumi.get(self, "max_flash_disk_iops")

    @property
    @pulumi.getter(name="maxFlashDiskThroughput")
    def max_flash_disk_throughput(self) -> int:
        """
        The maximum flash disk IO throughput in MB/s of the Exadata storage server.
        """
        return pulumi.get(self, "max_flash_disk_throughput")

    @property
    @pulumi.getter(name="maxHardDiskIops")
    def max_hard_disk_iops(self) -> int:
        """
        The maximum hard disk IO operations per second of the Exadata storage server.
        """
        return pulumi.get(self, "max_hard_disk_iops")

    @property
    @pulumi.getter(name="maxHardDiskThroughput")
    def max_hard_disk_throughput(self) -> int:
        """
        The maximum hard disk IO throughput in MB/s of the Exadata storage server.
        """
        return pulumi.get(self, "max_hard_disk_throughput")

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> float:
        """
        The Exadata storage server memory size in GB.
        """
        return pulumi.get(self, "memory_gb")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The type of Exadata resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the database resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the Exadata resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageGridId")
    def storage_grid_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server grid.
        """
        return pulumi.get(self, "storage_grid_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The timestamp of the creation of the Exadata resource.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The timestamp of the last update of the Exadata resource.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the Exadata resource.
        """
        return pulumi.get(self, "version")


class AwaitableGetExternalExadataStorageServerResult(GetExternalExadataStorageServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalExadataStorageServerResult(
            additional_details=self.additional_details,
            connectors=self.connectors,
            cpu_count=self.cpu_count,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            exadata_infrastructure_id=self.exadata_infrastructure_id,
            external_exadata_storage_server_id=self.external_exadata_storage_server_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            internal_id=self.internal_id,
            ip_address=self.ip_address,
            lifecycle_details=self.lifecycle_details,
            make_model=self.make_model,
            max_flash_disk_iops=self.max_flash_disk_iops,
            max_flash_disk_throughput=self.max_flash_disk_throughput,
            max_hard_disk_iops=self.max_hard_disk_iops,
            max_hard_disk_throughput=self.max_hard_disk_throughput,
            memory_gb=self.memory_gb,
            resource_type=self.resource_type,
            state=self.state,
            status=self.status,
            storage_grid_id=self.storage_grid_id,
            time_created=self.time_created,
            time_updated=self.time_updated,
            version=self.version)


def get_external_exadata_storage_server(external_exadata_storage_server_id: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalExadataStorageServerResult:
    """
    This data source provides details about a specific External Exadata Storage Server resource in Oracle Cloud Infrastructure Database Management service.

    Gets the summary for the Exadata storage server specified by exadataStorageServerId.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_exadata_storage_server = oci.DatabaseManagement.get_external_exadata_storage_server(external_exadata_storage_server_id=oci_database_management_external_exadata_storage_server["test_external_exadata_storage_server"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str external_exadata_storage_server_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server.
    """
    __args__ = dict()
    __args__['externalExadataStorageServerId'] = external_exadata_storage_server_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalExadataStorageServer:getExternalExadataStorageServer', __args__, opts=opts, typ=GetExternalExadataStorageServerResult).value

    return AwaitableGetExternalExadataStorageServerResult(
        additional_details=pulumi.get(__ret__, 'additional_details'),
        connectors=pulumi.get(__ret__, 'connectors'),
        cpu_count=pulumi.get(__ret__, 'cpu_count'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__ret__, 'exadata_infrastructure_id'),
        external_exadata_storage_server_id=pulumi.get(__ret__, 'external_exadata_storage_server_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        internal_id=pulumi.get(__ret__, 'internal_id'),
        ip_address=pulumi.get(__ret__, 'ip_address'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        make_model=pulumi.get(__ret__, 'make_model'),
        max_flash_disk_iops=pulumi.get(__ret__, 'max_flash_disk_iops'),
        max_flash_disk_throughput=pulumi.get(__ret__, 'max_flash_disk_throughput'),
        max_hard_disk_iops=pulumi.get(__ret__, 'max_hard_disk_iops'),
        max_hard_disk_throughput=pulumi.get(__ret__, 'max_hard_disk_throughput'),
        memory_gb=pulumi.get(__ret__, 'memory_gb'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        storage_grid_id=pulumi.get(__ret__, 'storage_grid_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_external_exadata_storage_server)
def get_external_exadata_storage_server_output(external_exadata_storage_server_id: Optional[pulumi.Input[str]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExternalExadataStorageServerResult]:
    """
    This data source provides details about a specific External Exadata Storage Server resource in Oracle Cloud Infrastructure Database Management service.

    Gets the summary for the Exadata storage server specified by exadataStorageServerId.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_exadata_storage_server = oci.DatabaseManagement.get_external_exadata_storage_server(external_exadata_storage_server_id=oci_database_management_external_exadata_storage_server["test_external_exadata_storage_server"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str external_exadata_storage_server_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server.
    """
    ...
