# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedDatabaseUserRolesResult',
    'AwaitableGetManagedDatabaseUserRolesResult',
    'get_managed_database_user_roles',
    'get_managed_database_user_roles_output',
]

@pulumi.output_type
class GetManagedDatabaseUserRolesResult:
    """
    A collection of values returned by getManagedDatabaseUserRoles.
    """
    def __init__(__self__, filters=None, id=None, managed_database_id=None, name=None, opc_named_credential_id=None, role_collections=None, user_name=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if opc_named_credential_id and not isinstance(opc_named_credential_id, str):
            raise TypeError("Expected argument 'opc_named_credential_id' to be a str")
        pulumi.set(__self__, "opc_named_credential_id", opc_named_credential_id)
        if role_collections and not isinstance(role_collections, list):
            raise TypeError("Expected argument 'role_collections' to be a list")
        pulumi.set(__self__, "role_collections", role_collections)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedDatabaseUserRolesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the role granted to the user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="opcNamedCredentialId")
    def opc_named_credential_id(self) -> Optional[str]:
        return pulumi.get(self, "opc_named_credential_id")

    @property
    @pulumi.getter(name="roleCollections")
    def role_collections(self) -> Sequence['outputs.GetManagedDatabaseUserRolesRoleCollectionResult']:
        """
        The list of role_collection.
        """
        return pulumi.get(self, "role_collections")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        return pulumi.get(self, "user_name")


class AwaitableGetManagedDatabaseUserRolesResult(GetManagedDatabaseUserRolesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseUserRolesResult(
            filters=self.filters,
            id=self.id,
            managed_database_id=self.managed_database_id,
            name=self.name,
            opc_named_credential_id=self.opc_named_credential_id,
            role_collections=self.role_collections,
            user_name=self.user_name)


def get_managed_database_user_roles(filters: Optional[Sequence[pulumi.InputType['GetManagedDatabaseUserRolesFilterArgs']]] = None,
                                    managed_database_id: Optional[str] = None,
                                    name: Optional[str] = None,
                                    opc_named_credential_id: Optional[str] = None,
                                    user_name: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseUserRolesResult:
    """
    This data source provides the list of Managed Database User Roles in Oracle Cloud Infrastructure Database Management service.

    Gets the list of roles granted to a specific user.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_user_roles = oci.DatabaseManagement.get_managed_database_user_roles(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        user_name=oci_identity_user["test_user"]["name"],
        name=var["managed_database_user_role_name"],
        opc_named_credential_id=var["managed_database_user_role_opc_named_credential_id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name: A filter to return only resources that match the entire name.
    :param str opc_named_credential_id: The OCID of the Named Credential.
    :param str user_name: The name of the user whose details are to be viewed.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['managedDatabaseId'] = managed_database_id
    __args__['name'] = name
    __args__['opcNamedCredentialId'] = opc_named_credential_id
    __args__['userName'] = user_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseUserRoles:getManagedDatabaseUserRoles', __args__, opts=opts, typ=GetManagedDatabaseUserRolesResult).value

    return AwaitableGetManagedDatabaseUserRolesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        name=pulumi.get(__ret__, 'name'),
        opc_named_credential_id=pulumi.get(__ret__, 'opc_named_credential_id'),
        role_collections=pulumi.get(__ret__, 'role_collections'),
        user_name=pulumi.get(__ret__, 'user_name'))


@_utilities.lift_output_func(get_managed_database_user_roles)
def get_managed_database_user_roles_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagedDatabaseUserRolesFilterArgs']]]]] = None,
                                           managed_database_id: Optional[pulumi.Input[str]] = None,
                                           name: Optional[pulumi.Input[Optional[str]]] = None,
                                           opc_named_credential_id: Optional[pulumi.Input[Optional[str]]] = None,
                                           user_name: Optional[pulumi.Input[str]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseUserRolesResult]:
    """
    This data source provides the list of Managed Database User Roles in Oracle Cloud Infrastructure Database Management service.

    Gets the list of roles granted to a specific user.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_user_roles = oci.DatabaseManagement.get_managed_database_user_roles(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        user_name=oci_identity_user["test_user"]["name"],
        name=var["managed_database_user_role_name"],
        opc_named_credential_id=var["managed_database_user_role_opc_named_credential_id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name: A filter to return only resources that match the entire name.
    :param str opc_named_credential_id: The OCID of the Named Credential.
    :param str user_name: The name of the user whose details are to be viewed.
    """
    ...
