# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecurityAssessmentsResult',
    'AwaitableGetSecurityAssessmentsResult',
    'get_security_assessments',
    'get_security_assessments_output',
]

@pulumi.output_type
class GetSecurityAssessmentsResult:
    """
    A collection of values returned by getSecurityAssessments.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, filters=None, id=None, is_baseline=None, is_schedule_assessment=None, schedule_assessment_id=None, security_assessments=None, state=None, target_id=None, time_created_greater_than_or_equal_to=None, time_created_less_than=None, triggered_by=None, type=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_baseline and not isinstance(is_baseline, bool):
            raise TypeError("Expected argument 'is_baseline' to be a bool")
        pulumi.set(__self__, "is_baseline", is_baseline)
        if is_schedule_assessment and not isinstance(is_schedule_assessment, bool):
            raise TypeError("Expected argument 'is_schedule_assessment' to be a bool")
        pulumi.set(__self__, "is_schedule_assessment", is_schedule_assessment)
        if schedule_assessment_id and not isinstance(schedule_assessment_id, str):
            raise TypeError("Expected argument 'schedule_assessment_id' to be a str")
        pulumi.set(__self__, "schedule_assessment_id", schedule_assessment_id)
        if security_assessments and not isinstance(security_assessments, list):
            raise TypeError("Expected argument 'security_assessments' to be a list")
        pulumi.set(__self__, "security_assessments", security_assessments)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if time_created_greater_than_or_equal_to and not isinstance(time_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than and not isinstance(time_created_less_than, str):
            raise TypeError("Expected argument 'time_created_less_than' to be a str")
        pulumi.set(__self__, "time_created_less_than", time_created_less_than)
        if triggered_by and not isinstance(triggered_by, str):
            raise TypeError("Expected argument 'triggered_by' to be a str")
        pulumi.set(__self__, "triggered_by", triggered_by)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the security assessment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the security assessment.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecurityAssessmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isBaseline")
    def is_baseline(self) -> Optional[bool]:
        """
        Indicates whether or not the security assessment is set as a baseline. This is applicable only for saved security assessments.
        """
        return pulumi.get(self, "is_baseline")

    @property
    @pulumi.getter(name="isScheduleAssessment")
    def is_schedule_assessment(self) -> Optional[bool]:
        return pulumi.get(self, "is_schedule_assessment")

    @property
    @pulumi.getter(name="scheduleAssessmentId")
    def schedule_assessment_id(self) -> Optional[str]:
        return pulumi.get(self, "schedule_assessment_id")

    @property
    @pulumi.getter(name="securityAssessments")
    def security_assessments(self) -> Sequence['outputs.GetSecurityAssessmentsSecurityAssessmentResult']:
        """
        The list of security_assessments.
        """
        return pulumi.get(self, "security_assessments")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the security assessment.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_created_less_than")

    @property
    @pulumi.getter(name="triggeredBy")
    def triggered_by(self) -> Optional[str]:
        """
        Indicates whether the security assessment was created by system or by a user.
        """
        return pulumi.get(self, "triggered_by")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of this security assessment. The possible types are:
        """
        return pulumi.get(self, "type")


class AwaitableGetSecurityAssessmentsResult(GetSecurityAssessmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityAssessmentsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            is_baseline=self.is_baseline,
            is_schedule_assessment=self.is_schedule_assessment,
            schedule_assessment_id=self.schedule_assessment_id,
            security_assessments=self.security_assessments,
            state=self.state,
            target_id=self.target_id,
            time_created_greater_than_or_equal_to=self.time_created_greater_than_or_equal_to,
            time_created_less_than=self.time_created_less_than,
            triggered_by=self.triggered_by,
            type=self.type)


def get_security_assessments(access_level: Optional[str] = None,
                             compartment_id: Optional[str] = None,
                             compartment_id_in_subtree: Optional[bool] = None,
                             display_name: Optional[str] = None,
                             filters: Optional[Sequence[pulumi.InputType['GetSecurityAssessmentsFilterArgs']]] = None,
                             is_baseline: Optional[bool] = None,
                             is_schedule_assessment: Optional[bool] = None,
                             schedule_assessment_id: Optional[str] = None,
                             state: Optional[str] = None,
                             target_id: Optional[str] = None,
                             time_created_greater_than_or_equal_to: Optional[str] = None,
                             time_created_less_than: Optional[str] = None,
                             triggered_by: Optional[str] = None,
                             type: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityAssessmentsResult:
    """
    This data source provides the list of Security Assessments in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of security assessments.

    The ListSecurityAssessments operation returns only the assessments in the specified `compartmentId`.
    The list does not include any subcompartments of the compartmentId passed.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListSecurityAssessments on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_assessments = oci.DataSafe.get_security_assessments(compartment_id=var["compartment_id"],
        access_level=var["security_assessment_access_level"],
        compartment_id_in_subtree=var["security_assessment_compartment_id_in_subtree"],
        display_name=var["security_assessment_display_name"],
        is_baseline=var["security_assessment_is_baseline"],
        is_schedule_assessment=var["security_assessment_is_schedule_assessment"],
        schedule_assessment_id=oci_data_safe_schedule_assessment["test_schedule_assessment"]["id"],
        state=var["security_assessment_state"],
        target_id=oci_cloud_guard_target["test_target"]["id"],
        time_created_greater_than_or_equal_to=var["security_assessment_time_created_greater_than_or_equal_to"],
        time_created_less_than=var["security_assessment_time_created_less_than"],
        triggered_by=var["security_assessment_triggered_by"],
        type=var["security_assessment_type"])
    ```
    <!--End PulumiCodeChooser -->


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str display_name: A filter to return only resources that match the specified display name.
    :param bool is_baseline: A filter to return only the security assessments that are set as a baseline.
    :param bool is_schedule_assessment: A filter to return only security assessments of type save schedule.
    :param str schedule_assessment_id: The OCID of the security assessment of type SAVE_SCHEDULE.
    :param str state: A filter to return only resources that match the specified lifecycle state.
    :param str target_id: A filter to return only items related to a specific target OCID.
    :param str time_created_greater_than_or_equal_to: A filter to return only the resources that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using TimeCreatedGreaterThanOrEqualToQueryParam parameter retrieves all resources created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str triggered_by: A filter to return only security asessments that were created by either user or system.
    :param str type: A filter to return only items that match the specified security assessment type.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isBaseline'] = is_baseline
    __args__['isScheduleAssessment'] = is_schedule_assessment
    __args__['scheduleAssessmentId'] = schedule_assessment_id
    __args__['state'] = state
    __args__['targetId'] = target_id
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    __args__['triggeredBy'] = triggered_by
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSecurityAssessments:getSecurityAssessments', __args__, opts=opts, typ=GetSecurityAssessmentsResult).value

    return AwaitableGetSecurityAssessmentsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_baseline=pulumi.get(__ret__, 'is_baseline'),
        is_schedule_assessment=pulumi.get(__ret__, 'is_schedule_assessment'),
        schedule_assessment_id=pulumi.get(__ret__, 'schedule_assessment_id'),
        security_assessments=pulumi.get(__ret__, 'security_assessments'),
        state=pulumi.get(__ret__, 'state'),
        target_id=pulumi.get(__ret__, 'target_id'),
        time_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__ret__, 'time_created_less_than'),
        triggered_by=pulumi.get(__ret__, 'triggered_by'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_security_assessments)
def get_security_assessments_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                    compartment_id: Optional[pulumi.Input[str]] = None,
                                    compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                    display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                    filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSecurityAssessmentsFilterArgs']]]]] = None,
                                    is_baseline: Optional[pulumi.Input[Optional[bool]]] = None,
                                    is_schedule_assessment: Optional[pulumi.Input[Optional[bool]]] = None,
                                    schedule_assessment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    state: Optional[pulumi.Input[Optional[str]]] = None,
                                    target_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    time_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                    time_created_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                                    triggered_by: Optional[pulumi.Input[Optional[str]]] = None,
                                    type: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecurityAssessmentsResult]:
    """
    This data source provides the list of Security Assessments in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of security assessments.

    The ListSecurityAssessments operation returns only the assessments in the specified `compartmentId`.
    The list does not include any subcompartments of the compartmentId passed.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListSecurityAssessments on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_assessments = oci.DataSafe.get_security_assessments(compartment_id=var["compartment_id"],
        access_level=var["security_assessment_access_level"],
        compartment_id_in_subtree=var["security_assessment_compartment_id_in_subtree"],
        display_name=var["security_assessment_display_name"],
        is_baseline=var["security_assessment_is_baseline"],
        is_schedule_assessment=var["security_assessment_is_schedule_assessment"],
        schedule_assessment_id=oci_data_safe_schedule_assessment["test_schedule_assessment"]["id"],
        state=var["security_assessment_state"],
        target_id=oci_cloud_guard_target["test_target"]["id"],
        time_created_greater_than_or_equal_to=var["security_assessment_time_created_greater_than_or_equal_to"],
        time_created_less_than=var["security_assessment_time_created_less_than"],
        triggered_by=var["security_assessment_triggered_by"],
        type=var["security_assessment_type"])
    ```
    <!--End PulumiCodeChooser -->


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str display_name: A filter to return only resources that match the specified display name.
    :param bool is_baseline: A filter to return only the security assessments that are set as a baseline.
    :param bool is_schedule_assessment: A filter to return only security assessments of type save schedule.
    :param str schedule_assessment_id: The OCID of the security assessment of type SAVE_SCHEDULE.
    :param str state: A filter to return only resources that match the specified lifecycle state.
    :param str target_id: A filter to return only items related to a specific target OCID.
    :param str time_created_greater_than_or_equal_to: A filter to return only the resources that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using TimeCreatedGreaterThanOrEqualToQueryParam parameter retrieves all resources created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str triggered_by: A filter to return only security asessments that were created by either user or system.
    :param str type: A filter to return only items that match the specified security assessment type.
    """
    ...
