# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetZonesResult',
    'AwaitableGetZonesResult',
    'get_zones',
    'get_zones_output',
]

@pulumi.output_type
class GetZonesResult:
    """
    A collection of values returned by getZones.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, name_contains=None, scope=None, sort_by=None, sort_order=None, state=None, time_created_greater_than_or_equal_to=None, time_created_less_than=None, tsig_key_id=None, view_id=None, zone_type=None, zones=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_contains and not isinstance(name_contains, str):
            raise TypeError("Expected argument 'name_contains' to be a str")
        pulumi.set(__self__, "name_contains", name_contains)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)
        if sort_by and not isinstance(sort_by, str):
            raise TypeError("Expected argument 'sort_by' to be a str")
        pulumi.set(__self__, "sort_by", sort_by)
        if sort_order and not isinstance(sort_order, str):
            raise TypeError("Expected argument 'sort_order' to be a str")
        pulumi.set(__self__, "sort_order", sort_order)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created_greater_than_or_equal_to and not isinstance(time_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than and not isinstance(time_created_less_than, str):
            raise TypeError("Expected argument 'time_created_less_than' to be a str")
        pulumi.set(__self__, "time_created_less_than", time_created_less_than)
        if tsig_key_id and not isinstance(tsig_key_id, str):
            raise TypeError("Expected argument 'tsig_key_id' to be a str")
        pulumi.set(__self__, "tsig_key_id", tsig_key_id)
        if view_id and not isinstance(view_id, str):
            raise TypeError("Expected argument 'view_id' to be a str")
        pulumi.set(__self__, "view_id", view_id)
        if zone_type and not isinstance(zone_type, str):
            raise TypeError("Expected argument 'zone_type' to be a str")
        pulumi.set(__self__, "zone_type", zone_type)
        if zones and not isinstance(zones, list):
            raise TypeError("Expected argument 'zones' to be a list")
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the zone.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetZonesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the zone.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameContains")
    def name_contains(self) -> Optional[str]:
        return pulumi.get(self, "name_contains")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The scope of the zone.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="sortBy")
    def sort_by(self) -> Optional[str]:
        return pulumi.get(self, "sort_by")

    @property
    @pulumi.getter(name="sortOrder")
    def sort_order(self) -> Optional[str]:
        return pulumi.get(self, "sort_order")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the zone resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_created_less_than")

    @property
    @pulumi.getter(name="tsigKeyId")
    def tsig_key_id(self) -> Optional[str]:
        """
        The OCID of the TSIG key.
        """
        return pulumi.get(self, "tsig_key_id")

    @property
    @pulumi.getter(name="viewId")
    def view_id(self) -> Optional[str]:
        """
        The OCID of the private view containing the zone. This value will be null for zones in the global DNS, which are publicly resolvable and not part of a private view.
        """
        return pulumi.get(self, "view_id")

    @property
    @pulumi.getter(name="zoneType")
    def zone_type(self) -> Optional[str]:
        """
        The type of the zone. Must be either `PRIMARY` or `SECONDARY`. `SECONDARY` is only supported for GLOBAL zones.
        """
        return pulumi.get(self, "zone_type")

    @property
    @pulumi.getter
    def zones(self) -> Sequence['outputs.GetZonesZoneResult']:
        """
        The list of zones.
        """
        return pulumi.get(self, "zones")


class AwaitableGetZonesResult(GetZonesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZonesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            name_contains=self.name_contains,
            scope=self.scope,
            sort_by=self.sort_by,
            sort_order=self.sort_order,
            state=self.state,
            time_created_greater_than_or_equal_to=self.time_created_greater_than_or_equal_to,
            time_created_less_than=self.time_created_less_than,
            tsig_key_id=self.tsig_key_id,
            view_id=self.view_id,
            zone_type=self.zone_type,
            zones=self.zones)


def get_zones(compartment_id: Optional[str] = None,
              filters: Optional[Sequence[pulumi.InputType['GetZonesFilterArgs']]] = None,
              name: Optional[str] = None,
              name_contains: Optional[str] = None,
              scope: Optional[str] = None,
              sort_by: Optional[str] = None,
              sort_order: Optional[str] = None,
              state: Optional[str] = None,
              time_created_greater_than_or_equal_to: Optional[str] = None,
              time_created_less_than: Optional[str] = None,
              tsig_key_id: Optional[str] = None,
              view_id: Optional[str] = None,
              zone_type: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZonesResult:
    """
    This data source provides the list of Zones in Oracle Cloud Infrastructure DNS service.

    Gets a list of all zones in the specified compartment. The collection
    can be filtered by name, time created, scope, associated view, and zone type.
    Additionally, for Private DNS, the `scope` query parameter is required when
    listing private zones.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_zones = oci.Dns.get_zones(compartment_id=var["compartment_id"],
        name=var["zone_name"],
        name_contains=var["zone_name_contains"],
        scope=var["zone_scope"],
        state=var["zone_state"],
        time_created_greater_than_or_equal_to=var["zone_time_created_greater_than_or_equal_to"],
        time_created_less_than=var["zone_time_created_less_than"],
        tsig_key_id=oci_dns_tsig_key["test_tsig_key"]["id"],
        view_id=oci_dns_view["test_view"]["id"],
        zone_type=var["zone_zone_type"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment the resource belongs to.
    :param str name: A case-sensitive filter for zone names. Will match any zone with a name that equals the provided value.
    :param str name_contains: Search by zone name. Will match any zone whose name (case-insensitive) contains the provided value.
    :param str scope: Specifies to operate only on resources that have a matching DNS scope. This value will be null 
           for zones in the global DNS and `PRIVATE` when listing private zones.
    :param str sort_by: The field by which to sort zones. Allowed values are: name|zoneType|timeCreated
    :param str sort_order: The order to sort the resources. Allowed values are: ASC|DESC
    :param str state: The state of a resource.
    :param str time_created_greater_than_or_equal_to: An [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) timestamp that states all returned resources were created on or after the indicated time.
    :param str time_created_less_than: An [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) timestamp that states all returned resources were created before the indicated time.
    :param str tsig_key_id: Search for zones that are associated with a TSIG key.
    :param str view_id: The OCID of the view the resource is associated with.
    :param str zone_type: Search by zone type, `PRIMARY` or `SECONDARY`. Will match any zone whose type equals the provided value.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['nameContains'] = name_contains
    __args__['scope'] = scope
    __args__['sortBy'] = sort_by
    __args__['sortOrder'] = sort_order
    __args__['state'] = state
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    __args__['tsigKeyId'] = tsig_key_id
    __args__['viewId'] = view_id
    __args__['zoneType'] = zone_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Dns/getZones:getZones', __args__, opts=opts, typ=GetZonesResult).value

    return AwaitableGetZonesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        name_contains=pulumi.get(__ret__, 'name_contains'),
        scope=pulumi.get(__ret__, 'scope'),
        sort_by=pulumi.get(__ret__, 'sort_by'),
        sort_order=pulumi.get(__ret__, 'sort_order'),
        state=pulumi.get(__ret__, 'state'),
        time_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__ret__, 'time_created_less_than'),
        tsig_key_id=pulumi.get(__ret__, 'tsig_key_id'),
        view_id=pulumi.get(__ret__, 'view_id'),
        zone_type=pulumi.get(__ret__, 'zone_type'),
        zones=pulumi.get(__ret__, 'zones'))


@_utilities.lift_output_func(get_zones)
def get_zones_output(compartment_id: Optional[pulumi.Input[str]] = None,
                     filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetZonesFilterArgs']]]]] = None,
                     name: Optional[pulumi.Input[Optional[str]]] = None,
                     name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                     scope: Optional[pulumi.Input[Optional[str]]] = None,
                     sort_by: Optional[pulumi.Input[Optional[str]]] = None,
                     sort_order: Optional[pulumi.Input[Optional[str]]] = None,
                     state: Optional[pulumi.Input[Optional[str]]] = None,
                     time_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                     time_created_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                     tsig_key_id: Optional[pulumi.Input[Optional[str]]] = None,
                     view_id: Optional[pulumi.Input[Optional[str]]] = None,
                     zone_type: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetZonesResult]:
    """
    This data source provides the list of Zones in Oracle Cloud Infrastructure DNS service.

    Gets a list of all zones in the specified compartment. The collection
    can be filtered by name, time created, scope, associated view, and zone type.
    Additionally, for Private DNS, the `scope` query parameter is required when
    listing private zones.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_zones = oci.Dns.get_zones(compartment_id=var["compartment_id"],
        name=var["zone_name"],
        name_contains=var["zone_name_contains"],
        scope=var["zone_scope"],
        state=var["zone_state"],
        time_created_greater_than_or_equal_to=var["zone_time_created_greater_than_or_equal_to"],
        time_created_less_than=var["zone_time_created_less_than"],
        tsig_key_id=oci_dns_tsig_key["test_tsig_key"]["id"],
        view_id=oci_dns_view["test_view"]["id"],
        zone_type=var["zone_zone_type"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment the resource belongs to.
    :param str name: A case-sensitive filter for zone names. Will match any zone with a name that equals the provided value.
    :param str name_contains: Search by zone name. Will match any zone whose name (case-insensitive) contains the provided value.
    :param str scope: Specifies to operate only on resources that have a matching DNS scope. This value will be null 
           for zones in the global DNS and `PRIVATE` when listing private zones.
    :param str sort_by: The field by which to sort zones. Allowed values are: name|zoneType|timeCreated
    :param str sort_order: The order to sort the resources. Allowed values are: ASC|DESC
    :param str state: The state of a resource.
    :param str time_created_greater_than_or_equal_to: An [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) timestamp that states all returned resources were created on or after the indicated time.
    :param str time_created_less_than: An [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) timestamp that states all returned resources were created before the indicated time.
    :param str tsig_key_id: Search for zones that are associated with a TSIG key.
    :param str view_id: The OCID of the view the resource is associated with.
    :param str zone_type: Search by zone type, `PRIMARY` or `SECONDARY`. Will match any zone whose type equals the provided value.
    """
    ...
