# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'RuleActions',
    'RuleActionsAction',
    'GetRuleActionResult',
    'GetRuleActionActionResult',
    'GetRulesFilterResult',
    'GetRulesRuleResult',
    'GetRulesRuleActionResult',
    'GetRulesRuleActionActionResult',
]

@pulumi.output_type
class RuleActions(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.RuleActionsAction']):
        """
        :param Sequence['RuleActionsActionArgs'] actions: (Updatable) A list of one or more ActionDetails objects.
        """
        pulumi.set(__self__, "actions", actions)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.RuleActionsAction']:
        """
        (Updatable) A list of one or more ActionDetails objects.
        """
        return pulumi.get(self, "actions")


@pulumi.output_type
class RuleActionsAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "functionId":
            suggest = "function_id"
        elif key == "lifecycleMessage":
            suggest = "lifecycle_message"
        elif key == "streamId":
            suggest = "stream_id"
        elif key == "topicId":
            suggest = "topic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleActionsAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleActionsAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleActionsAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_type: str,
                 is_enabled: bool,
                 description: Optional[str] = None,
                 function_id: Optional[str] = None,
                 id: Optional[str] = None,
                 lifecycle_message: Optional[str] = None,
                 state: Optional[str] = None,
                 stream_id: Optional[str] = None,
                 topic_id: Optional[str] = None):
        """
        :param str action_type: (Updatable) The action to perform if the condition in the rule matches an event.
               * **ONS:** Send to an Oracle Notification Service topic.
               * **OSS:** Send to a stream from Oracle Streaming Service.
               * **FAAS:** Send to an Oracle Functions Service endpoint.
        :param bool is_enabled: (Updatable) Whether or not this rule is currently enabled.  Example: `true` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param str description: (Updatable) A string that describes the details of the rule. It does not have to be unique, and you can change it. Avoid entering confidential information.
        :param str function_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Function hosted by Oracle Functions Service.
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this rule.
        :param str lifecycle_message: A message generated by the Events service about the current state of this rule.
        :param str state: The current state of the rule.
        :param str stream_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream to which messages are delivered.
        :param str topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic to which messages are delivered.
        """
        pulumi.set(__self__, "action_type", action_type)
        pulumi.set(__self__, "is_enabled", is_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if function_id is not None:
            pulumi.set(__self__, "function_id", function_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if lifecycle_message is not None:
            pulumi.set(__self__, "lifecycle_message", lifecycle_message)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)
        if topic_id is not None:
            pulumi.set(__self__, "topic_id", topic_id)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        (Updatable) The action to perform if the condition in the rule matches an event.
        * **ONS:** Send to an Oracle Notification Service topic.
        * **OSS:** Send to a stream from Oracle Streaming Service.
        * **FAAS:** Send to an Oracle Functions Service endpoint.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        (Updatable) Whether or not this rule is currently enabled.  Example: `true` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        (Updatable) A string that describes the details of the rule. It does not have to be unique, and you can change it. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Function hosted by Oracle Functions Service.
        """
        return pulumi.get(self, "function_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleMessage")
    def lifecycle_message(self) -> Optional[str]:
        """
        A message generated by the Events service about the current state of this rule.
        """
        return pulumi.get(self, "lifecycle_message")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the rule.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream to which messages are delivered.
        """
        return pulumi.get(self, "stream_id")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic to which messages are delivered.
        """
        return pulumi.get(self, "topic_id")


@pulumi.output_type
class GetRuleActionResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetRuleActionActionResult']):
        """
        :param Sequence['GetRuleActionActionArgs'] actions: A list of one or more Action objects.
        """
        pulumi.set(__self__, "actions", actions)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetRuleActionActionResult']:
        """
        A list of one or more Action objects.
        """
        return pulumi.get(self, "actions")


@pulumi.output_type
class GetRuleActionActionResult(dict):
    def __init__(__self__, *,
                 action_type: str,
                 description: str,
                 function_id: str,
                 id: str,
                 is_enabled: bool,
                 lifecycle_message: str,
                 state: str,
                 stream_id: str,
                 topic_id: str):
        """
        :param str action_type: The action to perform if the condition in the rule matches an event.
               * **ONS:** Send to an Oracle Notification Service topic.
               * **OSS:** Send to a stream from Oracle Streaming Service.
               * **FAAS:** Send to an Oracle Functions Service endpoint.
        :param str description: A string that describes the details of the rule. It does not have to be unique, and you can change it. Avoid entering confidential information.
        :param str function_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Function hosted by Oracle Functions Service.
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this rule.
        :param bool is_enabled: Whether or not this rule is currently enabled.  Example: `true`
        :param str lifecycle_message: A message generated by the Events service about the current state of this rule.
        :param str state: The current state of the rule.
        :param str stream_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream to which messages are delivered.
        :param str topic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic to which messages are delivered.
        """
        pulumi.set(__self__, "action_type", action_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "function_id", function_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "lifecycle_message", lifecycle_message)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "stream_id", stream_id)
        pulumi.set(__self__, "topic_id", topic_id)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        The action to perform if the condition in the rule matches an event.
        * **ONS:** Send to an Oracle Notification Service topic.
        * **OSS:** Send to a stream from Oracle Streaming Service.
        * **FAAS:** Send to an Oracle Functions Service endpoint.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A string that describes the details of the rule. It does not have to be unique, and you can change it. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Function hosted by Oracle Functions Service.
        """
        return pulumi.get(self, "function_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether or not this rule is currently enabled.  Example: `true`
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="lifecycleMessage")
    def lifecycle_message(self) -> str:
        """
        A message generated by the Events service about the current state of this rule.
        """
        return pulumi.get(self, "lifecycle_message")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the rule.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream to which messages are delivered.
        """
        return pulumi.get(self, "stream_id")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic to which messages are delivered.
        """
        return pulumi.get(self, "topic_id")


@pulumi.output_type
class GetRulesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRulesRuleResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetRulesRuleActionResult'],
                 compartment_id: str,
                 condition: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_enabled: bool,
                 lifecycle_message: str,
                 state: str,
                 time_created: str):
        """
        :param Sequence['GetRulesRuleActionArgs'] actions: A list of one or more Action objects.
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to which this rule belongs.
        :param str condition: A filter that specifies the event that will trigger actions associated with this rule. A few  important things to remember about filters:
               * Fields not mentioned in the condition are ignored. You can create a valid filter that matches all events with two curly brackets: `{}`
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str description: A string that describes the details of the rule. It does not have to be unique, and you can change it. Avoid entering confidential information.
        :param str display_name: A filter to return only rules with descriptions that match the displayName string in this parameter.  Example: `"This rule sends a notification upon completion of DbaaS backup."`
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this rule.
        :param bool is_enabled: Whether or not this rule is currently enabled.  Example: `true`
        :param str lifecycle_message: A message generated by the Events service about the current state of this rule.
        :param str state: A filter to return only rules that match the lifecycle state in this parameter.  Example: `Creating`
        :param str time_created: The time this rule was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "lifecycle_message", lifecycle_message)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetRulesRuleActionResult']:
        """
        A list of one or more Action objects.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to which this rule belongs.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        A filter that specifies the event that will trigger actions associated with this rule. A few  important things to remember about filters:
        * Fields not mentioned in the condition are ignored. You can create a valid filter that matches all events with two curly brackets: `{}`
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A string that describes the details of the rule. It does not have to be unique, and you can change it. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only rules with descriptions that match the displayName string in this parameter.  Example: `"This rule sends a notification upon completion of DbaaS backup."`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether or not this rule is currently enabled.  Example: `true`
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="lifecycleMessage")
    def lifecycle_message(self) -> str:
        """
        A message generated by the Events service about the current state of this rule.
        """
        return pulumi.get(self, "lifecycle_message")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only rules that match the lifecycle state in this parameter.  Example: `Creating`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this rule was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetRulesRuleActionResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetRulesRuleActionActionResult']):
        """
        :param Sequence['GetRulesRuleActionActionArgs'] actions: A list of one or more Action objects.
        """
        pulumi.set(__self__, "actions", actions)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetRulesRuleActionActionResult']:
        """
        A list of one or more Action objects.
        """
        return pulumi.get(self, "actions")


@pulumi.output_type
class GetRulesRuleActionActionResult(dict):
    def __init__(__self__, *,
                 action_type: str,
                 description: str,
                 function_id: str,
                 id: str,
                 is_enabled: bool,
                 lifecycle_message: str,
                 state: str,
                 stream_id: str,
                 topic_id: str):
        """
        :param str action_type: The action to perform if the condition in the rule matches an event.
               * **ONS:** Send to an Oracle Notification Service topic.
               * **OSS:** Send to a stream from Oracle Streaming Service.
               * **FAAS:** Send to an Oracle Functions Service endpoint.
        :param str description: A string that describes the details of the rule. It does not have to be unique, and you can change it. Avoid entering confidential information.
        :param str function_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Function hosted by Oracle Functions Service.
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this rule.
        :param bool is_enabled: Whether or not this rule is currently enabled.  Example: `true`
        :param str lifecycle_message: A message generated by the Events service about the current state of this rule.
        :param str state: A filter to return only rules that match the lifecycle state in this parameter.  Example: `Creating`
        :param str stream_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream to which messages are delivered.
        :param str topic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic to which messages are delivered.
        """
        pulumi.set(__self__, "action_type", action_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "function_id", function_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "lifecycle_message", lifecycle_message)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "stream_id", stream_id)
        pulumi.set(__self__, "topic_id", topic_id)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        The action to perform if the condition in the rule matches an event.
        * **ONS:** Send to an Oracle Notification Service topic.
        * **OSS:** Send to a stream from Oracle Streaming Service.
        * **FAAS:** Send to an Oracle Functions Service endpoint.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A string that describes the details of the rule. It does not have to be unique, and you can change it. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Function hosted by Oracle Functions Service.
        """
        return pulumi.get(self, "function_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether or not this rule is currently enabled.  Example: `true`
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="lifecycleMessage")
    def lifecycle_message(self) -> str:
        """
        A message generated by the Events service about the current state of this rule.
        """
        return pulumi.get(self, "lifecycle_message")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only rules that match the lifecycle state in this parameter.  Example: `Creating`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream to which messages are delivered.
        """
        return pulumi.get(self, "stream_id")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic to which messages are delivered.
        """
        return pulumi.get(self, "topic_id")


