# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetJavaDownloadsJavaDownloadRecordsResult',
    'AwaitableGetJavaDownloadsJavaDownloadRecordsResult',
    'get_java_downloads_java_download_records',
    'get_java_downloads_java_download_records_output',
]

@pulumi.output_type
class GetJavaDownloadsJavaDownloadRecordsResult:
    """
    A collection of values returned by getJavaDownloadsJavaDownloadRecords.
    """
    def __init__(__self__, architecture=None, compartment_id=None, family_version=None, filters=None, id=None, java_download_record_collections=None, os_family=None, package_type_detail=None, release_version=None, time_end=None, time_start=None):
        if architecture and not isinstance(architecture, str):
            raise TypeError("Expected argument 'architecture' to be a str")
        pulumi.set(__self__, "architecture", architecture)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if family_version and not isinstance(family_version, str):
            raise TypeError("Expected argument 'family_version' to be a str")
        pulumi.set(__self__, "family_version", family_version)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if java_download_record_collections and not isinstance(java_download_record_collections, list):
            raise TypeError("Expected argument 'java_download_record_collections' to be a list")
        pulumi.set(__self__, "java_download_record_collections", java_download_record_collections)
        if os_family and not isinstance(os_family, str):
            raise TypeError("Expected argument 'os_family' to be a str")
        pulumi.set(__self__, "os_family", os_family)
        if package_type_detail and not isinstance(package_type_detail, str):
            raise TypeError("Expected argument 'package_type_detail' to be a str")
        pulumi.set(__self__, "package_type_detail", package_type_detail)
        if release_version and not isinstance(release_version, str):
            raise TypeError("Expected argument 'release_version' to be a str")
        pulumi.set(__self__, "release_version", release_version)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[str]:
        """
        The target Operating System architecture for the artifact.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="familyVersion")
    def family_version(self) -> Optional[str]:
        """
        The Java family version identifier.
        """
        return pulumi.get(self, "family_version")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetJavaDownloadsJavaDownloadRecordsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="javaDownloadRecordCollections")
    def java_download_record_collections(self) -> Sequence['outputs.GetJavaDownloadsJavaDownloadRecordsJavaDownloadRecordCollectionResult']:
        """
        The list of java_download_record_collection.
        """
        return pulumi.get(self, "java_download_record_collections")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[str]:
        """
        The target Operating System family for the artifact.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="packageTypeDetail")
    def package_type_detail(self) -> Optional[str]:
        """
        Additional information about the package type.
        """
        return pulumi.get(self, "package_type_detail")

    @property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> Optional[str]:
        """
        The Java release version identifier.
        """
        return pulumi.get(self, "release_version")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> Optional[str]:
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[str]:
        return pulumi.get(self, "time_start")


class AwaitableGetJavaDownloadsJavaDownloadRecordsResult(GetJavaDownloadsJavaDownloadRecordsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJavaDownloadsJavaDownloadRecordsResult(
            architecture=self.architecture,
            compartment_id=self.compartment_id,
            family_version=self.family_version,
            filters=self.filters,
            id=self.id,
            java_download_record_collections=self.java_download_record_collections,
            os_family=self.os_family,
            package_type_detail=self.package_type_detail,
            release_version=self.release_version,
            time_end=self.time_end,
            time_start=self.time_start)


def get_java_downloads_java_download_records(architecture: Optional[str] = None,
                                             compartment_id: Optional[str] = None,
                                             family_version: Optional[str] = None,
                                             filters: Optional[Sequence[pulumi.InputType['GetJavaDownloadsJavaDownloadRecordsFilterArgs']]] = None,
                                             os_family: Optional[str] = None,
                                             package_type_detail: Optional[str] = None,
                                             release_version: Optional[str] = None,
                                             time_end: Optional[str] = None,
                                             time_start: Optional[str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJavaDownloadsJavaDownloadRecordsResult:
    """
    This data source provides the list of Java Download Records in Oracle Cloud Infrastructure Jms Java Downloads service.

    Returns a list of Java download records in a tenancy based on specified parameters.
    See [JavaReleases API](https://docs.cloud.oracle.com/iaas/api/#/en/jms/20210610/JavaRelease/ListJavaReleases)
    for possible values of `javaFamilyVersion` and `javaReleaseVersion` parameters.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_download_records = oci.Jms.get_java_downloads_java_download_records(compartment_id=var["compartment_id"],
        architecture=var["java_download_record_architecture"],
        family_version=var["java_download_record_family_version"],
        os_family=var["java_download_record_os_family"],
        package_type_detail=var["java_download_record_package_type_detail"],
        release_version=var["java_download_record_release_version"],
        time_end=var["java_download_record_time_end"],
        time_start=var["java_download_record_time_start"])
    ```
    <!--End PulumiCodeChooser -->


    :param str architecture: Target Operating System architecture of the artifact.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy.
    :param str family_version: Unique Java family version identifier.
    :param str os_family: Target Operating System family of the artifact.
    :param str package_type_detail: Packaging type detail of the artifact.
    :param str release_version: Unique Java release version identifier.
    :param str time_end: The end of the time period for which reports are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param str time_start: The start of the time period for which reports are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['architecture'] = architecture
    __args__['compartmentId'] = compartment_id
    __args__['familyVersion'] = family_version
    __args__['filters'] = filters
    __args__['osFamily'] = os_family
    __args__['packageTypeDetail'] = package_type_detail
    __args__['releaseVersion'] = release_version
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getJavaDownloadsJavaDownloadRecords:getJavaDownloadsJavaDownloadRecords', __args__, opts=opts, typ=GetJavaDownloadsJavaDownloadRecordsResult).value

    return AwaitableGetJavaDownloadsJavaDownloadRecordsResult(
        architecture=pulumi.get(__ret__, 'architecture'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        family_version=pulumi.get(__ret__, 'family_version'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        java_download_record_collections=pulumi.get(__ret__, 'java_download_record_collections'),
        os_family=pulumi.get(__ret__, 'os_family'),
        package_type_detail=pulumi.get(__ret__, 'package_type_detail'),
        release_version=pulumi.get(__ret__, 'release_version'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'))


@_utilities.lift_output_func(get_java_downloads_java_download_records)
def get_java_downloads_java_download_records_output(architecture: Optional[pulumi.Input[Optional[str]]] = None,
                                                    compartment_id: Optional[pulumi.Input[str]] = None,
                                                    family_version: Optional[pulumi.Input[Optional[str]]] = None,
                                                    filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetJavaDownloadsJavaDownloadRecordsFilterArgs']]]]] = None,
                                                    os_family: Optional[pulumi.Input[Optional[str]]] = None,
                                                    package_type_detail: Optional[pulumi.Input[Optional[str]]] = None,
                                                    release_version: Optional[pulumi.Input[Optional[str]]] = None,
                                                    time_end: Optional[pulumi.Input[Optional[str]]] = None,
                                                    time_start: Optional[pulumi.Input[Optional[str]]] = None,
                                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetJavaDownloadsJavaDownloadRecordsResult]:
    """
    This data source provides the list of Java Download Records in Oracle Cloud Infrastructure Jms Java Downloads service.

    Returns a list of Java download records in a tenancy based on specified parameters.
    See [JavaReleases API](https://docs.cloud.oracle.com/iaas/api/#/en/jms/20210610/JavaRelease/ListJavaReleases)
    for possible values of `javaFamilyVersion` and `javaReleaseVersion` parameters.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_download_records = oci.Jms.get_java_downloads_java_download_records(compartment_id=var["compartment_id"],
        architecture=var["java_download_record_architecture"],
        family_version=var["java_download_record_family_version"],
        os_family=var["java_download_record_os_family"],
        package_type_detail=var["java_download_record_package_type_detail"],
        release_version=var["java_download_record_release_version"],
        time_end=var["java_download_record_time_end"],
        time_start=var["java_download_record_time_start"])
    ```
    <!--End PulumiCodeChooser -->


    :param str architecture: Target Operating System architecture of the artifact.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy.
    :param str family_version: Unique Java family version identifier.
    :param str os_family: Target Operating System family of the artifact.
    :param str package_type_detail: Packaging type detail of the artifact.
    :param str release_version: Unique Java release version identifier.
    :param str time_end: The end of the time period for which reports are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param str time_start: The start of the time period for which reports are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    ...
