# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IngressGatewayArgs', 'IngressGateway']

@pulumi.input_type
class IngressGatewayArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 hosts: pulumi.Input[Sequence[pulumi.Input['IngressGatewayHostArgs']]],
                 mesh_id: pulumi.Input[str],
                 access_logging: Optional[pulumi.Input['IngressGatewayAccessLoggingArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 mtls: Optional[pulumi.Input['IngressGatewayMtlsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IngressGateway resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input['IngressGatewayHostArgs']]] hosts: (Updatable) An array of hostnames and their listener configuration that this gateway will bind to.
        :param pulumi.Input[str] mesh_id: The OCID of the service mesh in which this ingress gateway is created.
        :param pulumi.Input['IngressGatewayAccessLoggingArgs'] access_logging: (Updatable) This configuration determines if logging is enabled and where the logs will be output.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Description of the resource. It can be changed after creation. Avoid entering confidential information.  Example: `This is my new resource`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input['IngressGatewayMtlsArgs'] mtls: (Updatable) Mutual TLS settings used when sending requests to virtual services within the mesh.
        :param pulumi.Input[str] name: A user-friendly name. The name has to be unique within the same service mesh and cannot be changed after creation. Avoid entering confidential information.  Example: `My unique resource name` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "mesh_id", mesh_id)
        if access_logging is not None:
            pulumi.set(__self__, "access_logging", access_logging)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if mtls is not None:
            pulumi.set(__self__, "mtls", mtls)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Input[Sequence[pulumi.Input['IngressGatewayHostArgs']]]:
        """
        (Updatable) An array of hostnames and their listener configuration that this gateway will bind to.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: pulumi.Input[Sequence[pulumi.Input['IngressGatewayHostArgs']]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter(name="meshId")
    def mesh_id(self) -> pulumi.Input[str]:
        """
        The OCID of the service mesh in which this ingress gateway is created.
        """
        return pulumi.get(self, "mesh_id")

    @mesh_id.setter
    def mesh_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "mesh_id", value)

    @property
    @pulumi.getter(name="accessLogging")
    def access_logging(self) -> Optional[pulumi.Input['IngressGatewayAccessLoggingArgs']]:
        """
        (Updatable) This configuration determines if logging is enabled and where the logs will be output.
        """
        return pulumi.get(self, "access_logging")

    @access_logging.setter
    def access_logging(self, value: Optional[pulumi.Input['IngressGatewayAccessLoggingArgs']]):
        pulumi.set(self, "access_logging", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description of the resource. It can be changed after creation. Avoid entering confidential information.  Example: `This is my new resource`
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def mtls(self) -> Optional[pulumi.Input['IngressGatewayMtlsArgs']]:
        """
        (Updatable) Mutual TLS settings used when sending requests to virtual services within the mesh.
        """
        return pulumi.get(self, "mtls")

    @mtls.setter
    def mtls(self, value: Optional[pulumi.Input['IngressGatewayMtlsArgs']]):
        pulumi.set(self, "mtls", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name. The name has to be unique within the same service mesh and cannot be changed after creation. Avoid entering confidential information.  Example: `My unique resource name` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _IngressGatewayState:
    def __init__(__self__, *,
                 access_logging: Optional[pulumi.Input['IngressGatewayAccessLoggingArgs']] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['IngressGatewayHostArgs']]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 mesh_id: Optional[pulumi.Input[str]] = None,
                 mtls: Optional[pulumi.Input['IngressGatewayMtlsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IngressGateway resources.
        :param pulumi.Input['IngressGatewayAccessLoggingArgs'] access_logging: (Updatable) This configuration determines if logging is enabled and where the logs will be output.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Description of the resource. It can be changed after creation. Avoid entering confidential information.  Example: `This is my new resource`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['IngressGatewayHostArgs']]] hosts: (Updatable) An array of hostnames and their listener configuration that this gateway will bind to.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed state.
        :param pulumi.Input[str] mesh_id: The OCID of the service mesh in which this ingress gateway is created.
        :param pulumi.Input['IngressGatewayMtlsArgs'] mtls: (Updatable) Mutual TLS settings used when sending requests to virtual services within the mesh.
        :param pulumi.Input[str] name: A user-friendly name. The name has to be unique within the same service mesh and cannot be changed after creation. Avoid entering confidential information.  Example: `My unique resource name` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the Resource.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time when this resource was created in an RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when this resource was updated in an RFC3339 formatted datetime string.
        """
        if access_logging is not None:
            pulumi.set(__self__, "access_logging", access_logging)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if mesh_id is not None:
            pulumi.set(__self__, "mesh_id", mesh_id)
        if mtls is not None:
            pulumi.set(__self__, "mtls", mtls)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="accessLogging")
    def access_logging(self) -> Optional[pulumi.Input['IngressGatewayAccessLoggingArgs']]:
        """
        (Updatable) This configuration determines if logging is enabled and where the logs will be output.
        """
        return pulumi.get(self, "access_logging")

    @access_logging.setter
    def access_logging(self, value: Optional[pulumi.Input['IngressGatewayAccessLoggingArgs']]):
        pulumi.set(self, "access_logging", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description of the resource. It can be changed after creation. Avoid entering confidential information.  Example: `This is my new resource`
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IngressGatewayHostArgs']]]]:
        """
        (Updatable) An array of hostnames and their listener configuration that this gateway will bind to.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IngressGatewayHostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="meshId")
    def mesh_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the service mesh in which this ingress gateway is created.
        """
        return pulumi.get(self, "mesh_id")

    @mesh_id.setter
    def mesh_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mesh_id", value)

    @property
    @pulumi.getter
    def mtls(self) -> Optional[pulumi.Input['IngressGatewayMtlsArgs']]:
        """
        (Updatable) Mutual TLS settings used when sending requests to virtual services within the mesh.
        """
        return pulumi.get(self, "mtls")

    @mtls.setter
    def mtls(self, value: Optional[pulumi.Input['IngressGatewayMtlsArgs']]):
        pulumi.set(self, "mtls", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name. The name has to be unique within the same service mesh and cannot be changed after creation. Avoid entering confidential information.  Example: `My unique resource name` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time when this resource was created in an RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time when this resource was updated in an RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class IngressGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_logging: Optional[pulumi.Input[pulumi.InputType['IngressGatewayAccessLoggingArgs']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IngressGatewayHostArgs']]]]] = None,
                 mesh_id: Optional[pulumi.Input[str]] = None,
                 mtls: Optional[pulumi.Input[pulumi.InputType['IngressGatewayMtlsArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Ingress Gateway resource in Oracle Cloud Infrastructure Service Mesh service.

        Creates a new IngressGateway.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_ingress_gateway = oci.service_mesh.IngressGateway("testIngressGateway",
            compartment_id=var["compartment_id"],
            hosts=[oci.service_mesh.IngressGatewayHostArgs(
                listeners=[oci.service_mesh.IngressGatewayHostListenerArgs(
                    port=var["ingress_gateway_hosts_listeners_port"],
                    protocol=var["ingress_gateway_hosts_listeners_protocol"],
                    tls=oci.service_mesh.IngressGatewayHostListenerTlsArgs(
                        mode=var["ingress_gateway_hosts_listeners_tls_mode"],
                        client_validation=oci.service_mesh.IngressGatewayHostListenerTlsClientValidationArgs(
                            subject_alternate_names=var["ingress_gateway_hosts_listeners_tls_client_validation_subject_alternate_names"],
                            trusted_ca_bundle=oci.service_mesh.IngressGatewayHostListenerTlsClientValidationTrustedCaBundleArgs(
                                type=var["ingress_gateway_hosts_listeners_tls_client_validation_trusted_ca_bundle_type"],
                                ca_bundle_id=oci_certificates_management_ca_bundle["test_ca_bundle"]["id"],
                                secret_name=oci_vault_secret["test_secret"]["name"],
                            ),
                        ),
                        server_certificate=oci.service_mesh.IngressGatewayHostListenerTlsServerCertificateArgs(
                            type=var["ingress_gateway_hosts_listeners_tls_server_certificate_type"],
                            certificate_id=oci_certificates_management_certificate["test_certificate"]["id"],
                            secret_name=oci_vault_secret["test_secret"]["name"],
                        ),
                    ),
                )],
                name=var["ingress_gateway_hosts_name"],
                hostnames=var["ingress_gateway_hosts_hostnames"],
            )],
            mesh_id=oci_service_mesh_mesh["test_mesh"]["id"],
            access_logging=oci.service_mesh.IngressGatewayAccessLoggingArgs(
                is_enabled=var["ingress_gateway_access_logging_is_enabled"],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["ingress_gateway_description"],
            freeform_tags={
                "bar-key": "value",
            },
            mtls=oci.service_mesh.IngressGatewayMtlsArgs(
                maximum_validity=var["ingress_gateway_mtls_maximum_validity"],
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        IngressGateways can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ServiceMesh/ingressGateway:IngressGateway test_ingress_gateway "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['IngressGatewayAccessLoggingArgs']] access_logging: (Updatable) This configuration determines if logging is enabled and where the logs will be output.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Description of the resource. It can be changed after creation. Avoid entering confidential information.  Example: `This is my new resource`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IngressGatewayHostArgs']]]] hosts: (Updatable) An array of hostnames and their listener configuration that this gateway will bind to.
        :param pulumi.Input[str] mesh_id: The OCID of the service mesh in which this ingress gateway is created.
        :param pulumi.Input[pulumi.InputType['IngressGatewayMtlsArgs']] mtls: (Updatable) Mutual TLS settings used when sending requests to virtual services within the mesh.
        :param pulumi.Input[str] name: A user-friendly name. The name has to be unique within the same service mesh and cannot be changed after creation. Avoid entering confidential information.  Example: `My unique resource name` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IngressGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Ingress Gateway resource in Oracle Cloud Infrastructure Service Mesh service.

        Creates a new IngressGateway.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_ingress_gateway = oci.service_mesh.IngressGateway("testIngressGateway",
            compartment_id=var["compartment_id"],
            hosts=[oci.service_mesh.IngressGatewayHostArgs(
                listeners=[oci.service_mesh.IngressGatewayHostListenerArgs(
                    port=var["ingress_gateway_hosts_listeners_port"],
                    protocol=var["ingress_gateway_hosts_listeners_protocol"],
                    tls=oci.service_mesh.IngressGatewayHostListenerTlsArgs(
                        mode=var["ingress_gateway_hosts_listeners_tls_mode"],
                        client_validation=oci.service_mesh.IngressGatewayHostListenerTlsClientValidationArgs(
                            subject_alternate_names=var["ingress_gateway_hosts_listeners_tls_client_validation_subject_alternate_names"],
                            trusted_ca_bundle=oci.service_mesh.IngressGatewayHostListenerTlsClientValidationTrustedCaBundleArgs(
                                type=var["ingress_gateway_hosts_listeners_tls_client_validation_trusted_ca_bundle_type"],
                                ca_bundle_id=oci_certificates_management_ca_bundle["test_ca_bundle"]["id"],
                                secret_name=oci_vault_secret["test_secret"]["name"],
                            ),
                        ),
                        server_certificate=oci.service_mesh.IngressGatewayHostListenerTlsServerCertificateArgs(
                            type=var["ingress_gateway_hosts_listeners_tls_server_certificate_type"],
                            certificate_id=oci_certificates_management_certificate["test_certificate"]["id"],
                            secret_name=oci_vault_secret["test_secret"]["name"],
                        ),
                    ),
                )],
                name=var["ingress_gateway_hosts_name"],
                hostnames=var["ingress_gateway_hosts_hostnames"],
            )],
            mesh_id=oci_service_mesh_mesh["test_mesh"]["id"],
            access_logging=oci.service_mesh.IngressGatewayAccessLoggingArgs(
                is_enabled=var["ingress_gateway_access_logging_is_enabled"],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["ingress_gateway_description"],
            freeform_tags={
                "bar-key": "value",
            },
            mtls=oci.service_mesh.IngressGatewayMtlsArgs(
                maximum_validity=var["ingress_gateway_mtls_maximum_validity"],
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        IngressGateways can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ServiceMesh/ingressGateway:IngressGateway test_ingress_gateway "id"
        ```

        :param str resource_name: The name of the resource.
        :param IngressGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IngressGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_logging: Optional[pulumi.Input[pulumi.InputType['IngressGatewayAccessLoggingArgs']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IngressGatewayHostArgs']]]]] = None,
                 mesh_id: Optional[pulumi.Input[str]] = None,
                 mtls: Optional[pulumi.Input[pulumi.InputType['IngressGatewayMtlsArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IngressGatewayArgs.__new__(IngressGatewayArgs)

            __props__.__dict__["access_logging"] = access_logging
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["freeform_tags"] = freeform_tags
            if hosts is None and not opts.urn:
                raise TypeError("Missing required property 'hosts'")
            __props__.__dict__["hosts"] = hosts
            if mesh_id is None and not opts.urn:
                raise TypeError("Missing required property 'mesh_id'")
            __props__.__dict__["mesh_id"] = mesh_id
            __props__.__dict__["mtls"] = mtls
            __props__.__dict__["name"] = name
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(IngressGateway, __self__).__init__(
            'oci:ServiceMesh/ingressGateway:IngressGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_logging: Optional[pulumi.Input[pulumi.InputType['IngressGatewayAccessLoggingArgs']]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IngressGatewayHostArgs']]]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            mesh_id: Optional[pulumi.Input[str]] = None,
            mtls: Optional[pulumi.Input[pulumi.InputType['IngressGatewayMtlsArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'IngressGateway':
        """
        Get an existing IngressGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['IngressGatewayAccessLoggingArgs']] access_logging: (Updatable) This configuration determines if logging is enabled and where the logs will be output.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Description of the resource. It can be changed after creation. Avoid entering confidential information.  Example: `This is my new resource`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IngressGatewayHostArgs']]]] hosts: (Updatable) An array of hostnames and their listener configuration that this gateway will bind to.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed state.
        :param pulumi.Input[str] mesh_id: The OCID of the service mesh in which this ingress gateway is created.
        :param pulumi.Input[pulumi.InputType['IngressGatewayMtlsArgs']] mtls: (Updatable) Mutual TLS settings used when sending requests to virtual services within the mesh.
        :param pulumi.Input[str] name: A user-friendly name. The name has to be unique within the same service mesh and cannot be changed after creation. Avoid entering confidential information.  Example: `My unique resource name` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the Resource.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time when this resource was created in an RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when this resource was updated in an RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IngressGatewayState.__new__(_IngressGatewayState)

        __props__.__dict__["access_logging"] = access_logging
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["mesh_id"] = mesh_id
        __props__.__dict__["mtls"] = mtls
        __props__.__dict__["name"] = name
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return IngressGateway(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessLogging")
    def access_logging(self) -> pulumi.Output['outputs.IngressGatewayAccessLogging']:
        """
        (Updatable) This configuration determines if logging is enabled and where the logs will be output.
        """
        return pulumi.get(self, "access_logging")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Description of the resource. It can be changed after creation. Avoid entering confidential information.  Example: `This is my new resource`
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Sequence['outputs.IngressGatewayHost']]:
        """
        (Updatable) An array of hostnames and their listener configuration that this gateway will bind to.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="meshId")
    def mesh_id(self) -> pulumi.Output[str]:
        """
        The OCID of the service mesh in which this ingress gateway is created.
        """
        return pulumi.get(self, "mesh_id")

    @property
    @pulumi.getter
    def mtls(self) -> pulumi.Output['outputs.IngressGatewayMtls']:
        """
        (Updatable) Mutual TLS settings used when sending requests to virtual services within the mesh.
        """
        return pulumi.get(self, "mtls")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A user-friendly name. The name has to be unique within the same service mesh and cannot be changed after creation. Avoid entering confidential information.  Example: `My unique resource name` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time when this resource was created in an RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time when this resource was updated in an RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

