"""Constants used in KNX config store."""

from typing import Final

# Common
CONF_DATA: Final = "data"
CONF_ENTITY: Final = "entity"
CONF_DEVICE_INFO: Final = "device_info"
CONF_GA_WRITE: Final = "write"
CONF_GA_STATE: Final = "state"
CONF_GA_PASSIVE: Final = "passive"
CONF_DPT: Final = "dpt"

CONF_GA_SENSOR: Final = "ga_sensor"
CONF_GA_SWITCH: Final = "ga_switch"

# Cover
CONF_GA_UP_DOWN: Final = "ga_up_down"
CONF_GA_STOP: Final = "ga_stop"
CONF_GA_STEP: Final = "ga_step"
CONF_GA_POSITION_SET: Final = "ga_position_set"
CONF_GA_POSITION_STATE: Final = "ga_position_state"
CONF_GA_ANGLE: Final = "ga_angle"

# Light
CONF_COLOR_TEMP_MIN: Final = "color_temp_min"
CONF_COLOR_TEMP_MAX: Final = "color_temp_max"
CONF_GA_BRIGHTNESS: Final = "ga_brightness"
CONF_GA_COLOR_TEMP: Final = "ga_color_temp"
# Light/color
CONF_COLOR: Final = "color"
CONF_GA_COLOR: Final = "ga_color"
CONF_GA_RED_BRIGHTNESS: Final = "ga_red_brightness"
CONF_GA_RED_SWITCH: Final = "ga_red_switch"
CONF_GA_GREEN_BRIGHTNESS: Final = "ga_green_brightness"
CONF_GA_GREEN_SWITCH: Final = "ga_green_switch"
CONF_GA_BLUE_BRIGHTNESS: Final = "ga_blue_brightness"
CONF_GA_BLUE_SWITCH: Final = "ga_blue_switch"
CONF_GA_WHITE_BRIGHTNESS: Final = "ga_white_brightness"
CONF_GA_WHITE_SWITCH: Final = "ga_white_switch"
CONF_GA_HUE: Final = "ga_hue"
CONF_GA_SATURATION: Final = "ga_saturation"
