# Generated by Django 3.2.9 on 2022-01-09 16:31

import uuid

import _socket
import django.contrib.sites.managers
import django.core.validators
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_model.models.fields.duration
import edc_model.models.fields.other_charfield
import edc_model.validators.date
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import edc_vitals.models.fields.blood_pressure
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="CholInitialReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "dx_location_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dx_date",
                    models.DateField(
                        blank=True,
                        help_text="If possible, provide the exact date here instead of estimating above.",
                        null=True,
                        verbose_name="Date patient diagnosed",
                    ),
                ),
                (
                    "dx_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `dx_ago`",
                        null=True,
                        verbose_name="Estimated diagnoses date",
                    ),
                ),
                (
                    "dx_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the diagnosis date estimated?",
                    ),
                ),
                (
                    "med_start_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "med_start_estimated_date",
                    models.DateField(
                        editable=False,
                        null=True,
                        verbose_name="Estimated medication start date",
                    ),
                ),
                (
                    "med_start_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the medication start date estimated?",
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("drugs", "Oral drugs"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="How is the patient's cholesterol managed?",
                    ),
                ),
                (
                    "chol_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient had their cholesterol measured in the last few months?",
                    ),
                ),
            ],
            options={
                "verbose_name": "High Cholesterol Initial Review",
                "verbose_name_plural": "High Cholesterol Initial Reviews",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="CholReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("drugs", "Oral drugs"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="How will the patient's High Cholesterol be managed going forward?",
                    ),
                ),
            ],
            options={
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="ClinicalReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "hiv_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Note: Select `not applicable` if diagnosis previously reported. <BR>`Since last seen` includes today.<BR>If `yes', complete the initial review CRF<BR>If `not applicable`, complete the review CRF.",
                        max_length=15,
                        verbose_name="Since last seen, was the patient tested for HIV infection?",
                    ),
                ),
                (
                    "hiv_test_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date test requested"
                    ),
                ),
                (
                    "hiv_reason_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "hiv_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="As of today, was the patient <u>newly</u> diagnosed with HIV infection?",
                    ),
                ),
                (
                    "htn_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Note: Select `not applicable` if diagnosis previously reported. <BR>`Since last seen` includes today.<BR>If `yes', complete the initial review CRF<BR>If `not applicable`, complete the review CRF.",
                        max_length=15,
                        verbose_name="Since last seen, was the patient tested for hypertension?",
                    ),
                ),
                (
                    "htn_test_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date test requested"
                    ),
                ),
                (
                    "htn_reason_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "htn_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="As of today, was the patient <u>newly</u> diagnosed with hypertension?",
                    ),
                ),
                (
                    "dm_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Note: Select `not applicable` if diagnosis previously reported. <BR>`Since last seen` includes today.<BR>If `yes', complete the initial review CRF<BR>If `not applicable`, complete the review CRF.",
                        max_length=15,
                        verbose_name="Since last seen, was the patient tested for diabetes?",
                    ),
                ),
                (
                    "dm_test_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date test requested"
                    ),
                ),
                (
                    "dm_reason_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "dm_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="As of today, was the patient <u>newly</u> diagnosed with diabetes?",
                    ),
                ),
                (
                    "chol_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Note: Select `not applicable` if diagnosis previously reported. <BR>`Since last seen` includes today.<BR>If `yes', complete the initial review CRF<BR>If `not applicable`, complete the review CRF.",
                        max_length=15,
                        verbose_name="Since last seen, was the patient tested for high cholesterol?",
                    ),
                ),
                (
                    "chol_test_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date test requested"
                    ),
                ),
                (
                    "chol_reason_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "chol_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="As of today, was the patient <u>newly</u> diagnosed with high cholesterol?",
                    ),
                ),
                (
                    "complications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If Yes, complete the `Complications` CRF",
                        max_length=15,
                        verbose_name="Since last seen, has the patient had any complications",
                    ),
                ),
            ],
            options={
                "verbose_name": "Clinical Review",
                "verbose_name_plural": "Clinical Reviews",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="ClinicalReviewBaseline",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "chol_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient ever tested for High Cholesterol?",
                    ),
                ),
                (
                    "chol_test_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "chol_test_estimated_date",
                    models.DateField(
                        blank=True,
                        help_text="calculated by the EDC using `chol_test_ago`",
                        null=True,
                    ),
                ),
                (
                    "chol_test_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of patient's most recent Cholesterol test?",
                    ),
                ),
                (
                    "chol_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="If yes, complete form `High Cholesterol Initial Review`",
                        max_length=15,
                        verbose_name="Have you ever been diagnosed with High Cholesterol",
                    ),
                ),
                (
                    "dm_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient ever tested for Diabetes?",
                    ),
                ),
                (
                    "dm_test_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dm_test_estimated_date",
                    models.DateField(
                        blank=True,
                        help_text="calculated by the EDC using `dm_test_ago`",
                        null=True,
                    ),
                ),
                (
                    "dm_test_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of patient's most recent Diabetes test?",
                    ),
                ),
                (
                    "dm_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="If yes, complete form `Diabetes Initial Review`",
                        max_length=15,
                        verbose_name="Have you ever been diagnosed with Diabetes",
                    ),
                ),
                (
                    "hiv_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient ever tested for HIV infection?",
                    ),
                ),
                (
                    "hiv_test_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "hiv_test_estimated_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        help_text="calculated by the EDC using `hiv_test_ago`",
                        null=True,
                    ),
                ),
                (
                    "hiv_test_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of patient's most recent HIV test?",
                    ),
                ),
                (
                    "hiv_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="If yes, complete form `HIV Initial Review`",
                        max_length=15,
                        verbose_name="Has the patient ever tested <U>positive</U> for HIV infection?",
                    ),
                ),
                (
                    "htn_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient ever tested for Hypertension?",
                    ),
                ),
                (
                    "htn_test_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "htn_test_estimated_date",
                    models.DateField(
                        blank=True,
                        help_text="calculated by the EDC using `htn_test_ago`",
                        null=True,
                    ),
                ),
                (
                    "htn_test_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of patient's most recent Hypertension test?",
                    ),
                ),
                (
                    "htn_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="If yes, complete form `Hypertension Initial Review`",
                        max_length=15,
                        verbose_name="Has the patient ever been diagnosed with Hypertension",
                    ),
                ),
                (
                    "complications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If Yes, complete the `Complications` CRF",
                        max_length=15,
                        verbose_name="Since last seen, has the patient had any complications",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
            ],
            options={
                "verbose_name": "Clinical Review: Baseline",
                "verbose_name_plural": "Clinical Review: Baseline",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="DiagnosisLocations",
            fields=[
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        help_text="This is the stored value, required",
                        max_length=250,
                        unique=True,
                        verbose_name="Stored value",
                    ),
                ),
                (
                    "display_name",
                    models.CharField(
                        db_index=True,
                        help_text="(suggest 40 characters max.)",
                        max_length=250,
                        unique=True,
                        verbose_name="Name",
                    ),
                ),
                (
                    "display_index",
                    models.IntegerField(
                        db_index=True,
                        default=0,
                        help_text="Index to control display order if not alphabetical, not required",
                        verbose_name="display index",
                    ),
                ),
                (
                    "field_name",
                    models.CharField(
                        blank=True,
                        editable=False,
                        help_text="Not required",
                        max_length=25,
                        null=True,
                    ),
                ),
                ("version", models.CharField(default="1.0", editable=False, max_length=35)),
                ("id", models.AutoField(primary_key=True, serialize=False)),
            ],
            options={
                "verbose_name": "Diagnosis Locations",
                "verbose_name_plural": "Diagnosis Locations",
                "ordering": ["display_index", "display_name"],
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
        ),
        migrations.CreateModel(
            name="DmInitialReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "dx_location_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dx_date",
                    models.DateField(
                        blank=True,
                        help_text="If possible, provide the exact date here instead of estimating above.",
                        null=True,
                        verbose_name="Date patient diagnosed",
                    ),
                ),
                (
                    "dx_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `dx_ago`",
                        null=True,
                        verbose_name="Estimated diagnoses date",
                    ),
                ),
                (
                    "dx_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the diagnosis date estimated?",
                    ),
                ),
                (
                    "med_start_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "med_start_estimated_date",
                    models.DateField(
                        editable=False,
                        null=True,
                        verbose_name="Estimated medication start date",
                    ),
                ),
                (
                    "med_start_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the medication start date estimated?",
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("insulin", "Insulin injections"),
                            ("drugs", "Oral drugs"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        help_text="If insulin or oral drugs, diet and lifestyle is assumed.",
                        max_length=25,
                        verbose_name="How is the patient's diabetes managed?",
                    ),
                ),
            ],
            options={
                "verbose_name": "Diabetes Initial Review",
                "verbose_name_plural": "Diabetes Initial Reviews",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="DmReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "care_delivery",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Select `not applicable` if site was not selected for integrated care.",
                        max_length=25,
                        verbose_name="Was care for this `condition` delivered in an integrated care clinic today?",
                    ),
                ),
                (
                    "care_delivery_other",
                    models.TextField(
                        blank=True, null=True, verbose_name="If no, please explain"
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("insulin", "Insulin injections"),
                            ("drugs", "Oral drugs"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="How will the patient's diabetes be managed going forward?",
                    ),
                ),
            ],
            options={
                "verbose_name": "Diabetes Review",
                "verbose_name_plural": "Diabetes Review",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalCholInitialReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "dx_location_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dx_date",
                    models.DateField(
                        blank=True,
                        help_text="If possible, provide the exact date here instead of estimating above.",
                        null=True,
                        verbose_name="Date patient diagnosed",
                    ),
                ),
                (
                    "dx_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `dx_ago`",
                        null=True,
                        verbose_name="Estimated diagnoses date",
                    ),
                ),
                (
                    "dx_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the diagnosis date estimated?",
                    ),
                ),
                (
                    "med_start_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "med_start_estimated_date",
                    models.DateField(
                        editable=False,
                        null=True,
                        verbose_name="Estimated medication start date",
                    ),
                ),
                (
                    "med_start_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the medication start date estimated?",
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("drugs", "Oral drugs"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="How is the patient's cholesterol managed?",
                    ),
                ),
                (
                    "chol_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient had their cholesterol measured in the last few months?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical High Cholesterol Initial Review",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalCholReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("drugs", "Oral drugs"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="How will the patient's High Cholesterol be managed going forward?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical chol review",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalClinicalReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "hiv_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Note: Select `not applicable` if diagnosis previously reported. <BR>`Since last seen` includes today.<BR>If `yes', complete the initial review CRF<BR>If `not applicable`, complete the review CRF.",
                        max_length=15,
                        verbose_name="Since last seen, was the patient tested for HIV infection?",
                    ),
                ),
                (
                    "hiv_test_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date test requested"
                    ),
                ),
                (
                    "hiv_reason_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "hiv_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="As of today, was the patient <u>newly</u> diagnosed with HIV infection?",
                    ),
                ),
                (
                    "htn_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Note: Select `not applicable` if diagnosis previously reported. <BR>`Since last seen` includes today.<BR>If `yes', complete the initial review CRF<BR>If `not applicable`, complete the review CRF.",
                        max_length=15,
                        verbose_name="Since last seen, was the patient tested for hypertension?",
                    ),
                ),
                (
                    "htn_test_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date test requested"
                    ),
                ),
                (
                    "htn_reason_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "htn_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="As of today, was the patient <u>newly</u> diagnosed with hypertension?",
                    ),
                ),
                (
                    "dm_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Note: Select `not applicable` if diagnosis previously reported. <BR>`Since last seen` includes today.<BR>If `yes', complete the initial review CRF<BR>If `not applicable`, complete the review CRF.",
                        max_length=15,
                        verbose_name="Since last seen, was the patient tested for diabetes?",
                    ),
                ),
                (
                    "dm_test_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date test requested"
                    ),
                ),
                (
                    "dm_reason_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "dm_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="As of today, was the patient <u>newly</u> diagnosed with diabetes?",
                    ),
                ),
                (
                    "chol_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Note: Select `not applicable` if diagnosis previously reported. <BR>`Since last seen` includes today.<BR>If `yes', complete the initial review CRF<BR>If `not applicable`, complete the review CRF.",
                        max_length=15,
                        verbose_name="Since last seen, was the patient tested for high cholesterol?",
                    ),
                ),
                (
                    "chol_test_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date test requested"
                    ),
                ),
                (
                    "chol_reason_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "chol_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="As of today, was the patient <u>newly</u> diagnosed with high cholesterol?",
                    ),
                ),
                (
                    "complications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If Yes, complete the `Complications` CRF",
                        max_length=15,
                        verbose_name="Since last seen, has the patient had any complications",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Clinical Review",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalClinicalReviewBaseline",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "chol_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient ever tested for High Cholesterol?",
                    ),
                ),
                (
                    "chol_test_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "chol_test_estimated_date",
                    models.DateField(
                        blank=True,
                        help_text="calculated by the EDC using `chol_test_ago`",
                        null=True,
                    ),
                ),
                (
                    "chol_test_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of patient's most recent Cholesterol test?",
                    ),
                ),
                (
                    "chol_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="If yes, complete form `High Cholesterol Initial Review`",
                        max_length=15,
                        verbose_name="Have you ever been diagnosed with High Cholesterol",
                    ),
                ),
                (
                    "dm_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient ever tested for Diabetes?",
                    ),
                ),
                (
                    "dm_test_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dm_test_estimated_date",
                    models.DateField(
                        blank=True,
                        help_text="calculated by the EDC using `dm_test_ago`",
                        null=True,
                    ),
                ),
                (
                    "dm_test_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of patient's most recent Diabetes test?",
                    ),
                ),
                (
                    "dm_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="If yes, complete form `Diabetes Initial Review`",
                        max_length=15,
                        verbose_name="Have you ever been diagnosed with Diabetes",
                    ),
                ),
                (
                    "hiv_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient ever tested for HIV infection?",
                    ),
                ),
                (
                    "hiv_test_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "hiv_test_estimated_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        help_text="calculated by the EDC using `hiv_test_ago`",
                        null=True,
                    ),
                ),
                (
                    "hiv_test_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of patient's most recent HIV test?",
                    ),
                ),
                (
                    "hiv_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="If yes, complete form `HIV Initial Review`",
                        max_length=15,
                        verbose_name="Has the patient ever tested <U>positive</U> for HIV infection?",
                    ),
                ),
                (
                    "htn_test",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient ever tested for Hypertension?",
                    ),
                ),
                (
                    "htn_test_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "htn_test_estimated_date",
                    models.DateField(
                        blank=True,
                        help_text="calculated by the EDC using `htn_test_ago`",
                        null=True,
                    ),
                ),
                (
                    "htn_test_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of patient's most recent Hypertension test?",
                    ),
                ),
                (
                    "htn_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="If yes, complete form `Hypertension Initial Review`",
                        max_length=15,
                        verbose_name="Has the patient ever been diagnosed with Hypertension",
                    ),
                ),
                (
                    "complications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If Yes, complete the `Complications` CRF",
                        max_length=15,
                        verbose_name="Since last seen, has the patient had any complications",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Clinical Review: Baseline",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalDmInitialReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "dx_location_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dx_date",
                    models.DateField(
                        blank=True,
                        help_text="If possible, provide the exact date here instead of estimating above.",
                        null=True,
                        verbose_name="Date patient diagnosed",
                    ),
                ),
                (
                    "dx_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `dx_ago`",
                        null=True,
                        verbose_name="Estimated diagnoses date",
                    ),
                ),
                (
                    "dx_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the diagnosis date estimated?",
                    ),
                ),
                (
                    "med_start_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "med_start_estimated_date",
                    models.DateField(
                        editable=False,
                        null=True,
                        verbose_name="Estimated medication start date",
                    ),
                ),
                (
                    "med_start_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the medication start date estimated?",
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("insulin", "Insulin injections"),
                            ("drugs", "Oral drugs"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        help_text="If insulin or oral drugs, diet and lifestyle is assumed.",
                        max_length=25,
                        verbose_name="How is the patient's diabetes managed?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Diabetes Initial Review",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalDmReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "care_delivery",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Select `not applicable` if site was not selected for integrated care.",
                        max_length=25,
                        verbose_name="Was care for this `condition` delivered in an integrated care clinic today?",
                    ),
                ),
                (
                    "care_delivery_other",
                    models.TextField(
                        blank=True, null=True, verbose_name="If no, please explain"
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("insulin", "Insulin injections"),
                            ("drugs", "Oral drugs"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="How will the patient's diabetes be managed going forward?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Diabetes Review",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHivInitialReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "dx_location_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dx_date",
                    models.DateField(
                        blank=True,
                        help_text="If possible, provide the exact date here instead of estimating above.",
                        null=True,
                        verbose_name="Date patient diagnosed",
                    ),
                ),
                (
                    "dx_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `dx_ago`",
                        null=True,
                        verbose_name="Estimated diagnoses date",
                    ),
                ),
                (
                    "dx_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the diagnosis date estimated?",
                    ),
                ),
                (
                    "arv_initiated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=15,
                        verbose_name="Has the patient started antiretroviral therapy (ART)?",
                    ),
                ),
                (
                    "arv_initiation_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "arv_initiation_actual_date",
                    models.DateField(
                        blank=True,
                        help_text="Calculated based on response to `arv_initiation_ago`",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date started antiretroviral therapy (ART)",
                    ),
                ),
                (
                    "arv_initiation_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `arv_initiation_ago`",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Estimated Date started antiretroviral therapy (ART)",
                    ),
                ),
                (
                    "arv_initiation_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the ART start date estimated?",
                    ),
                ),
                (
                    "has_vl",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("PENDING", "Pending"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the patient's most recent viral load result available?",
                    ),
                ),
                (
                    "vl",
                    models.IntegerField(
                        blank=True,
                        help_text="copies/mL",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(9999999),
                        ],
                        verbose_name="Most recent viral load",
                    ),
                ),
                (
                    "vl_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[("=", "="), (">", ">"), ("<", "<")],
                        max_length=10,
                        null=True,
                    ),
                ),
                (
                    "vl_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of most recent viral load",
                    ),
                ),
                (
                    "has_cd4",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the patient's most recent CD4 result available?",
                    ),
                ),
                (
                    "cd4",
                    models.IntegerField(
                        blank=True,
                        help_text="cells/mm<sup>3</sup>",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(3000),
                        ],
                        verbose_name="Most recent CD4",
                    ),
                ),
                (
                    "cd4_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of most recent CD4",
                    ),
                ),
                (
                    "receives_care",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient receiving care for HIV?",
                    ),
                ),
                (
                    "clinic",
                    models.CharField(
                        choices=[
                            ("this_clinic", "Patient comes to this facility for their care"),
                            ("OTHER", "Patient goes to a different clinic"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Where does the patient receive care for HIV",
                    ),
                ),
                (
                    "clinic_other",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If <u>not</u> attending here, where does the patient attend?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical HIV Initial Review",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHivReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "care_delivery",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Select `not applicable` if site was not selected for integrated care.",
                        max_length=25,
                        verbose_name="Was care for this `condition` delivered in an integrated care clinic today?",
                    ),
                ),
                (
                    "care_delivery_other",
                    models.TextField(
                        blank=True, null=True, verbose_name="If no, please explain"
                    ),
                ),
                (
                    "dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has the patient been infected with HIV?",
                    ),
                ),
                (
                    "arv_initiated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Select `not applicable` if previously reported.",
                        max_length=15,
                        verbose_name="Has the patient started antiretroviral therapy (ART)?",
                    ),
                ),
                (
                    "arv_initiation_actual_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="Date started antiretroviral therapy (ART)",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical HIV Followup Review",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHtnInitialReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "dx_location_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dx_date",
                    models.DateField(
                        blank=True,
                        help_text="If possible, provide the exact date here instead of estimating above.",
                        null=True,
                        verbose_name="Date patient diagnosed",
                    ),
                ),
                (
                    "dx_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `dx_ago`",
                        null=True,
                        verbose_name="Estimated diagnoses date",
                    ),
                ),
                (
                    "dx_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the diagnosis date estimated?",
                    ),
                ),
                (
                    "med_start_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "med_start_estimated_date",
                    models.DateField(
                        editable=False,
                        null=True,
                        verbose_name="Estimated medication start date",
                    ),
                ),
                (
                    "med_start_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the medication start date estimated?",
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("drugs", "Drugs / Medicine"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="How is the patient's hypertension managed?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Hypertension Initial Review",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHtnReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "care_delivery",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Select `not applicable` if site was not selected for integrated care.",
                        max_length=25,
                        verbose_name="Was care for this `condition` delivered in an integrated care clinic today?",
                    ),
                ),
                (
                    "care_delivery_other",
                    models.TextField(
                        blank=True, null=True, verbose_name="If no, please explain"
                    ),
                ),
                (
                    "sys_blood_pressure",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "test_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Date tested for Hypertension",
                    ),
                ),
                (
                    "dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has the patient been diagnosed with Hypertension?",
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("drugs", "Drugs / Medicine"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="How will the patient's hypertension be managed going forward?",
                    ),
                ),
                (
                    "care_start_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date clinical management started"
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Hypertension Review",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HivInitialReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "dx_location_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dx_date",
                    models.DateField(
                        blank=True,
                        help_text="If possible, provide the exact date here instead of estimating above.",
                        null=True,
                        verbose_name="Date patient diagnosed",
                    ),
                ),
                (
                    "dx_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `dx_ago`",
                        null=True,
                        verbose_name="Estimated diagnoses date",
                    ),
                ),
                (
                    "dx_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the diagnosis date estimated?",
                    ),
                ),
                (
                    "arv_initiated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=15,
                        verbose_name="Has the patient started antiretroviral therapy (ART)?",
                    ),
                ),
                (
                    "arv_initiation_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "arv_initiation_actual_date",
                    models.DateField(
                        blank=True,
                        help_text="Calculated based on response to `arv_initiation_ago`",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date started antiretroviral therapy (ART)",
                    ),
                ),
                (
                    "arv_initiation_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `arv_initiation_ago`",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Estimated Date started antiretroviral therapy (ART)",
                    ),
                ),
                (
                    "arv_initiation_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the ART start date estimated?",
                    ),
                ),
                (
                    "has_vl",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("PENDING", "Pending"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the patient's most recent viral load result available?",
                    ),
                ),
                (
                    "vl",
                    models.IntegerField(
                        blank=True,
                        help_text="copies/mL",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(9999999),
                        ],
                        verbose_name="Most recent viral load",
                    ),
                ),
                (
                    "vl_quantifier",
                    models.CharField(
                        blank=True,
                        choices=[("=", "="), (">", ">"), ("<", "<")],
                        max_length=10,
                        null=True,
                    ),
                ),
                (
                    "vl_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of most recent viral load",
                    ),
                ),
                (
                    "has_cd4",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the patient's most recent CD4 result available?",
                    ),
                ),
                (
                    "cd4",
                    models.IntegerField(
                        blank=True,
                        help_text="cells/mm<sup>3</sup>",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(3000),
                        ],
                        verbose_name="Most recent CD4",
                    ),
                ),
                (
                    "cd4_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of most recent CD4",
                    ),
                ),
                (
                    "receives_care",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient receiving care for HIV?",
                    ),
                ),
                (
                    "clinic",
                    models.CharField(
                        choices=[
                            ("this_clinic", "Patient comes to this facility for their care"),
                            ("OTHER", "Patient goes to a different clinic"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Where does the patient receive care for HIV",
                    ),
                ),
                (
                    "clinic_other",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If <u>not</u> attending here, where does the patient attend?",
                    ),
                ),
            ],
            options={
                "verbose_name": "HIV Initial Review",
                "verbose_name_plural": "HIV Initial Reviews",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HivReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "care_delivery",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Select `not applicable` if site was not selected for integrated care.",
                        max_length=25,
                        verbose_name="Was care for this `condition` delivered in an integrated care clinic today?",
                    ),
                ),
                (
                    "care_delivery_other",
                    models.TextField(
                        blank=True, null=True, verbose_name="If no, please explain"
                    ),
                ),
                (
                    "dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has the patient been infected with HIV?",
                    ),
                ),
                (
                    "arv_initiated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Select `not applicable` if previously reported.",
                        max_length=15,
                        verbose_name="Has the patient started antiretroviral therapy (ART)?",
                    ),
                ),
                (
                    "arv_initiation_actual_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="Date started antiretroviral therapy (ART)",
                    ),
                ),
            ],
            options={
                "verbose_name": "HIV Followup Review",
                "verbose_name_plural": "HIV Followup Review",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HtnInitialReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "dx_location_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "dx_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "dx_date",
                    models.DateField(
                        blank=True,
                        help_text="If possible, provide the exact date here instead of estimating above.",
                        null=True,
                        verbose_name="Date patient diagnosed",
                    ),
                ),
                (
                    "dx_estimated_date",
                    models.DateField(
                        editable=False,
                        help_text="Calculated based on response to `dx_ago`",
                        null=True,
                        verbose_name="Estimated diagnoses date",
                    ),
                ),
                (
                    "dx_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the diagnosis date estimated?",
                    ),
                ),
                (
                    "med_start_ago",
                    edc_model.models.fields.duration.DurationYMDField(blank=True, null=True),
                ),
                (
                    "med_start_estimated_date",
                    models.DateField(
                        editable=False,
                        null=True,
                        verbose_name="Estimated medication start date",
                    ),
                ),
                (
                    "med_start_date_estimated",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        editable=False,
                        max_length=15,
                        verbose_name="Was the medication start date estimated?",
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("drugs", "Drugs / Medicine"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="How is the patient's hypertension managed?",
                    ),
                ),
            ],
            options={
                "verbose_name": "Hypertension Initial Review",
                "verbose_name_plural": "Hypertension Initial Reviews",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HtnReview",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "care_delivery",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Select `not applicable` if site was not selected for integrated care.",
                        max_length=25,
                        verbose_name="Was care for this `condition` delivered in an integrated care clinic today?",
                    ),
                ),
                (
                    "care_delivery_other",
                    models.TextField(
                        blank=True, null=True, verbose_name="If no, please explain"
                    ),
                ),
                (
                    "sys_blood_pressure",
                    edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure",
                    edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "test_date",
                    models.DateField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Date tested for Hypertension",
                    ),
                ),
                (
                    "dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has the patient been diagnosed with Hypertension?",
                    ),
                ),
                (
                    "managed_by",
                    models.CharField(
                        choices=[
                            ("drugs", "Drugs / Medicine"),
                            ("diet_lifestyle", "Diet and lifestyle alone"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="How will the patient's hypertension be managed going forward?",
                    ),
                ),
                (
                    "care_start_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date clinical management started"
                    ),
                ),
            ],
            options={
                "verbose_name": "Hypertension Review",
                "verbose_name_plural": "Hypertension Review",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="ReasonsForTesting",
            fields=[
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        help_text="This is the stored value, required",
                        max_length=250,
                        unique=True,
                        verbose_name="Stored value",
                    ),
                ),
                (
                    "display_name",
                    models.CharField(
                        db_index=True,
                        help_text="(suggest 40 characters max.)",
                        max_length=250,
                        unique=True,
                        verbose_name="Name",
                    ),
                ),
                (
                    "display_index",
                    models.IntegerField(
                        db_index=True,
                        default=0,
                        help_text="Index to control display order if not alphabetical, not required",
                        verbose_name="display index",
                    ),
                ),
                (
                    "field_name",
                    models.CharField(
                        blank=True,
                        editable=False,
                        help_text="Not required",
                        max_length=25,
                        null=True,
                    ),
                ),
                ("version", models.CharField(default="1.0", editable=False, max_length=35)),
                ("id", models.AutoField(primary_key=True, serialize=False)),
            ],
            options={
                "verbose_name": "Reasons for Testing",
                "verbose_name_plural": "Reasons for Testing",
                "ordering": ["display_index", "display_name"],
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
        ),
        migrations.AddIndex(
            model_name="reasonsfortesting",
            index=models.Index(
                fields=["id", "display_name", "display_index"],
                name="edc_dx_revi_id_9cf36d_idx",
            ),
        ),
        migrations.AddField(
            model_name="htnreview",
            name="site",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="htnreview",
            name="subject_visit",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.PROTECT, to="mocca_subject.subjectvisit"
            ),
        ),
        migrations.AddField(
            model_name="htninitialreview",
            name="dx_location",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_dx_review.diagnosislocations",
                verbose_name="Where was the diagnosis made?",
            ),
        ),
        migrations.AddField(
            model_name="htninitialreview",
            name="site",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="htninitialreview",
            name="subject_visit",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.PROTECT, to="mocca_subject.subjectvisit"
            ),
        ),
        migrations.AddField(
            model_name="hivreview",
            name="site",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="hivreview",
            name="subject_visit",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.PROTECT, to="mocca_subject.subjectvisit"
            ),
        ),
        migrations.AddField(
            model_name="hivinitialreview",
            name="dx_location",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_dx_review.diagnosislocations",
                verbose_name="Where was the diagnosis made?",
            ),
        ),
        migrations.AddField(
            model_name="hivinitialreview",
            name="site",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="hivinitialreview",
            name="subject_visit",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.PROTECT, to="mocca_subject.subjectvisit"
            ),
        ),
        migrations.AddField(
            model_name="historicalhtnreview",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalhtnreview",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicalhtnreview",
            name="subject_visit",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="mocca_subject.subjectvisit",
            ),
        ),
        migrations.AddField(
            model_name="historicalhtninitialreview",
            name="dx_location",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_dx_review.diagnosislocations",
                verbose_name="Where was the diagnosis made?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhtninitialreview",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalhtninitialreview",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicalhtninitialreview",
            name="subject_visit",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="mocca_subject.subjectvisit",
            ),
        ),
        migrations.AddField(
            model_name="historicalhivreview",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalhivreview",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicalhivreview",
            name="subject_visit",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="mocca_subject.subjectvisit",
            ),
        ),
        migrations.AddField(
            model_name="historicalhivinitialreview",
            name="dx_location",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_dx_review.diagnosislocations",
                verbose_name="Where was the diagnosis made?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhivinitialreview",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalhivinitialreview",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicalhivinitialreview",
            name="subject_visit",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="mocca_subject.subjectvisit",
            ),
        ),
        migrations.AddField(
            model_name="historicaldmreview",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicaldmreview",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicaldmreview",
            name="subject_visit",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="mocca_subject.subjectvisit",
            ),
        ),
        migrations.AddField(
            model_name="historicaldminitialreview",
            name="dx_location",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_dx_review.diagnosislocations",
                verbose_name="Where was the diagnosis made?",
            ),
        ),
        migrations.AddField(
            model_name="historicaldminitialreview",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicaldminitialreview",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicaldminitialreview",
            name="subject_visit",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="mocca_subject.subjectvisit",
            ),
        ),
        migrations.AddField(
            model_name="historicalclinicalreviewbaseline",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalclinicalreviewbaseline",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicalclinicalreviewbaseline",
            name="subject_visit",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="mocca_subject.subjectvisit",
            ),
        ),
        migrations.AddField(
            model_name="historicalclinicalreview",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalclinicalreview",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicalclinicalreview",
            name="subject_visit",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="mocca_subject.subjectvisit",
            ),
        ),
        migrations.AddField(
            model_name="historicalcholreview",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalcholreview",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicalcholreview",
            name="subject_visit",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="mocca_subject.subjectvisit",
            ),
        ),
        migrations.AddField(
            model_name="historicalcholinitialreview",
            name="dx_location",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_dx_review.diagnosislocations",
                verbose_name="Where was the diagnosis made?",
            ),
        ),
        migrations.AddField(
            model_name="historicalcholinitialreview",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalcholinitialreview",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicalcholinitialreview",
            name="subject_visit",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="mocca_subject.subjectvisit",
            ),
        ),
        migrations.AddField(
            model_name="dmreview",
            name="site",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="dmreview",
            name="subject_visit",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.PROTECT, to="mocca_subject.subjectvisit"
            ),
        ),
        migrations.AddField(
            model_name="dminitialreview",
            name="dx_location",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_dx_review.diagnosislocations",
                verbose_name="Where was the diagnosis made?",
            ),
        ),
        migrations.AddField(
            model_name="dminitialreview",
            name="site",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="dminitialreview",
            name="subject_visit",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.PROTECT, to="mocca_subject.subjectvisit"
            ),
        ),
        migrations.AddIndex(
            model_name="diagnosislocations",
            index=models.Index(
                fields=["id", "display_name", "display_index"],
                name="edc_dx_revi_id_ab6550_idx",
            ),
        ),
        migrations.AddField(
            model_name="clinicalreviewbaseline",
            name="site",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="clinicalreviewbaseline",
            name="subject_visit",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.PROTECT, to="mocca_subject.subjectvisit"
            ),
        ),
        migrations.AddField(
            model_name="clinicalreview",
            name="chol_reason",
            field=models.ManyToManyField(
                blank=True,
                related_name="chol_reason",
                to="edc_dx_review.ReasonsForTesting",
                verbose_name="Why was the patient tested for cholesterol?",
            ),
        ),
        migrations.AddField(
            model_name="clinicalreview",
            name="dm_reason",
            field=models.ManyToManyField(
                blank=True,
                related_name="dm_reason",
                to="edc_dx_review.ReasonsForTesting",
                verbose_name="Why was the patient tested for diabetes?",
            ),
        ),
        migrations.AddField(
            model_name="clinicalreview",
            name="hiv_reason",
            field=models.ManyToManyField(
                blank=True,
                related_name="hiv_test_reason",
                to="edc_dx_review.ReasonsForTesting",
                verbose_name="Why was the patient tested for HIV infection?",
            ),
        ),
        migrations.AddField(
            model_name="clinicalreview",
            name="htn_reason",
            field=models.ManyToManyField(
                blank=True,
                related_name="htn_test_reason",
                to="edc_dx_review.ReasonsForTesting",
                verbose_name="Why was the patient tested for hypertension?",
            ),
        ),
        migrations.AddField(
            model_name="clinicalreview",
            name="site",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="clinicalreview",
            name="subject_visit",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.PROTECT, to="mocca_subject.subjectvisit"
            ),
        ),
        migrations.AddField(
            model_name="cholreview",
            name="site",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="cholreview",
            name="subject_visit",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.PROTECT, to="mocca_subject.subjectvisit"
            ),
        ),
        migrations.AddField(
            model_name="cholinitialreview",
            name="dx_location",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_dx_review.diagnosislocations",
                verbose_name="Where was the diagnosis made?",
            ),
        ),
        migrations.AddField(
            model_name="cholinitialreview",
            name="site",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="cholinitialreview",
            name="subject_visit",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.PROTECT, to="mocca_subject.subjectvisit"
            ),
        ),
        migrations.AddIndex(
            model_name="htnreview",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="edc_dx_revi_subject_dad90b_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="htninitialreview",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="edc_dx_revi_subject_bed215_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="hivreview",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="edc_dx_revi_subject_ba937d_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="hivinitialreview",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="edc_dx_revi_subject_769014_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="dmreview",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="edc_dx_revi_subject_82ceac_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="dminitialreview",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="edc_dx_revi_subject_62801d_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="clinicalreviewbaseline",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="edc_dx_revi_subject_cbff3f_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="clinicalreview",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="edc_dx_revi_subject_787fe5_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="cholreview",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="edc_dx_revi_subject_87ec99_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="cholinitialreview",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="edc_dx_revi_subject_bfd190_idx"
            ),
        ),
    ]
