# coding: utf-8

"""
    Kimai 2 - API Docs

    JSON API for the Kimai 2 time-tracking software. Read more about its usage in the [API documentation](https://www.kimai.org/documentation/rest-api.html) and then download a [Swagger file](doc.json) for import e.g. in Postman. Be aware: it is not yet considered stable and BC breaks might happen.   # noqa: E501

    OpenAPI spec version: 0.5
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class TagEntity(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'name': 'str',
        'timesheets': 'list[Timesheet]',
        'color': 'str'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'timesheets': 'timesheets',
        'color': 'color'
    }

    def __init__(self, id=None, name=None, timesheets=None, color=None):  # noqa: E501
        """TagEntity - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._name = None
        self._timesheets = None
        self._color = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.name = name
        if timesheets is not None:
            self.timesheets = timesheets
        if color is not None:
            self.color = color

    @property
    def id(self):
        """Gets the id of this TagEntity.  # noqa: E501


        :return: The id of this TagEntity.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this TagEntity.


        :param id: The id of this TagEntity.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this TagEntity.  # noqa: E501


        :return: The name of this TagEntity.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TagEntity.


        :param name: The name of this TagEntity.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if name is not None and len(name) > 100:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `100`")  # noqa: E501
        if name is not None and len(name) < 2:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `2`")  # noqa: E501
        if name is not None and not re.search(r'((?!,).)*', name):  # noqa: E501
            raise ValueError(r"Invalid value for `name`, must be a follow pattern or equal to `/((?!,).)*/`")  # noqa: E501

        self._name = name

    @property
    def timesheets(self):
        """Gets the timesheets of this TagEntity.  # noqa: E501


        :return: The timesheets of this TagEntity.  # noqa: E501
        :rtype: list[Timesheet]
        """
        return self._timesheets

    @timesheets.setter
    def timesheets(self, timesheets):
        """Sets the timesheets of this TagEntity.


        :param timesheets: The timesheets of this TagEntity.  # noqa: E501
        :type: list[Timesheet]
        """

        self._timesheets = timesheets

    @property
    def color(self):
        """Gets the color of this TagEntity.  # noqa: E501


        :return: The color of this TagEntity.  # noqa: E501
        :rtype: str
        """
        return self._color

    @color.setter
    def color(self, color):
        """Sets the color of this TagEntity.


        :param color: The color of this TagEntity.  # noqa: E501
        :type: str
        """

        self._color = color

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TagEntity, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TagEntity):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
