"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .subscription_request import SubscriptionRequest, SubscriptionRequestTypedDict
from mollie.types import BaseModel
from mollie.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateSubscriptionRequestTypedDict(TypedDict):
    customer_id: str
    r"""Provide the ID of the related customer."""
    idempotency_key: NotRequired[str]
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""
    subscription_request: NotRequired[SubscriptionRequestTypedDict]


class CreateSubscriptionRequest(BaseModel):
    customer_id: Annotated[
        str,
        pydantic.Field(alias="customerId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related customer."""

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""

    subscription_request: Annotated[
        Optional[SubscriptionRequest],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None
