# -*- coding: utf-8 -*-
"""
Python language-specific code review checklist.
"""

CHECKLIST = """
## Python 代码审查检查清单

### 代码风格
- [ ] 是否遵循 PEP 8 规范
- [ ] 命名是否符合 Python 约定
- [ ] 是否有适当的空格和缩进
- [ ] 是否避免了过长的行

### 类型安全
- [ ] 是否使用类型注解 (Python 3.6+)
- [ ] 是否处理了可能的类型不匹配
- [ ] 复杂参数是否有类型说明

### 异常处理
- [ ] 是否捕获和处理了异常
- [ ] 是否使用了合适的异常类型
- [ ] 是否避免了过于宽泛的 except 子句
- [ ] 自定义异常是否合理

### 性能
- [ ] 是否避免了低效的循环和操作
- [ ] 列表推导式和生成器的使用是否合理
- [ ] 是否优化了 I/O 操作
- [ ] 是否合理使用了缓存

### 安全
- [ ] 是否存在 SQL 注入风险
- [ ] 是否存在命令注入风险
- [ ] 密码和密钥是否安全存储
- [ ] 是否正确验证用户输入

### 依赖管理
- [ ] 是否明确指定了依赖版本
- [ ] 是否考虑了版本兼容性
- [ ] 是否最小化了依赖的数量

### 测试
- [ ] 是否有单元测试
- [ ] 测试覆盖率是否合理
- [ ] 是否处理了边界情况

### 文档
- [ ] 函数和类是否有文档字符串
- [ ] 复杂逻辑是否有注释说明
- [ ] README 是否完整

### 设计
- [ ] 是否遵循 SOLID 原则
- [ ] 是否避免了过度工程
- [ ] 是否实现了适当的抽象
""" 