# -*- coding: utf-8 -*-
"""
Shell/Bash language-specific code review checklist.
"""

CHECKLIST = """
## Shell/Bash 代码审查检查清单

### 脚本结构和可读性
- [ ] 是否有明确的 shebang 行 (#!/bin/bash 或 #!/usr/bin/env bash)
- [ ] 是否有脚本描述和使用说明
- [ ] 代码是否有一致的缩进和格式
- [ ] 函数和代码块是否有注释说明
- [ ] 命名是否清晰表达意图
- [ ] 是否使用 shellcheck 等工具检查代码

### 错误处理和调试
- [ ] 是否设置了 `set -e` 或 `set -o errexit`
- [ ] 是否适当处理管道失败 (`set -o pipefail`)
- [ ] 是否处理未声明变量 (`set -u` 或 `set -o nounset`)
- [ ] 是否有适当的错误消息和日志
- [ ] 退出代码 (exit codes) 是否一致且有意义
- [ ] 是否考虑了错误路径和异常情况

### 命令和管道
- [ ] 复杂管道是否可读和可维护
- [ ] 是否避免了不必要的命令和处理步骤
- [ ] 是否考虑了命令失败的情况
- [ ] 是否避免了不必要的子 shell
- [ ] 是否正确使用命令替换 ($(...) 而非 `...`)

### 变量和参数
- [ ] 变量引用是否使用双引号 ("$var" 而非 $var)
- [ ] 是否避免了全局变量污染
- [ ] 是否使用有意义的变量名
- [ ] 是否正确处理特殊字符和空格
- [ ] 是否验证命令行参数
- [ ] 是否设置了默认值 (${var:-default})
- [ ] 常量是否使用大写命名

### 函数
- [ ] 是否适当使用函数模块化代码
- [ ] 函数是否有明确的输入和输出
- [ ] 函数是否有文档说明
- [ ] 函数是否是幂等的 (可重复运行)
- [ ] 是否避免了副作用
- [ ] 返回状态是否明确

### 安全性
- [ ] 是否安全处理用户输入
- [ ] 是否避免了命令注入风险
- [ ] 敏感信息是否安全管理 (不使用明文密码)
- [ ] 临时文件是否安全创建和清理
- [ ] 是否正确设置了文件权限
- [ ] 是否避免了 eval 和其他危险结构

### 可移植性
- [ ] 是否考虑了不同 shell 的兼容性 (bash, sh, zsh)
- [ ] 是否避免了系统特定的命令和功能
- [ ] 是否考虑了路径的可移植性
- [ ] 是否考虑了不同环境的差异 (Linux, macOS)
- [ ] 外部依赖是否明确记录

### 性能
- [ ] 是否避免了不必要的外部命令调用
- [ ] 循环是否高效
- [ ] 是否优化了文件 I/O 操作
- [ ] 是否避免了不必要的重复计算
- [ ] 是否合理使用并行处理

### 可测试性
- [ ] 代码是否易于测试
- [ ] 是否有自动化测试
- [ ] 测试是否涵盖主要功能和错误路径
- [ ] 是否可以使用 mock 替换外部依赖
""" 