# My Django Package

My Django Package is a web application for managing and querying documents using a chatbot interface. It supports multiple file formats, extracts text from documents, and uses an AI model to answer questions based on the content of uploaded documents.

## Features

- View and manage chat sessions

## Installation

### Prerequisites

- Python 3.11
- Django 3.2 or higher

### Steps

1. **Install the package:**

   ```bash
   pip install unique-log-questions
   ```

2. **Set up a virtual environment:**

   ```bash
   pip install virtualenv

   virtualenv env

   # On Windows
   .\env\Scripts\activate

   # On macOS/Linux
   source env/bin/activate
   ```

3. **Install required packages:**

   ```bash
   pip install -r requirements.txt
   ```

4. **Set up the Django project:**

   ```bash
   python manage.py makemigrations
   python manage.py migrate
   python manage.py createsuperuser
   python manage.py runserver
   ```

5. **Open your browser and navigate to:**

   ```plaintext
   http://127.0.0.1:8000/
   ```

   This will display your Django project with the integrated `app1` app.

## Usage

## Usage

1. **Integrate the library in your code:**

   **settings.py:**

   Add `unique_log_question_app` to your `INSTALLED_APPS` list:

   ```python
   INSTALLED_APPS = [

       'unique_log_question_app',
   ]
   ```

**views.py:**

```python
from unique_log_question_app.views import display_log_questions  # for log questions
from unique_log_question_app.views import display_unique_questions  # for unique questions
```

**urls.py:**

```python
from django.urls import path
from unique_log_question_app.views import display_unique_questions, display_log_questions

urlpatterns = [
    path('unique_questions/', display_unique_questions, name='display_unique_questions'),
    path('log_questions/', display_log_questions, name='display_log_questions'),
    # other paths...
]
```

By following these instructions, you should be able to set up and use your Django package correctly.

Open your browser and navigate to http://127.0.0.1:8000/unique_questions/ to see your unique questions with the integrated unique_log_question_app app.
Open your browser and navigate to http://127.0.0.1:8000/log_questions/ to see your log questions with the integrated unique_log_question_app app.
