"""
This type stub file was generated by pyright.
"""

import abc
import typing as t
from connexion.frameworks.abstract import Framework
from connexion.frameworks.starlette import Starlette as StarletteFramework
from connexion.uri_parsing import AbstractURIParser

class BaseDecorator:
    """Base class for connexion decorators."""
    framework: t.Type[Framework]
    def __init__(self, *, pythonic_params: bool = ..., uri_parser_class: AbstractURIParser = ..., jsonifier=...) -> None:
        ...
    
    @property
    def uri_parser(self):
        ...
    
    def decorate(self, function: t.Callable) -> t.Callable:
        """Decorate a function with decorators based on the operation."""
        ...
    
    @abc.abstractmethod
    def __call__(self, function: t.Callable) -> t.Callable:
        ...
    


class WSGIDecorator(BaseDecorator):
    """Decorator for usage with WSGI apps. The parameter decorator works with a Flask request,
    and provides Flask datastructures to the view function. This works for any WSGI app, since
    we get the request via the connexion context provided by WSGI middleware.

    This decorator does not parse responses, but passes them directly to the WSGI App."""
    framework = ...
    def __call__(self, function: t.Callable) -> t.Callable:
        ...
    


class FlaskDecorator(WSGIDecorator):
    """Decorator for usage with Connexion or Flask apps. The parameter decorator works with a
    Flask request, and provides Flask datastructures to the view function.

    The response decorator returns Flask responses."""
    ...


class ASGIDecorator(BaseDecorator):
    """Decorator for usage with ASGI apps. The parameter decorator works with a Starlette request,
    and provides Starlette datastructures to the view function. This works for any ASGI app, since
    we get the request via the connexion context provided by ASGI middleware.

    This decorator does not parse responses, but passes them directly to the ASGI App."""
    framework = StarletteFramework
    def __call__(self, function: t.Callable) -> t.Callable:
        ...
    


class StarletteDecorator(ASGIDecorator):
    """Decorator for usage with Connexion or Starlette apps. The parameter decorator works with a
    Starlette request, and provides Starlette datastructures to the view function.

    The response decorator returns Starlette responses."""
    ...


