"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const lambda = require("aws-cdk-lib/aws-lambda");
const bundling_1 = require("./bundling");
const util_1 = require("./util");
/**
 * A Golang Lambda function
 */
class GoFunction extends lambda.Function {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_go_alpha_GoFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GoFunction);
            }
            throw error;
        }
        if (props.runtime && (props.runtime.family !== lambda.RuntimeFamily.GO && props.runtime.family != lambda.RuntimeFamily.OTHER)) {
            throw new Error('Only `go` and `provided` runtimes are supported.');
        }
        const entry = path.resolve(props.entry);
        // Find the project root
        let moduleDir;
        if (props.moduleDir) {
            const parsedModuleDir = path.parse(props.moduleDir);
            if (parsedModuleDir.base && parsedModuleDir.ext && parsedModuleDir.base === 'go.mod') {
                if (!fs.existsSync(props.moduleDir)) {
                    throw new Error(`go.mod file at ${props.moduleDir} doesn't exist`);
                }
            }
            else if (parsedModuleDir.base && parsedModuleDir.ext && parsedModuleDir.base != 'go.mod') {
                throw new Error('moduleDir is specifying a file that is not go.mod');
            }
            else if (!fs.existsSync(path.join(props.moduleDir, 'go.mod'))) {
                throw new Error(`go.mod file at ${props.moduleDir} doesn't exist`);
            }
            moduleDir = props.moduleDir;
        }
        else {
            const modFile = (0, util_1.findUp)('go.mod', entry);
            if (!modFile) {
                throw new Error('Cannot find go.mod. Please specify it with `moduleDir`.');
            }
            moduleDir = modFile;
        }
        const runtime = props.runtime ?? lambda.Runtime.PROVIDED_AL2;
        const architecture = props.architecture ?? lambda.Architecture.X86_64;
        super(scope, id, {
            ...props,
            runtime,
            code: bundling_1.Bundling.bundle({
                ...props.bundling ?? {},
                entry,
                runtime,
                architecture,
                moduleDir,
            }),
            handler: 'bootstrap', // setting name to bootstrap so that the 'provided' runtime can also be used
        });
    }
}
exports.GoFunction = GoFunction;
_a = JSII_RTTI_SYMBOL_1;
GoFunction[_a] = { fqn: "@aws-cdk/aws-lambda-go-alpha.GoFunction", version: "2.112.0-alpha.0" };
/**
 * The address of the Google Go proxy
 */
GoFunction.GOOGLE_GOPROXY = 'https://proxy.golang.org';
//# sourceMappingURL=data:application/json;base64,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