// Copyright (c) 2022 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#pragma once

#include "paddle/phi/core/dense_tensor.h"

namespace phi {
template <typename T, typename Context>
void AnyRawKernel(const Context& dev_ctx,
                  const DenseTensor& x,
                  const std::vector<int64_t>& dims,
                  bool keep_dim,
                  bool reduce_all,
                  DenseTensor* out);

template <typename T, typename Context>
TEST_API void AnyKernel(const Context& dev_ctx,
                        const DenseTensor& x,
                        const std::vector<int64_t>& dims,
                        bool keep_dim,
                        DenseTensor* out);

#ifdef _WIN32
#define INSTANTIATE_ANY_KERNEL(type, context)        \
  template PADDLE_API void AnyKernel<type, context>( \
      const context&,                                \
      const DenseTensor&,                            \
      const std::vector<int64_t>&,                   \
      bool,                                          \
      DenseTensor*);
#endif
}  // namespace phi
