# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest
from aliyunsdkcloudapi.endpoint import endpoint_data

class CreateInstanceRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'CloudAPI', '2016-07-14', 'CreateInstance','apigateway')
		self.set_method('POST')

		if hasattr(self, "endpoint_map"):
			setattr(self, "endpoint_map", endpoint_data.getEndpointMap())
		if hasattr(self, "endpoint_regional"):
			setattr(self, "endpoint_regional", endpoint_data.getEndpointRegional())

	def get_InstanceSpec(self): # String
		return self.get_query_params().get('InstanceSpec')

	def set_InstanceSpec(self, InstanceSpec):  # String
		self.add_query_param('InstanceSpec', InstanceSpec)
	def get_InstanceCidr(self): # String
		return self.get_query_params().get('InstanceCidr')

	def set_InstanceCidr(self, InstanceCidr):  # String
		self.add_query_param('InstanceCidr', InstanceCidr)
	def get_HttpsPolicy(self): # String
		return self.get_query_params().get('HttpsPolicy')

	def set_HttpsPolicy(self, HttpsPolicy):  # String
		self.add_query_param('HttpsPolicy', HttpsPolicy)
	def get_Duration(self): # Integer
		return self.get_query_params().get('Duration')

	def set_Duration(self, Duration):  # Integer
		self.add_query_param('Duration', Duration)
	def get_InstanceType(self): # String
		return self.get_query_params().get('InstanceType')

	def set_InstanceType(self, InstanceType):  # String
		self.add_query_param('InstanceType', InstanceType)
	def get_Tags(self): # RepeatList
		return self.get_query_params().get('Tag')

	def set_Tags(self, Tag):  # RepeatList
		for depth1 in range(len(Tag)):
			if Tag[depth1].get('Value') is not None:
				self.add_query_param('Tag.' + str(depth1 + 1) + '.Value', Tag[depth1].get('Value'))
			if Tag[depth1].get('Key') is not None:
				self.add_query_param('Tag.' + str(depth1 + 1) + '.Key', Tag[depth1].get('Key'))
	def get_AutoPay(self): # Boolean
		return self.get_query_params().get('AutoPay')

	def set_AutoPay(self, AutoPay):  # Boolean
		self.add_query_param('AutoPay', AutoPay)
	def get_UserVpcId(self): # String
		return self.get_query_params().get('UserVpcId')

	def set_UserVpcId(self, UserVpcId):  # String
		self.add_query_param('UserVpcId', UserVpcId)
	def get_Token(self): # String
		return self.get_query_params().get('Token')

	def set_Token(self, Token):  # String
		self.add_query_param('Token', Token)
	def get_ZoneVSwitchSecurityGroups(self): # RepeatList
		return self.get_query_params().get('ZoneVSwitchSecurityGroup')

	def set_ZoneVSwitchSecurityGroups(self, ZoneVSwitchSecurityGroup):  # RepeatList
		for depth1 in range(len(ZoneVSwitchSecurityGroup)):
			if ZoneVSwitchSecurityGroup[depth1].get('VSwitchId') is not None:
				self.add_query_param('ZoneVSwitchSecurityGroup.' + str(depth1 + 1) + '.VSwitchId', ZoneVSwitchSecurityGroup[depth1].get('VSwitchId'))
			if ZoneVSwitchSecurityGroup[depth1].get('CidrBlock') is not None:
				self.add_query_param('ZoneVSwitchSecurityGroup.' + str(depth1 + 1) + '.CidrBlock', ZoneVSwitchSecurityGroup[depth1].get('CidrBlock'))
			if ZoneVSwitchSecurityGroup[depth1].get('SecurityGroupId') is not None:
				self.add_query_param('ZoneVSwitchSecurityGroup.' + str(depth1 + 1) + '.SecurityGroupId', ZoneVSwitchSecurityGroup[depth1].get('SecurityGroupId'))
			if ZoneVSwitchSecurityGroup[depth1].get('ZoneId') is not None:
				self.add_query_param('ZoneVSwitchSecurityGroup.' + str(depth1 + 1) + '.ZoneId', ZoneVSwitchSecurityGroup[depth1].get('ZoneId'))
	def get_InstanceName(self): # String
		return self.get_query_params().get('InstanceName')

	def set_InstanceName(self, InstanceName):  # String
		self.add_query_param('InstanceName', InstanceName)
	def get_ZoneId(self): # String
		return self.get_query_params().get('ZoneId')

	def set_ZoneId(self, ZoneId):  # String
		self.add_query_param('ZoneId', ZoneId)
	def get_ChargeType(self): # String
		return self.get_query_params().get('ChargeType')

	def set_ChargeType(self, ChargeType):  # String
		self.add_query_param('ChargeType', ChargeType)
	def get_PricingCycle(self): # String
		return self.get_query_params().get('PricingCycle')

	def set_PricingCycle(self, PricingCycle):  # String
		self.add_query_param('PricingCycle', PricingCycle)
