"use strict";
const cxapi = require("@aws-cdk/cx-api");
const lib_1 = require("../lib");
const util_1 = require("./util");
module.exports = {
    'addFileAsset correctly sets metadata and creates S3 parameters'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        stack.addFileAsset({
            fileName: 'file-name',
            packaging: lib_1.FileAssetPackaging.ZIP_DIRECTORY,
            sourceHash: 'source-hash'
        });
        // THEN
        const assetMetadata = stack.node.metadata.find(({ type }) => type === cxapi.ASSET_METADATA);
        test.equal(assetMetadata && assetMetadata.data.path, 'file-name');
        test.equal(assetMetadata && assetMetadata.data.id, 'source-hash');
        test.equal(assetMetadata && assetMetadata.data.packaging, lib_1.FileAssetPackaging.ZIP_DIRECTORY);
        test.equal(assetMetadata && assetMetadata.data.sourceHash, 'source-hash');
        test.deepEqual(util_1.toCloudFormation(stack), {
            Parameters: {
                AssetParameterssourcehashS3BucketE6E91E3E: {
                    Type: 'String',
                    Description: 'S3 bucket for asset "source-hash"'
                },
                AssetParameterssourcehashS3VersionKeyAC4157C3: {
                    Type: 'String',
                    Description: 'S3 key for asset version "source-hash"'
                },
                AssetParameterssourcehashArtifactHashADBAE418: {
                    Type: 'String',
                    Description: 'Artifact hash for asset "source-hash"'
                }
            }
        });
        test.done();
    },
    'addDockerImageAsset correctly sets metadata and creates an ECR parameter'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        stack.addDockerImageAsset({
            sourceHash: 'source-hash',
            directoryName: 'directory-name',
            repositoryName: 'repository-name'
        });
        // THEN
        const assetMetadata = stack.node.metadata.find(({ type }) => type === cxapi.ASSET_METADATA);
        test.equal(assetMetadata && assetMetadata.data.packaging, 'container-image');
        test.equal(assetMetadata && assetMetadata.data.path, 'directory-name');
        test.equal(assetMetadata && assetMetadata.data.sourceHash, 'source-hash');
        test.equal(assetMetadata && assetMetadata.data.repositoryName, 'repository-name');
        test.deepEqual(util_1.toCloudFormation(stack), {
            Parameters: {
                AssetParameterssourcehashImageName3B572B12: {
                    Type: 'String',
                    Description: 'ECR repository name and tag for asset "source-hash"'
                }
            }
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5hc3NldHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXN0LmFzc2V0cy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEseUNBQTBDO0FBRTFDLGdDQUFtRDtBQUNuRCxpQ0FBMEM7QUFFMUMsaUJBQVM7SUFDUCxnRUFBZ0UsQ0FBQyxJQUFVO1FBQ3pFLFFBQVE7UUFDUixNQUFNLEtBQUssR0FBRyxJQUFJLFdBQUssRUFBRSxDQUFDO1FBRTFCLE9BQU87UUFDUCxLQUFLLENBQUMsWUFBWSxDQUFDO1lBQ2pCLFFBQVEsRUFBRSxXQUFXO1lBQ3JCLFNBQVMsRUFBRSx3QkFBa0IsQ0FBQyxhQUFhO1lBQzNDLFVBQVUsRUFBRSxhQUFhO1NBQzFCLENBQUMsQ0FBQztRQUVILE9BQU87UUFDUCxNQUFNLGFBQWEsR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxFQUFFLElBQUksRUFBRSxFQUFFLEVBQUUsQ0FBQyxJQUFJLEtBQUssS0FBSyxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBRTVGLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxJQUFJLGFBQWEsQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLFdBQVcsQ0FBQyxDQUFDO1FBQ2xFLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxJQUFJLGFBQWEsQ0FBQyxJQUFJLENBQUMsRUFBRSxFQUFFLGFBQWEsQ0FBQyxDQUFDO1FBQ2xFLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxJQUFJLGFBQWEsQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLHdCQUFrQixDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQzVGLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxJQUFJLGFBQWEsQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFLGFBQWEsQ0FBQyxDQUFDO1FBRTFFLElBQUksQ0FBQyxTQUFTLENBQUMsdUJBQWdCLENBQUMsS0FBSyxDQUFDLEVBQUU7WUFDdEMsVUFBVSxFQUFFO2dCQUNWLHlDQUF5QyxFQUFFO29CQUN6QyxJQUFJLEVBQUUsUUFBUTtvQkFDZCxXQUFXLEVBQUUsbUNBQW1DO2lCQUNqRDtnQkFDRCw2Q0FBNkMsRUFBRTtvQkFDN0MsSUFBSSxFQUFFLFFBQVE7b0JBQ2QsV0FBVyxFQUFFLHdDQUF3QztpQkFDdEQ7Z0JBQ0QsNkNBQTZDLEVBQUU7b0JBQzdDLElBQUksRUFBRSxRQUFRO29CQUNkLFdBQVcsRUFBRSx1Q0FBdUM7aUJBQ3JEO2FBQ0Y7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFFZCxDQUFDO0lBRUQsMEVBQTBFLENBQUMsSUFBVTtRQUNuRixRQUFRO1FBQ1IsTUFBTSxLQUFLLEdBQUcsSUFBSSxXQUFLLEVBQUUsQ0FBQztRQUUxQixPQUFPO1FBQ1AsS0FBSyxDQUFDLG1CQUFtQixDQUFDO1lBQ3hCLFVBQVUsRUFBRSxhQUFhO1lBQ3pCLGFBQWEsRUFBRSxnQkFBZ0I7WUFDL0IsY0FBYyxFQUFFLGlCQUFpQjtTQUNsQyxDQUFDLENBQUM7UUFFSCxPQUFPO1FBQ1AsTUFBTSxhQUFhLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUMsRUFBRSxJQUFJLEVBQUUsRUFBRSxFQUFFLENBQUMsSUFBSSxLQUFLLEtBQUssQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUU1RixJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsSUFBSSxhQUFhLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO1FBQzdFLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxJQUFJLGFBQWEsQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLGdCQUFnQixDQUFDLENBQUM7UUFDdkUsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLElBQUksYUFBYSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUUsYUFBYSxDQUFDLENBQUM7UUFDMUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLElBQUksYUFBYSxDQUFDLElBQUksQ0FBQyxjQUFjLEVBQUUsaUJBQWlCLENBQUMsQ0FBQztRQUVsRixJQUFJLENBQUMsU0FBUyxDQUFDLHVCQUFnQixDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ3RDLFVBQVUsRUFBRTtnQkFDViwwQ0FBMEMsRUFBRTtvQkFDMUMsSUFBSSxFQUFFLFFBQVE7b0JBQ2QsV0FBVyxFQUFFLHFEQUFxRDtpQkFDbkU7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7Q0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGN4YXBpID0gcmVxdWlyZSgnQGF3cy1jZGsvY3gtYXBpJyk7XG5pbXBvcnQgeyBUZXN0IH0gZnJvbSAnbm9kZXVuaXQnO1xuaW1wb3J0IHsgRmlsZUFzc2V0UGFja2FnaW5nLCBTdGFjayB9IGZyb20gJy4uL2xpYic7XG5pbXBvcnQgeyB0b0Nsb3VkRm9ybWF0aW9uIH0gZnJvbSAnLi91dGlsJztcblxuZXhwb3J0ID0ge1xuICAnYWRkRmlsZUFzc2V0IGNvcnJlY3RseSBzZXRzIG1ldGFkYXRhIGFuZCBjcmVhdGVzIFMzIHBhcmFtZXRlcnMnKHRlc3Q6IFRlc3QpIHtcbiAgICAvLyBHSVZFTlxuICAgIGNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKCk7XG5cbiAgICAvLyBXSEVOXG4gICAgc3RhY2suYWRkRmlsZUFzc2V0KHtcbiAgICAgIGZpbGVOYW1lOiAnZmlsZS1uYW1lJyxcbiAgICAgIHBhY2thZ2luZzogRmlsZUFzc2V0UGFja2FnaW5nLlpJUF9ESVJFQ1RPUlksXG4gICAgICBzb3VyY2VIYXNoOiAnc291cmNlLWhhc2gnXG4gICAgfSk7XG5cbiAgICAvLyBUSEVOXG4gICAgY29uc3QgYXNzZXRNZXRhZGF0YSA9IHN0YWNrLm5vZGUubWV0YWRhdGEuZmluZCgoeyB0eXBlIH0pID0+IHR5cGUgPT09IGN4YXBpLkFTU0VUX01FVEFEQVRBKTtcblxuICAgIHRlc3QuZXF1YWwoYXNzZXRNZXRhZGF0YSAmJiBhc3NldE1ldGFkYXRhLmRhdGEucGF0aCwgJ2ZpbGUtbmFtZScpO1xuICAgIHRlc3QuZXF1YWwoYXNzZXRNZXRhZGF0YSAmJiBhc3NldE1ldGFkYXRhLmRhdGEuaWQsICdzb3VyY2UtaGFzaCcpO1xuICAgIHRlc3QuZXF1YWwoYXNzZXRNZXRhZGF0YSAmJiBhc3NldE1ldGFkYXRhLmRhdGEucGFja2FnaW5nLCBGaWxlQXNzZXRQYWNrYWdpbmcuWklQX0RJUkVDVE9SWSk7XG4gICAgdGVzdC5lcXVhbChhc3NldE1ldGFkYXRhICYmIGFzc2V0TWV0YWRhdGEuZGF0YS5zb3VyY2VIYXNoLCAnc291cmNlLWhhc2gnKTtcblxuICAgIHRlc3QuZGVlcEVxdWFsKHRvQ2xvdWRGb3JtYXRpb24oc3RhY2spLCB7XG4gICAgICBQYXJhbWV0ZXJzOiB7XG4gICAgICAgIEFzc2V0UGFyYW1ldGVyc3NvdXJjZWhhc2hTM0J1Y2tldEU2RTkxRTNFOiB7XG4gICAgICAgICAgVHlwZTogJ1N0cmluZycsXG4gICAgICAgICAgRGVzY3JpcHRpb246ICdTMyBidWNrZXQgZm9yIGFzc2V0IFwic291cmNlLWhhc2hcIidcbiAgICAgICAgfSxcbiAgICAgICAgQXNzZXRQYXJhbWV0ZXJzc291cmNlaGFzaFMzVmVyc2lvbktleUFDNDE1N0MzOiB7XG4gICAgICAgICAgVHlwZTogJ1N0cmluZycsXG4gICAgICAgICAgRGVzY3JpcHRpb246ICdTMyBrZXkgZm9yIGFzc2V0IHZlcnNpb24gXCJzb3VyY2UtaGFzaFwiJ1xuICAgICAgICB9LFxuICAgICAgICBBc3NldFBhcmFtZXRlcnNzb3VyY2VoYXNoQXJ0aWZhY3RIYXNoQURCQUU0MTg6IHtcbiAgICAgICAgICBUeXBlOiAnU3RyaW5nJyxcbiAgICAgICAgICBEZXNjcmlwdGlvbjogJ0FydGlmYWN0IGhhc2ggZm9yIGFzc2V0IFwic291cmNlLWhhc2hcIidcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH0pO1xuXG4gICAgdGVzdC5kb25lKCk7XG5cbiAgfSxcblxuICAnYWRkRG9ja2VySW1hZ2VBc3NldCBjb3JyZWN0bHkgc2V0cyBtZXRhZGF0YSBhbmQgY3JlYXRlcyBhbiBFQ1IgcGFyYW1ldGVyJyh0ZXN0OiBUZXN0KSB7XG4gICAgLy8gR0lWRU5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBTdGFjaygpO1xuXG4gICAgLy8gV0hFTlxuICAgIHN0YWNrLmFkZERvY2tlckltYWdlQXNzZXQoe1xuICAgICAgc291cmNlSGFzaDogJ3NvdXJjZS1oYXNoJyxcbiAgICAgIGRpcmVjdG9yeU5hbWU6ICdkaXJlY3RvcnktbmFtZScsXG4gICAgICByZXBvc2l0b3J5TmFtZTogJ3JlcG9zaXRvcnktbmFtZSdcbiAgICB9KTtcblxuICAgIC8vIFRIRU5cbiAgICBjb25zdCBhc3NldE1ldGFkYXRhID0gc3RhY2subm9kZS5tZXRhZGF0YS5maW5kKCh7IHR5cGUgfSkgPT4gdHlwZSA9PT0gY3hhcGkuQVNTRVRfTUVUQURBVEEpO1xuXG4gICAgdGVzdC5lcXVhbChhc3NldE1ldGFkYXRhICYmIGFzc2V0TWV0YWRhdGEuZGF0YS5wYWNrYWdpbmcsICdjb250YWluZXItaW1hZ2UnKTtcbiAgICB0ZXN0LmVxdWFsKGFzc2V0TWV0YWRhdGEgJiYgYXNzZXRNZXRhZGF0YS5kYXRhLnBhdGgsICdkaXJlY3RvcnktbmFtZScpO1xuICAgIHRlc3QuZXF1YWwoYXNzZXRNZXRhZGF0YSAmJiBhc3NldE1ldGFkYXRhLmRhdGEuc291cmNlSGFzaCwgJ3NvdXJjZS1oYXNoJyk7XG4gICAgdGVzdC5lcXVhbChhc3NldE1ldGFkYXRhICYmIGFzc2V0TWV0YWRhdGEuZGF0YS5yZXBvc2l0b3J5TmFtZSwgJ3JlcG9zaXRvcnktbmFtZScpO1xuXG4gICAgdGVzdC5kZWVwRXF1YWwodG9DbG91ZEZvcm1hdGlvbihzdGFjayksIHtcbiAgICAgIFBhcmFtZXRlcnM6IHtcbiAgICAgICAgQXNzZXRQYXJhbWV0ZXJzc291cmNlaGFzaEltYWdlTmFtZTNCNTcyQjEyOiB7XG4gICAgICAgICAgVHlwZTogJ1N0cmluZycsXG4gICAgICAgICAgRGVzY3JpcHRpb246ICdFQ1IgcmVwb3NpdG9yeSBuYW1lIGFuZCB0YWcgZm9yIGFzc2V0IFwic291cmNlLWhhc2hcIidcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH0pO1xuXG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG59O1xuIl19