"use strict";
const nodeunit = require("nodeunit");
const core = require("../lib");
module.exports = nodeunit.testCase({
    '._toCloudFormation': {
        'does not call renderProperties with an undefined value'(test) {
            const app = new core.App();
            const stack = new core.Stack(app, 'TestStack');
            const resource = new core.CfnResource(stack, 'DefaultResource', { type: 'Test::Resource::Fake' });
            let called = false;
            resource.renderProperties = (val) => {
                called = true;
                test.notEqual(val, null);
            };
            test.deepEqual(app.synth().getStackByName(stack.stackName).template, {
                Resources: {
                    DefaultResource: {
                        Type: 'Test::Resource::Fake'
                    }
                }
            });
            test.ok(called, `renderProperties must be called called`);
            test.done();
        }
    },
    'applyRemovalPolicy default includes Update policy'(test) {
        // GIVEN
        const app = new core.App();
        const stack = new core.Stack(app, 'TestStack');
        const resource = new core.CfnResource(stack, 'DefaultResource', { type: 'Test::Resource::Fake' });
        // WHEN
        resource.applyRemovalPolicy(core.RemovalPolicy.RETAIN);
        // THEN
        test.deepEqual(app.synth().getStackByName(stack.stackName).template, {
            Resources: {
                DefaultResource: {
                    Type: 'Test::Resource::Fake',
                    DeletionPolicy: 'Retain',
                    UpdateReplacePolicy: 'Retain',
                }
            }
        });
        test.done();
    },
    'can switch off updating Update policy'(test) {
        // GIVEN
        const app = new core.App();
        const stack = new core.Stack(app, 'TestStack');
        const resource = new core.CfnResource(stack, 'DefaultResource', { type: 'Test::Resource::Fake' });
        // WHEN
        resource.applyRemovalPolicy(core.RemovalPolicy.RETAIN, {
            applyToUpdateReplacePolicy: false
        });
        // THEN
        test.deepEqual(app.synth().getStackByName(stack.stackName).template, {
            Resources: {
                DefaultResource: {
                    Type: 'Test::Resource::Fake',
                    DeletionPolicy: 'Retain',
                }
            }
        });
        test.done();
    },
});
//# sourceMappingURL=data:application/json;base64,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