# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthorizationProfileArgs', 'AuthorizationProfile']

@pulumi.input_type
class AuthorizationProfileArgs:
    def __init__(__self__, *,
                 access_type: Optional[pulumi.Input[builtins.str]] = None,
                 acl: Optional[pulumi.Input[builtins.str]] = None,
                 advanced_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationProfileAdvancedAttributeArgs']]]] = None,
                 agentless_posture: Optional[pulumi.Input[builtins.bool]] = None,
                 airespace_acl: Optional[pulumi.Input[builtins.str]] = None,
                 airespace_ipv6_acl: Optional[pulumi.Input[builtins.str]] = None,
                 asa_vpn: Optional[pulumi.Input[builtins.str]] = None,
                 auto_smart_port: Optional[pulumi.Input[builtins.str]] = None,
                 avc_profile: Optional[pulumi.Input[builtins.str]] = None,
                 dacl_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 easywired_session_candidate: Optional[pulumi.Input[builtins.bool]] = None,
                 interface_template: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_acl_filter: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_dacl_name: Optional[pulumi.Input[builtins.str]] = None,
                 mac_sec_policy: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 neat: Optional[pulumi.Input[builtins.bool]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 reauthentication_connectivity: Optional[pulumi.Input[builtins.str]] = None,
                 reauthentication_timer: Optional[pulumi.Input[builtins.int]] = None,
                 service_template: Optional[pulumi.Input[builtins.bool]] = None,
                 track_movement: Optional[pulumi.Input[builtins.bool]] = None,
                 unique_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_name_id: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_tag_id: Optional[pulumi.Input[builtins.int]] = None,
                 voice_domain_permission: Optional[pulumi.Input[builtins.bool]] = None,
                 web_auth: Optional[pulumi.Input[builtins.bool]] = None,
                 web_redirection_acl: Optional[pulumi.Input[builtins.str]] = None,
                 web_redirection_display_certificates_renewal_messages: Optional[pulumi.Input[builtins.bool]] = None,
                 web_redirection_portal_name: Optional[pulumi.Input[builtins.str]] = None,
                 web_redirection_static_ip_host_name_fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 web_redirection_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AuthorizationProfile resource.
        :param pulumi.Input[builtins.str] access_type: Access type - Choices: `ACCESS_ACCEPT`, `ACCESS_REJECT` - Default value: `ACCESS_ACCEPT`
        :param pulumi.Input[builtins.str] acl: ACL
        :param pulumi.Input[Sequence[pulumi.Input['AuthorizationProfileAdvancedAttributeArgs']]] advanced_attributes: List of advanced attributes
        :param pulumi.Input[builtins.bool] agentless_posture: Agentless Posture.
        :param pulumi.Input[builtins.str] airespace_acl: Airespace ACL
        :param pulumi.Input[builtins.str] airespace_ipv6_acl: Airespace IPv6 ACL
        :param pulumi.Input[builtins.str] asa_vpn: ASA VPN
        :param pulumi.Input[builtins.str] auto_smart_port: Auto smart port
        :param pulumi.Input[builtins.str] avc_profile: AVC profile
        :param pulumi.Input[builtins.str] dacl_name: DACL name
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.bool] easywired_session_candidate: Easy wired session candidate - Default value: `false`
        :param pulumi.Input[builtins.str] interface_template: Interface template
        :param pulumi.Input[builtins.str] ipv6_acl_filter: IPv6 ACL
        :param pulumi.Input[builtins.str] ipv6_dacl_name: IPv6 DACL name
        :param pulumi.Input[builtins.str] mac_sec_policy: MacSec policy - Choices: `MUST_SECURE`, `MUST_NOT_SECURE`, `SHOULD_SECURE`
        :param pulumi.Input[builtins.str] name: The name of the authorization profile
        :param pulumi.Input[builtins.bool] neat: NEAT - Default value: `false`
        :param pulumi.Input[builtins.str] profile_name: Value needs to be an existing Network Device Profile - Default value: `Cisco`
        :param pulumi.Input[builtins.str] reauthentication_connectivity: Maintain Connectivity During Reauthentication - Choices: `DEFAULT`, `RADIUS_REQUEST`
        :param pulumi.Input[builtins.int] reauthentication_timer: Reauthentication timer - Range: `1`-`65535`
        :param pulumi.Input[builtins.bool] service_template: Service template - Default value: `false`
        :param pulumi.Input[builtins.bool] track_movement: Track movement - Default value: `false`
        :param pulumi.Input[builtins.str] unique_identifier: Unique identifier
        :param pulumi.Input[builtins.str] vlan_name_id: Vlan name or ID
        :param pulumi.Input[builtins.int] vlan_tag_id: Vlan tag ID - Range: `0`-`31`
        :param pulumi.Input[builtins.bool] voice_domain_permission: Voice domain permission - Default value: `false`
        :param pulumi.Input[builtins.bool] web_auth: Web authentication (local) - Default value: `false`
        :param pulumi.Input[builtins.str] web_redirection_acl: Web redirection ACL
        :param pulumi.Input[builtins.bool] web_redirection_display_certificates_renewal_messages: This attribute is mandatory when `web_redirection_type` value is `CentralizedWebAuth`. For all other
               `web_redirection_type` values the field must be ignored.
        :param pulumi.Input[builtins.str] web_redirection_portal_name: A portal that exist in the DB and fits the `web_redirection_type`
        :param pulumi.Input[builtins.str] web_redirection_static_ip_host_name_fqdn: IP, hostname or FQDN
        :param pulumi.Input[builtins.str] web_redirection_type: This type must fit the `web_redirection_portal_name` - Choices: `CentralizedWebAuth`, `HotSpot`,
               `NativeSupplicanProvisioning`, `ClientProvisioning`
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if advanced_attributes is not None:
            pulumi.set(__self__, "advanced_attributes", advanced_attributes)
        if agentless_posture is not None:
            pulumi.set(__self__, "agentless_posture", agentless_posture)
        if airespace_acl is not None:
            pulumi.set(__self__, "airespace_acl", airespace_acl)
        if airespace_ipv6_acl is not None:
            pulumi.set(__self__, "airespace_ipv6_acl", airespace_ipv6_acl)
        if asa_vpn is not None:
            pulumi.set(__self__, "asa_vpn", asa_vpn)
        if auto_smart_port is not None:
            pulumi.set(__self__, "auto_smart_port", auto_smart_port)
        if avc_profile is not None:
            pulumi.set(__self__, "avc_profile", avc_profile)
        if dacl_name is not None:
            pulumi.set(__self__, "dacl_name", dacl_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if easywired_session_candidate is not None:
            pulumi.set(__self__, "easywired_session_candidate", easywired_session_candidate)
        if interface_template is not None:
            pulumi.set(__self__, "interface_template", interface_template)
        if ipv6_acl_filter is not None:
            pulumi.set(__self__, "ipv6_acl_filter", ipv6_acl_filter)
        if ipv6_dacl_name is not None:
            pulumi.set(__self__, "ipv6_dacl_name", ipv6_dacl_name)
        if mac_sec_policy is not None:
            pulumi.set(__self__, "mac_sec_policy", mac_sec_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if neat is not None:
            pulumi.set(__self__, "neat", neat)
        if profile_name is not None:
            pulumi.set(__self__, "profile_name", profile_name)
        if reauthentication_connectivity is not None:
            pulumi.set(__self__, "reauthentication_connectivity", reauthentication_connectivity)
        if reauthentication_timer is not None:
            pulumi.set(__self__, "reauthentication_timer", reauthentication_timer)
        if service_template is not None:
            pulumi.set(__self__, "service_template", service_template)
        if track_movement is not None:
            pulumi.set(__self__, "track_movement", track_movement)
        if unique_identifier is not None:
            pulumi.set(__self__, "unique_identifier", unique_identifier)
        if vlan_name_id is not None:
            pulumi.set(__self__, "vlan_name_id", vlan_name_id)
        if vlan_tag_id is not None:
            pulumi.set(__self__, "vlan_tag_id", vlan_tag_id)
        if voice_domain_permission is not None:
            pulumi.set(__self__, "voice_domain_permission", voice_domain_permission)
        if web_auth is not None:
            pulumi.set(__self__, "web_auth", web_auth)
        if web_redirection_acl is not None:
            pulumi.set(__self__, "web_redirection_acl", web_redirection_acl)
        if web_redirection_display_certificates_renewal_messages is not None:
            pulumi.set(__self__, "web_redirection_display_certificates_renewal_messages", web_redirection_display_certificates_renewal_messages)
        if web_redirection_portal_name is not None:
            pulumi.set(__self__, "web_redirection_portal_name", web_redirection_portal_name)
        if web_redirection_static_ip_host_name_fqdn is not None:
            pulumi.set(__self__, "web_redirection_static_ip_host_name_fqdn", web_redirection_static_ip_host_name_fqdn)
        if web_redirection_type is not None:
            pulumi.set(__self__, "web_redirection_type", web_redirection_type)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Access type - Choices: `ACCESS_ACCEPT`, `ACCESS_REJECT` - Default value: `ACCESS_ACCEPT`
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_type", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ACL
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter(name="advancedAttributes")
    def advanced_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationProfileAdvancedAttributeArgs']]]]:
        """
        List of advanced attributes
        """
        return pulumi.get(self, "advanced_attributes")

    @advanced_attributes.setter
    def advanced_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationProfileAdvancedAttributeArgs']]]]):
        pulumi.set(self, "advanced_attributes", value)

    @property
    @pulumi.getter(name="agentlessPosture")
    def agentless_posture(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Agentless Posture.
        """
        return pulumi.get(self, "agentless_posture")

    @agentless_posture.setter
    def agentless_posture(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "agentless_posture", value)

    @property
    @pulumi.getter(name="airespaceAcl")
    def airespace_acl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Airespace ACL
        """
        return pulumi.get(self, "airespace_acl")

    @airespace_acl.setter
    def airespace_acl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "airespace_acl", value)

    @property
    @pulumi.getter(name="airespaceIpv6Acl")
    def airespace_ipv6_acl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Airespace IPv6 ACL
        """
        return pulumi.get(self, "airespace_ipv6_acl")

    @airespace_ipv6_acl.setter
    def airespace_ipv6_acl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "airespace_ipv6_acl", value)

    @property
    @pulumi.getter(name="asaVpn")
    def asa_vpn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ASA VPN
        """
        return pulumi.get(self, "asa_vpn")

    @asa_vpn.setter
    def asa_vpn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "asa_vpn", value)

    @property
    @pulumi.getter(name="autoSmartPort")
    def auto_smart_port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Auto smart port
        """
        return pulumi.get(self, "auto_smart_port")

    @auto_smart_port.setter
    def auto_smart_port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auto_smart_port", value)

    @property
    @pulumi.getter(name="avcProfile")
    def avc_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AVC profile
        """
        return pulumi.get(self, "avc_profile")

    @avc_profile.setter
    def avc_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "avc_profile", value)

    @property
    @pulumi.getter(name="daclName")
    def dacl_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DACL name
        """
        return pulumi.get(self, "dacl_name")

    @dacl_name.setter
    def dacl_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dacl_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="easywiredSessionCandidate")
    def easywired_session_candidate(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Easy wired session candidate - Default value: `false`
        """
        return pulumi.get(self, "easywired_session_candidate")

    @easywired_session_candidate.setter
    def easywired_session_candidate(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "easywired_session_candidate", value)

    @property
    @pulumi.getter(name="interfaceTemplate")
    def interface_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interface template
        """
        return pulumi.get(self, "interface_template")

    @interface_template.setter
    def interface_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_template", value)

    @property
    @pulumi.getter(name="ipv6AclFilter")
    def ipv6_acl_filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv6 ACL
        """
        return pulumi.get(self, "ipv6_acl_filter")

    @ipv6_acl_filter.setter
    def ipv6_acl_filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv6_acl_filter", value)

    @property
    @pulumi.getter(name="ipv6DaclName")
    def ipv6_dacl_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv6 DACL name
        """
        return pulumi.get(self, "ipv6_dacl_name")

    @ipv6_dacl_name.setter
    def ipv6_dacl_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv6_dacl_name", value)

    @property
    @pulumi.getter(name="macSecPolicy")
    def mac_sec_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        MacSec policy - Choices: `MUST_SECURE`, `MUST_NOT_SECURE`, `SHOULD_SECURE`
        """
        return pulumi.get(self, "mac_sec_policy")

    @mac_sec_policy.setter
    def mac_sec_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mac_sec_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the authorization profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def neat(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        NEAT - Default value: `false`
        """
        return pulumi.get(self, "neat")

    @neat.setter
    def neat(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "neat", value)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Value needs to be an existing Network Device Profile - Default value: `Cisco`
        """
        return pulumi.get(self, "profile_name")

    @profile_name.setter
    def profile_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_name", value)

    @property
    @pulumi.getter(name="reauthenticationConnectivity")
    def reauthentication_connectivity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maintain Connectivity During Reauthentication - Choices: `DEFAULT`, `RADIUS_REQUEST`
        """
        return pulumi.get(self, "reauthentication_connectivity")

    @reauthentication_connectivity.setter
    def reauthentication_connectivity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reauthentication_connectivity", value)

    @property
    @pulumi.getter(name="reauthenticationTimer")
    def reauthentication_timer(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Reauthentication timer - Range: `1`-`65535`
        """
        return pulumi.get(self, "reauthentication_timer")

    @reauthentication_timer.setter
    def reauthentication_timer(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "reauthentication_timer", value)

    @property
    @pulumi.getter(name="serviceTemplate")
    def service_template(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Service template - Default value: `false`
        """
        return pulumi.get(self, "service_template")

    @service_template.setter
    def service_template(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "service_template", value)

    @property
    @pulumi.getter(name="trackMovement")
    def track_movement(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Track movement - Default value: `false`
        """
        return pulumi.get(self, "track_movement")

    @track_movement.setter
    def track_movement(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "track_movement", value)

    @property
    @pulumi.getter(name="uniqueIdentifier")
    def unique_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier
        """
        return pulumi.get(self, "unique_identifier")

    @unique_identifier.setter
    def unique_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unique_identifier", value)

    @property
    @pulumi.getter(name="vlanNameId")
    def vlan_name_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Vlan name or ID
        """
        return pulumi.get(self, "vlan_name_id")

    @vlan_name_id.setter
    def vlan_name_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vlan_name_id", value)

    @property
    @pulumi.getter(name="vlanTagId")
    def vlan_tag_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Vlan tag ID - Range: `0`-`31`
        """
        return pulumi.get(self, "vlan_tag_id")

    @vlan_tag_id.setter
    def vlan_tag_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vlan_tag_id", value)

    @property
    @pulumi.getter(name="voiceDomainPermission")
    def voice_domain_permission(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Voice domain permission - Default value: `false`
        """
        return pulumi.get(self, "voice_domain_permission")

    @voice_domain_permission.setter
    def voice_domain_permission(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "voice_domain_permission", value)

    @property
    @pulumi.getter(name="webAuth")
    def web_auth(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Web authentication (local) - Default value: `false`
        """
        return pulumi.get(self, "web_auth")

    @web_auth.setter
    def web_auth(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "web_auth", value)

    @property
    @pulumi.getter(name="webRedirectionAcl")
    def web_redirection_acl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Web redirection ACL
        """
        return pulumi.get(self, "web_redirection_acl")

    @web_redirection_acl.setter
    def web_redirection_acl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "web_redirection_acl", value)

    @property
    @pulumi.getter(name="webRedirectionDisplayCertificatesRenewalMessages")
    def web_redirection_display_certificates_renewal_messages(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This attribute is mandatory when `web_redirection_type` value is `CentralizedWebAuth`. For all other
        `web_redirection_type` values the field must be ignored.
        """
        return pulumi.get(self, "web_redirection_display_certificates_renewal_messages")

    @web_redirection_display_certificates_renewal_messages.setter
    def web_redirection_display_certificates_renewal_messages(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "web_redirection_display_certificates_renewal_messages", value)

    @property
    @pulumi.getter(name="webRedirectionPortalName")
    def web_redirection_portal_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A portal that exist in the DB and fits the `web_redirection_type`
        """
        return pulumi.get(self, "web_redirection_portal_name")

    @web_redirection_portal_name.setter
    def web_redirection_portal_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "web_redirection_portal_name", value)

    @property
    @pulumi.getter(name="webRedirectionStaticIpHostNameFqdn")
    def web_redirection_static_ip_host_name_fqdn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP, hostname or FQDN
        """
        return pulumi.get(self, "web_redirection_static_ip_host_name_fqdn")

    @web_redirection_static_ip_host_name_fqdn.setter
    def web_redirection_static_ip_host_name_fqdn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "web_redirection_static_ip_host_name_fqdn", value)

    @property
    @pulumi.getter(name="webRedirectionType")
    def web_redirection_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This type must fit the `web_redirection_portal_name` - Choices: `CentralizedWebAuth`, `HotSpot`,
        `NativeSupplicanProvisioning`, `ClientProvisioning`
        """
        return pulumi.get(self, "web_redirection_type")

    @web_redirection_type.setter
    def web_redirection_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "web_redirection_type", value)


@pulumi.input_type
class _AuthorizationProfileState:
    def __init__(__self__, *,
                 access_type: Optional[pulumi.Input[builtins.str]] = None,
                 acl: Optional[pulumi.Input[builtins.str]] = None,
                 advanced_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationProfileAdvancedAttributeArgs']]]] = None,
                 agentless_posture: Optional[pulumi.Input[builtins.bool]] = None,
                 airespace_acl: Optional[pulumi.Input[builtins.str]] = None,
                 airespace_ipv6_acl: Optional[pulumi.Input[builtins.str]] = None,
                 asa_vpn: Optional[pulumi.Input[builtins.str]] = None,
                 auto_smart_port: Optional[pulumi.Input[builtins.str]] = None,
                 avc_profile: Optional[pulumi.Input[builtins.str]] = None,
                 dacl_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 easywired_session_candidate: Optional[pulumi.Input[builtins.bool]] = None,
                 interface_template: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_acl_filter: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_dacl_name: Optional[pulumi.Input[builtins.str]] = None,
                 mac_sec_policy: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 neat: Optional[pulumi.Input[builtins.bool]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 reauthentication_connectivity: Optional[pulumi.Input[builtins.str]] = None,
                 reauthentication_timer: Optional[pulumi.Input[builtins.int]] = None,
                 service_template: Optional[pulumi.Input[builtins.bool]] = None,
                 track_movement: Optional[pulumi.Input[builtins.bool]] = None,
                 unique_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_name_id: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_tag_id: Optional[pulumi.Input[builtins.int]] = None,
                 voice_domain_permission: Optional[pulumi.Input[builtins.bool]] = None,
                 web_auth: Optional[pulumi.Input[builtins.bool]] = None,
                 web_redirection_acl: Optional[pulumi.Input[builtins.str]] = None,
                 web_redirection_display_certificates_renewal_messages: Optional[pulumi.Input[builtins.bool]] = None,
                 web_redirection_portal_name: Optional[pulumi.Input[builtins.str]] = None,
                 web_redirection_static_ip_host_name_fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 web_redirection_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthorizationProfile resources.
        :param pulumi.Input[builtins.str] access_type: Access type - Choices: `ACCESS_ACCEPT`, `ACCESS_REJECT` - Default value: `ACCESS_ACCEPT`
        :param pulumi.Input[builtins.str] acl: ACL
        :param pulumi.Input[Sequence[pulumi.Input['AuthorizationProfileAdvancedAttributeArgs']]] advanced_attributes: List of advanced attributes
        :param pulumi.Input[builtins.bool] agentless_posture: Agentless Posture.
        :param pulumi.Input[builtins.str] airespace_acl: Airespace ACL
        :param pulumi.Input[builtins.str] airespace_ipv6_acl: Airespace IPv6 ACL
        :param pulumi.Input[builtins.str] asa_vpn: ASA VPN
        :param pulumi.Input[builtins.str] auto_smart_port: Auto smart port
        :param pulumi.Input[builtins.str] avc_profile: AVC profile
        :param pulumi.Input[builtins.str] dacl_name: DACL name
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.bool] easywired_session_candidate: Easy wired session candidate - Default value: `false`
        :param pulumi.Input[builtins.str] interface_template: Interface template
        :param pulumi.Input[builtins.str] ipv6_acl_filter: IPv6 ACL
        :param pulumi.Input[builtins.str] ipv6_dacl_name: IPv6 DACL name
        :param pulumi.Input[builtins.str] mac_sec_policy: MacSec policy - Choices: `MUST_SECURE`, `MUST_NOT_SECURE`, `SHOULD_SECURE`
        :param pulumi.Input[builtins.str] name: The name of the authorization profile
        :param pulumi.Input[builtins.bool] neat: NEAT - Default value: `false`
        :param pulumi.Input[builtins.str] profile_name: Value needs to be an existing Network Device Profile - Default value: `Cisco`
        :param pulumi.Input[builtins.str] reauthentication_connectivity: Maintain Connectivity During Reauthentication - Choices: `DEFAULT`, `RADIUS_REQUEST`
        :param pulumi.Input[builtins.int] reauthentication_timer: Reauthentication timer - Range: `1`-`65535`
        :param pulumi.Input[builtins.bool] service_template: Service template - Default value: `false`
        :param pulumi.Input[builtins.bool] track_movement: Track movement - Default value: `false`
        :param pulumi.Input[builtins.str] unique_identifier: Unique identifier
        :param pulumi.Input[builtins.str] vlan_name_id: Vlan name or ID
        :param pulumi.Input[builtins.int] vlan_tag_id: Vlan tag ID - Range: `0`-`31`
        :param pulumi.Input[builtins.bool] voice_domain_permission: Voice domain permission - Default value: `false`
        :param pulumi.Input[builtins.bool] web_auth: Web authentication (local) - Default value: `false`
        :param pulumi.Input[builtins.str] web_redirection_acl: Web redirection ACL
        :param pulumi.Input[builtins.bool] web_redirection_display_certificates_renewal_messages: This attribute is mandatory when `web_redirection_type` value is `CentralizedWebAuth`. For all other
               `web_redirection_type` values the field must be ignored.
        :param pulumi.Input[builtins.str] web_redirection_portal_name: A portal that exist in the DB and fits the `web_redirection_type`
        :param pulumi.Input[builtins.str] web_redirection_static_ip_host_name_fqdn: IP, hostname or FQDN
        :param pulumi.Input[builtins.str] web_redirection_type: This type must fit the `web_redirection_portal_name` - Choices: `CentralizedWebAuth`, `HotSpot`,
               `NativeSupplicanProvisioning`, `ClientProvisioning`
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if advanced_attributes is not None:
            pulumi.set(__self__, "advanced_attributes", advanced_attributes)
        if agentless_posture is not None:
            pulumi.set(__self__, "agentless_posture", agentless_posture)
        if airespace_acl is not None:
            pulumi.set(__self__, "airespace_acl", airespace_acl)
        if airespace_ipv6_acl is not None:
            pulumi.set(__self__, "airespace_ipv6_acl", airespace_ipv6_acl)
        if asa_vpn is not None:
            pulumi.set(__self__, "asa_vpn", asa_vpn)
        if auto_smart_port is not None:
            pulumi.set(__self__, "auto_smart_port", auto_smart_port)
        if avc_profile is not None:
            pulumi.set(__self__, "avc_profile", avc_profile)
        if dacl_name is not None:
            pulumi.set(__self__, "dacl_name", dacl_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if easywired_session_candidate is not None:
            pulumi.set(__self__, "easywired_session_candidate", easywired_session_candidate)
        if interface_template is not None:
            pulumi.set(__self__, "interface_template", interface_template)
        if ipv6_acl_filter is not None:
            pulumi.set(__self__, "ipv6_acl_filter", ipv6_acl_filter)
        if ipv6_dacl_name is not None:
            pulumi.set(__self__, "ipv6_dacl_name", ipv6_dacl_name)
        if mac_sec_policy is not None:
            pulumi.set(__self__, "mac_sec_policy", mac_sec_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if neat is not None:
            pulumi.set(__self__, "neat", neat)
        if profile_name is not None:
            pulumi.set(__self__, "profile_name", profile_name)
        if reauthentication_connectivity is not None:
            pulumi.set(__self__, "reauthentication_connectivity", reauthentication_connectivity)
        if reauthentication_timer is not None:
            pulumi.set(__self__, "reauthentication_timer", reauthentication_timer)
        if service_template is not None:
            pulumi.set(__self__, "service_template", service_template)
        if track_movement is not None:
            pulumi.set(__self__, "track_movement", track_movement)
        if unique_identifier is not None:
            pulumi.set(__self__, "unique_identifier", unique_identifier)
        if vlan_name_id is not None:
            pulumi.set(__self__, "vlan_name_id", vlan_name_id)
        if vlan_tag_id is not None:
            pulumi.set(__self__, "vlan_tag_id", vlan_tag_id)
        if voice_domain_permission is not None:
            pulumi.set(__self__, "voice_domain_permission", voice_domain_permission)
        if web_auth is not None:
            pulumi.set(__self__, "web_auth", web_auth)
        if web_redirection_acl is not None:
            pulumi.set(__self__, "web_redirection_acl", web_redirection_acl)
        if web_redirection_display_certificates_renewal_messages is not None:
            pulumi.set(__self__, "web_redirection_display_certificates_renewal_messages", web_redirection_display_certificates_renewal_messages)
        if web_redirection_portal_name is not None:
            pulumi.set(__self__, "web_redirection_portal_name", web_redirection_portal_name)
        if web_redirection_static_ip_host_name_fqdn is not None:
            pulumi.set(__self__, "web_redirection_static_ip_host_name_fqdn", web_redirection_static_ip_host_name_fqdn)
        if web_redirection_type is not None:
            pulumi.set(__self__, "web_redirection_type", web_redirection_type)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Access type - Choices: `ACCESS_ACCEPT`, `ACCESS_REJECT` - Default value: `ACCESS_ACCEPT`
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_type", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ACL
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter(name="advancedAttributes")
    def advanced_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationProfileAdvancedAttributeArgs']]]]:
        """
        List of advanced attributes
        """
        return pulumi.get(self, "advanced_attributes")

    @advanced_attributes.setter
    def advanced_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationProfileAdvancedAttributeArgs']]]]):
        pulumi.set(self, "advanced_attributes", value)

    @property
    @pulumi.getter(name="agentlessPosture")
    def agentless_posture(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Agentless Posture.
        """
        return pulumi.get(self, "agentless_posture")

    @agentless_posture.setter
    def agentless_posture(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "agentless_posture", value)

    @property
    @pulumi.getter(name="airespaceAcl")
    def airespace_acl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Airespace ACL
        """
        return pulumi.get(self, "airespace_acl")

    @airespace_acl.setter
    def airespace_acl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "airespace_acl", value)

    @property
    @pulumi.getter(name="airespaceIpv6Acl")
    def airespace_ipv6_acl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Airespace IPv6 ACL
        """
        return pulumi.get(self, "airespace_ipv6_acl")

    @airespace_ipv6_acl.setter
    def airespace_ipv6_acl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "airespace_ipv6_acl", value)

    @property
    @pulumi.getter(name="asaVpn")
    def asa_vpn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ASA VPN
        """
        return pulumi.get(self, "asa_vpn")

    @asa_vpn.setter
    def asa_vpn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "asa_vpn", value)

    @property
    @pulumi.getter(name="autoSmartPort")
    def auto_smart_port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Auto smart port
        """
        return pulumi.get(self, "auto_smart_port")

    @auto_smart_port.setter
    def auto_smart_port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auto_smart_port", value)

    @property
    @pulumi.getter(name="avcProfile")
    def avc_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AVC profile
        """
        return pulumi.get(self, "avc_profile")

    @avc_profile.setter
    def avc_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "avc_profile", value)

    @property
    @pulumi.getter(name="daclName")
    def dacl_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DACL name
        """
        return pulumi.get(self, "dacl_name")

    @dacl_name.setter
    def dacl_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dacl_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="easywiredSessionCandidate")
    def easywired_session_candidate(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Easy wired session candidate - Default value: `false`
        """
        return pulumi.get(self, "easywired_session_candidate")

    @easywired_session_candidate.setter
    def easywired_session_candidate(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "easywired_session_candidate", value)

    @property
    @pulumi.getter(name="interfaceTemplate")
    def interface_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interface template
        """
        return pulumi.get(self, "interface_template")

    @interface_template.setter
    def interface_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_template", value)

    @property
    @pulumi.getter(name="ipv6AclFilter")
    def ipv6_acl_filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv6 ACL
        """
        return pulumi.get(self, "ipv6_acl_filter")

    @ipv6_acl_filter.setter
    def ipv6_acl_filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv6_acl_filter", value)

    @property
    @pulumi.getter(name="ipv6DaclName")
    def ipv6_dacl_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv6 DACL name
        """
        return pulumi.get(self, "ipv6_dacl_name")

    @ipv6_dacl_name.setter
    def ipv6_dacl_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv6_dacl_name", value)

    @property
    @pulumi.getter(name="macSecPolicy")
    def mac_sec_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        MacSec policy - Choices: `MUST_SECURE`, `MUST_NOT_SECURE`, `SHOULD_SECURE`
        """
        return pulumi.get(self, "mac_sec_policy")

    @mac_sec_policy.setter
    def mac_sec_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mac_sec_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the authorization profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def neat(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        NEAT - Default value: `false`
        """
        return pulumi.get(self, "neat")

    @neat.setter
    def neat(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "neat", value)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Value needs to be an existing Network Device Profile - Default value: `Cisco`
        """
        return pulumi.get(self, "profile_name")

    @profile_name.setter
    def profile_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_name", value)

    @property
    @pulumi.getter(name="reauthenticationConnectivity")
    def reauthentication_connectivity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maintain Connectivity During Reauthentication - Choices: `DEFAULT`, `RADIUS_REQUEST`
        """
        return pulumi.get(self, "reauthentication_connectivity")

    @reauthentication_connectivity.setter
    def reauthentication_connectivity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reauthentication_connectivity", value)

    @property
    @pulumi.getter(name="reauthenticationTimer")
    def reauthentication_timer(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Reauthentication timer - Range: `1`-`65535`
        """
        return pulumi.get(self, "reauthentication_timer")

    @reauthentication_timer.setter
    def reauthentication_timer(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "reauthentication_timer", value)

    @property
    @pulumi.getter(name="serviceTemplate")
    def service_template(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Service template - Default value: `false`
        """
        return pulumi.get(self, "service_template")

    @service_template.setter
    def service_template(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "service_template", value)

    @property
    @pulumi.getter(name="trackMovement")
    def track_movement(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Track movement - Default value: `false`
        """
        return pulumi.get(self, "track_movement")

    @track_movement.setter
    def track_movement(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "track_movement", value)

    @property
    @pulumi.getter(name="uniqueIdentifier")
    def unique_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier
        """
        return pulumi.get(self, "unique_identifier")

    @unique_identifier.setter
    def unique_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unique_identifier", value)

    @property
    @pulumi.getter(name="vlanNameId")
    def vlan_name_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Vlan name or ID
        """
        return pulumi.get(self, "vlan_name_id")

    @vlan_name_id.setter
    def vlan_name_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vlan_name_id", value)

    @property
    @pulumi.getter(name="vlanTagId")
    def vlan_tag_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Vlan tag ID - Range: `0`-`31`
        """
        return pulumi.get(self, "vlan_tag_id")

    @vlan_tag_id.setter
    def vlan_tag_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vlan_tag_id", value)

    @property
    @pulumi.getter(name="voiceDomainPermission")
    def voice_domain_permission(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Voice domain permission - Default value: `false`
        """
        return pulumi.get(self, "voice_domain_permission")

    @voice_domain_permission.setter
    def voice_domain_permission(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "voice_domain_permission", value)

    @property
    @pulumi.getter(name="webAuth")
    def web_auth(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Web authentication (local) - Default value: `false`
        """
        return pulumi.get(self, "web_auth")

    @web_auth.setter
    def web_auth(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "web_auth", value)

    @property
    @pulumi.getter(name="webRedirectionAcl")
    def web_redirection_acl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Web redirection ACL
        """
        return pulumi.get(self, "web_redirection_acl")

    @web_redirection_acl.setter
    def web_redirection_acl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "web_redirection_acl", value)

    @property
    @pulumi.getter(name="webRedirectionDisplayCertificatesRenewalMessages")
    def web_redirection_display_certificates_renewal_messages(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This attribute is mandatory when `web_redirection_type` value is `CentralizedWebAuth`. For all other
        `web_redirection_type` values the field must be ignored.
        """
        return pulumi.get(self, "web_redirection_display_certificates_renewal_messages")

    @web_redirection_display_certificates_renewal_messages.setter
    def web_redirection_display_certificates_renewal_messages(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "web_redirection_display_certificates_renewal_messages", value)

    @property
    @pulumi.getter(name="webRedirectionPortalName")
    def web_redirection_portal_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A portal that exist in the DB and fits the `web_redirection_type`
        """
        return pulumi.get(self, "web_redirection_portal_name")

    @web_redirection_portal_name.setter
    def web_redirection_portal_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "web_redirection_portal_name", value)

    @property
    @pulumi.getter(name="webRedirectionStaticIpHostNameFqdn")
    def web_redirection_static_ip_host_name_fqdn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP, hostname or FQDN
        """
        return pulumi.get(self, "web_redirection_static_ip_host_name_fqdn")

    @web_redirection_static_ip_host_name_fqdn.setter
    def web_redirection_static_ip_host_name_fqdn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "web_redirection_static_ip_host_name_fqdn", value)

    @property
    @pulumi.getter(name="webRedirectionType")
    def web_redirection_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This type must fit the `web_redirection_portal_name` - Choices: `CentralizedWebAuth`, `HotSpot`,
        `NativeSupplicanProvisioning`, `ClientProvisioning`
        """
        return pulumi.get(self, "web_redirection_type")

    @web_redirection_type.setter
    def web_redirection_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "web_redirection_type", value)


class AuthorizationProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_type: Optional[pulumi.Input[builtins.str]] = None,
                 acl: Optional[pulumi.Input[builtins.str]] = None,
                 advanced_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationProfileAdvancedAttributeArgs', 'AuthorizationProfileAdvancedAttributeArgsDict']]]]] = None,
                 agentless_posture: Optional[pulumi.Input[builtins.bool]] = None,
                 airespace_acl: Optional[pulumi.Input[builtins.str]] = None,
                 airespace_ipv6_acl: Optional[pulumi.Input[builtins.str]] = None,
                 asa_vpn: Optional[pulumi.Input[builtins.str]] = None,
                 auto_smart_port: Optional[pulumi.Input[builtins.str]] = None,
                 avc_profile: Optional[pulumi.Input[builtins.str]] = None,
                 dacl_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 easywired_session_candidate: Optional[pulumi.Input[builtins.bool]] = None,
                 interface_template: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_acl_filter: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_dacl_name: Optional[pulumi.Input[builtins.str]] = None,
                 mac_sec_policy: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 neat: Optional[pulumi.Input[builtins.bool]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 reauthentication_connectivity: Optional[pulumi.Input[builtins.str]] = None,
                 reauthentication_timer: Optional[pulumi.Input[builtins.int]] = None,
                 service_template: Optional[pulumi.Input[builtins.bool]] = None,
                 track_movement: Optional[pulumi.Input[builtins.bool]] = None,
                 unique_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_name_id: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_tag_id: Optional[pulumi.Input[builtins.int]] = None,
                 voice_domain_permission: Optional[pulumi.Input[builtins.bool]] = None,
                 web_auth: Optional[pulumi.Input[builtins.bool]] = None,
                 web_redirection_acl: Optional[pulumi.Input[builtins.str]] = None,
                 web_redirection_display_certificates_renewal_messages: Optional[pulumi.Input[builtins.bool]] = None,
                 web_redirection_portal_name: Optional[pulumi.Input[builtins.str]] = None,
                 web_redirection_static_ip_host_name_fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 web_redirection_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage an authorization profiles policy element.

        ## Import

        ```sh
        $ pulumi import ise:networkaccess/authorizationProfile:AuthorizationProfile example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_type: Access type - Choices: `ACCESS_ACCEPT`, `ACCESS_REJECT` - Default value: `ACCESS_ACCEPT`
        :param pulumi.Input[builtins.str] acl: ACL
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationProfileAdvancedAttributeArgs', 'AuthorizationProfileAdvancedAttributeArgsDict']]]] advanced_attributes: List of advanced attributes
        :param pulumi.Input[builtins.bool] agentless_posture: Agentless Posture.
        :param pulumi.Input[builtins.str] airespace_acl: Airespace ACL
        :param pulumi.Input[builtins.str] airespace_ipv6_acl: Airespace IPv6 ACL
        :param pulumi.Input[builtins.str] asa_vpn: ASA VPN
        :param pulumi.Input[builtins.str] auto_smart_port: Auto smart port
        :param pulumi.Input[builtins.str] avc_profile: AVC profile
        :param pulumi.Input[builtins.str] dacl_name: DACL name
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.bool] easywired_session_candidate: Easy wired session candidate - Default value: `false`
        :param pulumi.Input[builtins.str] interface_template: Interface template
        :param pulumi.Input[builtins.str] ipv6_acl_filter: IPv6 ACL
        :param pulumi.Input[builtins.str] ipv6_dacl_name: IPv6 DACL name
        :param pulumi.Input[builtins.str] mac_sec_policy: MacSec policy - Choices: `MUST_SECURE`, `MUST_NOT_SECURE`, `SHOULD_SECURE`
        :param pulumi.Input[builtins.str] name: The name of the authorization profile
        :param pulumi.Input[builtins.bool] neat: NEAT - Default value: `false`
        :param pulumi.Input[builtins.str] profile_name: Value needs to be an existing Network Device Profile - Default value: `Cisco`
        :param pulumi.Input[builtins.str] reauthentication_connectivity: Maintain Connectivity During Reauthentication - Choices: `DEFAULT`, `RADIUS_REQUEST`
        :param pulumi.Input[builtins.int] reauthentication_timer: Reauthentication timer - Range: `1`-`65535`
        :param pulumi.Input[builtins.bool] service_template: Service template - Default value: `false`
        :param pulumi.Input[builtins.bool] track_movement: Track movement - Default value: `false`
        :param pulumi.Input[builtins.str] unique_identifier: Unique identifier
        :param pulumi.Input[builtins.str] vlan_name_id: Vlan name or ID
        :param pulumi.Input[builtins.int] vlan_tag_id: Vlan tag ID - Range: `0`-`31`
        :param pulumi.Input[builtins.bool] voice_domain_permission: Voice domain permission - Default value: `false`
        :param pulumi.Input[builtins.bool] web_auth: Web authentication (local) - Default value: `false`
        :param pulumi.Input[builtins.str] web_redirection_acl: Web redirection ACL
        :param pulumi.Input[builtins.bool] web_redirection_display_certificates_renewal_messages: This attribute is mandatory when `web_redirection_type` value is `CentralizedWebAuth`. For all other
               `web_redirection_type` values the field must be ignored.
        :param pulumi.Input[builtins.str] web_redirection_portal_name: A portal that exist in the DB and fits the `web_redirection_type`
        :param pulumi.Input[builtins.str] web_redirection_static_ip_host_name_fqdn: IP, hostname or FQDN
        :param pulumi.Input[builtins.str] web_redirection_type: This type must fit the `web_redirection_portal_name` - Choices: `CentralizedWebAuth`, `HotSpot`,
               `NativeSupplicanProvisioning`, `ClientProvisioning`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AuthorizationProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage an authorization profiles policy element.

        ## Import

        ```sh
        $ pulumi import ise:networkaccess/authorizationProfile:AuthorizationProfile example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param AuthorizationProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthorizationProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_type: Optional[pulumi.Input[builtins.str]] = None,
                 acl: Optional[pulumi.Input[builtins.str]] = None,
                 advanced_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationProfileAdvancedAttributeArgs', 'AuthorizationProfileAdvancedAttributeArgsDict']]]]] = None,
                 agentless_posture: Optional[pulumi.Input[builtins.bool]] = None,
                 airespace_acl: Optional[pulumi.Input[builtins.str]] = None,
                 airespace_ipv6_acl: Optional[pulumi.Input[builtins.str]] = None,
                 asa_vpn: Optional[pulumi.Input[builtins.str]] = None,
                 auto_smart_port: Optional[pulumi.Input[builtins.str]] = None,
                 avc_profile: Optional[pulumi.Input[builtins.str]] = None,
                 dacl_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 easywired_session_candidate: Optional[pulumi.Input[builtins.bool]] = None,
                 interface_template: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_acl_filter: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_dacl_name: Optional[pulumi.Input[builtins.str]] = None,
                 mac_sec_policy: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 neat: Optional[pulumi.Input[builtins.bool]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 reauthentication_connectivity: Optional[pulumi.Input[builtins.str]] = None,
                 reauthentication_timer: Optional[pulumi.Input[builtins.int]] = None,
                 service_template: Optional[pulumi.Input[builtins.bool]] = None,
                 track_movement: Optional[pulumi.Input[builtins.bool]] = None,
                 unique_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_name_id: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_tag_id: Optional[pulumi.Input[builtins.int]] = None,
                 voice_domain_permission: Optional[pulumi.Input[builtins.bool]] = None,
                 web_auth: Optional[pulumi.Input[builtins.bool]] = None,
                 web_redirection_acl: Optional[pulumi.Input[builtins.str]] = None,
                 web_redirection_display_certificates_renewal_messages: Optional[pulumi.Input[builtins.bool]] = None,
                 web_redirection_portal_name: Optional[pulumi.Input[builtins.str]] = None,
                 web_redirection_static_ip_host_name_fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 web_redirection_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthorizationProfileArgs.__new__(AuthorizationProfileArgs)

            __props__.__dict__["access_type"] = access_type
            __props__.__dict__["acl"] = acl
            __props__.__dict__["advanced_attributes"] = advanced_attributes
            __props__.__dict__["agentless_posture"] = agentless_posture
            __props__.__dict__["airespace_acl"] = airespace_acl
            __props__.__dict__["airespace_ipv6_acl"] = airespace_ipv6_acl
            __props__.__dict__["asa_vpn"] = asa_vpn
            __props__.__dict__["auto_smart_port"] = auto_smart_port
            __props__.__dict__["avc_profile"] = avc_profile
            __props__.__dict__["dacl_name"] = dacl_name
            __props__.__dict__["description"] = description
            __props__.__dict__["easywired_session_candidate"] = easywired_session_candidate
            __props__.__dict__["interface_template"] = interface_template
            __props__.__dict__["ipv6_acl_filter"] = ipv6_acl_filter
            __props__.__dict__["ipv6_dacl_name"] = ipv6_dacl_name
            __props__.__dict__["mac_sec_policy"] = mac_sec_policy
            __props__.__dict__["name"] = name
            __props__.__dict__["neat"] = neat
            __props__.__dict__["profile_name"] = profile_name
            __props__.__dict__["reauthentication_connectivity"] = reauthentication_connectivity
            __props__.__dict__["reauthentication_timer"] = reauthentication_timer
            __props__.__dict__["service_template"] = service_template
            __props__.__dict__["track_movement"] = track_movement
            __props__.__dict__["unique_identifier"] = unique_identifier
            __props__.__dict__["vlan_name_id"] = vlan_name_id
            __props__.__dict__["vlan_tag_id"] = vlan_tag_id
            __props__.__dict__["voice_domain_permission"] = voice_domain_permission
            __props__.__dict__["web_auth"] = web_auth
            __props__.__dict__["web_redirection_acl"] = web_redirection_acl
            __props__.__dict__["web_redirection_display_certificates_renewal_messages"] = web_redirection_display_certificates_renewal_messages
            __props__.__dict__["web_redirection_portal_name"] = web_redirection_portal_name
            __props__.__dict__["web_redirection_static_ip_host_name_fqdn"] = web_redirection_static_ip_host_name_fqdn
            __props__.__dict__["web_redirection_type"] = web_redirection_type
        super(AuthorizationProfile, __self__).__init__(
            'ise:networkaccess/authorizationProfile:AuthorizationProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_type: Optional[pulumi.Input[builtins.str]] = None,
            acl: Optional[pulumi.Input[builtins.str]] = None,
            advanced_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationProfileAdvancedAttributeArgs', 'AuthorizationProfileAdvancedAttributeArgsDict']]]]] = None,
            agentless_posture: Optional[pulumi.Input[builtins.bool]] = None,
            airespace_acl: Optional[pulumi.Input[builtins.str]] = None,
            airespace_ipv6_acl: Optional[pulumi.Input[builtins.str]] = None,
            asa_vpn: Optional[pulumi.Input[builtins.str]] = None,
            auto_smart_port: Optional[pulumi.Input[builtins.str]] = None,
            avc_profile: Optional[pulumi.Input[builtins.str]] = None,
            dacl_name: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            easywired_session_candidate: Optional[pulumi.Input[builtins.bool]] = None,
            interface_template: Optional[pulumi.Input[builtins.str]] = None,
            ipv6_acl_filter: Optional[pulumi.Input[builtins.str]] = None,
            ipv6_dacl_name: Optional[pulumi.Input[builtins.str]] = None,
            mac_sec_policy: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            neat: Optional[pulumi.Input[builtins.bool]] = None,
            profile_name: Optional[pulumi.Input[builtins.str]] = None,
            reauthentication_connectivity: Optional[pulumi.Input[builtins.str]] = None,
            reauthentication_timer: Optional[pulumi.Input[builtins.int]] = None,
            service_template: Optional[pulumi.Input[builtins.bool]] = None,
            track_movement: Optional[pulumi.Input[builtins.bool]] = None,
            unique_identifier: Optional[pulumi.Input[builtins.str]] = None,
            vlan_name_id: Optional[pulumi.Input[builtins.str]] = None,
            vlan_tag_id: Optional[pulumi.Input[builtins.int]] = None,
            voice_domain_permission: Optional[pulumi.Input[builtins.bool]] = None,
            web_auth: Optional[pulumi.Input[builtins.bool]] = None,
            web_redirection_acl: Optional[pulumi.Input[builtins.str]] = None,
            web_redirection_display_certificates_renewal_messages: Optional[pulumi.Input[builtins.bool]] = None,
            web_redirection_portal_name: Optional[pulumi.Input[builtins.str]] = None,
            web_redirection_static_ip_host_name_fqdn: Optional[pulumi.Input[builtins.str]] = None,
            web_redirection_type: Optional[pulumi.Input[builtins.str]] = None) -> 'AuthorizationProfile':
        """
        Get an existing AuthorizationProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_type: Access type - Choices: `ACCESS_ACCEPT`, `ACCESS_REJECT` - Default value: `ACCESS_ACCEPT`
        :param pulumi.Input[builtins.str] acl: ACL
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationProfileAdvancedAttributeArgs', 'AuthorizationProfileAdvancedAttributeArgsDict']]]] advanced_attributes: List of advanced attributes
        :param pulumi.Input[builtins.bool] agentless_posture: Agentless Posture.
        :param pulumi.Input[builtins.str] airespace_acl: Airespace ACL
        :param pulumi.Input[builtins.str] airespace_ipv6_acl: Airespace IPv6 ACL
        :param pulumi.Input[builtins.str] asa_vpn: ASA VPN
        :param pulumi.Input[builtins.str] auto_smart_port: Auto smart port
        :param pulumi.Input[builtins.str] avc_profile: AVC profile
        :param pulumi.Input[builtins.str] dacl_name: DACL name
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.bool] easywired_session_candidate: Easy wired session candidate - Default value: `false`
        :param pulumi.Input[builtins.str] interface_template: Interface template
        :param pulumi.Input[builtins.str] ipv6_acl_filter: IPv6 ACL
        :param pulumi.Input[builtins.str] ipv6_dacl_name: IPv6 DACL name
        :param pulumi.Input[builtins.str] mac_sec_policy: MacSec policy - Choices: `MUST_SECURE`, `MUST_NOT_SECURE`, `SHOULD_SECURE`
        :param pulumi.Input[builtins.str] name: The name of the authorization profile
        :param pulumi.Input[builtins.bool] neat: NEAT - Default value: `false`
        :param pulumi.Input[builtins.str] profile_name: Value needs to be an existing Network Device Profile - Default value: `Cisco`
        :param pulumi.Input[builtins.str] reauthentication_connectivity: Maintain Connectivity During Reauthentication - Choices: `DEFAULT`, `RADIUS_REQUEST`
        :param pulumi.Input[builtins.int] reauthentication_timer: Reauthentication timer - Range: `1`-`65535`
        :param pulumi.Input[builtins.bool] service_template: Service template - Default value: `false`
        :param pulumi.Input[builtins.bool] track_movement: Track movement - Default value: `false`
        :param pulumi.Input[builtins.str] unique_identifier: Unique identifier
        :param pulumi.Input[builtins.str] vlan_name_id: Vlan name or ID
        :param pulumi.Input[builtins.int] vlan_tag_id: Vlan tag ID - Range: `0`-`31`
        :param pulumi.Input[builtins.bool] voice_domain_permission: Voice domain permission - Default value: `false`
        :param pulumi.Input[builtins.bool] web_auth: Web authentication (local) - Default value: `false`
        :param pulumi.Input[builtins.str] web_redirection_acl: Web redirection ACL
        :param pulumi.Input[builtins.bool] web_redirection_display_certificates_renewal_messages: This attribute is mandatory when `web_redirection_type` value is `CentralizedWebAuth`. For all other
               `web_redirection_type` values the field must be ignored.
        :param pulumi.Input[builtins.str] web_redirection_portal_name: A portal that exist in the DB and fits the `web_redirection_type`
        :param pulumi.Input[builtins.str] web_redirection_static_ip_host_name_fqdn: IP, hostname or FQDN
        :param pulumi.Input[builtins.str] web_redirection_type: This type must fit the `web_redirection_portal_name` - Choices: `CentralizedWebAuth`, `HotSpot`,
               `NativeSupplicanProvisioning`, `ClientProvisioning`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthorizationProfileState.__new__(_AuthorizationProfileState)

        __props__.__dict__["access_type"] = access_type
        __props__.__dict__["acl"] = acl
        __props__.__dict__["advanced_attributes"] = advanced_attributes
        __props__.__dict__["agentless_posture"] = agentless_posture
        __props__.__dict__["airespace_acl"] = airespace_acl
        __props__.__dict__["airespace_ipv6_acl"] = airespace_ipv6_acl
        __props__.__dict__["asa_vpn"] = asa_vpn
        __props__.__dict__["auto_smart_port"] = auto_smart_port
        __props__.__dict__["avc_profile"] = avc_profile
        __props__.__dict__["dacl_name"] = dacl_name
        __props__.__dict__["description"] = description
        __props__.__dict__["easywired_session_candidate"] = easywired_session_candidate
        __props__.__dict__["interface_template"] = interface_template
        __props__.__dict__["ipv6_acl_filter"] = ipv6_acl_filter
        __props__.__dict__["ipv6_dacl_name"] = ipv6_dacl_name
        __props__.__dict__["mac_sec_policy"] = mac_sec_policy
        __props__.__dict__["name"] = name
        __props__.__dict__["neat"] = neat
        __props__.__dict__["profile_name"] = profile_name
        __props__.__dict__["reauthentication_connectivity"] = reauthentication_connectivity
        __props__.__dict__["reauthentication_timer"] = reauthentication_timer
        __props__.__dict__["service_template"] = service_template
        __props__.__dict__["track_movement"] = track_movement
        __props__.__dict__["unique_identifier"] = unique_identifier
        __props__.__dict__["vlan_name_id"] = vlan_name_id
        __props__.__dict__["vlan_tag_id"] = vlan_tag_id
        __props__.__dict__["voice_domain_permission"] = voice_domain_permission
        __props__.__dict__["web_auth"] = web_auth
        __props__.__dict__["web_redirection_acl"] = web_redirection_acl
        __props__.__dict__["web_redirection_display_certificates_renewal_messages"] = web_redirection_display_certificates_renewal_messages
        __props__.__dict__["web_redirection_portal_name"] = web_redirection_portal_name
        __props__.__dict__["web_redirection_static_ip_host_name_fqdn"] = web_redirection_static_ip_host_name_fqdn
        __props__.__dict__["web_redirection_type"] = web_redirection_type
        return AuthorizationProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> pulumi.Output[builtins.str]:
        """
        Access type - Choices: `ACCESS_ACCEPT`, `ACCESS_REJECT` - Default value: `ACCESS_ACCEPT`
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ACL
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="advancedAttributes")
    def advanced_attributes(self) -> pulumi.Output[Optional[Sequence['outputs.AuthorizationProfileAdvancedAttribute']]]:
        """
        List of advanced attributes
        """
        return pulumi.get(self, "advanced_attributes")

    @property
    @pulumi.getter(name="agentlessPosture")
    def agentless_posture(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Agentless Posture.
        """
        return pulumi.get(self, "agentless_posture")

    @property
    @pulumi.getter(name="airespaceAcl")
    def airespace_acl(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Airespace ACL
        """
        return pulumi.get(self, "airespace_acl")

    @property
    @pulumi.getter(name="airespaceIpv6Acl")
    def airespace_ipv6_acl(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Airespace IPv6 ACL
        """
        return pulumi.get(self, "airespace_ipv6_acl")

    @property
    @pulumi.getter(name="asaVpn")
    def asa_vpn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ASA VPN
        """
        return pulumi.get(self, "asa_vpn")

    @property
    @pulumi.getter(name="autoSmartPort")
    def auto_smart_port(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Auto smart port
        """
        return pulumi.get(self, "auto_smart_port")

    @property
    @pulumi.getter(name="avcProfile")
    def avc_profile(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        AVC profile
        """
        return pulumi.get(self, "avc_profile")

    @property
    @pulumi.getter(name="daclName")
    def dacl_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        DACL name
        """
        return pulumi.get(self, "dacl_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="easywiredSessionCandidate")
    def easywired_session_candidate(self) -> pulumi.Output[builtins.bool]:
        """
        Easy wired session candidate - Default value: `false`
        """
        return pulumi.get(self, "easywired_session_candidate")

    @property
    @pulumi.getter(name="interfaceTemplate")
    def interface_template(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Interface template
        """
        return pulumi.get(self, "interface_template")

    @property
    @pulumi.getter(name="ipv6AclFilter")
    def ipv6_acl_filter(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IPv6 ACL
        """
        return pulumi.get(self, "ipv6_acl_filter")

    @property
    @pulumi.getter(name="ipv6DaclName")
    def ipv6_dacl_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IPv6 DACL name
        """
        return pulumi.get(self, "ipv6_dacl_name")

    @property
    @pulumi.getter(name="macSecPolicy")
    def mac_sec_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        MacSec policy - Choices: `MUST_SECURE`, `MUST_NOT_SECURE`, `SHOULD_SECURE`
        """
        return pulumi.get(self, "mac_sec_policy")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the authorization profile
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def neat(self) -> pulumi.Output[builtins.bool]:
        """
        NEAT - Default value: `false`
        """
        return pulumi.get(self, "neat")

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> pulumi.Output[builtins.str]:
        """
        Value needs to be an existing Network Device Profile - Default value: `Cisco`
        """
        return pulumi.get(self, "profile_name")

    @property
    @pulumi.getter(name="reauthenticationConnectivity")
    def reauthentication_connectivity(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Maintain Connectivity During Reauthentication - Choices: `DEFAULT`, `RADIUS_REQUEST`
        """
        return pulumi.get(self, "reauthentication_connectivity")

    @property
    @pulumi.getter(name="reauthenticationTimer")
    def reauthentication_timer(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Reauthentication timer - Range: `1`-`65535`
        """
        return pulumi.get(self, "reauthentication_timer")

    @property
    @pulumi.getter(name="serviceTemplate")
    def service_template(self) -> pulumi.Output[builtins.bool]:
        """
        Service template - Default value: `false`
        """
        return pulumi.get(self, "service_template")

    @property
    @pulumi.getter(name="trackMovement")
    def track_movement(self) -> pulumi.Output[builtins.bool]:
        """
        Track movement - Default value: `false`
        """
        return pulumi.get(self, "track_movement")

    @property
    @pulumi.getter(name="uniqueIdentifier")
    def unique_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Unique identifier
        """
        return pulumi.get(self, "unique_identifier")

    @property
    @pulumi.getter(name="vlanNameId")
    def vlan_name_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Vlan name or ID
        """
        return pulumi.get(self, "vlan_name_id")

    @property
    @pulumi.getter(name="vlanTagId")
    def vlan_tag_id(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Vlan tag ID - Range: `0`-`31`
        """
        return pulumi.get(self, "vlan_tag_id")

    @property
    @pulumi.getter(name="voiceDomainPermission")
    def voice_domain_permission(self) -> pulumi.Output[builtins.bool]:
        """
        Voice domain permission - Default value: `false`
        """
        return pulumi.get(self, "voice_domain_permission")

    @property
    @pulumi.getter(name="webAuth")
    def web_auth(self) -> pulumi.Output[builtins.bool]:
        """
        Web authentication (local) - Default value: `false`
        """
        return pulumi.get(self, "web_auth")

    @property
    @pulumi.getter(name="webRedirectionAcl")
    def web_redirection_acl(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Web redirection ACL
        """
        return pulumi.get(self, "web_redirection_acl")

    @property
    @pulumi.getter(name="webRedirectionDisplayCertificatesRenewalMessages")
    def web_redirection_display_certificates_renewal_messages(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This attribute is mandatory when `web_redirection_type` value is `CentralizedWebAuth`. For all other
        `web_redirection_type` values the field must be ignored.
        """
        return pulumi.get(self, "web_redirection_display_certificates_renewal_messages")

    @property
    @pulumi.getter(name="webRedirectionPortalName")
    def web_redirection_portal_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A portal that exist in the DB and fits the `web_redirection_type`
        """
        return pulumi.get(self, "web_redirection_portal_name")

    @property
    @pulumi.getter(name="webRedirectionStaticIpHostNameFqdn")
    def web_redirection_static_ip_host_name_fqdn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IP, hostname or FQDN
        """
        return pulumi.get(self, "web_redirection_static_ip_host_name_fqdn")

    @property
    @pulumi.getter(name="webRedirectionType")
    def web_redirection_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        This type must fit the `web_redirection_portal_name` - Choices: `CentralizedWebAuth`, `HotSpot`,
        `NativeSupplicanProvisioning`, `ClientProvisioning`
        """
        return pulumi.get(self, "web_redirection_type")

