/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.code.SwitchInstruction;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.DecHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.SwitchHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.SwitchExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.util.StartEndPair;
import org.jetbrains.java.decompiler.util.TextBuffer;

public final class SwitchStatement
extends Statement {
    private List<Statement> caseStatements = new ArrayList<Statement>();
    private List<List<StatEdge>> caseEdges = new ArrayList<List<StatEdge>>();
    private List<List<@Nullable Exprent>> caseValues = new ArrayList<List<Exprent>>();
    private final Map<Statement, Exprent> guards = new HashMap<Statement, Exprent>();
    private StatEdge defaultEdge;
    private Exprent headExprent;
    private boolean canBeRule = false;
    private boolean useCustomDefault = false;

    private SwitchStatement() {
        super(Statement.StatementType.SWITCH);
    }

    private SwitchStatement(@NotNull Statement head, @Nullable Statement postStatement) {
        this();
        this.first = head;
        this.stats.addWithKey(head, head.id);
        HashSet<Statement> regularSuccessors = new HashSet<Statement>(head.getNeighbours(StatEdge.EdgeType.REGULAR, StatEdge.EdgeDirection.FORWARD));
        if (postStatement != null) {
            this.post = postStatement;
            regularSuccessors.remove(this.post);
        }
        this.defaultEdge = head.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL).get(0);
        ArrayList<Statement> sorted = new ArrayList<Statement>(regularSuccessors);
        Collections.sort(sorted, Comparator.comparingInt(o -> o.id));
        for (Statement successor : sorted) {
            this.stats.addWithKey(successor, successor.id);
        }
    }

    public void setCanBeRule(boolean canBeRule) {
        this.canBeRule = canBeRule;
    }

    public void addGuard(@NotNull Statement statement, @NotNull Exprent guard) {
        this.guards.put(statement, guard);
    }

    public void removeCaseStatement(@NotNull Statement statement) {
        this.stats.removeWithKey(statement.id);
        int caseIndex = this.caseStatements.indexOf(statement);
        if (caseIndex < 0) {
            return;
        }
        this.caseStatements.remove(caseIndex);
        this.caseEdges.remove(caseIndex);
        this.caseValues.remove(caseIndex);
        for (StatEdge edge : statement.getAllSuccessorEdges()) {
            edge.getDestination().removePredecessor(edge);
        }
        for (StatEdge edge : statement.getAllPredecessorEdges()) {
            edge.getSource().removeSuccessor(edge);
        }
    }

    public int duplicateCaseStatement(@NotNull Statement currentStatement) {
        StatEdge copy;
        Statement dummy = currentStatement.getSimpleCopy();
        int statIndex = this.stats.indexOf(currentStatement);
        if (statIndex < 0) {
            return statIndex;
        }
        this.stats.addWithKeyAndIndex(statIndex + 1, dummy, dummy.id);
        int caseIndex = this.caseStatements.indexOf(currentStatement);
        this.caseStatements.add(caseIndex + 1, dummy);
        List<@Nullable Exprent> toCopyValues = this.caseValues.get(caseIndex);
        this.caseValues.add(caseIndex + 1, toCopyValues);
        List<StatEdge> previousEdges = this.caseEdges.get(caseIndex);
        ArrayList<StatEdge> toCopyEdges = new ArrayList<StatEdge>();
        for (StatEdge previousEdge : previousEdges) {
            StatEdge edge = previousEdge.copy();
            edge.setDestination(dummy);
            toCopyEdges.add(edge);
        }
        this.caseEdges.add(caseIndex + 1, toCopyEdges);
        for (StatEdge edge : currentStatement.getAllPredecessorEdges()) {
            copy = edge.copy();
            copy.setDestination(dummy);
            copy.getSource().addSuccessor(copy);
        }
        for (StatEdge edge : currentStatement.getAllSuccessorEdges()) {
            copy = edge.copy();
            copy.setSource(dummy);
            dummy.addSuccessor(copy);
        }
        dummy.setParent(this);
        return caseIndex + 1;
    }

    public void setUseCustomDefault() {
        this.useCustomDefault = true;
    }

    @Nullable
    public static Statement isHead(@NotNull Statement head) {
        ArrayList statements;
        if (head.type == Statement.StatementType.BASIC_BLOCK && head.getLastBasicType() == Statement.StatementType.SWITCH && DecHelper.isChoiceStatement(head, statements = new ArrayList())) {
            Statement post = (Statement)statements.remove(0);
            for (Statement statement : statements) {
                if (!statement.isMonitorEnter()) continue;
                return null;
            }
            if (DecHelper.checkStatementExceptions(statements)) {
                return new SwitchStatement(head, post);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public TextBuffer toJava(int indent, @NotNull BytecodeMappingTracer tracer) {
        SwitchHelper.simplifySwitchOnEnum(this);
        TextBuffer buf = new TextBuffer();
        buf.append(ExprProcessor.listToJava(this.varDefinitions, indent, tracer));
        buf.append(this.first.toJava(indent, tracer));
        if (this.isLabeled()) {
            buf.appendIndent(indent).append("label").append(Integer.toString(this.id)).append(":").appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
        buf.appendIndent(indent).append(this.headExprent.toJava(indent, tracer)).append(" {").appendLineSeparator();
        tracer.incrementCurrentSourceLine();
        VarType switchType = this.headExprent.getExprType();
        for (int i = 0; i < this.caseStatements.size(); ++i) {
            TextBuffer buffer;
            ExitExprent exitExprent;
            Exprent exprent;
            BasicBlockStatement blockStatement;
            BasicBlockStatement blockStatement2;
            Statement stat = this.caseStatements.get(i);
            List<StatEdge> edges = this.caseEdges.get(i);
            List<Exprent> values = this.caseValues.get(i);
            for (int j = 0; j < edges.size(); ++j) {
                if (edges.get(j) == this.defaultEdge && !this.useCustomDefault) {
                    if (!this.canBeRule) {
                        buf.appendIndent(indent + 1).append("default:").appendLineSeparator();
                    } else {
                        buf.appendIndent(indent + 1).append("default -> ");
                    }
                } else {
                    ConstExprent constExprent;
                    buf.appendIndent(indent + 1).append("case ");
                    Exprent value = values.get(j);
                    if (value instanceof ConstExprent && !(constExprent = (ConstExprent)value).isNull()) {
                        value = value.copy();
                        if (switchType.getType() != 8) {
                            ((ConstExprent)value).setConstType(switchType);
                        } else if ("java/lang/Character".equals(switchType.getValue())) {
                            ((ConstExprent)value).setConstType(VarType.VARTYPE_CHAR);
                        }
                    }
                    if (value instanceof FieldExprent && ((FieldExprent)value).isStatic()) {
                        buf.append(((FieldExprent)value).getName());
                    } else {
                        buf.append(value.toJava(indent, tracer));
                    }
                    Exprent guard = this.guards.get(stat);
                    if (guard != null) {
                        buf.append(" when ").append(guard.toJava(0, tracer));
                    }
                    if (!this.canBeRule) {
                        buf.append(":").appendLineSeparator();
                    } else {
                        buf.append(" -> ");
                    }
                }
                if (this.canBeRule) continue;
                tracer.incrementCurrentSourceLine();
            }
            if (this.canBeRule && stat instanceof BasicBlockStatement && (blockStatement2 = (BasicBlockStatement)stat).getBlock().getSeq().isEmpty() && (stat.getExprents() == null || stat.getExprents().isEmpty())) {
                buf.append("{ }").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                continue;
            }
            if (this.canBeRule && stat instanceof BasicBlockStatement && (blockStatement = (BasicBlockStatement)stat).getExprents() != null && (blockStatement.getExprents().size() > 1 || blockStatement.getExprents().size() == 1 && (exprent = blockStatement.getExprents().get(0)) instanceof ExitExprent && (exitExprent = (ExitExprent)exprent).getExitType() == 0)) {
                buffer = ExprProcessor.jmpWrapper(stat, indent + 2, false, tracer);
                buf.append("{").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                buf.append(buffer).appendIndent(indent + 1).append("}").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                continue;
            }
            buffer = ExprProcessor.jmpWrapper(stat, this.canBeRule ? 0 : indent + 2, false, tracer);
            buf.append(buffer);
        }
        buf.appendIndent(indent).append("}").appendLineSeparator();
        tracer.incrementCurrentSourceLine();
        return buf;
    }

    @Override
    public void initExprents() {
        SwitchExprent exprent = (SwitchExprent)this.first.getExprents().remove(this.first.getExprents().size() - 1);
        exprent.setCaseValues(this.caseValues);
        this.headExprent = exprent;
    }

    @Override
    @NotNull
    public List<IMatchable> getSequentialObjects() {
        ArrayList<IMatchable> result = new ArrayList<IMatchable>(this.stats);
        result.add(1, this.headExprent);
        return result;
    }

    @Override
    public void replaceExprent(Exprent oldExprent, Exprent newExprent) {
        if (this.headExprent == oldExprent) {
            this.headExprent = newExprent;
        }
    }

    @Override
    public void replaceStatement(Statement oldStatement, Statement newStatement) {
        for (int i = 0; i < this.caseStatements.size(); ++i) {
            if (this.caseStatements.get(i) != oldStatement) continue;
            this.caseStatements.set(i, newStatement);
        }
        super.replaceStatement(oldStatement, newStatement);
    }

    @Override
    @NotNull
    public Statement getSimpleCopy() {
        return new SwitchStatement();
    }

    @Override
    public void initSimpleCopy() {
        this.first = (Statement)this.stats.get(0);
        this.defaultEdge = this.first.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL).get(0);
        this.sortEdgesAndNodes();
    }

    @Override
    public StartEndPair getStartEndRange() {
        StartEndPair[] sepairs = new StartEndPair[this.caseStatements.size() + 1];
        int i = 0;
        sepairs[i++] = super.getStartEndRange();
        for (Statement st : this.caseStatements) {
            sepairs[i++] = st.getStartEndRange();
        }
        return StartEndPair.join(sepairs);
    }

    public void sortEdgesAndNodes() {
        HashMap<StatEdge, Integer> edgeIndicesMapping = new HashMap<StatEdge, Integer>();
        List<StatEdge> firstSuccessors = this.first.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
        for (int i = 0; i < firstSuccessors.size(); ++i) {
            edgeIndicesMapping.put(firstSuccessors.get(i), i == 0 ? firstSuccessors.size() : i);
        }
        BasicBlockStatement firstBlock = (BasicBlockStatement)this.first;
        int[] values = ((SwitchInstruction)firstBlock.getBlock().getLastInstruction()).getValues();
        ArrayList<@Nullable Statement> caseStatements = new ArrayList<Statement>(this.stats.size() - 1);
        ArrayList<List<Integer>> edgeIndices = new ArrayList<List<Integer>>(this.stats.size() - 1);
        this.collectRegularEdgesIndices(edgeIndicesMapping, caseStatements, edgeIndices);
        this.collectExitEdgesIndices(edgeIndicesMapping, caseStatements, edgeIndices);
        this.sortEdges(caseStatements, edgeIndices);
        ArrayList<List<StatEdge>> caseEdges = new ArrayList<List<StatEdge>>(edgeIndices.size());
        ArrayList<List<@Nullable Exprent>> caseValues = new ArrayList<List<Exprent>>(edgeIndices.size());
        this.mapEdgeIndicesToEdges(values, edgeIndices, caseEdges, caseValues);
        this.replaceNullStatementsWithBasicBlocks(caseStatements, caseEdges);
        this.caseStatements = caseStatements;
        this.caseEdges = caseEdges;
        this.caseValues = caseValues;
    }

    private void mapEdgeIndicesToEdges(int[] values, @NotNull List<List<Integer>> edgeIndices, @NotNull List<List<StatEdge>> caseEdges, @NotNull List<List<@Nullable Exprent>> caseValues) {
        for (List<Integer> indices : edgeIndices) {
            ArrayList<StatEdge> edges = new ArrayList<StatEdge>(indices.size());
            ArrayList<ConstExprent> valueExprents = new ArrayList<ConstExprent>(indices.size());
            List<StatEdge> firstSuccessors = this.first.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
            for (Integer in : indices) {
                int index = in.intValue() == firstSuccessors.size() ? 0 : in;
                edges.add(firstSuccessors.get(index));
                valueExprents.add(index == 0 ? null : new ConstExprent(values[index - 1], false, null));
            }
            caseEdges.add(edges);
            caseValues.add(valueExprents);
        }
    }

    private void collectRegularEdgesIndices(@NotNull Map<StatEdge, Integer> edgeIndicesMapping, @NotNull List<@Nullable Statement> nodes, @NotNull List<List<Integer>> edgeIndices) {
        for (int i = 1; i < this.stats.size(); ++i) {
            Statement statement = (Statement)this.stats.get(i);
            ArrayList<Integer> regularEdgeIndices = new ArrayList<Integer>();
            for (StatEdge regularEdge : statement.getPredecessorEdges(StatEdge.EdgeType.REGULAR)) {
                if (regularEdge.getSource() != this.first) continue;
                regularEdgeIndices.add(edgeIndicesMapping.get(regularEdge));
            }
            Collections.sort(regularEdgeIndices);
            nodes.add(statement);
            edgeIndices.add(regularEdgeIndices);
        }
    }

    private void collectExitEdgesIndices(@NotNull Map<StatEdge, Integer> edgeIndicesMapping, @NotNull List<@Nullable Statement> nodes, @NotNull List<List<Integer>> edgeIndices) {
        List<StatEdge> firstExitEdges = this.first.getSuccessorEdges(StatEdge.EdgeType.BREAK.unite(StatEdge.EdgeType.CONTINUE));
        while (!firstExitEdges.isEmpty()) {
            StatEdge exitEdge = firstExitEdges.get(0);
            ArrayList<Integer> exitEdgeIndices = new ArrayList<Integer>();
            for (int i = firstExitEdges.size() - 1; i >= 0; --i) {
                StatEdge edgeTemp = firstExitEdges.get(i);
                if (edgeTemp.getDestination() != exitEdge.getDestination() || edgeTemp.getType() != exitEdge.getType()) continue;
                exitEdgeIndices.add(edgeIndicesMapping.get(edgeTemp));
                firstExitEdges.remove(i);
            }
            Collections.sort(exitEdgeIndices);
            nodes.add(null);
            edgeIndices.add(exitEdgeIndices);
        }
    }

    private void sortEdges(List<@Nullable Statement> nodes, @NotNull List<List<Integer>> edgeIndices) {
        for (int i = 0; i < edgeIndices.size() - 1; ++i) {
            for (int j = edgeIndices.size() - 1; j > i; --j) {
                if (edgeIndices.get(j - 1).get(0) <= edgeIndices.get(j).get(0)) continue;
                edgeIndices.set(j, edgeIndices.set(j - 1, edgeIndices.get(j)));
                nodes.set(j, nodes.set(j - 1, nodes.get(j)));
            }
        }
        block2: for (int index = 0; index < nodes.size(); ++index) {
            Statement node = nodes.get(index);
            if (node == null) continue;
            HashSet<Statement> nodePredecessors = new HashSet<Statement>(node.getNeighbours(StatEdge.EdgeType.REGULAR, StatEdge.EdgeDirection.BACKWARD));
            nodePredecessors.remove(this.first);
            if (nodePredecessors.isEmpty()) continue;
            Statement predecessor = nodePredecessors.iterator().next();
            for (int j = 0; j < nodes.size(); ++j) {
                if (j == index - 1 || nodes.get(j) != predecessor) continue;
                nodes.add(j + 1, node);
                edgeIndices.add(j + 1, edgeIndices.get(index));
                if (j > index) {
                    nodes.remove(index);
                    edgeIndices.remove(index);
                    --index;
                    continue block2;
                }
                nodes.remove(index + 1);
                edgeIndices.remove(index + 1);
                continue block2;
            }
        }
    }

    private void replaceNullStatementsWithBasicBlocks(List<@Nullable Statement> statements, @NotNull List<List<StatEdge>> edges) {
        for (int i = 0; i < statements.size(); ++i) {
            if (statements.get(i) != null) continue;
            BasicBlockStatement basicBlock = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
            StatEdge sampleEdge = edges.get(i).get(0);
            basicBlock.addSuccessor(new StatEdge(sampleEdge.getType(), basicBlock, sampleEdge.getDestination(), sampleEdge.closure));
            for (StatEdge edge : edges.get(i)) {
                edge.getSource().changeEdgeType(StatEdge.EdgeDirection.FORWARD, edge, StatEdge.EdgeType.REGULAR);
                edge.closure.getLabelEdges().remove(edge);
                edge.getDestination().removePredecessor(edge);
                edge.getSource().changeEdgeNode(StatEdge.EdgeDirection.FORWARD, edge, basicBlock);
                basicBlock.addPredecessor(edge);
            }
            statements.set(i, basicBlock);
            this.stats.addWithKey(basicBlock, basicBlock.id);
            basicBlock.setParent(this);
        }
    }

    @NotNull
    public List<Exprent> getHeadExprentList() {
        return Collections.singletonList(this.headExprent);
    }

    @Nullable
    public Exprent getHeadExprent() {
        return this.headExprent;
    }

    @NotNull
    public List<List<StatEdge>> getCaseEdges() {
        return this.caseEdges;
    }

    @NotNull
    public List<Statement> getCaseStatements() {
        return this.caseStatements;
    }

    @NotNull
    public StatEdge getDefaultEdge() {
        return this.defaultEdge;
    }

    public @NotNull List<List<@Nullable Exprent>> getCaseValues() {
        return this.caseValues;
    }
}

