"""A PsychoPy GratingStim, mainly for use with coroutines"""

category = 'Visual stimuli'
controls = [
  {'label': 'Update every',
   'type': 'spinbox',
   'suffix': ' ms',
   'info': '-1 = no updating',
   'min_val': -1,
   'max_val': 10000,
   'var': 'framerate'},
  {'label': 'Interpret values as',
   'type': 'combobox',
   'options': ['python', 'opensesame'],
   'var': 'interpretation'},
  {'label': 'Color',
   'type': 'line_edit',
   'info': 'A valid PsychoPy color argument',
   'var': 'color'},
  {'label': 'Texture',
   'type': 'line_edit',
   'info': 'A valid PsychoPy tex argument',
   'var': 'tex'},
  {'label': 'Mask',
   'type': 'line_edit',
   'info': 'A valid PsychoPy mask argument',
   'var': 'mask'},
  {'label': 'Horizontal position (x)', 'type': 'line_edit', 'var': 'xpos'},
  {'label': 'Vertical position (y)', 'type': 'line_edit', 'var': 'ypos'},
  {'label': 'Width', 'type': 'line_edit', 'var': 'xsize'},
  {'label': 'Height', 'type': 'line_edit', 'var': 'ysize'},
  {'label': 'Contrast',
   'type': 'line_edit',
   'info': '0 is no contrast, 1 is full contrast',
   'var': 'contrast'},
  {'label': 'Opacity',
   'type': 'line_edit',
   'info': '0 is fully transparent, 1 is fully opaque',
   'var': 'opacity'},
  {'label': 'Spatial frequency',
   'type': 'line_edit',
   'info': 'Cycles per pixel',
   'var': 'sf'},
  {'label': 'Orientation',
   'type': 'line_edit',
   'info': 'In degrees of clockwise rotation from vertical',
   'var': 'ori'},
  {'label': 'Phase',
   'type': 'line_edit',
   'info': 'Between 0 and 1',
   'var': 'phase'},
  {'label': 'Object name',
   'type': 'line_edit',
   'info': 'For Python script',
   'var': 'objectname'},
  {'label': 'Drawing order',
   'type': 'spinbox',
   'info': 'Lowest values draw first',
   'min_val': -10000,
   'max_val': 10000,
   'var': 'order'},
  {'label': 'Custom Python code',
   'type': 'editor',
   'syntax': True,
   'var': 'script'}]


def supports(exp):
    return exp.var.canvas_backend == 'psycho'
