"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EditingProject = exports.EditingProjectProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vod_generated_1 = require("./vod.generated");
Object.defineProperty(exports, "EditingProjectProperty", { enumerable: true, get: function () { return vod_generated_1.RosEditingProject; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::VOD::EditingProject`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosEditingProject`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-vod-editingproject
 */
class EditingProject extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosEditingProject = new vod_generated_1.RosEditingProject(this, id, {
            editingProjectId: props.editingProjectId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosEditingProject;
        this.attrCreateTime = rosEditingProject.attrCreateTime;
        this.attrEditingProjectId = rosEditingProject.attrEditingProjectId;
        this.attrEditingProjectName = rosEditingProject.attrEditingProjectName;
        this.attrModifiedTime = rosEditingProject.attrModifiedTime;
        this.attrTimeline = rosEditingProject.attrTimeline;
        this.attrTitle = rosEditingProject.attrTitle;
    }
}
exports.EditingProject = EditingProject;
//# sourceMappingURL=data:application/json;base64,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