"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageCallback = exports.MessageCallbackProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vod_generated_1 = require("./vod.generated");
Object.defineProperty(exports, "MessageCallbackProperty", { enumerable: true, get: function () { return vod_generated_1.RosMessageCallback; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::VOD::MessageCallback`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosMessageCallback`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-vod-messagecallback
 */
class MessageCallback extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosMessageCallback = new vod_generated_1.RosMessageCallback(this, id, {
            appId: props.appId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosMessageCallback;
        this.attrAppId = rosMessageCallback.attrAppId;
        this.attrAuthKey = rosMessageCallback.attrAuthKey;
        this.attrAuthSwitch = rosMessageCallback.attrAuthSwitch;
        this.attrCallbackType = rosMessageCallback.attrCallbackType;
        this.attrCallbackUrl = rosMessageCallback.attrCallbackUrl;
        this.attrEventTypeList = rosMessageCallback.attrEventTypeList;
        this.attrMnsEndpoint = rosMessageCallback.attrMnsEndpoint;
        this.attrMnsQueueName = rosMessageCallback.attrMnsQueueName;
    }
}
exports.MessageCallback = MessageCallback;
//# sourceMappingURL=data:application/json;base64,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