"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EditingProject = exports.EditingProjectProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vod_generated_1 = require("./vod.generated");
Object.defineProperty(exports, "EditingProjectProperty", { enumerable: true, get: function () { return vod_generated_1.RosEditingProject; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::VOD::EditingProject`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosEditingProject`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-vod-editingproject
 */
class EditingProject extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosEditingProject = new vod_generated_1.RosEditingProject(this, id, {
            editingProjectName: props.editingProjectName,
            timeline: props.timeline,
            title: props.title,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosEditingProject;
        this.attrCreateTime = rosEditingProject.attrCreateTime;
        this.attrEditingProjectId = rosEditingProject.attrEditingProjectId;
        this.attrEditingProjectName = rosEditingProject.attrEditingProjectName;
        this.attrModifiedTime = rosEditingProject.attrModifiedTime;
        this.attrTimeline = rosEditingProject.attrTimeline;
        this.attrTitle = rosEditingProject.attrTitle;
    }
}
exports.EditingProject = EditingProject;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWRpdGluZ3Byb2plY3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlZGl0aW5ncHJvamVjdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsbURBQW9EO0FBRXRCLHVHQUZyQixpQ0FBaUIsT0FFMEI7QUErRHBEOzs7O0dBSUc7QUFDSCxNQUFhLGNBQWUsU0FBUSxHQUFHLENBQUMsUUFBUTtJQXNDNUM7Ozs7T0FJRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBMEIsRUFBRSxtQ0FBMkMsSUFBSTtRQUNySCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ25CLElBQUksQ0FBQyxFQUFFLEdBQUcsRUFBRSxDQUFDO1FBQ2IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFDbkIsSUFBSSxDQUFDLGdDQUFnQyxHQUFHLGdDQUFnQyxDQUFDO1FBRXpFLE1BQU0saUJBQWlCLEdBQUcsSUFBSSxpQ0FBaUIsQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFHO1lBQ3ZELGtCQUFrQixFQUFFLEtBQUssQ0FBQyxrQkFBa0I7WUFDNUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1lBQ3hCLEtBQUssRUFBRSxLQUFLLENBQUMsS0FBSztTQUNyQixFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLGlCQUFpQixDQUFDO1FBQ2xDLElBQUksQ0FBQyxjQUFjLEdBQUcsaUJBQWlCLENBQUMsY0FBYyxDQUFDO1FBQ3ZELElBQUksQ0FBQyxvQkFBb0IsR0FBRyxpQkFBaUIsQ0FBQyxvQkFBb0IsQ0FBQztRQUNuRSxJQUFJLENBQUMsc0JBQXNCLEdBQUcsaUJBQWlCLENBQUMsc0JBQXNCLENBQUM7UUFDdkUsSUFBSSxDQUFDLGdCQUFnQixHQUFHLGlCQUFpQixDQUFDLGdCQUFnQixDQUFDO1FBQzNELElBQUksQ0FBQyxZQUFZLEdBQUcsaUJBQWlCLENBQUMsWUFBWSxDQUFDO1FBQ25ELElBQUksQ0FBQyxTQUFTLEdBQUcsaUJBQWlCLENBQUMsU0FBUyxDQUFDO0lBQ2pELENBQUM7Q0FDSjtBQS9ERCx3Q0ErREMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyByb3MgZnJvbSAnQGFsaWNsb3VkL3Jvcy1jZGstY29yZSc7XG5pbXBvcnQgeyBSb3NFZGl0aW5nUHJvamVjdCB9IGZyb20gJy4vdm9kLmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc0VkaXRpbmdQcm9qZWN0IGFzIEVkaXRpbmdQcm9qZWN0UHJvcGVydHkgfTtcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBFZGl0aW5nUHJvamVjdGAuXG4gKiBTZWUgaHR0cHM6Ly93d3cuYWxpYmFiYWNsb3VkLmNvbS9oZWxwL3Jvcy9kZXZlbG9wZXItcmVmZXJlbmNlL2FsaXl1bi12b2QtZWRpdGluZ3Byb2plY3RcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBFZGl0aW5nUHJvamVjdFByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHRpdGxlOiBUaGUgdGl0bGUgb2YgdGhlIG9ubGluZSBlZGl0aW5nIHByb2plY3QuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGl0bGU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGVkaXRpbmdQcm9qZWN0TmFtZTogVGhlIG5hbWUgb2YgdGhlIG9ubGluZSBlZGl0aW5nIHByb2plY3QuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZWRpdGluZ1Byb2plY3ROYW1lPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdGltZWxpbmU6IFRoZSB0aW1lbGluZSBvZiB0aGUgb25saW5lIGVkaXRpbmcgcHJvamVjdCwgaW4gSlNPTiBmb3JtYXQuXG4gICAgICogSWYgeW91IGRvIG5vdCBzcGVjaWZ5IHRoaXMgcGFyYW1ldGVyLCBhbiBlbXB0eSB0aW1lbGluZSBpcyBjcmVhdGVkIGFuZCB0aGUgZHVyYXRpb24gb2YgdGhlIG9ubGluZSBlZGl0aW5nIHByb2plY3QgaXMgemVyby5cbiAgICAgKi9cbiAgICByZWFkb25seSB0aW1lbGluZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIGEgYEVkaXRpbmdQcm9qZWN0YC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJRWRpdGluZ1Byb2plY3QgZXh0ZW5kcyByb3MuSVJlc291cmNlIHtcbiAgICByZWFkb25seSBwcm9wczogRWRpdGluZ1Byb2plY3RQcm9wcztcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBDcmVhdGVUaW1lOiBUaGUgdGltZSB3aGVuIHRoZSBvbmxpbmUgZWRpdGluZyBwcm9qZWN0IHdhcyBjcmVhdGVkLlxuVGhlIHRpbWUgZm9sbG93cyB0aGUgSVNPIDg2MDEgc3RhbmRhcmQgaW4gdGhlIHl5eXktTU0tZGRUSEg6bW06c3NaIGZvcm1hdC4gVGhlIHRpbWUgaXMgZGlzcGxheWVkIGluIFVUQy5cbiAgICAgKi9cbiAgICByZWFkb25seSBhdHRyQ3JlYXRlVGltZTogcm9zLklSZXNvbHZhYmxlIHwgc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIEVkaXRpbmdQcm9qZWN0SWQ6IFRoZSBJRCBvZiB0aGUgb25saW5lIGVkaXRpbmcgcHJvamVjdC5cbiAgICAgKi9cbiAgICByZWFkb25seSBhdHRyRWRpdGluZ1Byb2plY3RJZDogcm9zLklSZXNvbHZhYmxlIHwgc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIEVkaXRpbmdQcm9qZWN0TmFtZTogVGhlIG5hbWUgb2YgdGhlIG9ubGluZSBlZGl0aW5nIHByb2plY3QuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXR0ckVkaXRpbmdQcm9qZWN0TmFtZTogcm9zLklSZXNvbHZhYmxlIHwgc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIE1vZGlmaWVkVGltZTogVGhlIGxhc3QgdGltZSB3aGVuIHRoZSBvbmxpbmUgZWRpdGluZyBwcm9qZWN0IHdhcyBtb2RpZmllZC5cblRoZSB0aW1lIGZvbGxvd3MgdGhlIElTTyA4NjAxIHN0YW5kYXJkIGluIHRoZSB5eXl5LU1NLWRkVEhIOm1tOnNzWiBmb3JtYXQuIFRoZSB0aW1lIGlzIGRpc3BsYXllZCBpbiBVVEMuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXR0ck1vZGlmaWVkVGltZTogcm9zLklSZXNvbHZhYmxlIHwgc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIFRpbWVsaW5lOiBUaGUgdGltZWxpbmUgb2YgdGhlIG9ubGluZSBlZGl0aW5nIHByb2plY3QuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXR0clRpbWVsaW5lOiByb3MuSVJlc29sdmFibGUgfCBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgVGl0bGU6IFRoZSB0aXRsZSBvZiB0aGUgb25saW5lIGVkaXRpbmcgcHJvamVjdC5cbiAgICAgKi9cbiAgICByZWFkb25seSBhdHRyVGl0bGU6IHJvcy5JUmVzb2x2YWJsZSB8IHN0cmluZztcbn1cbi8qKlxuICogVGhpcyBjbGFzcyBlbmNhcHN1bGF0ZXMgYW5kIGV4dGVuZHMgdGhlIFJPUyByZXNvdXJjZSB0eXBlIGBBTElZVU46OlZPRDo6RWRpdGluZ1Byb2plY3RgLlxuICogQE5vdGUgVGhpcyBjbGFzcyBtYXkgaGF2ZSBzb21lIG5ldyBmdW5jdGlvbnMgdG8gZmFjaWxpdGF0ZSBkZXZlbG9wbWVudCwgc28gaXQgaXMgcmVjb21tZW5kZWQgdG8gdXNlIHRoaXMgY2xhc3MgaW5zdGVhZCBvZiBgUm9zRWRpdGluZ1Byb2plY3RgZm9yIGEgbW9yZSBjb252ZW5pZW50IGRldmVsb3BtZW50IGV4cGVyaWVuY2UuXG4gKiBTZWUgaHR0cHM6Ly93d3cuYWxpYmFiYWNsb3VkLmNvbS9oZWxwL3Jvcy9kZXZlbG9wZXItcmVmZXJlbmNlL2FsaXl1bi12b2QtZWRpdGluZ3Byb2plY3RcbiAqL1xuZXhwb3J0IGNsYXNzIEVkaXRpbmdQcm9qZWN0IGV4dGVuZHMgcm9zLlJlc291cmNlIGltcGxlbWVudHMgSUVkaXRpbmdQcm9qZWN0IHtcbiAgICBwcm90ZWN0ZWQgc2NvcGU6IHJvcy5Db25zdHJ1Y3Q7XG4gICAgcHJvdGVjdGVkIGlkOiBzdHJpbmc7XG4gICAgcHVibGljIHJlYWRvbmx5IHByb3BzOiBFZGl0aW5nUHJvamVjdFByb3BzO1xuICAgIHByb3RlY3RlZCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDogYm9vbGVhbjtcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBDcmVhdGVUaW1lOiBUaGUgdGltZSB3aGVuIHRoZSBvbmxpbmUgZWRpdGluZyBwcm9qZWN0IHdhcyBjcmVhdGVkLlxuVGhlIHRpbWUgZm9sbG93cyB0aGUgSVNPIDg2MDEgc3RhbmRhcmQgaW4gdGhlIHl5eXktTU0tZGRUSEg6bW06c3NaIGZvcm1hdC4gVGhlIHRpbWUgaXMgZGlzcGxheWVkIGluIFVUQy5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckNyZWF0ZVRpbWU6IHJvcy5JUmVzb2x2YWJsZSB8IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBFZGl0aW5nUHJvamVjdElkOiBUaGUgSUQgb2YgdGhlIG9ubGluZSBlZGl0aW5nIHByb2plY3QuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJFZGl0aW5nUHJvamVjdElkOiByb3MuSVJlc29sdmFibGUgfCBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgRWRpdGluZ1Byb2plY3ROYW1lOiBUaGUgbmFtZSBvZiB0aGUgb25saW5lIGVkaXRpbmcgcHJvamVjdC5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckVkaXRpbmdQcm9qZWN0TmFtZTogcm9zLklSZXNvbHZhYmxlIHwgc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIE1vZGlmaWVkVGltZTogVGhlIGxhc3QgdGltZSB3aGVuIHRoZSBvbmxpbmUgZWRpdGluZyBwcm9qZWN0IHdhcyBtb2RpZmllZC5cblRoZSB0aW1lIGZvbGxvd3MgdGhlIElTTyA4NjAxIHN0YW5kYXJkIGluIHRoZSB5eXl5LU1NLWRkVEhIOm1tOnNzWiBmb3JtYXQuIFRoZSB0aW1lIGlzIGRpc3BsYXllZCBpbiBVVEMuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJNb2RpZmllZFRpbWU6IHJvcy5JUmVzb2x2YWJsZSB8IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBUaW1lbGluZTogVGhlIHRpbWVsaW5lIG9mIHRoZSBvbmxpbmUgZWRpdGluZyBwcm9qZWN0LlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyVGltZWxpbmU6IHJvcy5JUmVzb2x2YWJsZSB8IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBUaXRsZTogVGhlIHRpdGxlIG9mIHRoZSBvbmxpbmUgZWRpdGluZyBwcm9qZWN0LlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyVGl0bGU6IHJvcy5JUmVzb2x2YWJsZSB8IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogUGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogUGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBFZGl0aW5nUHJvamVjdFByb3BzLCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDpib29sZWFuID0gdHJ1ZSkge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgICAgICB0aGlzLnNjb3BlID0gc2NvcGU7XG4gICAgICAgIHRoaXMuaWQgPSBpZDtcbiAgICAgICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuICAgICAgICB0aGlzLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50ID0gZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ7XG5cbiAgICAgICAgY29uc3Qgcm9zRWRpdGluZ1Byb2plY3QgPSBuZXcgUm9zRWRpdGluZ1Byb2plY3QodGhpcywgaWQsICB7XG4gICAgICAgICAgICBlZGl0aW5nUHJvamVjdE5hbWU6IHByb3BzLmVkaXRpbmdQcm9qZWN0TmFtZSxcbiAgICAgICAgICAgIHRpbWVsaW5lOiBwcm9wcy50aW1lbGluZSxcbiAgICAgICAgICAgIHRpdGxlOiBwcm9wcy50aXRsZSxcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NFZGl0aW5nUHJvamVjdDtcbiAgICAgICAgdGhpcy5hdHRyQ3JlYXRlVGltZSA9IHJvc0VkaXRpbmdQcm9qZWN0LmF0dHJDcmVhdGVUaW1lO1xuICAgICAgICB0aGlzLmF0dHJFZGl0aW5nUHJvamVjdElkID0gcm9zRWRpdGluZ1Byb2plY3QuYXR0ckVkaXRpbmdQcm9qZWN0SWQ7XG4gICAgICAgIHRoaXMuYXR0ckVkaXRpbmdQcm9qZWN0TmFtZSA9IHJvc0VkaXRpbmdQcm9qZWN0LmF0dHJFZGl0aW5nUHJvamVjdE5hbWU7XG4gICAgICAgIHRoaXMuYXR0ck1vZGlmaWVkVGltZSA9IHJvc0VkaXRpbmdQcm9qZWN0LmF0dHJNb2RpZmllZFRpbWU7XG4gICAgICAgIHRoaXMuYXR0clRpbWVsaW5lID0gcm9zRWRpdGluZ1Byb2plY3QuYXR0clRpbWVsaW5lO1xuICAgICAgICB0aGlzLmF0dHJUaXRsZSA9IHJvc0VkaXRpbmdQcm9qZWN0LmF0dHJUaXRsZTtcbiAgICB9XG59XG4iXX0=