"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageCallback = exports.MessageCallbackProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vod_generated_1 = require("./vod.generated");
Object.defineProperty(exports, "MessageCallbackProperty", { enumerable: true, get: function () { return vod_generated_1.RosMessageCallback; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::VOD::MessageCallback`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosMessageCallback`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-vod-messagecallback
 */
class MessageCallback extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosMessageCallback = new vod_generated_1.RosMessageCallback(this, id, {
            mnsEndpoint: props.mnsEndpoint,
            callbackUrl: props.callbackUrl,
            authSwitch: props.authSwitch,
            appId: props.appId,
            callbackType: props.callbackType,
            eventTypeList: props.eventTypeList,
            mnsQueueName: props.mnsQueueName,
            authKey: props.authKey,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosMessageCallback;
        this.attrAppId = rosMessageCallback.attrAppId;
        this.attrAuthKey = rosMessageCallback.attrAuthKey;
        this.attrAuthSwitch = rosMessageCallback.attrAuthSwitch;
        this.attrCallbackType = rosMessageCallback.attrCallbackType;
        this.attrCallbackUrl = rosMessageCallback.attrCallbackUrl;
        this.attrEventTypeList = rosMessageCallback.attrEventTypeList;
        this.attrMnsEndpoint = rosMessageCallback.attrMnsEndpoint;
        this.attrMnsQueueName = rosMessageCallback.attrMnsQueueName;
    }
}
exports.MessageCallback = MessageCallback;
//# sourceMappingURL=data:application/json;base64,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