"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosStorage = exports.RosMessageCallback = exports.RosEditingProject = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosEditingProjectProps`
 *
 * @param properties - the TypeScript properties of a `RosEditingProjectProps`
 *
 * @returns the result of the validation.
 */
function RosEditingProjectPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('editingProjectName', ros.validateString)(properties.editingProjectName));
    errors.collect(ros.propertyValidator('timeline', ros.validateString)(properties.timeline));
    errors.collect(ros.propertyValidator('title', ros.requiredValidator)(properties.title));
    errors.collect(ros.propertyValidator('title', ros.validateString)(properties.title));
    return errors.wrap('supplied properties not correct for "RosEditingProjectProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::VOD::EditingProject` resource
 *
 * @param properties - the TypeScript properties of a `RosEditingProjectProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::VOD::EditingProject` resource.
 */
// @ts-ignore TS6133
function rosEditingProjectPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosEditingProjectPropsValidator(properties).assertSuccess();
    }
    return {
        'Title': ros.stringToRosTemplate(properties.title),
        'EditingProjectName': ros.stringToRosTemplate(properties.editingProjectName),
        'Timeline': ros.stringToRosTemplate(properties.timeline),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::VOD::EditingProject`.
 * @Note This class does not contain additional functions, so it is recommended to use the `EditingProject` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-vod-editingproject
 */
class RosEditingProject extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosEditingProject.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrCreateTime = this.getAtt('CreateTime');
        this.attrEditingProjectId = this.getAtt('EditingProjectId');
        this.attrEditingProjectName = this.getAtt('EditingProjectName');
        this.attrModifiedTime = this.getAtt('ModifiedTime');
        this.attrTimeline = this.getAtt('Timeline');
        this.attrTitle = this.getAtt('Title');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.title = props.title;
        this.editingProjectName = props.editingProjectName;
        this.timeline = props.timeline;
    }
    get rosProperties() {
        return {
            title: this.title,
            editingProjectName: this.editingProjectName,
            timeline: this.timeline,
        };
    }
    renderProperties(props) {
        return rosEditingProjectPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosEditingProject = RosEditingProject;
/**
 * The resource type name for this resource class.
 */
RosEditingProject.ROS_RESOURCE_TYPE_NAME = "ALIYUN::VOD::EditingProject";
/**
 * Determine whether the given properties match those of a `RosMessageCallbackProps`
 *
 * @param properties - the TypeScript properties of a `RosMessageCallbackProps`
 *
 * @returns the result of the validation.
 */
function RosMessageCallbackPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('mnsEndpoint', ros.validateString)(properties.mnsEndpoint));
    errors.collect(ros.propertyValidator('callbackUrl', ros.validateString)(properties.callbackUrl));
    errors.collect(ros.propertyValidator('authSwitch', ros.validateString)(properties.authSwitch));
    errors.collect(ros.propertyValidator('appId', ros.validateString)(properties.appId));
    errors.collect(ros.propertyValidator('callbackType', ros.requiredValidator)(properties.callbackType));
    errors.collect(ros.propertyValidator('callbackType', ros.validateString)(properties.callbackType));
    errors.collect(ros.propertyValidator('eventTypeList', ros.validateString)(properties.eventTypeList));
    errors.collect(ros.propertyValidator('mnsQueueName', ros.validateString)(properties.mnsQueueName));
    errors.collect(ros.propertyValidator('authKey', ros.validateString)(properties.authKey));
    return errors.wrap('supplied properties not correct for "RosMessageCallbackProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::VOD::MessageCallback` resource
 *
 * @param properties - the TypeScript properties of a `RosMessageCallbackProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::VOD::MessageCallback` resource.
 */
// @ts-ignore TS6133
function rosMessageCallbackPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosMessageCallbackPropsValidator(properties).assertSuccess();
    }
    return {
        'CallbackType': ros.stringToRosTemplate(properties.callbackType),
        'AppId': ros.stringToRosTemplate(properties.appId),
        'AuthKey': ros.stringToRosTemplate(properties.authKey),
        'AuthSwitch': ros.stringToRosTemplate(properties.authSwitch),
        'CallbackUrl': ros.stringToRosTemplate(properties.callbackUrl),
        'EventTypeList': ros.stringToRosTemplate(properties.eventTypeList),
        'MnsEndpoint': ros.stringToRosTemplate(properties.mnsEndpoint),
        'MnsQueueName': ros.stringToRosTemplate(properties.mnsQueueName),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::VOD::MessageCallback`.
 * @Note This class does not contain additional functions, so it is recommended to use the `MessageCallback` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-vod-messagecallback
 */
class RosMessageCallback extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosMessageCallback.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAppId = this.getAtt('AppId');
        this.attrAuthKey = this.getAtt('AuthKey');
        this.attrAuthSwitch = this.getAtt('AuthSwitch');
        this.attrCallbackType = this.getAtt('CallbackType');
        this.attrCallbackUrl = this.getAtt('CallbackUrl');
        this.attrEventTypeList = this.getAtt('EventTypeList');
        this.attrMnsEndpoint = this.getAtt('MnsEndpoint');
        this.attrMnsQueueName = this.getAtt('MnsQueueName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.callbackType = props.callbackType;
        this.appId = props.appId;
        this.authKey = props.authKey;
        this.authSwitch = props.authSwitch;
        this.callbackUrl = props.callbackUrl;
        this.eventTypeList = props.eventTypeList;
        this.mnsEndpoint = props.mnsEndpoint;
        this.mnsQueueName = props.mnsQueueName;
    }
    get rosProperties() {
        return {
            callbackType: this.callbackType,
            appId: this.appId,
            authKey: this.authKey,
            authSwitch: this.authSwitch,
            callbackUrl: this.callbackUrl,
            eventTypeList: this.eventTypeList,
            mnsEndpoint: this.mnsEndpoint,
            mnsQueueName: this.mnsQueueName,
        };
    }
    renderProperties(props) {
        return rosMessageCallbackPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosMessageCallback = RosMessageCallback;
/**
 * The resource type name for this resource class.
 */
RosMessageCallback.ROS_RESOURCE_TYPE_NAME = "ALIYUN::VOD::MessageCallback";
/**
 * Determine whether the given properties match those of a `RosStorageProps`
 *
 * @param properties - the TypeScript properties of a `RosStorageProps`
 *
 * @returns the result of the validation.
 */
function RosStoragePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('storageType', ros.requiredValidator)(properties.storageType));
    errors.collect(ros.propertyValidator('storageType', ros.validateString)(properties.storageType));
    errors.collect(ros.propertyValidator('defaultUpload', ros.validateBoolean)(properties.defaultUpload));
    errors.collect(ros.propertyValidator('storageLocation', ros.requiredValidator)(properties.storageLocation));
    errors.collect(ros.propertyValidator('storageLocation', ros.validateString)(properties.storageLocation));
    return errors.wrap('supplied properties not correct for "RosStorageProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::VOD::Storage` resource
 *
 * @param properties - the TypeScript properties of a `RosStorageProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::VOD::Storage` resource.
 */
// @ts-ignore TS6133
function rosStoragePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosStoragePropsValidator(properties).assertSuccess();
    }
    return {
        'StorageLocation': ros.stringToRosTemplate(properties.storageLocation),
        'StorageType': ros.stringToRosTemplate(properties.storageType),
        'DefaultUpload': ros.booleanToRosTemplate(properties.defaultUpload),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::VOD::Storage`.
 * @Note This class does not contain additional functions, so it is recommended to use the `Storage` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-vod-storage
 */
class RosStorage extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosStorage.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrCreateTime = this.getAtt('CreateTime');
        this.attrDefaultUpload = this.getAtt('DefaultUpload');
        this.attrGmtModified = this.getAtt('GmtModified');
        this.attrGroupId = this.getAtt('GroupId');
        this.attrResourceGroupId = this.getAtt('ResourceGroupId');
        this.attrStorageAcl = this.getAtt('StorageAcl');
        this.attrStorageLocation = this.getAtt('StorageLocation');
        this.attrStorageUsage = this.getAtt('StorageUsage');
        this.attrType = this.getAtt('Type');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.storageLocation = props.storageLocation;
        this.storageType = props.storageType;
        this.defaultUpload = props.defaultUpload;
    }
    get rosProperties() {
        return {
            storageLocation: this.storageLocation,
            storageType: this.storageType,
            defaultUpload: this.defaultUpload,
        };
    }
    renderProperties(props) {
        return rosStoragePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosStorage = RosStorage;
/**
 * The resource type name for this resource class.
 */
RosStorage.ROS_RESOURCE_TYPE_NAME = "ALIYUN::VOD::Storage";
//# sourceMappingURL=data:application/json;base64,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