# coding: utf-8

"""
    Residential Electrification Model API

    An API for REM, the Residential Electrification Model.         The other Rewiring America APIs and methodology for REM are [here](https://api.rewiringamerica.org/).

    The version of the OpenAPI document: 0.1.0
    Contact: datascience@rewiringamerica.org
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing_extensions import Annotated
from rewiringamerica_rem.models.heating_fuel_input import HeatingFuelInput
from rewiringamerica_rem.models.rem_profile_request import RemProfileRequest
from rewiringamerica_rem.models.savings import Savings
from rewiringamerica_rem.models.supported_upgrade import SupportedUpgrade

from rewiringamerica_rem.api_client import ApiClient, RequestSerialized
from rewiringamerica_rem.api_response import ApiResponse
from rewiringamerica_rem.rest import RESTResponseType


class ResidentialElectrificationModelApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_by_address(
        self,
        upgrade: Annotated[SupportedUpgrade, Field(description="The upgrade whose effects we want to analyze. Supported values are as follows: - `basic_enclosure`: A basic weatherization upgrade for the home   as described in measure package 1 (on page 4) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `min_eff_hp_elec_backup`: A relatively-low efficiency heat pump upgrade for the home’s HVAC   system as described in measure package 3 (on page 5) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `high_eff_hp_elec_backup`: A high efficiency heat pump upgrade for the home’s HVAC system as   described in measure package 4 (on page 6) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `whole_home_electric_max_eff_basic_enclosure`: A whole-home upgrade including a high   efficiency heat pump for the home’s HVAC system, basic weatherization, a heat pump water heater, a heat pump dryer,   and an induction stove as described in measure package 9 (on page 9) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `med_eff_hp_hers_sizing_no_setback`: A medium-efficiency heat pump upgrade for   the home's HVAC system. Rewiring America simulated this upgrade using the same tools NREL uses for ResStock. - `med_eff_hp_hers_sizing_no_setback_basic_enclosure`: A custom upgrade based on a   medium-efficiency heat pump and basic weatherization upgrade for the home. Rewiring America simulated this upgrade   using the same tools NREL uses for ResStock. ")],
        address: Annotated[str, Field(min_length=1, strict=True, description="The address of the home being upgraded.")],
        heating_fuel: Annotated[HeatingFuelInput, Field(description="The heating fuel used in the home before the upgrade. Supported values are as follows: - `electricity`: the home was heated with electric heating, such as   baseboard heating, an electric boiler, or an electric furnace. - `natural_gas`: The home was heated with a natural gas furnace. - `fuel_oil`: The home was heated with a fuel oil boiler or furnace. - `propane`:  The home was heated with a propane furnace. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Savings:
        """Get By Address

        Predict a user's savings using the Residential Electrification Model.  This API makes predictions of the effects of an upgrade based on the address of the home being upgraded, and the current heating fuel.  Using the provided address, it first queries a large database of home properties that Rewiring America has assembled, which contains data such as home age, size, construction material, and much more. We don't know all of the properties needed to get a good estimate of energy consumption, so we perform a [Monte Carlo](https://en.wikipedia.org/wiki/Monte_Carlo_method) simulation over a sample homes chosen from a [conditional probability distribution](https://github.com/NREL/resstock/tree/develop/project_national/housing_characteristics) based the properties that we do know. We then estimate the energy consumption for each sample building by running inference using a Machine Learning based surrogate model, trained on [EnergyPlus](https://energyplus.net/) simulations.  The response JSON is a dictionary with three components: - `fuel_results`: This is a dictionary of the main results from the model, one for each heating fuel type,   which are:   - `electricity`   - `fuel_oil`   - `natural_gas`   - `propane`   - `total` (for the total of all the others). - `rates`: A summary of the rates used to calculate the cost in dollars of the fuels used. - `emissions_factors`: A summary of the local emissions factors used to calculate emissions.   These vary from region to region based on how electricity is generated and the nature of   other fuels.  Within the `fuel_results` subsection for each of the fuel types, there are three components:   - `baseline`: the usage of the fuel before the upgrade   - `upgrade`: the usage of the fuel after the upgrade   - `delta`: the change is usage of the fuel.  Inside those three, there are parallel structures with statistics for the `energy` used in the form the fuel, the `emissions` associated with the use of the fuel, and  the `cost` of the fuel. The electricity emissions factors are [long run marginal emissions rates assuming a 95% decarbonized grid by 2050](https://www.nrel.gov/analysis/cambium.html). The emissions and costs are computed with the help of the numbers returned in the `rates` and `emissions_factors` data mentioned above, where the costs only reflect only the volumetric charges without the monthly fixed charge. All of the statistics are for a full typical weather year. The units for each of the statistics are also provided and are as appropriate for the fuel, emissions, or cost.  *A note on statistics*: For each value we provide statistics for, we provide a mean, a median, and the 20th and 80th percentile values over all the set of sample homes in the Monte Carlo simulation. It is important to note that the statistics are taken over the distribution of the values they represent. This means, for example, that the median in terms of electricity usage before the upgrade and the median in terms of electricity usage after the upgrade and the median in terms of change of electricity usage might not be the same, so adding the median change to the median usage before the upgrade might fail to produce the number reported as the median usage after the upgrade.  Note that because we are modeling whole home energy consumption over a set of building samples, and the building set contains homes with a variety of fuels for the non-heating appliances, you may see consumption of fuels other than the passed heating fuel, particularly for the mean.  Parameters ----------     upgrade: The upgrade we want to analyze.     address: The location of a user.     heating_fuel: The heating fuel in use before the upgrade.  Returns -------     Savings data from our REM model. See details in the API description.

        :param upgrade: The upgrade whose effects we want to analyze. Supported values are as follows: - `basic_enclosure`: A basic weatherization upgrade for the home   as described in measure package 1 (on page 4) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `min_eff_hp_elec_backup`: A relatively-low efficiency heat pump upgrade for the home’s HVAC   system as described in measure package 3 (on page 5) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `high_eff_hp_elec_backup`: A high efficiency heat pump upgrade for the home’s HVAC system as   described in measure package 4 (on page 6) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `whole_home_electric_max_eff_basic_enclosure`: A whole-home upgrade including a high   efficiency heat pump for the home’s HVAC system, basic weatherization, a heat pump water heater, a heat pump dryer,   and an induction stove as described in measure package 9 (on page 9) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `med_eff_hp_hers_sizing_no_setback`: A medium-efficiency heat pump upgrade for   the home's HVAC system. Rewiring America simulated this upgrade using the same tools NREL uses for ResStock. - `med_eff_hp_hers_sizing_no_setback_basic_enclosure`: A custom upgrade based on a   medium-efficiency heat pump and basic weatherization upgrade for the home. Rewiring America simulated this upgrade   using the same tools NREL uses for ResStock.  (required)
        :type upgrade: SupportedUpgrade
        :param address: The address of the home being upgraded. (required)
        :type address: str
        :param heating_fuel: The heating fuel used in the home before the upgrade. Supported values are as follows: - `electricity`: the home was heated with electric heating, such as   baseboard heating, an electric boiler, or an electric furnace. - `natural_gas`: The home was heated with a natural gas furnace. - `fuel_oil`: The home was heated with a fuel oil boiler or furnace. - `propane`:  The home was heated with a propane furnace.  (required)
        :type heating_fuel: HeatingFuelInput
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_by_address_serialize(
            upgrade=upgrade,
            address=address,
            heating_fuel=heating_fuel,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Savings",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_by_address_with_http_info(
        self,
        upgrade: Annotated[SupportedUpgrade, Field(description="The upgrade whose effects we want to analyze. Supported values are as follows: - `basic_enclosure`: A basic weatherization upgrade for the home   as described in measure package 1 (on page 4) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `min_eff_hp_elec_backup`: A relatively-low efficiency heat pump upgrade for the home’s HVAC   system as described in measure package 3 (on page 5) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `high_eff_hp_elec_backup`: A high efficiency heat pump upgrade for the home’s HVAC system as   described in measure package 4 (on page 6) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `whole_home_electric_max_eff_basic_enclosure`: A whole-home upgrade including a high   efficiency heat pump for the home’s HVAC system, basic weatherization, a heat pump water heater, a heat pump dryer,   and an induction stove as described in measure package 9 (on page 9) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `med_eff_hp_hers_sizing_no_setback`: A medium-efficiency heat pump upgrade for   the home's HVAC system. Rewiring America simulated this upgrade using the same tools NREL uses for ResStock. - `med_eff_hp_hers_sizing_no_setback_basic_enclosure`: A custom upgrade based on a   medium-efficiency heat pump and basic weatherization upgrade for the home. Rewiring America simulated this upgrade   using the same tools NREL uses for ResStock. ")],
        address: Annotated[str, Field(min_length=1, strict=True, description="The address of the home being upgraded.")],
        heating_fuel: Annotated[HeatingFuelInput, Field(description="The heating fuel used in the home before the upgrade. Supported values are as follows: - `electricity`: the home was heated with electric heating, such as   baseboard heating, an electric boiler, or an electric furnace. - `natural_gas`: The home was heated with a natural gas furnace. - `fuel_oil`: The home was heated with a fuel oil boiler or furnace. - `propane`:  The home was heated with a propane furnace. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Savings]:
        """Get By Address

        Predict a user's savings using the Residential Electrification Model.  This API makes predictions of the effects of an upgrade based on the address of the home being upgraded, and the current heating fuel.  Using the provided address, it first queries a large database of home properties that Rewiring America has assembled, which contains data such as home age, size, construction material, and much more. We don't know all of the properties needed to get a good estimate of energy consumption, so we perform a [Monte Carlo](https://en.wikipedia.org/wiki/Monte_Carlo_method) simulation over a sample homes chosen from a [conditional probability distribution](https://github.com/NREL/resstock/tree/develop/project_national/housing_characteristics) based the properties that we do know. We then estimate the energy consumption for each sample building by running inference using a Machine Learning based surrogate model, trained on [EnergyPlus](https://energyplus.net/) simulations.  The response JSON is a dictionary with three components: - `fuel_results`: This is a dictionary of the main results from the model, one for each heating fuel type,   which are:   - `electricity`   - `fuel_oil`   - `natural_gas`   - `propane`   - `total` (for the total of all the others). - `rates`: A summary of the rates used to calculate the cost in dollars of the fuels used. - `emissions_factors`: A summary of the local emissions factors used to calculate emissions.   These vary from region to region based on how electricity is generated and the nature of   other fuels.  Within the `fuel_results` subsection for each of the fuel types, there are three components:   - `baseline`: the usage of the fuel before the upgrade   - `upgrade`: the usage of the fuel after the upgrade   - `delta`: the change is usage of the fuel.  Inside those three, there are parallel structures with statistics for the `energy` used in the form the fuel, the `emissions` associated with the use of the fuel, and  the `cost` of the fuel. The electricity emissions factors are [long run marginal emissions rates assuming a 95% decarbonized grid by 2050](https://www.nrel.gov/analysis/cambium.html). The emissions and costs are computed with the help of the numbers returned in the `rates` and `emissions_factors` data mentioned above, where the costs only reflect only the volumetric charges without the monthly fixed charge. All of the statistics are for a full typical weather year. The units for each of the statistics are also provided and are as appropriate for the fuel, emissions, or cost.  *A note on statistics*: For each value we provide statistics for, we provide a mean, a median, and the 20th and 80th percentile values over all the set of sample homes in the Monte Carlo simulation. It is important to note that the statistics are taken over the distribution of the values they represent. This means, for example, that the median in terms of electricity usage before the upgrade and the median in terms of electricity usage after the upgrade and the median in terms of change of electricity usage might not be the same, so adding the median change to the median usage before the upgrade might fail to produce the number reported as the median usage after the upgrade.  Note that because we are modeling whole home energy consumption over a set of building samples, and the building set contains homes with a variety of fuels for the non-heating appliances, you may see consumption of fuels other than the passed heating fuel, particularly for the mean.  Parameters ----------     upgrade: The upgrade we want to analyze.     address: The location of a user.     heating_fuel: The heating fuel in use before the upgrade.  Returns -------     Savings data from our REM model. See details in the API description.

        :param upgrade: The upgrade whose effects we want to analyze. Supported values are as follows: - `basic_enclosure`: A basic weatherization upgrade for the home   as described in measure package 1 (on page 4) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `min_eff_hp_elec_backup`: A relatively-low efficiency heat pump upgrade for the home’s HVAC   system as described in measure package 3 (on page 5) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `high_eff_hp_elec_backup`: A high efficiency heat pump upgrade for the home’s HVAC system as   described in measure package 4 (on page 6) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `whole_home_electric_max_eff_basic_enclosure`: A whole-home upgrade including a high   efficiency heat pump for the home’s HVAC system, basic weatherization, a heat pump water heater, a heat pump dryer,   and an induction stove as described in measure package 9 (on page 9) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `med_eff_hp_hers_sizing_no_setback`: A medium-efficiency heat pump upgrade for   the home's HVAC system. Rewiring America simulated this upgrade using the same tools NREL uses for ResStock. - `med_eff_hp_hers_sizing_no_setback_basic_enclosure`: A custom upgrade based on a   medium-efficiency heat pump and basic weatherization upgrade for the home. Rewiring America simulated this upgrade   using the same tools NREL uses for ResStock.  (required)
        :type upgrade: SupportedUpgrade
        :param address: The address of the home being upgraded. (required)
        :type address: str
        :param heating_fuel: The heating fuel used in the home before the upgrade. Supported values are as follows: - `electricity`: the home was heated with electric heating, such as   baseboard heating, an electric boiler, or an electric furnace. - `natural_gas`: The home was heated with a natural gas furnace. - `fuel_oil`: The home was heated with a fuel oil boiler or furnace. - `propane`:  The home was heated with a propane furnace.  (required)
        :type heating_fuel: HeatingFuelInput
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_by_address_serialize(
            upgrade=upgrade,
            address=address,
            heating_fuel=heating_fuel,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Savings",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_by_address_without_preload_content(
        self,
        upgrade: Annotated[SupportedUpgrade, Field(description="The upgrade whose effects we want to analyze. Supported values are as follows: - `basic_enclosure`: A basic weatherization upgrade for the home   as described in measure package 1 (on page 4) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `min_eff_hp_elec_backup`: A relatively-low efficiency heat pump upgrade for the home’s HVAC   system as described in measure package 3 (on page 5) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `high_eff_hp_elec_backup`: A high efficiency heat pump upgrade for the home’s HVAC system as   described in measure package 4 (on page 6) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `whole_home_electric_max_eff_basic_enclosure`: A whole-home upgrade including a high   efficiency heat pump for the home’s HVAC system, basic weatherization, a heat pump water heater, a heat pump dryer,   and an induction stove as described in measure package 9 (on page 9) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `med_eff_hp_hers_sizing_no_setback`: A medium-efficiency heat pump upgrade for   the home's HVAC system. Rewiring America simulated this upgrade using the same tools NREL uses for ResStock. - `med_eff_hp_hers_sizing_no_setback_basic_enclosure`: A custom upgrade based on a   medium-efficiency heat pump and basic weatherization upgrade for the home. Rewiring America simulated this upgrade   using the same tools NREL uses for ResStock. ")],
        address: Annotated[str, Field(min_length=1, strict=True, description="The address of the home being upgraded.")],
        heating_fuel: Annotated[HeatingFuelInput, Field(description="The heating fuel used in the home before the upgrade. Supported values are as follows: - `electricity`: the home was heated with electric heating, such as   baseboard heating, an electric boiler, or an electric furnace. - `natural_gas`: The home was heated with a natural gas furnace. - `fuel_oil`: The home was heated with a fuel oil boiler or furnace. - `propane`:  The home was heated with a propane furnace. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get By Address

        Predict a user's savings using the Residential Electrification Model.  This API makes predictions of the effects of an upgrade based on the address of the home being upgraded, and the current heating fuel.  Using the provided address, it first queries a large database of home properties that Rewiring America has assembled, which contains data such as home age, size, construction material, and much more. We don't know all of the properties needed to get a good estimate of energy consumption, so we perform a [Monte Carlo](https://en.wikipedia.org/wiki/Monte_Carlo_method) simulation over a sample homes chosen from a [conditional probability distribution](https://github.com/NREL/resstock/tree/develop/project_national/housing_characteristics) based the properties that we do know. We then estimate the energy consumption for each sample building by running inference using a Machine Learning based surrogate model, trained on [EnergyPlus](https://energyplus.net/) simulations.  The response JSON is a dictionary with three components: - `fuel_results`: This is a dictionary of the main results from the model, one for each heating fuel type,   which are:   - `electricity`   - `fuel_oil`   - `natural_gas`   - `propane`   - `total` (for the total of all the others). - `rates`: A summary of the rates used to calculate the cost in dollars of the fuels used. - `emissions_factors`: A summary of the local emissions factors used to calculate emissions.   These vary from region to region based on how electricity is generated and the nature of   other fuels.  Within the `fuel_results` subsection for each of the fuel types, there are three components:   - `baseline`: the usage of the fuel before the upgrade   - `upgrade`: the usage of the fuel after the upgrade   - `delta`: the change is usage of the fuel.  Inside those three, there are parallel structures with statistics for the `energy` used in the form the fuel, the `emissions` associated with the use of the fuel, and  the `cost` of the fuel. The electricity emissions factors are [long run marginal emissions rates assuming a 95% decarbonized grid by 2050](https://www.nrel.gov/analysis/cambium.html). The emissions and costs are computed with the help of the numbers returned in the `rates` and `emissions_factors` data mentioned above, where the costs only reflect only the volumetric charges without the monthly fixed charge. All of the statistics are for a full typical weather year. The units for each of the statistics are also provided and are as appropriate for the fuel, emissions, or cost.  *A note on statistics*: For each value we provide statistics for, we provide a mean, a median, and the 20th and 80th percentile values over all the set of sample homes in the Monte Carlo simulation. It is important to note that the statistics are taken over the distribution of the values they represent. This means, for example, that the median in terms of electricity usage before the upgrade and the median in terms of electricity usage after the upgrade and the median in terms of change of electricity usage might not be the same, so adding the median change to the median usage before the upgrade might fail to produce the number reported as the median usage after the upgrade.  Note that because we are modeling whole home energy consumption over a set of building samples, and the building set contains homes with a variety of fuels for the non-heating appliances, you may see consumption of fuels other than the passed heating fuel, particularly for the mean.  Parameters ----------     upgrade: The upgrade we want to analyze.     address: The location of a user.     heating_fuel: The heating fuel in use before the upgrade.  Returns -------     Savings data from our REM model. See details in the API description.

        :param upgrade: The upgrade whose effects we want to analyze. Supported values are as follows: - `basic_enclosure`: A basic weatherization upgrade for the home   as described in measure package 1 (on page 4) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `min_eff_hp_elec_backup`: A relatively-low efficiency heat pump upgrade for the home’s HVAC   system as described in measure package 3 (on page 5) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `high_eff_hp_elec_backup`: A high efficiency heat pump upgrade for the home’s HVAC system as   described in measure package 4 (on page 6) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `whole_home_electric_max_eff_basic_enclosure`: A whole-home upgrade including a high   efficiency heat pump for the home’s HVAC system, basic weatherization, a heat pump water heater, a heat pump dryer,   and an induction stove as described in measure package 9 (on page 9) of [this   document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `med_eff_hp_hers_sizing_no_setback`: A medium-efficiency heat pump upgrade for   the home's HVAC system. Rewiring America simulated this upgrade using the same tools NREL uses for ResStock. - `med_eff_hp_hers_sizing_no_setback_basic_enclosure`: A custom upgrade based on a   medium-efficiency heat pump and basic weatherization upgrade for the home. Rewiring America simulated this upgrade   using the same tools NREL uses for ResStock.  (required)
        :type upgrade: SupportedUpgrade
        :param address: The address of the home being upgraded. (required)
        :type address: str
        :param heating_fuel: The heating fuel used in the home before the upgrade. Supported values are as follows: - `electricity`: the home was heated with electric heating, such as   baseboard heating, an electric boiler, or an electric furnace. - `natural_gas`: The home was heated with a natural gas furnace. - `fuel_oil`: The home was heated with a fuel oil boiler or furnace. - `propane`:  The home was heated with a propane furnace.  (required)
        :type heating_fuel: HeatingFuelInput
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_by_address_serialize(
            upgrade=upgrade,
            address=address,
            heating_fuel=heating_fuel,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Savings",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_by_address_serialize(
        self,
        upgrade,
        address,
        heating_fuel,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if upgrade is not None:
            
            _query_params.append(('upgrade', upgrade.value))
            
        if address is not None:
            
            _query_params.append(('address', address))
            
        if heating_fuel is not None:
            
            _query_params.append(('heating_fuel', heating_fuel.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'auth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/rem/address',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_by_profile(
        self,
        rem_profile_request: RemProfileRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Savings:
        """Get By Profile

        Predict a user's savings using Residential Electrification Model using a Building Profile and an Upgrade.  This implementation takes in a dictionary of required inputs for the request body.  Parameters ----------     rem_profile_req (RemProfileRequest): An object containing all of the necessary inputs for Dohyo:         Upgrade, County, PUMA, Climate Zone, ResStock weather file location, state abbreviation, and         building features.  Returns -------     Savings: JSON containing prediction output from Dohyo.

        :param rem_profile_request: (required)
        :type rem_profile_request: RemProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_by_profile_serialize(
            rem_profile_request=rem_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Savings",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_by_profile_with_http_info(
        self,
        rem_profile_request: RemProfileRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Savings]:
        """Get By Profile

        Predict a user's savings using Residential Electrification Model using a Building Profile and an Upgrade.  This implementation takes in a dictionary of required inputs for the request body.  Parameters ----------     rem_profile_req (RemProfileRequest): An object containing all of the necessary inputs for Dohyo:         Upgrade, County, PUMA, Climate Zone, ResStock weather file location, state abbreviation, and         building features.  Returns -------     Savings: JSON containing prediction output from Dohyo.

        :param rem_profile_request: (required)
        :type rem_profile_request: RemProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_by_profile_serialize(
            rem_profile_request=rem_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Savings",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_by_profile_without_preload_content(
        self,
        rem_profile_request: RemProfileRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get By Profile

        Predict a user's savings using Residential Electrification Model using a Building Profile and an Upgrade.  This implementation takes in a dictionary of required inputs for the request body.  Parameters ----------     rem_profile_req (RemProfileRequest): An object containing all of the necessary inputs for Dohyo:         Upgrade, County, PUMA, Climate Zone, ResStock weather file location, state abbreviation, and         building features.  Returns -------     Savings: JSON containing prediction output from Dohyo.

        :param rem_profile_request: (required)
        :type rem_profile_request: RemProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_by_profile_serialize(
            rem_profile_request=rem_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Savings",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_by_profile_serialize(
        self,
        rem_profile_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if rem_profile_request is not None:
            _body_params = rem_profile_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'auth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/rem/profile',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_impl_version(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> str:
        """Get Impl Version

        Return the back end version of the code that is deployed.  This is not the version of the API, but rather of the code that implements it. This is mainly to track code deployments. The same API version is typically supported by a series of deployments each of which improves upon earlier ones in some way, such as fixing bugs or improving performance.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_impl_version_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_impl_version_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[str]:
        """Get Impl Version

        Return the back end version of the code that is deployed.  This is not the version of the API, but rather of the code that implements it. This is mainly to track code deployments. The same API version is typically supported by a series of deployments each of which improves upon earlier ones in some way, such as fixing bugs or improving performance.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_impl_version_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_impl_version_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Impl Version

        Return the back end version of the code that is deployed.  This is not the version of the API, but rather of the code that implements it. This is mainly to track code deployments. The same API version is typically supported by a series of deployments each of which improves upon earlier ones in some way, such as fixing bugs or improving performance.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_impl_version_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_impl_version_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'auth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/rem/server_version',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


