# This file was auto-generated by Fern from our API Definition.

import os
import typing

import httpx
from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.request_options import RequestOptions
from .environment import FathomApiEnvironment
from .raw_base_client import AsyncRawBaseClient, RawBaseClient
from .types.list_meetings_request_meeting_type import ListMeetingsRequestMeetingType
from .types.meeting_list_response import MeetingListResponse
from .types.team_list_response import TeamListResponse
from .types.team_member_list_response import TeamMemberListResponse


class BaseClient:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : FathomApiEnvironment
        The environment to use for requests from the client. from .environment import FathomApiEnvironment

        Defaults to FathomApiEnvironment.DEFAULT



    api_key : typing.Optional[typing.Union[str, typing.Callable[[], str]]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from fathom import FathomApi
    client = FathomApi(api_key="YOUR_API_KEY", )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: FathomApiEnvironment = FathomApiEnvironment.DEFAULT,
        api_key: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = os.getenv("FATHOM_API_KEY"),
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if api_key is None:
            raise ApiError(
                body="The client must be instantiated be either passing in api_key or setting FATHOM_API_KEY"
            )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._raw_client = RawBaseClient(client_wrapper=self._client_wrapper)

    @property
    def with_raw_response(self) -> RawBaseClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBaseClient
        """
        return self._raw_client

    def list_meetings(
        self,
        *,
        recorded_by: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        teams: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        calendar_invitees: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        created_after: typing.Optional[str] = None,
        meeting_type: typing.Optional[ListMeetingsRequestMeetingType] = None,
        include_transcript: typing.Optional[bool] = None,
        cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MeetingListResponse:
        """
        Parameters
        ----------
        recorded_by : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Email addresses of meeting owners.

            Pass the parameter once per value, e.g.
            `recorded_by[]=ceo@acme.com&recorded_by[]=pm@acme.com`.

            Returns meetings hosted by any of the specified users.

        teams : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Team names to filter by.

            Pass the parameter once per value, e.g.
            `teams[]=Sales&teams[]=Engineering`.

            Returns meetings that belong to any of the specified teams.

        calendar_invitees : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Email addresses of calendar_invitees.

            Pass the parameter once per value, e.g.
            `calendar_invitees[]=cfo@acme.com&calendar_invitees[]=legal@acme.com`.

            Returns meetings where any of the given email addresses appear
            in the calendar_invitees list.

        created_after : typing.Optional[str]
            Filter to meetings with created_at after this timestamp, e.g. `created_after=2025-01-01T00:00:00Z`.

        meeting_type : typing.Optional[ListMeetingsRequestMeetingType]
            Filter by meeting type.

        include_transcript : typing.Optional[bool]
            Include the transcript for each meeting.

        cursor : typing.Optional[str]
            Cursor for pagination.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MeetingListResponse
            Paginated list of meetings.

        Examples
        --------
        from fathom import FathomApi
        client = FathomApi(api_key="YOUR_API_KEY", )
        client.list_meetings()
        """
        _response = self._raw_client.list_meetings(
            recorded_by=recorded_by,
            teams=teams,
            calendar_invitees=calendar_invitees,
            created_after=created_after,
            meeting_type=meeting_type,
            include_transcript=include_transcript,
            cursor=cursor,
            request_options=request_options,
        )
        return _response.data

    def list_teams(
        self, *, cursor: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> TeamListResponse:
        """
        Parameters
        ----------
        cursor : typing.Optional[str]
            Cursor for pagination.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TeamListResponse
            Paginated list of teams.

        Examples
        --------
        from fathom import FathomApi
        client = FathomApi(api_key="YOUR_API_KEY", )
        client.list_teams()
        """
        _response = self._raw_client.list_teams(cursor=cursor, request_options=request_options)
        return _response.data

    def list_team_members(
        self,
        *,
        team: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TeamMemberListResponse:
        """
        Parameters
        ----------
        team : typing.Optional[str]
            Team name to filter by.

        cursor : typing.Optional[str]
            Cursor for pagination.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TeamMemberListResponse
            Paginated list of team members.

        Examples
        --------
        from fathom import FathomApi
        client = FathomApi(api_key="YOUR_API_KEY", )
        client.list_team_members()
        """
        _response = self._raw_client.list_team_members(team=team, cursor=cursor, request_options=request_options)
        return _response.data


class AsyncBaseClient:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : FathomApiEnvironment
        The environment to use for requests from the client. from .environment import FathomApiEnvironment

        Defaults to FathomApiEnvironment.DEFAULT



    api_key : typing.Optional[typing.Union[str, typing.Callable[[], str]]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from fathom import AsyncFathomApi
    client = AsyncFathomApi(api_key="YOUR_API_KEY", )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: FathomApiEnvironment = FathomApiEnvironment.DEFAULT,
        api_key: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = os.getenv("FATHOM_API_KEY"),
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if api_key is None:
            raise ApiError(
                body="The client must be instantiated be either passing in api_key or setting FATHOM_API_KEY"
            )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._raw_client = AsyncRawBaseClient(client_wrapper=self._client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawBaseClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBaseClient
        """
        return self._raw_client

    async def list_meetings(
        self,
        *,
        recorded_by: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        teams: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        calendar_invitees: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        created_after: typing.Optional[str] = None,
        meeting_type: typing.Optional[ListMeetingsRequestMeetingType] = None,
        include_transcript: typing.Optional[bool] = None,
        cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MeetingListResponse:
        """
        Parameters
        ----------
        recorded_by : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Email addresses of meeting owners.

            Pass the parameter once per value, e.g.
            `recorded_by[]=ceo@acme.com&recorded_by[]=pm@acme.com`.

            Returns meetings hosted by any of the specified users.

        teams : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Team names to filter by.

            Pass the parameter once per value, e.g.
            `teams[]=Sales&teams[]=Engineering`.

            Returns meetings that belong to any of the specified teams.

        calendar_invitees : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Email addresses of calendar_invitees.

            Pass the parameter once per value, e.g.
            `calendar_invitees[]=cfo@acme.com&calendar_invitees[]=legal@acme.com`.

            Returns meetings where any of the given email addresses appear
            in the calendar_invitees list.

        created_after : typing.Optional[str]
            Filter to meetings with created_at after this timestamp, e.g. `created_after=2025-01-01T00:00:00Z`.

        meeting_type : typing.Optional[ListMeetingsRequestMeetingType]
            Filter by meeting type.

        include_transcript : typing.Optional[bool]
            Include the transcript for each meeting.

        cursor : typing.Optional[str]
            Cursor for pagination.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MeetingListResponse
            Paginated list of meetings.

        Examples
        --------
        from fathom import AsyncFathomApi
        import asyncio
        client = AsyncFathomApi(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.list_meetings()
        asyncio.run(main())
        """
        _response = await self._raw_client.list_meetings(
            recorded_by=recorded_by,
            teams=teams,
            calendar_invitees=calendar_invitees,
            created_after=created_after,
            meeting_type=meeting_type,
            include_transcript=include_transcript,
            cursor=cursor,
            request_options=request_options,
        )
        return _response.data

    async def list_teams(
        self, *, cursor: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> TeamListResponse:
        """
        Parameters
        ----------
        cursor : typing.Optional[str]
            Cursor for pagination.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TeamListResponse
            Paginated list of teams.

        Examples
        --------
        from fathom import AsyncFathomApi
        import asyncio
        client = AsyncFathomApi(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.list_teams()
        asyncio.run(main())
        """
        _response = await self._raw_client.list_teams(cursor=cursor, request_options=request_options)
        return _response.data

    async def list_team_members(
        self,
        *,
        team: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TeamMemberListResponse:
        """
        Parameters
        ----------
        team : typing.Optional[str]
            Team name to filter by.

        cursor : typing.Optional[str]
            Cursor for pagination.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TeamMemberListResponse
            Paginated list of team members.

        Examples
        --------
        from fathom import AsyncFathomApi
        import asyncio
        client = AsyncFathomApi(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.list_team_members()
        asyncio.run(main())
        """
        _response = await self._raw_client.list_team_members(team=team, cursor=cursor, request_options=request_options)
        return _response.data


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: FathomApiEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
