# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInstanceAgentPluginsResult',
    'AwaitableGetInstanceAgentPluginsResult',
    'get_instance_agent_plugins',
    'get_instance_agent_plugins_output',
]

@pulumi.output_type
class GetInstanceAgentPluginsResult:
    """
    A collection of values returned by getInstanceAgentPlugins.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, instance_agent_plugins=None, instanceagent_id=None, name=None, status=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_agent_plugins and not isinstance(instance_agent_plugins, list):
            raise TypeError("Expected argument 'instance_agent_plugins' to be a list")
        pulumi.set(__self__, "instance_agent_plugins", instance_agent_plugins)
        if instanceagent_id and not isinstance(instanceagent_id, str):
            raise TypeError("Expected argument 'instanceagent_id' to be a str")
        pulumi.set(__self__, "instanceagent_id", instanceagent_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInstanceAgentPluginsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceAgentPlugins")
    def instance_agent_plugins(self) -> Sequence['outputs.GetInstanceAgentPluginsInstanceAgentPluginResult']:
        """
        The list of instance_agent_plugins.
        """
        return pulumi.get(self, "instance_agent_plugins")

    @property
    @pulumi.getter(name="instanceagentId")
    def instanceagent_id(self) -> str:
        return pulumi.get(self, "instanceagent_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The plugin name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The plugin status Specified the plugin state on the instance * `RUNNING` - The plugin is in running state * `STOPPED` - The plugin is in stopped state * `NOT_SUPPORTED` - The plugin is not supported on this platform * `INVALID` - The plugin state is not recognizable by the service
        """
        return pulumi.get(self, "status")


class AwaitableGetInstanceAgentPluginsResult(GetInstanceAgentPluginsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceAgentPluginsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            instance_agent_plugins=self.instance_agent_plugins,
            instanceagent_id=self.instanceagent_id,
            name=self.name,
            status=self.status)


def get_instance_agent_plugins(compartment_id: Optional[str] = None,
                               filters: Optional[Sequence[pulumi.InputType['GetInstanceAgentPluginsFilterArgs']]] = None,
                               instanceagent_id: Optional[str] = None,
                               name: Optional[str] = None,
                               status: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceAgentPluginsResult:
    """
    This data source provides the list of Instance Agent Plugins in Oracle Cloud Infrastructure Compute Instance Agent service.

    The API to get one or more plugin information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_agent_plugins = oci.ComputeInstanceAgent.get_instance_agent_plugins(instanceagent_id=oci_computeinstanceagent_instanceagent["test_instanceagent"]["id"],
        name=var["instance_agent_plugin_name"],
        status=var["instance_agent_plugin_status"])
    ```


    :param str instanceagent_id: The OCID of the instance.
    :param str name: The plugin name
    :param str status: The plugin status
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['instanceagentId'] = instanceagent_id
    __args__['name'] = name
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ComputeInstanceAgent/getInstanceAgentPlugins:getInstanceAgentPlugins', __args__, opts=opts, typ=GetInstanceAgentPluginsResult).value

    return AwaitableGetInstanceAgentPluginsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        instance_agent_plugins=pulumi.get(__ret__, 'instance_agent_plugins'),
        instanceagent_id=pulumi.get(__ret__, 'instanceagent_id'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_instance_agent_plugins)
def get_instance_agent_plugins_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetInstanceAgentPluginsFilterArgs']]]]] = None,
                                      instanceagent_id: Optional[pulumi.Input[str]] = None,
                                      name: Optional[pulumi.Input[Optional[str]]] = None,
                                      status: Optional[pulumi.Input[Optional[str]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstanceAgentPluginsResult]:
    """
    This data source provides the list of Instance Agent Plugins in Oracle Cloud Infrastructure Compute Instance Agent service.

    The API to get one or more plugin information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_agent_plugins = oci.ComputeInstanceAgent.get_instance_agent_plugins(instanceagent_id=oci_computeinstanceagent_instanceagent["test_instanceagent"]["id"],
        name=var["instance_agent_plugin_name"],
        status=var["instance_agent_plugin_status"])
    ```


    :param str instanceagent_id: The OCID of the instance.
    :param str name: The plugin name
    :param str status: The plugin status
    """
    ...
