# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUnifiedAgentConfigurationsResult',
    'AwaitableGetUnifiedAgentConfigurationsResult',
    'get_unified_agent_configurations',
    'get_unified_agent_configurations_output',
]

@pulumi.output_type
class GetUnifiedAgentConfigurationsResult:
    """
    A collection of values returned by getUnifiedAgentConfigurations.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, group_id=None, id=None, is_compartment_id_in_subtree=None, log_id=None, state=None, unified_agent_configuration_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_compartment_id_in_subtree and not isinstance(is_compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'is_compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "is_compartment_id_in_subtree", is_compartment_id_in_subtree)
        if log_id and not isinstance(log_id, str):
            raise TypeError("Expected argument 'log_id' to be a str")
        pulumi.set(__self__, "log_id", log_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if unified_agent_configuration_collections and not isinstance(unified_agent_configuration_collections, list):
            raise TypeError("Expected argument 'unified_agent_configuration_collections' to be a list")
        pulumi.set(__self__, "unified_agent_configuration_collections", unified_agent_configuration_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetUnifiedAgentConfigurationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[str]:
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCompartmentIdInSubtree")
    def is_compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "is_compartment_id_in_subtree")

    @property
    @pulumi.getter(name="logId")
    def log_id(self) -> Optional[str]:
        return pulumi.get(self, "log_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The pipeline state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="unifiedAgentConfigurationCollections")
    def unified_agent_configuration_collections(self) -> Sequence['outputs.GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionResult']:
        """
        The list of unified_agent_configuration_collection.
        """
        return pulumi.get(self, "unified_agent_configuration_collections")


class AwaitableGetUnifiedAgentConfigurationsResult(GetUnifiedAgentConfigurationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUnifiedAgentConfigurationsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            group_id=self.group_id,
            id=self.id,
            is_compartment_id_in_subtree=self.is_compartment_id_in_subtree,
            log_id=self.log_id,
            state=self.state,
            unified_agent_configuration_collections=self.unified_agent_configuration_collections)


def get_unified_agent_configurations(compartment_id: Optional[str] = None,
                                     display_name: Optional[str] = None,
                                     filters: Optional[Sequence[pulumi.InputType['GetUnifiedAgentConfigurationsFilterArgs']]] = None,
                                     group_id: Optional[str] = None,
                                     is_compartment_id_in_subtree: Optional[bool] = None,
                                     log_id: Optional[str] = None,
                                     state: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUnifiedAgentConfigurationsResult:
    """
    This data source provides the list of Unified Agent Configurations in Oracle Cloud Infrastructure Logging service.

    Lists all unified agent configurations in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_unified_agent_configurations = oci.Logging.get_unified_agent_configurations(compartment_id=var["compartment_id"],
        display_name=var["unified_agent_configuration_display_name"],
        group_id=oci_identity_group["test_group"]["id"],
        is_compartment_id_in_subtree=var["unified_agent_configuration_is_compartment_id_in_subtree"],
        log_id=oci_logging_log["test_log"]["id"],
        state=var["unified_agent_configuration_state"])
    ```


    :param str compartment_id: Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
    :param str display_name: Resource name.
    :param str group_id: The OCID of a group or a dynamic group.
    :param bool is_compartment_id_in_subtree: Specifies whether or not nested compartments should be traversed. Defaults to false.
    :param str log_id: Custom log OCID to list resources with the log as destination.
    :param str state: Lifecycle state of the log object
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['groupId'] = group_id
    __args__['isCompartmentIdInSubtree'] = is_compartment_id_in_subtree
    __args__['logId'] = log_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Logging/getUnifiedAgentConfigurations:getUnifiedAgentConfigurations', __args__, opts=opts, typ=GetUnifiedAgentConfigurationsResult).value

    return AwaitableGetUnifiedAgentConfigurationsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        is_compartment_id_in_subtree=pulumi.get(__ret__, 'is_compartment_id_in_subtree'),
        log_id=pulumi.get(__ret__, 'log_id'),
        state=pulumi.get(__ret__, 'state'),
        unified_agent_configuration_collections=pulumi.get(__ret__, 'unified_agent_configuration_collections'))


@_utilities.lift_output_func(get_unified_agent_configurations)
def get_unified_agent_configurations_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                            display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                            filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetUnifiedAgentConfigurationsFilterArgs']]]]] = None,
                                            group_id: Optional[pulumi.Input[Optional[str]]] = None,
                                            is_compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                            log_id: Optional[pulumi.Input[Optional[str]]] = None,
                                            state: Optional[pulumi.Input[Optional[str]]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUnifiedAgentConfigurationsResult]:
    """
    This data source provides the list of Unified Agent Configurations in Oracle Cloud Infrastructure Logging service.

    Lists all unified agent configurations in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_unified_agent_configurations = oci.Logging.get_unified_agent_configurations(compartment_id=var["compartment_id"],
        display_name=var["unified_agent_configuration_display_name"],
        group_id=oci_identity_group["test_group"]["id"],
        is_compartment_id_in_subtree=var["unified_agent_configuration_is_compartment_id_in_subtree"],
        log_id=oci_logging_log["test_log"]["id"],
        state=var["unified_agent_configuration_state"])
    ```


    :param str compartment_id: Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
    :param str display_name: Resource name.
    :param str group_id: The OCID of a group or a dynamic group.
    :param bool is_compartment_id_in_subtree: Specifies whether or not nested compartments should be traversed. Defaults to false.
    :param str log_id: Custom log OCID to list resources with the log as destination.
    :param str state: Lifecycle state of the log object
    """
    ...
