# vim: set filetype=python fileencoding=utf-8:
# -*- coding: utf-8 -*-

#============================================================================#
#                                                                            #
#  Licensed under the Apache License, Version 2.0 (the "License");           #
#  you may not use this file except in compliance with the License.          #
#  You may obtain a copy of the License at                                   #
#                                                                            #
#      http://www.apache.org/licenses/LICENSE-2.0                            #
#                                                                            #
#  Unless required by applicable law or agreed to in writing, software       #
#  distributed under the License is distributed on an "AS IS" BASIS,         #
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  #
#  See the License for the specific language governing permissions and       #
#  limitations under the License.                                            #
#                                                                            #
#============================================================================#


''' Flexible factory for Icecream debuggers. '''


from . import __
# --- BEGIN: Injected by Copier ---
from . import exceptions
# --- END: Injected by Copier ---


from .configuration import (
    Flavor as FlavorConfiguration,
    Module as ModuleConfiguration,
    Vehicle as VehicleConfiguration,
)
from .exceptions import *
from .recipes import *
from .vehicles import *


__version__ = '1.0a0'


# TODO: Also reclassify package modules as concealed.
__.reclassify_modules_as_immutable( __name__ )
