# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-04-08 18:19
from __future__ import unicode_literals

import os
import shutil
from django.conf import settings
from django.db import migrations
from stackdio.api.formulas.tasks import import_formula


def fix_formulas_forwards(apps, schema_editor):
    Formula = apps.get_model('formulas', 'Formula')

    formula_dir = os.path.join(settings.FILE_STORAGE_DIRECTORY, 'formulas')

    for formula in Formula.objects.all():
        # Delete the old dir
        repo_name = os.path.splitext(os.path.split(formula.uri)[-1])[0]
        dir_name = '{}-{}'.format(formula.id, repo_name)
        shutil.rmtree(os.path.join(formula_dir, dir_name), ignore_errors=True)

        # re-import
        import_formula.si(formula.id)()


def fix_formulas_reverse(apps, schema_editor):
    Formula = apps.get_model('formulas', 'Formula')

    formula_dir = os.path.join(settings.FILE_STORAGE_DIRECTORY, 'formulas')

    for formula in Formula.objects.all():
        repo_name = os.path.splitext(os.path.split(formula.uri)[-1])[0]
        dir_name = '{}-{}'.format(formula.id, repo_name)

        new_dir = os.path.join(formula_dir, dir_name)

        # Copy the HEAD over
        shutil.move(os.path.join(new_dir, 'checkouts', 'HEAD'), new_dir)

        # Blow away the old checkouts
        shutil.rmtree(os.path.join(new_dir, 'checkouts'))


class Migration(migrations.Migration):

    dependencies = [
        ('formulas', '0002_0_8_0_migrations'),
    ]

    operations = [
        migrations.RunPython(fix_formulas_forwards, fix_formulas_reverse),
    ]
