# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-04-08 18:19
"""
We need three stack migrations for 0.8.0 - there is an issue with fixing data and migrating
schema at the same time
"""

from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django_extensions.db.fields
import model_utils.fields
import stackdio.core.fields


def fix_stack_fields_forwards(apps, schema_editor):
    Stack = apps.get_model('stacks', 'Stack')
    Host = apps.get_model('stacks', 'Host')

    # Just set all the activities to be idle.
    for stack in Stack.objects.all():
        stack.activity = ''
        stack.save()

    for host in Host.objects.all():
        host.activity = ''
        host.save()


def fix_stack_fields_reverse(apps, schema_editor):
    Stack = apps.get_model('stacks', 'Stack')

    # Host states are already set in 0.8, no need to change them when going backwards.
    for stack in Stack.objects.all():
        stack.status = 'finished'
        stack.save()


class Migration(migrations.Migration):

    dependencies = [
        ('stacks', '0001_0_8_initial'),
        ('formulas', '0002_0_8_0_migrations'),
    ]

    operations = [
        # Host things
        migrations.AlterField(
            model_name='host',
            name='cloud_image',
            field=models.ForeignKey(related_name='hosts', null=True, to='cloud.CloudImage'),
        ),
        migrations.AlterField(
            model_name='host',
            name='instance_size',
            field=models.ForeignKey(related_name='hosts', null=True, to='cloud.CloudInstanceSize'),
        ),
        migrations.AlterField(
            model_name='host',
            name='created',
            field=django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created'),
        ),
        migrations.AlterField(
            model_name='host',
            name='modified',
            field=django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified'),
        ),
        # First rename the field
        migrations.RenameField(
            model_name='host',
            old_name='provider_dns',
            new_name='provider_public_dns',
        ),
        # Then alter the field to allow null values
        migrations.AlterField(
            model_name='host',
            name='provider_public_dns',
            field=models.CharField(max_length=64, null=True, verbose_name='Provider Public DNS'),
        ),
        migrations.AlterField(
            model_name='host',
            name='provider_private_dns',
            field=models.CharField(max_length=64, null=True, verbose_name='Provider Private DNS'),
        ),
        migrations.AddField(
            model_name='host',
            name='provider_public_ip',
            field=models.GenericIPAddressField(blank=True, null=True, verbose_name='Provider Public IP'),
        ),
        migrations.AlterField(
            model_name='host',
            name='provider_private_ip',
            field=models.GenericIPAddressField(blank=True, null=True, verbose_name='Provider Private IP'),
        ),
        migrations.RemoveField(
            model_name='host',
            name='state_reason',
        ),
        migrations.RemoveField(
            model_name='host',
            name='status_changed',
        ),
        migrations.RemoveField(
            model_name='host',
            name='status_detail',
        ),
        migrations.RenameField(
            model_name='host',
            old_name='status',
            new_name='activity',
        ),
        migrations.AlterField(
            model_name='host',
            name='activity',
            field=models.CharField(blank=True, choices=[('unknown', 'unknown'), ('queued', 'queued'), ('launching', 'launching'), ('provisioning', 'provisioning'), ('orchestrating', 'orchestrating'), ('', ''), ('pausing', 'pausing'), ('paused', 'paused'), ('resuming', 'resuming'), ('terminating', 'terminating'), ('terminated', 'terminated'), ('executing', 'executing'), ('dead', 'dead')], default='queued', max_length=32, verbose_name='Activity'),
        ),
        migrations.AddField(
            model_name='host',
            name='extra_options',
            field=stackdio.core.fields.JSONField(default={}, verbose_name='Extra Options'),
            preserve_default=False,
        ),

        # Stack things
        migrations.AlterField(
            model_name='stack',
            name='created',
            field=django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created'),
        ),
        migrations.AlterField(
            model_name='stack',
            name='modified',
            field=django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified'),
        ),
        migrations.RemoveField(
            model_name='stack',
            name='status_changed',
        ),
        migrations.RenameField(
            model_name='stack',
            old_name='status',
            new_name='activity',
        ),
        migrations.AlterField(
            model_name='stack',
            name='activity',
            field=models.CharField(blank=True, choices=[('unknown', 'unknown'), ('queued', 'queued'), ('launching', 'launching'), ('provisioning', 'provisioning'), ('orchestrating', 'orchestrating'), ('', ''), ('pausing', 'pausing'), ('paused', 'paused'), ('resuming', 'resuming'), ('terminating', 'terminating'), ('terminated', 'terminated'), ('executing', 'executing'), ('dead', 'dead')], default='queued', max_length=32, verbose_name='Activity'),
        ),
        migrations.AlterModelOptions(
            name='stack',
            options={'default_permissions': ('delete', 'execute', 'pause', 'launch', 'admin', 'create', 'resume', 'terminate', 'update', 'ssh', 'orchestrate', 'provision', 'view'), 'ordering': ('title',)},
        ),

        # Stack Command things
        migrations.AlterField(
            model_name='stackcommand',
            name='created',
            field=django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created'),
        ),
        migrations.AlterField(
            model_name='stackcommand',
            name='modified',
            field=django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified'),
        ),
        migrations.AlterField(
            model_name='stackcommand',
            name='status',
            field=model_utils.fields.StatusField(default='waiting', max_length=100, no_check_for_status=True, verbose_name='status'),
        ),

        # Stack History things
        migrations.AlterField(
            model_name='stackhistory',
            name='created',
            field=django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created'),
        ),
        migrations.AlterField(
            model_name='stackhistory',
            name='modified',
            field=django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified'),
        ),
        migrations.RemoveField(
            model_name='stackhistory',
            name='status',
        ),
        migrations.AlterField(
            model_name='stackhistory',
            name='event',
            field=models.CharField(max_length=128, default=''),
        ),
        migrations.RemoveField(
            model_name='stackhistory',
            name='event',
        ),
        migrations.AlterField(
            model_name='stackhistory',
            name='level',
            field=models.CharField(max_length=16, default='', choices=[('DEBUG', 'DEBUG'), ('INFO', 'INFO'), ('WARNING', 'WARNING'), ('ERROR', 'ERROR')]),
        ),
        migrations.RemoveField(
            model_name='stackhistory',
            name='level',
        ),
        migrations.RemoveField(
            model_name='stackhistory',
            name='status_changed',
        ),
        migrations.RenameField(
            model_name='stackhistory',
            old_name='status_detail',
            new_name='message',
        ),
        migrations.AlterField(
            model_name='stackhistory',
            name='message',
            field=models.CharField(max_length=256, verbose_name='Message'),
        ),

        # New things
        migrations.CreateModel(
            name='ComponentMetadata',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('status', models.CharField(choices=[('succeeded', 'succeeded'), ('unknown', 'unknown'), ('failed', 'failed'), ('running', 'running'), ('cancelled', 'cancelled'), ('queued', 'queued')], default='queued', max_length=32, verbose_name='Status')),
                ('health', models.CharField(choices=[('healthy', 'healthy'), ('unknown', 'unknown'), ('unstable', 'unstable'), ('unhealthy', 'unhealthy')], default='unknown', max_length=32, verbose_name='Health')),
                ('formula_component', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='metadatas', to='formulas.FormulaComponent')),
                ('host', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='component_metadatas', to='stacks.Host')),
            ],
            options={
                'ordering': ('-modified', '-created'),
                'abstract': False,
                'get_latest_by': 'modified',
            },
        ),

        # Fix fields (status -> activity, state, health)
        migrations.RunPython(fix_stack_fields_forwards, fix_stack_fields_reverse),
    ]
