# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-04-08 18:19
"""
We need three stack migrations for 0.8.0 - there is an issue with fixing data and migrating
schema at the same time
"""

from __future__ import unicode_literals

from django.db import migrations


def blank_to_null(model_name, field_name):

    def func(apps, schema_editor):
        model_cls = apps.get_model('stacks', model_name)

        for obj in model_cls.objects.filter(**{field_name: ''}):
            setattr(obj, field_name, None)
            obj.save()

    return func


def null_to_blank(model_name, field_name):

    def func(apps, schema_editor):
        model_cls = apps.get_model('stacks', model_name)

        for obj in model_cls.objects.filter(**{field_name: None}):
            setattr(obj, field_name, '')
            obj.save()

    return func


def fix_host_fields_forwards(apps, schema_editor):
    # Nothing to do yet
    pass


def fix_host_fields_reverse(apps, schema_editor):
    Host = apps.get_model('stacks', 'Host')
    BHD = apps.get_model('blueprints', 'BlueprintHostDefinition')

    # Fix the fields on the host
    for host in Host.objects.all():
        bhd = BHD.objects.get(hosts=host)

        host.availability_zone = bhd.zone
        host.cloud_image = bhd.cloud_image
        host.instance_size = bhd.size
        host.subnet_id = bhd.subnet_id
        host.save()


class Migration(migrations.Migration):

    dependencies = [
        ('blueprints', '0003_0_8_0_migrations'),
        ('stacks', '0002_0_8_0_migrations'),
    ]

    operations = [
        # Convert the dns fields from empty -> null
        migrations.RunPython(blank_to_null('Host', 'provider_public_dns'), null_to_blank('Host', 'provider_public_dns')),
        migrations.RunPython(blank_to_null('Host', 'provider_private_dns'), null_to_blank('Host', 'provider_private_dns')),

        # Fix all the host fields and delete them (this is so we can go in reverse)
        migrations.RunPython(fix_host_fields_forwards, fix_host_fields_reverse),
    ]
