/*!
  * Copyright 2016,  Digital Reasoning
  *
  * Licensed under the Apache License, Version 2.0 (the "License");
  * you may not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  *     http://www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an "AS IS" BASIS,
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
*/

define(["jquery","underscore","knockout","bootbox","moment","utils/utils","models/host","models/blueprint"],function(t,e,r,a,s,o,i,n){"use strict";function l(){this.calendar=function(){return""},this.toString=function(){return""}}function c(t,e){var a=!1;"string"==typeof t&&(t=parseInt(t)),"number"==typeof t&&(a=!0,t={id:t,url:"/api/stacks/"+t+"/"}),this.raw=t,this.parent=e,this.id=t.id,this.title=r.observable(),this.description=r.observable(),this.createUsers=r.observable(),this.activity=r.observable(),this.health=r.observable(),this.hostCount=r.observable(),this.labelClass=r.observable(),this.healthLabelClass=r.observable(),this.namespace=r.observable(),this.created=r.observable(new l),this.labelList=r.observable(),this.properties=r.observable({}),this.blueprint=r.observable(),this.availableActions=r.observableArray([]),this.history=r.observableArray([]),this.hosts=r.observableArray([]),this.volumes=r.observableArray([]),this.commands=r.observableArray([]),this.securityGroups=r.observableArray([]),this.formulaVersions=r.observableArray([]),this.latestLogs=r.observableArray([]),this.historicalLogs=r.observableArray([]),a?this.waiting=this.reload():this._process(t)}return c.constructor=c,c.prototype.actionMessages={launch:'This will create new infrastructure, undoing a "terminate" action you may have previously performed.  This will also re-launch any spot instances that have died.',orchestrate:"This will re-run all of your custom formula components.  This may overwrite anything you have manually changed on your hosts.","propagate-ssh":'This will create new users for everyone with "ssh" permission.',provision:"This will re-run core provisioning, in addition to re-running all of your custom formula components.  This may overwrite anything you have manually changed on your hosts.",pause:"",resume:"",terminate:'This will terminate all infrastructure related to this stack.  You can get it all back by later running the "launch" action on this stack.'},c.prototype._processActivity=function(t){switch(this.activity(t),t){case"idle":this.labelClass("label-success");break;case"launching":case"provisioning":case"orchestrating":case"resuming":case"pausing":case"executing":case"terminating":this.labelClass("label-warning");break;case"queued":this.labelClass("label-info");break;case"dead":this.labelClass("label-danger");break;default:this.labelClass("label-default")}},c.prototype._processHealth=function(t){switch(this.health(t),t){case"healthy":this.healthLabelClass("label-success");break;case"unstable":this.healthLabelClass("label-warning");break;case"unhealthy":this.healthLabelClass("label-danger");break;default:this.healthLabelClass("label-default")}},c.prototype._process=function(t){this.title(t.title),this.description(t.description),this.createUsers(t.create_users),this.hostCount(t.host_count),this.namespace(t.namespace),this.created(s(t.created)),this.labelList(t.label_list),this._processActivity(t.activity),this._processHealth(t.health)},c.prototype.reload=function(){var e=this;return t.ajax({method:"GET",url:e.raw.url}).done(function(t){e.raw=t,e._process(t)}).fail(function(t){403==t.status&&window.location.reload(!0)})},c.prototype.refreshActivity=function(){var e=this;return t.ajax({method:"GET",url:e.raw.url}).done(function(t){e.raw=t,e._processActivity(t.activity),e._processHealth(t.health)}).fail(function(t){403==t.status&&window.location.reload(!0)})},c.prototype.loadProperties=function(){var e=this;return this.raw.hasOwnProperty("properties")||(this.raw.properties=this.raw.url+"properties/"),t.ajax({method:"GET",url:this.raw.properties}).done(function(t){e.properties(t)})},c.prototype.saveProperties=function(){t.ajax({method:"PUT",url:this.raw.properties,data:JSON.stringify(this.properties())}).done(function(t){o.growlAlert("Successfully saved stack properties!","success")}).fail(function(t){var e;try{var r=JSON.parse(t.responseText);e=r.properties.join("<br>")}catch(t){e="Oops... there was a server error."}e+="  Your properties were not saved.",o.growlAlert(e,"danger")})},c.prototype.loadHosts=function(){var e=this;t.ajax({method:"GET",url:this.raw.hosts}).done(function(t){e.hosts(t.results.map(function(t){return new i(t,e.parent)}))})},c.prototype._addRemove=function(e,r,s){var o={action:e,host_definition:r.id,count:s},i=this;t.ajax({method:"POST",url:this.raw.hosts,data:JSON.stringify(o)}).done(function(){i.loadHosts()}).fail(function(t){var r;try{var s=JSON.parse(t.responseText);r="";for(var o in s)if(s.hasOwnProperty(o)){var i=o.replace("_"," ");s[o].forEach(function(t){r+="<dt>"+i+"</dt><dd>"+t+"</dd>"})}r&&(r='<dl class="dl-horizontal">'+r+"</dl>")}catch(t){r="Oops... there was a server error."}a.alert({title:"Error "+e+"ing hosts",message:r})})},c.prototype.addHosts=function(t,e){this._addRemove("add",t,e)},c.prototype.removeHosts=function(t,e){this._addRemove("remove",t,e)},c.prototype.loadBlueprint=function(){var e=this;return t.ajax({method:"GET",url:this.raw.blueprint}).done(function(t){e.blueprint(new n(t,e.parent))})},c.prototype.loadAvailableActions=function(){var e=this;this.raw.hasOwnProperty("action")||(this.raw.action=this.url+"action/"),t.ajax({method:"GET",url:this.raw.action}).done(function(t){e.availableActions(t.available_actions);try{e.parent.actionMap[e.id]=t.available_actions}catch(t){}})},c.prototype.performAction=function(r){var s=this,o=e.escape(s.title()),i=this.actionMessages.hasOwnProperty(r)?this.actionMessages[r]:"";a.confirm({title:"Confirm action for <strong>"+o+"</strong>",message:'Are you sure you want to perform the "'+r+'" action on <strong>'+o+"</strong>?<br>"+i,buttons:{confirm:{label:r.capitalize().replace("_"," "),className:"btn-primary"}},callback:function(e){e&&t.ajax({method:"POST",url:s.raw.action,data:JSON.stringify({action:r})}).done(function(){s.parent&&"function"==typeof s.parent.reload?s.parent.reload():s.reload()}).fail(function(t){var e;try{var s=JSON.parse(t.responseText);e=s.action.join("<br>")}catch(t){e="Oops... there was a server error.  This has been reported to your administrators."}a.alert({title:'Error performing the "'+r+'" action',message:e})})}})},c.prototype.loadHistory=function(){var e=this;return this.raw.hasOwnProperty("history")||(this.raw.history=this.raw.url+"history/"),t.ajax({method:"GET",url:this.raw.history}).done(function(t){t.results.forEach(function(t){t.timestamp=s(t.created)}),e.history(t.results)})},c.prototype.loadLogs=function(){var e=this;this.raw.hasOwnProperty("logs")||(this.raw.logs=this.raw.url+"logs/"),t.ajax({method:"GET",url:this.raw.logs}).done(function(t){var r=[];for(var a in t.latest)t.latest.hasOwnProperty(a)&&r.push({text:a,type:"item",url:t.latest[a]});e.latestLogs(r);var s=[];t.historical.forEach(function(t){var e=t.split("/");s.push({text:e[e.length-1],type:"item",url:t})}),e.historicalLogs(s)})},c.prototype.runCommand=function(e,r){var s=this;return t.ajax({method:"POST",url:this.raw.commands,data:JSON.stringify({host_target:e,command:r})}).done(function(){try{s.parent.reload()}catch(t){}}).fail(function(t){var e;try{var r=JSON.parse(t.responseText);e="";for(var s in r)if(r.hasOwnProperty(s)){var o=s.replace("_"," ");r[s].forEach(function(t){e+="<dt>"+o+"</dt><dd>"+t+"</dd>"})}e&&(e='<dl class="dl-horizontal">'+e+"</dl>")}catch(t){e="Oops... there was a server error."}a.alert({title:"Failed to run command",message:e})})},c.prototype.save=function(){var e=this,r=["title","description","create_users","namespace"];r.forEach(function(e){var r=t("#"+e);r.removeClass("has-error");var a=r.find(".help-block");a.remove()}),t.ajax({method:"PUT",url:e.raw.url,data:JSON.stringify({title:e.title(),description:e.description(),create_users:e.createUsers()})}).done(function(t){o.growlAlert("Successfully saved stack!","success");try{e.parent.stackTitle(t.title)}catch(t){}}).fail(function(t){o.parseSaveError(t,"stack",r)})},c.prototype.delete=function(){var r=this,s=e.escape(r.title());a.confirm({title:"Confirm delete of <strong>"+s+"</strong>",message:"Are you sure you want to delete <strong>"+s+"</strong>?<br>This will terminate all infrastructure, in addition to removing all history related to this stack.",buttons:{confirm:{label:"Delete",className:"btn-danger"}},callback:function(e){e&&t.ajax({method:"DELETE",url:r.raw.url}).done(function(t){r.raw=t,r._process(t),r.parent&&"function"==typeof r.parent.reload&&r.parent.reload()}).fail(function(t){var e;try{var r=JSON.parse(t.responseText);e=r.detail.join("<br>")}catch(t){e="Oops... there was a server error.  This has been reported to your administrators."}a.alert({title:"Error deleting stack",message:e})})}})},c});