# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetMetastoreResult',
    'AwaitableGetMetastoreResult',
    'get_metastore',
    'get_metastore_output',
]

@pulumi.output_type
class GetMetastoreResult:
    """
    A collection of values returned by getMetastore.
    """
    def __init__(__self__, compartment_id=None, default_external_table_location=None, default_managed_table_location=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, metastore_id=None, state=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if default_external_table_location and not isinstance(default_external_table_location, str):
            raise TypeError("Expected argument 'default_external_table_location' to be a str")
        pulumi.set(__self__, "default_external_table_location", default_external_table_location)
        if default_managed_table_location and not isinstance(default_managed_table_location, str):
            raise TypeError("Expected argument 'default_managed_table_location' to be a str")
        pulumi.set(__self__, "default_managed_table_location", default_managed_table_location)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if metastore_id and not isinstance(metastore_id, str):
            raise TypeError("Expected argument 'metastore_id' to be a str")
        pulumi.set(__self__, "metastore_id", metastore_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        OCID of the compartment which holds the metastore.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="defaultExternalTableLocation")
    def default_external_table_location(self) -> str:
        """
        Location under which external tables will be created by default. This references Object Storage using an HDFS URI format. Example: oci://bucket@namespace/sub-dir/
        """
        return pulumi.get(self, "default_external_table_location")

    @property
    @pulumi.getter(name="defaultManagedTableLocation")
    def default_managed_table_location(self) -> str:
        """
        Location under which managed tables will be created by default. This references Object Storage using an HDFS URI format. Example: oci://bucket@namespace/sub-dir/
        """
        return pulumi.get(self, "default_managed_table_location")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Mutable name of the metastore.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The metastore's OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> str:
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the metastore.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Time at which the metastore was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Time at which the metastore was last modified. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetMetastoreResult(GetMetastoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetastoreResult(
            compartment_id=self.compartment_id,
            default_external_table_location=self.default_external_table_location,
            default_managed_table_location=self.default_managed_table_location,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            metastore_id=self.metastore_id,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_metastore(metastore_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMetastoreResult:
    """
    This data source provides details about a specific Metastore resource in Oracle Cloud Infrastructure Data Catalog service.

    Gets a metastore by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_metastore = oci.DataCatalog.get_metastore(metastore_id=oci_datacatalog_metastore["test_metastore"]["id"])
    ```


    :param str metastore_id: The metastore's OCID.
    """
    __args__ = dict()
    __args__['metastoreId'] = metastore_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataCatalog/getMetastore:getMetastore', __args__, opts=opts, typ=GetMetastoreResult).value

    return AwaitableGetMetastoreResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        default_external_table_location=pulumi.get(__ret__, 'default_external_table_location'),
        default_managed_table_location=pulumi.get(__ret__, 'default_managed_table_location'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        metastore_id=pulumi.get(__ret__, 'metastore_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_metastore)
def get_metastore_output(metastore_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMetastoreResult]:
    """
    This data source provides details about a specific Metastore resource in Oracle Cloud Infrastructure Data Catalog service.

    Gets a metastore by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_metastore = oci.DataCatalog.get_metastore(metastore_id=oci_datacatalog_metastore["test_metastore"]["id"])
    ```


    :param str metastore_id: The metastore's OCID.
    """
    ...
