"use strict";
const lib_1 = require("../lib");
const util_1 = require("./util");
module.exports = {
    'Rule can be used to create rules'(test) {
        const stack = new lib_1.Stack();
        const rule = new lib_1.CfnRule(stack, 'MyRule');
        rule.addAssertion(lib_1.Fn.conditionEquals('lhs', 'rhs'), 'lhs equals rhs');
        rule.addAssertion(lib_1.Fn.conditionNot(lib_1.Fn.conditionAnd(lib_1.Fn.conditionContains(['hello', 'world'], 'world'))), 'some assertion');
        test.deepEqual(util_1.toCloudFormation(stack), {
            Rules: {
                MyRule: {
                    Assertions: [
                        {
                            Assert: { 'Fn::Equals': ['lhs', 'rhs'] },
                            AssertDescription: 'lhs equals rhs',
                        },
                        {
                            Assert: { 'Fn::Not': [{ 'Fn::And': [{ 'Fn::Contains': [['hello', 'world'], 'world'] }] }] },
                            AssertDescription: 'some assertion',
                        },
                    ],
                },
            },
        });
        test.done();
    },
    'a template can contain multiple Rules'(test) {
        const stack = new lib_1.Stack();
        new lib_1.CfnRule(stack, 'Rule1');
        new lib_1.CfnRule(stack, 'Rule2');
        test.deepEqual(util_1.toCloudFormation(stack), {
            Rules: {
                Rule1: {},
                Rule2: {},
            },
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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