"use strict";
const lib_1 = require("../lib");
module.exports = {
    'plainText'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.plainText('this just resolves to a string');
        // THEN
        test.deepEqual(stack.resolve(v), 'this just resolves to a string');
        test.done();
    },
    'secretsManager'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.secretsManager('secret-id', {
            jsonField: 'json-key',
            versionId: 'version-id',
            versionStage: 'version-stage',
        });
        // THEN
        test.deepEqual(stack.resolve(v), '{{resolve:secretsmanager:secret-id:SecretString:json-key:version-stage:version-id}}');
        test.done();
    },
    'secretsManager with defaults'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.secretsManager('secret-id');
        // THEN
        test.deepEqual(stack.resolve(v), '{{resolve:secretsmanager:secret-id:SecretString:::}}');
        test.done();
    },
    'secretsManager with an empty ID'(test) {
        test.throws(() => lib_1.SecretValue.secretsManager(''), /secretId cannot be empty/);
        test.done();
    },
    'secretsManager with a non-ARN ID that has colon'(test) {
        test.throws(() => lib_1.SecretValue.secretsManager('not:an:arn'), /is not an ARN but contains ":"/);
        test.done();
    },
    'ssmSecure'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.ssmSecure('param-name', 'param-version');
        // THEN
        test.deepEqual(stack.resolve(v), '{{resolve:ssm-secure:param-name:param-version}}');
        test.done();
    },
    'cfnDynamicReference'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.cfnDynamicReference(new lib_1.CfnDynamicReference(lib_1.CfnDynamicReferenceService.SSM, 'foo:bar'));
        // THEN
        test.deepEqual(stack.resolve(v), '{{resolve:ssm:foo:bar}}');
        test.done();
    },
    'cfnParameter (with NoEcho)'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        const p = new lib_1.CfnParameter(stack, 'MyParam', { type: 'String', noEcho: true });
        // WHEN
        const v = lib_1.SecretValue.cfnParameter(p);
        // THEN
        test.deepEqual(stack.resolve(v), { Ref: 'MyParam' });
        test.done();
    },
    'fails if cfnParameter does not have NoEcho'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        const p = new lib_1.CfnParameter(stack, 'MyParam', { type: 'String' });
        // THEN
        test.throws(() => lib_1.SecretValue.cfnParameter(p), /CloudFormation parameter must be configured with "NoEcho"/);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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