# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceACLEntriesArgs', 'ServiceACLEntries']

@pulumi.input_type
class ServiceACLEntriesArgs:
    def __init__(__self__, *,
                 acl_id: pulumi.Input[builtins.str],
                 service_id: pulumi.Input[builtins.str],
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceACLEntriesEntryArgs']]]] = None,
                 manage_entries: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ServiceACLEntries resource.
        :param pulumi.Input[builtins.str] acl_id: The ID of the ACL that the items belong to
        :param pulumi.Input[builtins.str] service_id: The ID of the Service that the ACL belongs to
        :param pulumi.Input[Sequence[pulumi.Input['ServiceACLEntriesEntryArgs']]] entries: ACL Entries
        :param pulumi.Input[builtins.bool] manage_entries: Whether to reapply changes if the state of the entries drifts, i.e. if entries are managed externally
        """
        pulumi.set(__self__, "acl_id", acl_id)
        pulumi.set(__self__, "service_id", service_id)
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if manage_entries is not None:
            pulumi.set(__self__, "manage_entries", manage_entries)

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the ACL that the items belong to
        """
        return pulumi.get(self, "acl_id")

    @acl_id.setter
    def acl_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "acl_id", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Service that the ACL belongs to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceACLEntriesEntryArgs']]]]:
        """
        ACL Entries
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceACLEntriesEntryArgs']]]]):
        pulumi.set(self, "entries", value)

    @property
    @pulumi.getter(name="manageEntries")
    def manage_entries(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to reapply changes if the state of the entries drifts, i.e. if entries are managed externally
        """
        return pulumi.get(self, "manage_entries")

    @manage_entries.setter
    def manage_entries(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "manage_entries", value)


@pulumi.input_type
class _ServiceACLEntriesState:
    def __init__(__self__, *,
                 acl_id: Optional[pulumi.Input[builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceACLEntriesEntryArgs']]]] = None,
                 manage_entries: Optional[pulumi.Input[builtins.bool]] = None,
                 service_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceACLEntries resources.
        :param pulumi.Input[builtins.str] acl_id: The ID of the ACL that the items belong to
        :param pulumi.Input[Sequence[pulumi.Input['ServiceACLEntriesEntryArgs']]] entries: ACL Entries
        :param pulumi.Input[builtins.bool] manage_entries: Whether to reapply changes if the state of the entries drifts, i.e. if entries are managed externally
        :param pulumi.Input[builtins.str] service_id: The ID of the Service that the ACL belongs to
        """
        if acl_id is not None:
            pulumi.set(__self__, "acl_id", acl_id)
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if manage_entries is not None:
            pulumi.set(__self__, "manage_entries", manage_entries)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the ACL that the items belong to
        """
        return pulumi.get(self, "acl_id")

    @acl_id.setter
    def acl_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl_id", value)

    @property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceACLEntriesEntryArgs']]]]:
        """
        ACL Entries
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceACLEntriesEntryArgs']]]]):
        pulumi.set(self, "entries", value)

    @property
    @pulumi.getter(name="manageEntries")
    def manage_entries(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to reapply changes if the state of the entries drifts, i.e. if entries are managed externally
        """
        return pulumi.get(self, "manage_entries")

    @manage_entries.setter
    def manage_entries(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "manage_entries", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Service that the ACL belongs to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_id", value)


class ServiceACLEntries(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_id: Optional[pulumi.Input[builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceACLEntriesEntryArgs', 'ServiceACLEntriesEntryArgsDict']]]]] = None,
                 manage_entries: Optional[pulumi.Input[builtins.bool]] = None,
                 service_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        This is an example of the import command being applied to the resource named `fastly_service_acl_entries.entries`

        The resource ID is a combined value of the `service_id` and `acl_id` separated by a forward slash.

        ```sh
        $ pulumi import fastly:index/serviceACLEntries:ServiceACLEntries entries xxxxxxxxxxxxxxxxxxxx/xxxxxxxxxxxxxxxxxxxx
        ```

        If Terraform is already managing remote acl entries against a resource being imported then the user will be asked to remove it from the existing Terraform state.

        The following is an example of the Terraform state command to remove the resource named `fastly_service_acl_entries.entries` from the Terraform state file.

        $ terraform state rm fastly_service_acl_entries.entries

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] acl_id: The ID of the ACL that the items belong to
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceACLEntriesEntryArgs', 'ServiceACLEntriesEntryArgsDict']]]] entries: ACL Entries
        :param pulumi.Input[builtins.bool] manage_entries: Whether to reapply changes if the state of the entries drifts, i.e. if entries are managed externally
        :param pulumi.Input[builtins.str] service_id: The ID of the Service that the ACL belongs to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceACLEntriesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        This is an example of the import command being applied to the resource named `fastly_service_acl_entries.entries`

        The resource ID is a combined value of the `service_id` and `acl_id` separated by a forward slash.

        ```sh
        $ pulumi import fastly:index/serviceACLEntries:ServiceACLEntries entries xxxxxxxxxxxxxxxxxxxx/xxxxxxxxxxxxxxxxxxxx
        ```

        If Terraform is already managing remote acl entries against a resource being imported then the user will be asked to remove it from the existing Terraform state.

        The following is an example of the Terraform state command to remove the resource named `fastly_service_acl_entries.entries` from the Terraform state file.

        $ terraform state rm fastly_service_acl_entries.entries

        :param str resource_name: The name of the resource.
        :param ServiceACLEntriesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceACLEntriesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_id: Optional[pulumi.Input[builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceACLEntriesEntryArgs', 'ServiceACLEntriesEntryArgsDict']]]]] = None,
                 manage_entries: Optional[pulumi.Input[builtins.bool]] = None,
                 service_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceACLEntriesArgs.__new__(ServiceACLEntriesArgs)

            if acl_id is None and not opts.urn:
                raise TypeError("Missing required property 'acl_id'")
            __props__.__dict__["acl_id"] = acl_id
            __props__.__dict__["entries"] = entries
            __props__.__dict__["manage_entries"] = manage_entries
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
        super(ServiceACLEntries, __self__).__init__(
            'fastly:index/serviceACLEntries:ServiceACLEntries',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_id: Optional[pulumi.Input[builtins.str]] = None,
            entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceACLEntriesEntryArgs', 'ServiceACLEntriesEntryArgsDict']]]]] = None,
            manage_entries: Optional[pulumi.Input[builtins.bool]] = None,
            service_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ServiceACLEntries':
        """
        Get an existing ServiceACLEntries resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] acl_id: The ID of the ACL that the items belong to
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceACLEntriesEntryArgs', 'ServiceACLEntriesEntryArgsDict']]]] entries: ACL Entries
        :param pulumi.Input[builtins.bool] manage_entries: Whether to reapply changes if the state of the entries drifts, i.e. if entries are managed externally
        :param pulumi.Input[builtins.str] service_id: The ID of the Service that the ACL belongs to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceACLEntriesState.__new__(_ServiceACLEntriesState)

        __props__.__dict__["acl_id"] = acl_id
        __props__.__dict__["entries"] = entries
        __props__.__dict__["manage_entries"] = manage_entries
        __props__.__dict__["service_id"] = service_id
        return ServiceACLEntries(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the ACL that the items belong to
        """
        return pulumi.get(self, "acl_id")

    @property
    @pulumi.getter
    def entries(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceACLEntriesEntry']]]:
        """
        ACL Entries
        """
        return pulumi.get(self, "entries")

    @property
    @pulumi.getter(name="manageEntries")
    def manage_entries(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to reapply changes if the state of the entries drifts, i.e. if entries are managed externally
        """
        return pulumi.get(self, "manage_entries")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Service that the ACL belongs to
        """
        return pulumi.get(self, "service_id")

