from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkFiltersCore
import vtkmodules.vtkFiltersGeneral
import vtkmodules.vtkImagingCore

class vtkmAverageToCells(vtkmodules.vtkFiltersCore.vtkPointDataToCellData):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmAverageToCells': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmAverageToCells': ...

class vtkmAverageToPoints(vtkmodules.vtkFiltersCore.vtkCellDataToPointData):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmAverageToPoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmAverageToPoints': ...

class vtkmCleanGrid(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    compact_points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CompactPointsOff(self) -> None: ...
    def CompactPointsOn(self) -> None: ...
    def GetCompactPoints(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmCleanGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmCleanGrid': ...
    def SetCompactPoints(self, _arg:bool) -> None: ...

class vtkmClip(vtkmodules.vtkFiltersGeneral.vtkTableBasedClipDataSet):
    compute_scalars:'getset_descriptor'
    force_vt_km:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    def ForceVTKmOff(self) -> None: ...
    def ForceVTKmOn(self) -> None: ...
    def GetComputeScalars(self) -> bool: ...
    def GetForceVTKm(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmClip': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmClip': ...
    def SetComputeScalars(self, _arg:bool) -> None: ...
    def SetForceVTKm(self, _arg:int) -> None: ...

class vtkmContour(vtkmodules.vtkFiltersCore.vtkContourFilter):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmContour': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmContour': ...

class vtkmCoordinateSystemTransform(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def FillInputPortInformation(self, port:int, info:'vtkInformation') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmCoordinateSystemTransform': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmCoordinateSystemTransform': ...
    def SetCartesianToCylindrical(self) -> None: ...
    def SetCartesianToSpherical(self) -> None: ...
    def SetCylindricalToCartesian(self) -> None: ...
    def SetSphericalToCartesian(self) -> None: ...

class vtkmExternalFaces(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    compact_points:'getset_descriptor'
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CompactPointsOff(self) -> None: ...
    def CompactPointsOn(self) -> None: ...
    def GetCompactPoints(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutput(self) -> 'vtkUnstructuredGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmExternalFaces': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmExternalFaces': ...
    def SetCompactPoints(self, _arg:bool) -> None: ...
    def SetInputData(self, ds:'vtkUnstructuredGrid') -> None: ...

class vtkmExtractVOI(vtkmodules.vtkImagingCore.vtkExtractVOI):
    force_vt_km:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ForceVTKmOff(self) -> None: ...
    def ForceVTKmOn(self) -> None: ...
    def GetForceVTKm(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmExtractVOI': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmExtractVOI': ...
    def SetForceVTKm(self, _arg:int) -> None: ...

class vtkmFilterOverrides(object):
    enabled:'getset_descriptor'
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkmFilterOverrides') -> None: ...
    @staticmethod
    def EnabledOff() -> None: ...
    @staticmethod
    def EnabledOn() -> None: ...
    @staticmethod
    def GetEnabled() -> bool: ...
    @staticmethod
    def SetEnabled(value:bool) -> None: ...

class vtkmGradient(vtkmodules.vtkFiltersGeneral.vtkGradientFilter):
    force_vt_km:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ForceVTKmOff(self) -> None: ...
    def ForceVTKmOn(self) -> None: ...
    def GetForceVTKm(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmGradient': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmGradient': ...
    def SetForceVTKm(self, _arg:int) -> None: ...

class vtkmHistogram(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    bin_delta:'getset_descriptor'
    center_bins_around_min_and_max:'getset_descriptor'
    computed_range:'getset_descriptor'
    custom_bin_range:'getset_descriptor'
    number_of_bins:'getset_descriptor'
    use_custom_bin_ranges:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CenterBinsAroundMinAndMaxOff(self) -> None: ...
    def CenterBinsAroundMinAndMaxOn(self) -> None: ...
    def GetBinDelta(self) -> float: ...
    def GetCenterBinsAroundMinAndMax(self) -> bool: ...
    def GetComputedRange(self) -> Tuple[float, float]: ...
    def GetCustomBinRange(self) -> Tuple[float, float]: ...
    def GetNumberOfBins(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseCustomBinRanges(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmHistogram': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmHistogram': ...
    def SetCenterBinsAroundMinAndMax(self, _arg:bool) -> None: ...
    @overload
    def SetCustomBinRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetCustomBinRange(self, _arg:Sequence[float]) -> None: ...
    def SetNumberOfBins(self, _arg:int) -> None: ...
    def SetUseCustomBinRanges(self, _arg:bool) -> None: ...
    def UseCustomBinRangesOff(self) -> None: ...
    def UseCustomBinRangesOn(self) -> None: ...

class vtkmImageConnectivity(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmImageConnectivity': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmImageConnectivity': ...

class vtkmLevelOfDetail(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    number_of_divisions:'getset_descriptor'
    number_of_x_divisions:'getset_descriptor'
    number_of_y_divisions:'getset_descriptor'
    number_of_z_divisions:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def GetNumberOfDivisions(self) -> Pointer: ...
    @overload
    def GetNumberOfDivisions(self, div:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfXDivisions(self) -> int: ...
    def GetNumberOfYDivisions(self) -> int: ...
    def GetNumberOfZDivisions(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmLevelOfDetail': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmLevelOfDetail': ...
    @overload
    def SetNumberOfDivisions(self, div:MutableSequence[int]) -> None: ...
    @overload
    def SetNumberOfDivisions(self, div0:int, div1:int, div2:int) -> None: ...
    def SetNumberOfXDivisions(self, num:int) -> None: ...
    def SetNumberOfYDivisions(self, num:int) -> None: ...
    def SetNumberOfZDivisions(self, num:int) -> None: ...

class vtkmNDHistogram(vtkmodules.vtkCommonExecutionModel.vtkArrayDataAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def AddFieldAndBin(self, fieldName:str, numberOfBins:int) -> None: ...
    def GetBinDelta(self, fieldIndex:int) -> float: ...
    def GetFieldIndexFromFieldName(self, fieldName:str) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmNDHistogram': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmNDHistogram': ...

class vtkmPointElevation(vtkmodules.vtkFiltersCore.vtkElevationFilter):
    force_vt_km:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ForceVTKmOff(self) -> None: ...
    def ForceVTKmOn(self) -> None: ...
    def GetForceVTKm(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmPointElevation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmPointElevation': ...
    def SetForceVTKm(self, _arg:int) -> None: ...

class vtkmPointTransform(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    transform:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def FillInputPortInformation(self, port:int, info:'vtkInformation') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTransform(self) -> 'vtkHomogeneousTransform': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmPointTransform': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmPointTransform': ...
    def SetTransform(self, tf:'vtkHomogeneousTransform') -> None: ...

class vtkmPolyDataNormals(vtkmodules.vtkFiltersCore.vtkPolyDataNormals):
    force_vt_km:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ForceVTKmOff(self) -> None: ...
    def ForceVTKmOn(self) -> None: ...
    def GetForceVTKm(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmPolyDataNormals': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmPolyDataNormals': ...
    def SetForceVTKm(self, _arg:int) -> None: ...

class vtkmProbe(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    pass_cell_arrays:'getset_descriptor'
    pass_field_arrays:'getset_descriptor'
    pass_point_arrays:'getset_descriptor'
    source:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    valid_cell_mask_array_name:'getset_descriptor'
    valid_point_mask_array_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassCellArrays(self) -> int: ...
    def GetPassFieldArrays(self) -> int: ...
    def GetPassPointArrays(self) -> int: ...
    def GetSource(self) -> 'vtkDataObject': ...
    def GetValidCellMaskArrayName(self) -> str: ...
    def GetValidPointMaskArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmProbe': ...
    def PassCellArraysOff(self) -> None: ...
    def PassCellArraysOn(self) -> None: ...
    def PassFieldArraysOff(self) -> None: ...
    def PassFieldArraysOn(self) -> None: ...
    def PassPointArraysOff(self) -> None: ...
    def PassPointArraysOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmProbe': ...
    def SetPassCellArrays(self, _arg:int) -> None: ...
    def SetPassFieldArrays(self, _arg:int) -> None: ...
    def SetPassPointArrays(self, _arg:int) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkDataObject') -> None: ...
    def SetValidCellMaskArrayName(self, _arg:str) -> None: ...
    def SetValidPointMaskArrayName(self, _arg:str) -> None: ...

class vtkmSlice(vtkmodules.vtkFiltersCore.vtkCutter):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmSlice': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmSlice': ...

class vtkmThreshold(vtkmodules.vtkFiltersCore.vtkThreshold):
    force_vt_km:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ForceVTKmOff(self) -> None: ...
    def ForceVTKmOn(self) -> None: ...
    def GetForceVTKm(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmThreshold': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmThreshold': ...
    def SetForceVTKm(self, _arg:int) -> None: ...

class vtkmTriangleMeshPointNormals(vtkmodules.vtkFiltersCore.vtkTriangleMeshPointNormals):
    force_vt_km:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ForceVTKmOff(self) -> None: ...
    def ForceVTKmOn(self) -> None: ...
    def GetForceVTKm(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmTriangleMeshPointNormals': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmTriangleMeshPointNormals': ...
    def SetForceVTKm(self, _arg:int) -> None: ...

class vtkmWarpScalar(vtkmodules.vtkFiltersGeneral.vtkWarpScalar):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmWarpScalar': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmWarpScalar': ...

class vtkmWarpVector(vtkmodules.vtkFiltersGeneral.vtkWarpVector):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkmWarpVector': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkmWarpVector': ...

