# -*- coding: utf-8 -*-
# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from .catalog import CatalogItem, Image, ProductCatalogItem
from .catalog_service import (
    CreateCatalogItemRequest,
    DeleteCatalogItemRequest,
    GetCatalogItemRequest,
    ListCatalogItemsRequest,
    ListCatalogItemsResponse,
    UpdateCatalogItemRequest,
)
from .common import FeatureMap
from .import_ import (
    CatalogInlineSource,
    GcsSource,
    ImportCatalogItemsRequest,
    ImportCatalogItemsResponse,
    ImportErrorsConfig,
    ImportMetadata,
    ImportUserEventsRequest,
    ImportUserEventsResponse,
    InputConfig,
    UserEventImportSummary,
    UserEventInlineSource,
)
from .prediction_apikey_registry_service import (
    CreatePredictionApiKeyRegistrationRequest,
    DeletePredictionApiKeyRegistrationRequest,
    ListPredictionApiKeyRegistrationsRequest,
    ListPredictionApiKeyRegistrationsResponse,
    PredictionApiKeyRegistration,
)
from .prediction_service import PredictRequest, PredictResponse
from .user_event import (
    EventDetail,
    ProductDetail,
    ProductEventDetail,
    PurchaseTransaction,
    UserEvent,
    UserInfo,
)
from .user_event_service import (
    CollectUserEventRequest,
    ListUserEventsRequest,
    ListUserEventsResponse,
    PurgeUserEventsMetadata,
    PurgeUserEventsRequest,
    PurgeUserEventsResponse,
    WriteUserEventRequest,
)

__all__ = (
    "CatalogItem",
    "Image",
    "ProductCatalogItem",
    "CreateCatalogItemRequest",
    "DeleteCatalogItemRequest",
    "GetCatalogItemRequest",
    "ListCatalogItemsRequest",
    "ListCatalogItemsResponse",
    "UpdateCatalogItemRequest",
    "FeatureMap",
    "CatalogInlineSource",
    "GcsSource",
    "ImportCatalogItemsRequest",
    "ImportCatalogItemsResponse",
    "ImportErrorsConfig",
    "ImportMetadata",
    "ImportUserEventsRequest",
    "ImportUserEventsResponse",
    "InputConfig",
    "UserEventImportSummary",
    "UserEventInlineSource",
    "CreatePredictionApiKeyRegistrationRequest",
    "DeletePredictionApiKeyRegistrationRequest",
    "ListPredictionApiKeyRegistrationsRequest",
    "ListPredictionApiKeyRegistrationsResponse",
    "PredictionApiKeyRegistration",
    "PredictRequest",
    "PredictResponse",
    "EventDetail",
    "ProductDetail",
    "ProductEventDetail",
    "PurchaseTransaction",
    "UserEvent",
    "UserInfo",
    "CollectUserEventRequest",
    "ListUserEventsRequest",
    "ListUserEventsResponse",
    "PurgeUserEventsMetadata",
    "PurgeUserEventsRequest",
    "PurgeUserEventsResponse",
    "WriteUserEventRequest",
)
