# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ExportExportOptionArgs',
    'FileSystemSourceDetailArgs',
    'FilesystemSnapshotPolicyScheduleArgs',
    'MountTargetKerberosArgs',
    'MountTargetLdapIdmapArgs',
    'OutboundConnectorEndpointArgs',
    'GetExportSetsFilterArgs',
    'GetExportsFilterArgs',
    'GetFileSystemsFilterArgs',
    'GetFilesystemSnapshotPoliciesFilterArgs',
    'GetMountTargetsFilterArgs',
    'GetOutboundConnectorsFilterArgs',
    'GetReplicationTargetsFilterArgs',
    'GetReplicationsFilterArgs',
    'GetSnapshotsFilterArgs',
]

@pulumi.input_type
class ExportExportOptionArgs:
    def __init__(__self__, *,
                 source: pulumi.Input[str],
                 access: Optional[pulumi.Input[str]] = None,
                 allowed_auths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 anonymous_gid: Optional[pulumi.Input[str]] = None,
                 anonymous_uid: Optional[pulumi.Input[str]] = None,
                 identity_squash: Optional[pulumi.Input[str]] = None,
                 is_anonymous_access_allowed: Optional[pulumi.Input[bool]] = None,
                 require_privileged_source_port: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] source: (Updatable) Clients these options should apply to. Must be a either single IPv4 address or single IPv4 CIDR block.
               
               **Note:** Access will also be limited by any applicable VCN security rules and the ability to route IP packets to the mount target. Mount targets do not have Internet-routable IP addresses.
        :param pulumi.Input[str] access: (Updatable) Type of access to grant clients using the file system through this export. If unspecified defaults to `READ_WRITE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_auths: (Updatable) Array of allowed NFS authentication types.
        :param pulumi.Input[str] anonymous_gid: (Updatable) GID value to remap to when squashing a client GID (see identitySquash for more details.) If unspecified defaults to `65534`.
        :param pulumi.Input[str] anonymous_uid: (Updatable) UID value to remap to when squashing a client UID (see identitySquash for more details.) If unspecified, defaults to `65534`.
        :param pulumi.Input[str] identity_squash: (Updatable) Used when clients accessing the file system through this export have their UID and GID remapped to 'anonymousUid' and 'anonymousGid'. If `ALL`, all users and groups are remapped; if `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `ROOT`.
        :param pulumi.Input[bool] is_anonymous_access_allowed: (Updatable) Whether or not to enable anonymous access to the file system through this export in cases where a user isn't found in the LDAP server used for ID mapping. If true, and the user is not found in the LDAP directory, the operation uses the Squash UID and Squash GID.
        :param pulumi.Input[bool] require_privileged_source_port: (Updatable) If `true`, clients accessing the file system through this export must connect from a privileged source port. If unspecified, defaults to `true`.
        """
        pulumi.set(__self__, "source", source)
        if access is not None:
            pulumi.set(__self__, "access", access)
        if allowed_auths is not None:
            pulumi.set(__self__, "allowed_auths", allowed_auths)
        if anonymous_gid is not None:
            pulumi.set(__self__, "anonymous_gid", anonymous_gid)
        if anonymous_uid is not None:
            pulumi.set(__self__, "anonymous_uid", anonymous_uid)
        if identity_squash is not None:
            pulumi.set(__self__, "identity_squash", identity_squash)
        if is_anonymous_access_allowed is not None:
            pulumi.set(__self__, "is_anonymous_access_allowed", is_anonymous_access_allowed)
        if require_privileged_source_port is not None:
            pulumi.set(__self__, "require_privileged_source_port", require_privileged_source_port)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        (Updatable) Clients these options should apply to. Must be a either single IPv4 address or single IPv4 CIDR block.

        **Note:** Access will also be limited by any applicable VCN security rules and the ability to route IP packets to the mount target. Mount targets do not have Internet-routable IP addresses.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of access to grant clients using the file system through this export. If unspecified defaults to `READ_WRITE`.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter(name="allowedAuths")
    def allowed_auths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Array of allowed NFS authentication types.
        """
        return pulumi.get(self, "allowed_auths")

    @allowed_auths.setter
    def allowed_auths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_auths", value)

    @property
    @pulumi.getter(name="anonymousGid")
    def anonymous_gid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) GID value to remap to when squashing a client GID (see identitySquash for more details.) If unspecified defaults to `65534`.
        """
        return pulumi.get(self, "anonymous_gid")

    @anonymous_gid.setter
    def anonymous_gid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "anonymous_gid", value)

    @property
    @pulumi.getter(name="anonymousUid")
    def anonymous_uid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) UID value to remap to when squashing a client UID (see identitySquash for more details.) If unspecified, defaults to `65534`.
        """
        return pulumi.get(self, "anonymous_uid")

    @anonymous_uid.setter
    def anonymous_uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "anonymous_uid", value)

    @property
    @pulumi.getter(name="identitySquash")
    def identity_squash(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Used when clients accessing the file system through this export have their UID and GID remapped to 'anonymousUid' and 'anonymousGid'. If `ALL`, all users and groups are remapped; if `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `ROOT`.
        """
        return pulumi.get(self, "identity_squash")

    @identity_squash.setter
    def identity_squash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_squash", value)

    @property
    @pulumi.getter(name="isAnonymousAccessAllowed")
    def is_anonymous_access_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether or not to enable anonymous access to the file system through this export in cases where a user isn't found in the LDAP server used for ID mapping. If true, and the user is not found in the LDAP directory, the operation uses the Squash UID and Squash GID.
        """
        return pulumi.get(self, "is_anonymous_access_allowed")

    @is_anonymous_access_allowed.setter
    def is_anonymous_access_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_anonymous_access_allowed", value)

    @property
    @pulumi.getter(name="requirePrivilegedSourcePort")
    def require_privileged_source_port(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If `true`, clients accessing the file system through this export must connect from a privileged source port. If unspecified, defaults to `true`.
        """
        return pulumi.get(self, "require_privileged_source_port")

    @require_privileged_source_port.setter
    def require_privileged_source_port(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_privileged_source_port", value)


@pulumi.input_type
class FileSystemSourceDetailArgs:
    def __init__(__self__, *,
                 parent_file_system_id: Optional[pulumi.Input[str]] = None,
                 source_snapshot_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] parent_file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system that contains the source snapshot of a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        :param pulumi.Input[str] source_snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if parent_file_system_id is not None:
            pulumi.set(__self__, "parent_file_system_id", parent_file_system_id)
        if source_snapshot_id is not None:
            pulumi.set(__self__, "source_snapshot_id", source_snapshot_id)

    @property
    @pulumi.getter(name="parentFileSystemId")
    def parent_file_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system that contains the source snapshot of a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "parent_file_system_id")

    @parent_file_system_id.setter
    def parent_file_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_file_system_id", value)

    @property
    @pulumi.getter(name="sourceSnapshotId")
    def source_snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_snapshot_id")

    @source_snapshot_id.setter
    def source_snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_snapshot_id", value)


@pulumi.input_type
class FilesystemSnapshotPolicyScheduleArgs:
    def __init__(__self__, *,
                 period: pulumi.Input[str],
                 time_zone: pulumi.Input[str],
                 day_of_month: Optional[pulumi.Input[int]] = None,
                 day_of_week: Optional[pulumi.Input[str]] = None,
                 hour_of_day: Optional[pulumi.Input[int]] = None,
                 month: Optional[pulumi.Input[str]] = None,
                 retention_duration_in_seconds: Optional[pulumi.Input[str]] = None,
                 schedule_prefix: Optional[pulumi.Input[str]] = None,
                 time_schedule_start: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] period: (Updatable) The frequency of scheduled snapshots.
        :param pulumi.Input[str] time_zone: (Updatable) Time zone used for scheduling the snapshot.
        :param pulumi.Input[int] day_of_month: (Updatable) The day of the month to create a scheduled snapshot. If the day does not exist for the month, snapshot creation will be skipped. Used for MONTHLY and YEARLY snapshot schedules.
        :param pulumi.Input[str] day_of_week: (Updatable) The day of the week to create a scheduled snapshot. Used for WEEKLY snapshot schedules.
        :param pulumi.Input[int] hour_of_day: (Updatable) The hour of the day to create a DAILY, WEEKLY, MONTHLY, or YEARLY snapshot. If not set, a value will be chosen at creation time.
        :param pulumi.Input[str] month: (Updatable) The month to create a scheduled snapshot. Used only for YEARLY snapshot schedules.
        :param pulumi.Input[str] retention_duration_in_seconds: (Updatable) The number of seconds to retain snapshots created with this schedule. Snapshot expiration time will not be set if this value is empty.
        :param pulumi.Input[str] schedule_prefix: (Updatable) A name prefix to be applied to snapshots created by this schedule.  Example: `compliance1`
        :param pulumi.Input[str] time_schedule_start: (Updatable) The starting point used to begin the scheduling of the snapshots based upon recurrence string in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. If no `timeScheduleStart` is provided, the value will be set to the time when the schedule was created.
        """
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "time_zone", time_zone)
        if day_of_month is not None:
            pulumi.set(__self__, "day_of_month", day_of_month)
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if hour_of_day is not None:
            pulumi.set(__self__, "hour_of_day", hour_of_day)
        if month is not None:
            pulumi.set(__self__, "month", month)
        if retention_duration_in_seconds is not None:
            pulumi.set(__self__, "retention_duration_in_seconds", retention_duration_in_seconds)
        if schedule_prefix is not None:
            pulumi.set(__self__, "schedule_prefix", schedule_prefix)
        if time_schedule_start is not None:
            pulumi.set(__self__, "time_schedule_start", time_schedule_start)

    @property
    @pulumi.getter
    def period(self) -> pulumi.Input[str]:
        """
        (Updatable) The frequency of scheduled snapshots.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[str]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Input[str]:
        """
        (Updatable) Time zone used for scheduling the snapshot.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="dayOfMonth")
    def day_of_month(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The day of the month to create a scheduled snapshot. If the day does not exist for the month, snapshot creation will be skipped. Used for MONTHLY and YEARLY snapshot schedules.
        """
        return pulumi.get(self, "day_of_month")

    @day_of_month.setter
    def day_of_month(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "day_of_month", value)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The day of the week to create a scheduled snapshot. Used for WEEKLY snapshot schedules.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "day_of_week", value)

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The hour of the day to create a DAILY, WEEKLY, MONTHLY, or YEARLY snapshot. If not set, a value will be chosen at creation time.
        """
        return pulumi.get(self, "hour_of_day")

    @hour_of_day.setter
    def hour_of_day(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hour_of_day", value)

    @property
    @pulumi.getter
    def month(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The month to create a scheduled snapshot. Used only for YEARLY snapshot schedules.
        """
        return pulumi.get(self, "month")

    @month.setter
    def month(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "month", value)

    @property
    @pulumi.getter(name="retentionDurationInSeconds")
    def retention_duration_in_seconds(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The number of seconds to retain snapshots created with this schedule. Snapshot expiration time will not be set if this value is empty.
        """
        return pulumi.get(self, "retention_duration_in_seconds")

    @retention_duration_in_seconds.setter
    def retention_duration_in_seconds(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_duration_in_seconds", value)

    @property
    @pulumi.getter(name="schedulePrefix")
    def schedule_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A name prefix to be applied to snapshots created by this schedule.  Example: `compliance1`
        """
        return pulumi.get(self, "schedule_prefix")

    @schedule_prefix.setter
    def schedule_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_prefix", value)

    @property
    @pulumi.getter(name="timeScheduleStart")
    def time_schedule_start(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The starting point used to begin the scheduling of the snapshots based upon recurrence string in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. If no `timeScheduleStart` is provided, the value will be set to the time when the schedule was created.
        """
        return pulumi.get(self, "time_schedule_start")

    @time_schedule_start.setter
    def time_schedule_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_schedule_start", value)


@pulumi.input_type
class MountTargetKerberosArgs:
    def __init__(__self__, *,
                 kerberos_realm: pulumi.Input[str],
                 backup_key_tab_secret_version: Optional[pulumi.Input[int]] = None,
                 current_key_tab_secret_version: Optional[pulumi.Input[int]] = None,
                 is_kerberos_enabled: Optional[pulumi.Input[bool]] = None,
                 key_tab_secret_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kerberos_realm: (Updatable) The Kerberos realm that the mount target will join.
        :param pulumi.Input[int] backup_key_tab_secret_version: (Updatable) Version of the keytab Secret in the Vault to use as a backup.
        :param pulumi.Input[int] current_key_tab_secret_version: (Updatable) Version of the keytab Secret in the Vault to use.
        :param pulumi.Input[bool] is_kerberos_enabled: (Updatable) Specifies whether to enable or disable Kerberos.
        :param pulumi.Input[str] key_tab_secret_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the keytab Secret in the Vault.
        """
        pulumi.set(__self__, "kerberos_realm", kerberos_realm)
        if backup_key_tab_secret_version is not None:
            pulumi.set(__self__, "backup_key_tab_secret_version", backup_key_tab_secret_version)
        if current_key_tab_secret_version is not None:
            pulumi.set(__self__, "current_key_tab_secret_version", current_key_tab_secret_version)
        if is_kerberos_enabled is not None:
            pulumi.set(__self__, "is_kerberos_enabled", is_kerberos_enabled)
        if key_tab_secret_id is not None:
            pulumi.set(__self__, "key_tab_secret_id", key_tab_secret_id)

    @property
    @pulumi.getter(name="kerberosRealm")
    def kerberos_realm(self) -> pulumi.Input[str]:
        """
        (Updatable) The Kerberos realm that the mount target will join.
        """
        return pulumi.get(self, "kerberos_realm")

    @kerberos_realm.setter
    def kerberos_realm(self, value: pulumi.Input[str]):
        pulumi.set(self, "kerberos_realm", value)

    @property
    @pulumi.getter(name="backupKeyTabSecretVersion")
    def backup_key_tab_secret_version(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Version of the keytab Secret in the Vault to use as a backup.
        """
        return pulumi.get(self, "backup_key_tab_secret_version")

    @backup_key_tab_secret_version.setter
    def backup_key_tab_secret_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_key_tab_secret_version", value)

    @property
    @pulumi.getter(name="currentKeyTabSecretVersion")
    def current_key_tab_secret_version(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Version of the keytab Secret in the Vault to use.
        """
        return pulumi.get(self, "current_key_tab_secret_version")

    @current_key_tab_secret_version.setter
    def current_key_tab_secret_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "current_key_tab_secret_version", value)

    @property
    @pulumi.getter(name="isKerberosEnabled")
    def is_kerberos_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Specifies whether to enable or disable Kerberos.
        """
        return pulumi.get(self, "is_kerberos_enabled")

    @is_kerberos_enabled.setter
    def is_kerberos_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_kerberos_enabled", value)

    @property
    @pulumi.getter(name="keyTabSecretId")
    def key_tab_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the keytab Secret in the Vault.
        """
        return pulumi.get(self, "key_tab_secret_id")

    @key_tab_secret_id.setter
    def key_tab_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_tab_secret_id", value)


@pulumi.input_type
class MountTargetLdapIdmapArgs:
    def __init__(__self__, *,
                 cache_lifetime_seconds: Optional[pulumi.Input[int]] = None,
                 cache_refresh_interval_seconds: Optional[pulumi.Input[int]] = None,
                 group_search_base: Optional[pulumi.Input[str]] = None,
                 negative_cache_lifetime_seconds: Optional[pulumi.Input[int]] = None,
                 outbound_connector1id: Optional[pulumi.Input[str]] = None,
                 outbound_connector2id: Optional[pulumi.Input[str]] = None,
                 schema_type: Optional[pulumi.Input[str]] = None,
                 user_search_base: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] cache_lifetime_seconds: (Updatable) The maximum amount of time the mount target is allowed to use a cached entry.
        :param pulumi.Input[int] cache_refresh_interval_seconds: (Updatable) The amount of time that the mount target should allow an entry to persist in its cache before attempting to refresh the entry.
        :param pulumi.Input[str] group_search_base: (Updatable) All LDAP searches are recursive starting at this group.  Example: `CN=Group,DC=domain,DC=com`
        :param pulumi.Input[int] negative_cache_lifetime_seconds: (Updatable) The amount of time that a mount target will maintain information that a user is not found in the ID mapping configuration.
        :param pulumi.Input[str] outbound_connector1id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the first connector to use to communicate with the LDAP server.
        :param pulumi.Input[str] outbound_connector2id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the second connector to use to communicate with the LDAP server.
        :param pulumi.Input[str] schema_type: (Updatable) Schema type of the LDAP account.
        :param pulumi.Input[str] user_search_base: (Updatable) All LDAP searches are recursive starting at this user.  Example: `CN=User,DC=domain,DC=com`
        """
        if cache_lifetime_seconds is not None:
            pulumi.set(__self__, "cache_lifetime_seconds", cache_lifetime_seconds)
        if cache_refresh_interval_seconds is not None:
            pulumi.set(__self__, "cache_refresh_interval_seconds", cache_refresh_interval_seconds)
        if group_search_base is not None:
            pulumi.set(__self__, "group_search_base", group_search_base)
        if negative_cache_lifetime_seconds is not None:
            pulumi.set(__self__, "negative_cache_lifetime_seconds", negative_cache_lifetime_seconds)
        if outbound_connector1id is not None:
            pulumi.set(__self__, "outbound_connector1id", outbound_connector1id)
        if outbound_connector2id is not None:
            pulumi.set(__self__, "outbound_connector2id", outbound_connector2id)
        if schema_type is not None:
            pulumi.set(__self__, "schema_type", schema_type)
        if user_search_base is not None:
            pulumi.set(__self__, "user_search_base", user_search_base)

    @property
    @pulumi.getter(name="cacheLifetimeSeconds")
    def cache_lifetime_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The maximum amount of time the mount target is allowed to use a cached entry.
        """
        return pulumi.get(self, "cache_lifetime_seconds")

    @cache_lifetime_seconds.setter
    def cache_lifetime_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cache_lifetime_seconds", value)

    @property
    @pulumi.getter(name="cacheRefreshIntervalSeconds")
    def cache_refresh_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The amount of time that the mount target should allow an entry to persist in its cache before attempting to refresh the entry.
        """
        return pulumi.get(self, "cache_refresh_interval_seconds")

    @cache_refresh_interval_seconds.setter
    def cache_refresh_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cache_refresh_interval_seconds", value)

    @property
    @pulumi.getter(name="groupSearchBase")
    def group_search_base(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) All LDAP searches are recursive starting at this group.  Example: `CN=Group,DC=domain,DC=com`
        """
        return pulumi.get(self, "group_search_base")

    @group_search_base.setter
    def group_search_base(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_search_base", value)

    @property
    @pulumi.getter(name="negativeCacheLifetimeSeconds")
    def negative_cache_lifetime_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The amount of time that a mount target will maintain information that a user is not found in the ID mapping configuration.
        """
        return pulumi.get(self, "negative_cache_lifetime_seconds")

    @negative_cache_lifetime_seconds.setter
    def negative_cache_lifetime_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "negative_cache_lifetime_seconds", value)

    @property
    @pulumi.getter(name="outboundConnector1id")
    def outbound_connector1id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the first connector to use to communicate with the LDAP server.
        """
        return pulumi.get(self, "outbound_connector1id")

    @outbound_connector1id.setter
    def outbound_connector1id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "outbound_connector1id", value)

    @property
    @pulumi.getter(name="outboundConnector2id")
    def outbound_connector2id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the second connector to use to communicate with the LDAP server.
        """
        return pulumi.get(self, "outbound_connector2id")

    @outbound_connector2id.setter
    def outbound_connector2id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "outbound_connector2id", value)

    @property
    @pulumi.getter(name="schemaType")
    def schema_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Schema type of the LDAP account.
        """
        return pulumi.get(self, "schema_type")

    @schema_type.setter
    def schema_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_type", value)

    @property
    @pulumi.getter(name="userSearchBase")
    def user_search_base(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) All LDAP searches are recursive starting at this user.  Example: `CN=User,DC=domain,DC=com`
        """
        return pulumi.get(self, "user_search_base")

    @user_search_base.setter
    def user_search_base(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_search_base", value)


@pulumi.input_type
class OutboundConnectorEndpointArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[str],
                 port: pulumi.Input[str]):
        """
        :param pulumi.Input[str] hostname: Name of the DNS server.
        :param pulumi.Input[str] port: Port of the DNS server.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        """
        Name of the DNS server.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[str]:
        """
        Port of the DNS server.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[str]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class GetExportSetsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetExportsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetFileSystemsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetFilesystemSnapshotPoliciesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetMountTargetsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetOutboundConnectorsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetReplicationTargetsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetReplicationsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSnapshotsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of the snapshot. This value is immutable.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the snapshot. This value is immutable.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


