# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetNetworkFirewallPolicyAddressListResult',
    'AwaitableGetNetworkFirewallPolicyAddressListResult',
    'get_network_firewall_policy_address_list',
    'get_network_firewall_policy_address_list_output',
]

@pulumi.output_type
class GetNetworkFirewallPolicyAddressListResult:
    """
    A collection of values returned by getNetworkFirewallPolicyAddressList.
    """
    def __init__(__self__, addresses=None, id=None, name=None, network_firewall_policy_id=None, parent_resource_id=None, total_addresses=None, type=None):
        if addresses and not isinstance(addresses, list):
            raise TypeError("Expected argument 'addresses' to be a list")
        pulumi.set(__self__, "addresses", addresses)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_firewall_policy_id and not isinstance(network_firewall_policy_id, str):
            raise TypeError("Expected argument 'network_firewall_policy_id' to be a str")
        pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if parent_resource_id and not isinstance(parent_resource_id, str):
            raise TypeError("Expected argument 'parent_resource_id' to be a str")
        pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        if total_addresses and not isinstance(total_addresses, int):
            raise TypeError("Expected argument 'total_addresses' to be a int")
        pulumi.set(__self__, "total_addresses", total_addresses)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence[str]:
        """
        List of addresses.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name to identify the group of addresses to be used in the policy rules.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> str:
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> str:
        """
        OCID of the Network Firewall Policy this Address List belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter(name="totalAddresses")
    def total_addresses(self) -> int:
        """
        Count of total Addresses in the AddressList
        """
        return pulumi.get(self, "total_addresses")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of address List.
        """
        return pulumi.get(self, "type")


class AwaitableGetNetworkFirewallPolicyAddressListResult(GetNetworkFirewallPolicyAddressListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkFirewallPolicyAddressListResult(
            addresses=self.addresses,
            id=self.id,
            name=self.name,
            network_firewall_policy_id=self.network_firewall_policy_id,
            parent_resource_id=self.parent_resource_id,
            total_addresses=self.total_addresses,
            type=self.type)


def get_network_firewall_policy_address_list(name: Optional[str] = None,
                                             network_firewall_policy_id: Optional[str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkFirewallPolicyAddressListResult:
    """
    This data source provides details about a specific Network Firewall Policy Address List resource in Oracle Cloud Infrastructure Network Firewall service.

    Get Address List by the given name in the context of network firewall policy.


    :param str name: Unique name to identify the group of addresses to be used in the policy rules.
    :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['networkFirewallPolicyId'] = network_firewall_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:NetworkFirewall/getNetworkFirewallPolicyAddressList:getNetworkFirewallPolicyAddressList', __args__, opts=opts, typ=GetNetworkFirewallPolicyAddressListResult).value

    return AwaitableGetNetworkFirewallPolicyAddressListResult(
        addresses=pulumi.get(__ret__, 'addresses'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        network_firewall_policy_id=pulumi.get(__ret__, 'network_firewall_policy_id'),
        parent_resource_id=pulumi.get(__ret__, 'parent_resource_id'),
        total_addresses=pulumi.get(__ret__, 'total_addresses'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_network_firewall_policy_address_list)
def get_network_firewall_policy_address_list_output(name: Optional[pulumi.Input[str]] = None,
                                                    network_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetworkFirewallPolicyAddressListResult]:
    """
    This data source provides details about a specific Network Firewall Policy Address List resource in Oracle Cloud Infrastructure Network Firewall service.

    Get Address List by the given name in the context of network firewall policy.


    :param str name: Unique name to identify the group of addresses to be used in the policy rules.
    :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
    """
    ...
