# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetCategoryResult',
    'AwaitableGetCategoryResult',
    'get_category',
    'get_category_output',
]

@pulumi.output_type
class GetCategoryResult:
    """
    A collection of values returned by getCategory.
    """
    def __init__(__self__, category_id=None, compartment_id=None, compartment_name=None, description=None, estimated_cost_saving=None, extended_metadata=None, id=None, name=None, recommendation_counts=None, resource_counts=None, state=None, time_created=None, time_updated=None):
        if category_id and not isinstance(category_id, str):
            raise TypeError("Expected argument 'category_id' to be a str")
        pulumi.set(__self__, "category_id", category_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_name and not isinstance(compartment_name, str):
            raise TypeError("Expected argument 'compartment_name' to be a str")
        pulumi.set(__self__, "compartment_name", compartment_name)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if estimated_cost_saving and not isinstance(estimated_cost_saving, float):
            raise TypeError("Expected argument 'estimated_cost_saving' to be a float")
        pulumi.set(__self__, "estimated_cost_saving", estimated_cost_saving)
        if extended_metadata and not isinstance(extended_metadata, dict):
            raise TypeError("Expected argument 'extended_metadata' to be a dict")
        pulumi.set(__self__, "extended_metadata", extended_metadata)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if recommendation_counts and not isinstance(recommendation_counts, list):
            raise TypeError("Expected argument 'recommendation_counts' to be a list")
        pulumi.set(__self__, "recommendation_counts", recommendation_counts)
        if resource_counts and not isinstance(resource_counts, list):
            raise TypeError("Expected argument 'resource_counts' to be a list")
        pulumi.set(__self__, "resource_counts", resource_counts)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> str:
        return pulumi.get(self, "category_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the tenancy. The tenancy is the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentName")
    def compartment_name(self) -> str:
        """
        The name associated with the compartment.
        """
        return pulumi.get(self, "compartment_name")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Text describing the category.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="estimatedCostSaving")
    def estimated_cost_saving(self) -> float:
        """
        The estimated cost savings, in dollars, for the category.
        """
        return pulumi.get(self, "estimated_cost_saving")

    @property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> Mapping[str, Any]:
        """
        Additional metadata key/value pairs for the category.
        """
        return pulumi.get(self, "extended_metadata")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name assigned to the category.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recommendationCounts")
    def recommendation_counts(self) -> Sequence['outputs.GetCategoryRecommendationCountResult']:
        """
        An array of `RecommendationCount` objects grouped by the level of importance assigned to the recommendation.
        """
        return pulumi.get(self, "recommendation_counts")

    @property
    @pulumi.getter(name="resourceCounts")
    def resource_counts(self) -> Sequence['outputs.GetCategoryResourceCountResult']:
        """
        An array of `ResourceCount` objects grouped by the status of the recommendation.
        """
        return pulumi.get(self, "resource_counts")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The category's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the category details were created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the category details were last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetCategoryResult(GetCategoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCategoryResult(
            category_id=self.category_id,
            compartment_id=self.compartment_id,
            compartment_name=self.compartment_name,
            description=self.description,
            estimated_cost_saving=self.estimated_cost_saving,
            extended_metadata=self.extended_metadata,
            id=self.id,
            name=self.name,
            recommendation_counts=self.recommendation_counts,
            resource_counts=self.resource_counts,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_category(category_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCategoryResult:
    """
    This data source provides details about a specific Category resource in Oracle Cloud Infrastructure Optimizer service.

    Gets the category that corresponds to the specified OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_category = oci.Optimizer.get_category(category_id=oci_optimizer_category["test_category"]["id"])
    ```


    :param str category_id: The unique OCID associated with the category.
    """
    __args__ = dict()
    __args__['categoryId'] = category_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Optimizer/getCategory:getCategory', __args__, opts=opts, typ=GetCategoryResult).value

    return AwaitableGetCategoryResult(
        category_id=pulumi.get(__ret__, 'category_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_name=pulumi.get(__ret__, 'compartment_name'),
        description=pulumi.get(__ret__, 'description'),
        estimated_cost_saving=pulumi.get(__ret__, 'estimated_cost_saving'),
        extended_metadata=pulumi.get(__ret__, 'extended_metadata'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        recommendation_counts=pulumi.get(__ret__, 'recommendation_counts'),
        resource_counts=pulumi.get(__ret__, 'resource_counts'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_category)
def get_category_output(category_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCategoryResult]:
    """
    This data source provides details about a specific Category resource in Oracle Cloud Infrastructure Optimizer service.

    Gets the category that corresponds to the specified OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_category = oci.Optimizer.get_category(category_id=oci_optimizer_category["test_category"]["id"])
    ```


    :param str category_id: The unique OCID associated with the category.
    """
    ...
